package org.jeecg.pm.hikvision.sdk.request.base.netzone;

import com.chanjx.utils.HttpMethod;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.http.entity.ContentType;
import org.jeecg.pm.hikvision.sdk.entity.body.base.netzone.HikvisionGetNetZones;
import org.jeecg.pm.hikvision.sdk.request.HikvisionAbstractRequest;
import org.jeecg.pm.hikvision.sdk.response.base.netzone.HikvisionGetNetZonesResponse;
import org.jeecg.pm.hikvision.sdk.result.base.netzone.HikvisionGetNetZonesResult;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetNetZonesRequest extends HikvisionAbstractRequest<HikvisionGetNetZonesResponse, HikvisionGetNetZonesResult> {

    public HikvisionGetNetZonesRequest() {
        super(new HikvisionGetNetZones());
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Class<HikvisionGetNetZonesResponse> getResponseClazz() {
        return HikvisionGetNetZonesResponse.class;
    }

    @Override
    public Class<HikvisionGetNetZonesResult> getResultClazz() {
        return HikvisionGetNetZonesResult.class;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getReqPath() {
        return "/openapi/service/base/netZone/getNetZones";
    }

}
