import org.jeecg.pm.hikvision.sdk.client.HikvisionBaseClient;
import org.jeecg.pm.hikvision.sdk.client.HikvisionClient;
import org.jeecg.pm.hikvision.sdk.entity.body.eps.HikvisionSubscribeEventsFromMQEx;
import org.jeecg.pm.hikvision.sdk.entity.body.vss.preview.HikvisiongetPreviewParamByCameraUuid;
import org.jeecg.pm.hikvision.sdk.entity.body.vss.res.HikvisionGetCamerasEx;
import org.jeecg.pm.hikvision.sdk.entity.body.vss.res.HikvisionGetEncoders;
import org.jeecg.pm.hikvision.sdk.request.base.netzone.HikvisionGetNetZonesRequest;
import org.jeecg.pm.hikvision.sdk.request.base.user.HikvisionGetDefaultUserUuidRequest;
import org.jeecg.pm.hikvision.sdk.request.vss.playback.HikvisionGetPlaybackParamByPlanUuidRequest;
import org.jeecg.pm.hikvision.sdk.request.vss.playback.HikvisionGetRecordPlansByCameraUuidsRequest;
import org.jeecg.pm.hikvision.sdk.request.eps.HikvisionSubscribeEventsFromMQExRequest;
import org.jeecg.pm.hikvision.sdk.request.vss.preview.HikvisionPreviewParamByCameraUuidRequest;
import org.jeecg.pm.hikvision.sdk.request.vss.res.HikvisionGetCamerasExRequest;
import org.jeecg.pm.hikvision.sdk.request.vss.res.HikvisionGetEncodersRequest;
import org.jeecg.pm.hikvision.sdk.response.base.netzone.HikvisionGetNetZonesResponse;
import org.jeecg.pm.hikvision.sdk.response.base.user.HikvisionGetDefaultUserUuidResponse;
import org.jeecg.pm.hikvision.sdk.response.eps.HikvisionSubscribeEventsFromMQExResponse;
import org.jeecg.pm.hikvision.sdk.response.vss.playback.HikvisionGetPlaybackParamByPlanUuidResponse;
import org.jeecg.pm.hikvision.sdk.response.vss.playback.HikvisionGetRecordPlansByCameraUuidsResponse;
import org.jeecg.pm.hikvision.sdk.response.vss.preview.HikvisionPreviewParamByCameraUuidResponse;
import org.jeecg.pm.hikvision.sdk.response.vss.res.HikvisionGetCamerasExResponse;
import org.jeecg.pm.hikvision.sdk.response.vss.res.HikvisionGetEncodersResponse;
import org.jeecg.pm.hikvision.sdk.result.base.netzone.HikvisionGetNetZonesResult;
import org.jeecg.pm.hikvision.sdk.result.vss.playback.HikvisionGetRecordPlansByCameraUuidsResult;
import org.jeecg.pm.hikvision.sdk.result.vss.res.HikvisionGetCamerasExResult;
import org.junit.jupiter.api.Test;

import java.util.Arrays;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/22
 */
public class HikvisionSdkTest {

    private static final String APP_KEY = "f9c1514b";
    private static final String SECRET = "13bd31dbd3fe449e9e13f7ce6693677a";

    private static final HikvisionClient CLIENT = new HikvisionBaseClient(APP_KEY, SECRET);

    @Test
    void getDefaultUserUuidTest() {
        final HikvisionGetDefaultUserUuidResponse response = CLIENT.execute(new HikvisionGetDefaultUserUuidRequest());
        System.out.println(response);
    }

    @Test
    void getNetZon() {
        final HikvisionGetNetZonesResponse response = CLIENT.execute(new HikvisionGetNetZonesRequest());
        System.out.println(response);
    }

    @Test
    void getEncoders() {
        final HikvisionGetEncoders encoders = new HikvisionGetEncoders(1, 10);
        final HikvisionGetEncodersResponse response = CLIENT.execute(new HikvisionGetEncodersRequest(encoders));
        System.out.println(response);
    }

    @Test
    void getCamerasEx() {
        final HikvisionGetCamerasEx camerasEx = new HikvisionGetCamerasEx(1, 10);
        final HikvisionGetCamerasExResponse response = CLIENT.execute(new HikvisionGetCamerasExRequest(camerasEx));
        System.out.println(response);
    }

    @Test
    void subscribeEventsFromMQEx(){
        HikvisionSubscribeEventsFromMQEx hikvisionSubscribeEventsFromMQEx = new HikvisionSubscribeEventsFromMQEx().setEventTypes(Arrays.asList("131331"));
        final HikvisionSubscribeEventsFromMQExResponse response = CLIENT.execute(new HikvisionSubscribeEventsFromMQExRequest(hikvisionSubscribeEventsFromMQEx));
        System.out.println(response);
    }

    @Test
    void previewParamByCameraUuid() {
        final HikvisionGetCamerasEx camerasEx = new HikvisionGetCamerasEx(1, 10);
        final HikvisionGetCamerasExResponse camerasExResponse = CLIENT.execute(new HikvisionGetCamerasExRequest(camerasEx));
        final HikvisionGetCamerasExResult camerasExResult = camerasExResponse.getResult();
        final String cameraUuid = camerasExResult.getData().getList().get(0).getCameraUuid();

        final HikvisionGetNetZonesResponse netZonesResponse = CLIENT.execute(new HikvisionGetNetZonesRequest());
        final List<HikvisionGetNetZonesResult.NetZone> netZones = netZonesResponse.getResult().getData();
        netZones.forEach(netZone -> {
            final HikvisionPreviewParamByCameraUuidResponse response = CLIENT.execute(
                    new HikvisionPreviewParamByCameraUuidRequest(
                            new HikvisiongetPreviewParamByCameraUuid(cameraUuid, netZone.getNetZoneUuid())));
            System.out.println(response.getResult());
        });
    }

    @Test
    void getRecordPlansByCameraUuids() {
        final HikvisionGetCamerasEx camerasEx = new HikvisionGetCamerasEx(1, 10);
        final HikvisionGetCamerasExResponse camerasExResponse = CLIENT.execute(new HikvisionGetCamerasExRequest(camerasEx));
        final HikvisionGetCamerasExResult camerasExResult = camerasExResponse.getResult();
        final String cameraUuid = camerasExResult.getData().getList().get(0).getCameraUuid();

        final HikvisionGetNetZonesResponse netZonesResponse = CLIENT.execute(new HikvisionGetNetZonesRequest());
        final List<HikvisionGetNetZonesResult.NetZone> netZones = netZonesResponse.getResult().getData();
        netZones.forEach(netZone -> {
            final HikvisionGetRecordPlansByCameraUuidsResponse response = CLIENT.execute(
                    new HikvisionGetRecordPlansByCameraUuidsRequest(
                            new HikvisionGetRecordPlansByCameraUuids(1, 10, cameraUuid, netZone.getNetZoneUuid())));
            System.out.println(response.getResult());
        });
    }

    @Test
    void getPlaybackParamByPlanUuid() {
        final HikvisionGetCamerasEx camerasEx = new HikvisionGetCamerasEx(1, 10);
        final HikvisionGetCamerasExResponse camerasExResponse = CLIENT.execute(new HikvisionGetCamerasExRequest(camerasEx));
        final HikvisionGetCamerasExResult camerasExResult = camerasExResponse.getResult();
        final String cameraUuid = camerasExResult.getData().getList().get(0).getCameraUuid();

        final HikvisionGetNetZonesResponse netZonesResponse = CLIENT.execute(new HikvisionGetNetZonesRequest());
        final List<HikvisionGetNetZonesResult.NetZone> netZones = netZonesResponse.getResult().getData();
        final HikvisionGetRecordPlansByCameraUuidsResponse response = CLIENT.execute(
                new HikvisionGetRecordPlansByCameraUuidsRequest(
                        new HikvisionGetRecordPlansByCameraUuids(1, 10, cameraUuid, netZones.get(0).getNetZoneUuid())));
        final HikvisionGetRecordPlansByCameraUuidsResult cameraUuidsResult = response.getResult();
        final HikvisionGetRecordPlansByCameraUuidsResult.RecordPlan recordPlan = cameraUuidsResult.getData().getList().get(0);
        final HikvisionGetPlaybackParamByPlanUuidResponse planUuidResponse = CLIENT.execute(
                new HikvisionGetPlaybackParamByPlanUuidRequest(
                        new HikvisionGetPlaybackParamByPlanUuid(recordPlan.getRecordPlanUuid(), recordPlan.getPlanType(), netZones.get(0).getNetZoneUuid())));
        System.out.println(planUuidResponse.getResult());
    }
}
