package org.jeecg.pm.hikvision.sdk.request;

import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionBodyModel;
import org.jeecg.pm.hikvision.sdk.entity.query.HikvisionQueryModel;
import org.jeecg.pm.hikvision.sdk.response.HikvisionResponse;
import org.jeecg.pm.hikvision.sdk.result.HikvisionBaseResult;

import java.util.Map;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
public abstract class HikvisionAbstractRequest<T extends HikvisionResponse<R>, R extends HikvisionBaseResult> implements HikvisionRequest<T, R> {

    /**
     * http body
     */
    private HikvisionBodyModel bodyModel;

    /**
     * http query
     */
    private HikvisionQueryModel queryModel;

    public HikvisionAbstractRequest() {
    }

    public HikvisionAbstractRequest(HikvisionBodyModel bodyModel) {
        this.bodyModel = bodyModel;
    }

    public HikvisionAbstractRequest(HikvisionQueryModel queryModel) {
        this.queryModel = queryModel;
    }

    public HikvisionAbstractRequest(HikvisionBodyModel bodyModel, HikvisionQueryModel queryModel) {
        this.bodyModel = bodyModel;
        this.queryModel = queryModel;
    }

    @Override
    public Map<String, String> getHeaders() {
        return null;
    }

    @Override
    public HikvisionBodyModel getBodyModel() {
        return bodyModel;
    }

    @Override
    public void setBodyModel(HikvisionBodyModel bodyModel) {
        this.bodyModel = bodyModel;
    }

    @Override
    public HikvisionQueryModel getQueryModel() {
        return queryModel;
    }

    @Override
    public void setQueryModel(HikvisionQueryModel queryModel) {
        this.queryModel = queryModel;
    }
}
