package org.jeecg.pm.hikvision.sdk.request;

import com.chanjx.utils.HttpMethod;
import org.jeecg.pm.hikvision.sdk.entity.HikvisionBaseModel;
import org.jeecg.pm.hikvision.sdk.response.HikvisionResponse;

import java.util.Map;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
public interface HikvisionRequest<T extends HikvisionResponse<R>, R> {

    /**
     * 获取业务对象
     *
     * @return model
     */
    HikvisionBaseModel getModel();


    /**
     * 设置业务实体
     *
     * @param hikvisionBaseModel
     */
    void serModel(HikvisionBaseModel hikvisionBaseModel);


    /**
     * 获取请求接口方法：GET POST ...
     *
     * @return method
     */
    HttpMethod getHttpMethod();

    /**
     * 设置 URI 查询参数
     *
     * @param query query
     */
    void setToken(String token);

    /**
     * 获取请求uri，可能包含一个或多个 * 号占位符，需要使用 {@link #getUriReplaces()} 进行替换
     *
     * @return uri
     */
    String getReqUri();

    /**
     * 获取设置的请求头参数（有的请求参数在请求头里）
     *
     * @return headers
     */
    Map<String, String> getHeaders();
}
