package org.jeecg.pm.hikvision.sdk.client;

import com.chanjx.utils.HttpClientUtils;
import com.chanjx.utils.JsonUtils;
import com.chanjx.utils.entity.http.HttpResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.SneakyThrows;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.http.client.methods.*;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jeecg.pm.hikvision.sdk.request.HikvisionVideoRequest;
import org.jeecg.pm.hikvision.sdk.response.HikvisionVideoResponse;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
public class HikvisionVideoClient extends HikvisionAbstractClient {

    /**
     * 请求的Host头，该字段值必须是：openapi/service
     */
    private static final String HEADER_HOST = "openapi/service";

    private final String appkey;

    private final String secret;

    public HikvisionVideoClient(String appkey, String secret) {
        this.appkey = appkey;
        this.secret = secret;
    }


    @SneakyThrows
    @Override
    public <T extends HikvisionVideoResponse<R>, R> T execute(HikvisionVideoRequest<T, R> request) {
        final HttpResponse resp = doHttpClient(request);
        return super.execute(request);
    }

    public <T extends HikvisionVideoResponse<R>, R> HttpResponse doHttpClient(HikvisionVideoRequest<T, R> request) throws URISyntaxException, JsonProcessingException {
        final CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        return HttpClientUtils.send(httpClient, new HttpPost(), request.getHeaders());
    }

}
