package org.jeecg.pm.mq;


import lombok.extern.slf4j.Slf4j;
import org.jeecg.pm.entity.eps.EventDis;
import org.jeecg.pm.entity.event.PmEventInfo;
import org.jeecg.pm.entity.event.enums.EventLevel;
import org.jeecg.pm.entity.event.enums.EventState;
import org.jeecg.pm.service.event.IPmEventInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import javax.jms.BytesMessage;
import java.util.Arrays;

/**
 * @author: JJww
 * @Date:2022/3/23
 */
@Slf4j
@Component
public class EventMessageListener {

    /**
     * 视频事件
     */
    private final static String VSS_TOPIC = "openapi.vss.topic";

    /**
     * 报警事件
     */
    private final static String EPS_TOPIC = "openapi.eps.topic";

    @Autowired
    private IPmEventInfoService pmEventInfoService;


    @JmsListener(destination = VSS_TOPIC)
    public void vssProcessMessage(BytesMessage bytesMessage) throws Exception {
        final byte[] bytes = new byte[(int) bytesMessage.getBodyLength()];
        bytesMessage.readBytes(bytes);
        // 壳文件字段，EventDis类为event_dis.proto文件解析而来，CommEventLog类为事件壳文件类
        final EventDis.CommEventLog commEventLog = EventDis.CommEventLog.parseFrom(bytes);
        final PmEventInfo pmEventInfo = this.recode(commEventLog);
        pmEventInfo.setEventCategory(PmEventInfo.VSS);
        pmEventInfoService.saveEvent(pmEventInfo);
        log.info("VSS_TOPIC:{}", pmEventInfo);
    }


    @JmsListener(destination = EPS_TOPIC)
    public void epsProcessMessage(BytesMessage bytesMessage) throws Exception {
        final byte[] bytes = new byte[(int) bytesMessage.getBodyLength()];
        bytesMessage.readBytes(bytes);
        final EventDis.CommEventLog commEventLog = EventDis.CommEventLog.parseFrom(bytes);
        final PmEventInfo pmEventInfo = this.recode(commEventLog);
        pmEventInfo.setEventCategory(PmEventInfo.EPS);
        pmEventInfoService.saveEvent(pmEventInfo);
        log.info("EPS_TOPIC:{}", pmEventInfo);
    }


    public PmEventInfo recode(EventDis.CommEventLog commEventLog) {
        final EventLevel eventLevel = Arrays.asList(EventLevel.values()).stream().filter(level -> level.getLevel().equals(commEventLog.getEventLevel())).findFirst().orElse(EventLevel.UNKNOWN);
        final EventState eventState = Arrays.asList(EventState.values()).stream().filter(state -> state.getState().equals(commEventLog.getEventState())).findFirst().orElse(EventState.UNKNOWN);
        return new PmEventInfo()
                .setLogId(commEventLog.getLogId())
                .setEventState(eventState.getRemark())
                .setEventLevel(eventLevel.getRemark())
                .setUnitIdx(commEventLog.getUnitIdx())
                .setEventType(commEventLog.getEventType())
                .setEventTypeName(commEventLog.getEventTypeName())
                .setSubSysType(commEventLog.getSubSysType())
                .setEventName(commEventLog.getEventName())
                .setStartTime(commEventLog.getStartTime())
                .setStopTime(commEventLog.getStopTime())
                .setSourceIdx(commEventLog.getSourceIdx())
                .setSourceType(commEventLog.getSourceType())
                .setSourceName(commEventLog.getSourceName())
                .setLogTxt(commEventLog.getLogTxt())
                .setRegionIdx(commEventLog.getRegionIdx())
                .setExtInfo(commEventLog.getExtInfo().toStringUtf8());
    }
}
