package org.jeecg.pm.entity.event;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @Description: pm_event_info
 * @Author: jeecg-boot
 * @Date: 2022-04-01
 * @Version: V1.0
 */
@Data
@TableName("pm_event_info")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "pm_event_info对象", description = "pm_event_info")
public class PmEventInfo implements Serializable {


    /**
     * 视频事件
     */
    public static final String VSS = "VSS";

    /**
     * 入侵报警事件
     */
    public static final String EPS = "EPS";


    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 唯一标识一次发生的事件
     */
    @Excel(name = "唯一标识一次发生的事件", width = 15)
    @ApiModelProperty(value = "唯一标识一次发生的事件")
    private String logId;
    /**
     * 0：瞬时事件，保存；1：事件开始，
     * 保存；2：事件结束，更新结束时间； 3：事件脉冲，客户端和服务器使用，
     * CMS 不用；4：事件更新，联动结果更
     * 新
     */
    @Excel(name = "0：瞬时事件，保存；1：事件开始， 保存；2：事件结束，更新结束时间； 3：事件脉冲，客户端和服务器使用， CMS 不用；4：事件更新，联动结果更 新", width = 15)
    @ApiModelProperty(value = "0：瞬时事件，保存；1：事件开始， 保存；2：事件结束，更新结束时间； 3：事件脉冲，客户端和服务器使用， CMS 不用；4：事件更新，联动结果更 新")
    private String eventState;
    /**
     * 0：普通事件；1：低级报警；2：中级
     * 报警；3：高级报警
     */
    @Excel(name = "0：普通事件；1：低级报警；2：中级 报警；3：高级报警", width = 15)
    @ApiModelProperty(value = "0：普通事件；1：低级报警；2：中级 报警；3：高级报警")
    private String eventLevel;
    /**
     * 控制中心编号
     */
    @Excel(name = "控制中心编号", width = 15)
    @ApiModelProperty(value = "控制中心编号")
    private String unitIdx;
    /**
     * 事件类型
     */
    @Excel(name = "事件类型", width = 15)
    @ApiModelProperty(value = "事件类型")
    private Integer eventType;
    /**
     * 事件类型名称
     */
    @Excel(name = "事件类型名称", width = 15)
    @ApiModelProperty(value = "事件类型名称")
    private String eventTypeName;
    /**
     * 事件所属子系统类型.
     * "废弃，事件整改，没有子系统属性"
     */
    @Excel(name = "事件所属子系统类型: 废弃，事件整改，没有子系统属性", width = 15)
    @ApiModelProperty(value = "事件所属子系统类型: 废弃，事件整改，没有子系统属性 ")
    private Integer subSysType;
    /**
     * 事件名称
     */
    @Excel(name = "事件名称", width = 15)
    @ApiModelProperty(value = "事件名称")
    private String eventName;
    /**
     * 事件开始时间
     */
    @Excel(name = "事件开始时间", width = 15, format = "yyyy-MM-dd")
//    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "事件开始时间")
    private String startTime;
    /**
     * 事件结束时间
     */
    @Excel(name = "事件结束时间", width = 15, format = "yyyy-MM-dd")
//    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "事件结束时间")
    private String stopTime;
    /**
     * 事件源编号
     */
    @Excel(name = "事件源编号", width = 15)
    @ApiModelProperty(value = "事件源编号")
    private String sourceIdx;
    /**
     * 事件源类型
     */
    @Excel(name = "事件源类型", width = 15)
    @ApiModelProperty(value = "事件源类型")
    private Integer sourceType;
    /**
     * 事件源名称
     */
    @Excel(name = "事件源名称", width = 15)
    @ApiModelProperty(value = "事件源名称")
    private String sourceName;
    /**
     * 事件描述信息
     */
    @Excel(name = "事件描述信息", width = 15)
    @ApiModelProperty(value = "事件描述信息")
    private String logTxt;
    /**
     * 事件源区域编号
     */
    @Excel(name = "事件源区域编号", width = 15)
    @ApiModelProperty(value = "事件源区域编号")
    private String regionIdx;
    /**
     * 事件拓展信息:
     * 各个子系统根据子系统的消息结构体
     * 定义解析,下文主要介绍事件中此字
     * 段含义
     */
    @Excel(name = "事件拓展信息:各个子系统根据子系统的消息结构体 定义解析, 下文主要介绍事件中此字 段含义", width = 15)
    @ApiModelProperty(value = "事件拓展信息: 各个子系统根据子系统的消息结构体 定义解析, 下文主要介绍事件中此字 段含义")
    private String extInfo;
    /**
     * 事件处理结果:当 event_state 为更新时使用
     */
    @Excel(name = "事件处理结果:当 event_state 为更新时使用", width = 15)
    @ApiModelProperty(value = "事件处理结果:当 event_state 为更新时使用")
    private String rsltMsg;
    /**
     * 联动信息:目前包含客户端联动、预
     * 案
     */
    @Excel(name = "联动信息:目前包含客户端联动、预 案", width = 15)
    @ApiModelProperty(value = "联动信息:目前包含客户端联动、预 案")
    private String trigInfo;

    /**
     * 上层事件类型
     * VSS: 视频事件
     * EPS: 入侵报警事件'
     */
    @Excel(name = "VSS: 视频事件 EPS: 入侵报警事件", width = 15)
    @ApiModelProperty(value = "VSS: 视频事件 EPS: 入侵报警事件")
    private String eventCategory;
}
