package org.jeecg.pm.hikvision.sdk.parser;

import com.chanjx.utils.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.pm.hikvision.sdk.result.HikvisionBaseResult;

import java.io.IOException;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/22
 */
public class HikvisionJsonParser<R extends HikvisionBaseResult> implements HikvisionParser<R>{

    private final Class<R> clazz;

    public HikvisionJsonParser(Class<R> clazz) {
        this.clazz = clazz;
    }

    @Override
    public R parse(String resp) throws JeecgBootException {
        try {
            return JsonUtils.json2Obj(resp, clazz);
        } catch (JsonProcessingException e) {
            throw new JeecgBootException(e);
        }
    }

    @Override
    public List<R> parseList(String resp) throws JeecgBootException {
        try {
            return JsonUtils.json2List(resp, clazz);
        } catch (IOException e) {
            throw new JeecgBootException(e);
        }
    }

    @Override
    public Class<R> getResultClazz() throws JeecgBootException {
        return clazz;
    }

    @Override
    public R parseErrorResult(String resp) throws JeecgBootException {
        try {
            return JsonUtils.json2Obj(resp, clazz);
        } catch (JsonProcessingException e) {
            throw new JeecgBootException(e);
        }
    }
}
