package org.jeecg.pm.hikvision.sdk.request.eps;

import com.chanjx.utils.HttpMethod;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.http.entity.ContentType;
import org.jeecg.pm.hikvision.sdk.entity.body.eps.HikvisionSubscribeEventsFromMQEx;
import org.jeecg.pm.hikvision.sdk.request.HikvisionAbstractRequest;
import org.jeecg.pm.hikvision.sdk.response.eps.HikvisionSubscribeEventsFromMQExResponse;
import org.jeecg.pm.hikvision.sdk.result.eps.HikvisionSubscribeEventsFromMQExResult;

/**
 * @author: JJww
 * @Date:2022/3/23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionSubscribeEventsFromMQExRequest extends HikvisionAbstractRequest<HikvisionSubscribeEventsFromMQExResponse, HikvisionSubscribeEventsFromMQExResult> {

    public HikvisionSubscribeEventsFromMQExRequest(HikvisionSubscribeEventsFromMQEx hikvisionGetSubscribeEventsFromMQEx) {
        super(hikvisionGetSubscribeEventsFromMQEx);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Class<HikvisionSubscribeEventsFromMQExResponse> getResponseClazz() {
        return HikvisionSubscribeEventsFromMQExResponse.class;
    }

    @Override
    public Class<HikvisionSubscribeEventsFromMQExResult> getResultClazz() {
        return HikvisionSubscribeEventsFromMQExResult.class;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getReqPath() {
        return "/openapi/service/eps/subscribeEventsFromMQEx";
    }

}
