package org.jeecg.pm.entity.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author: JJww
 * @Date:2022/4/6
 */
@Getter
@AllArgsConstructor
public enum EventState {

    INSTANTANEOUS(0, "瞬时"),

    START(1, "开始"),

    STOP(2, "结束"),

    PULSE(3, "脉冲"),

    UPDATE(4, "更新"),

    UNKNOWN(9, "未知类型");

    /**
     * 状态码
     */
    private final Integer state;

    /**
     * 状态说明
     */
    private final String remark;

}
