package org.jeecg.modules.demo.pm.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.demo.pm.entity.PmMonitoringDevice;
import org.jeecg.modules.demo.pm.mapper.PmMonitoringDeviceMapper;
import org.jeecg.modules.demo.pm.service.IPmMonitoringDeviceService;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: pm_monitoring_device
 * @Author: jeecg-boot
 * @Date: 2022-03-15
 * @Version: V1.0
 */
@Service
public class PmMonitoringDeviceServiceImpl extends ServiceImpl<PmMonitoringDeviceMapper, PmMonitoringDevice> implements IPmMonitoringDeviceService {

    @Override
    public boolean save(PmMonitoringDevice entity) {
        entity.setId(IdWorker.getId())
                .setCreateTime(new Date())
                .setModifyTime(new Date());
        return super.save(entity);
    }

    @Override
    public boolean updateById(PmMonitoringDevice entity) {
        entity.setModifyTime(new Date());
        return super.updateById(entity);
    }

    @Override
    public boolean removeById(Serializable id) {
        return update(
                new UpdateWrapper<PmMonitoringDevice>()
                        .lambda()
                        .eq(PmMonitoringDevice::getId, id)
                        .set(PmMonitoringDevice::getDeleted, true)
                        .set(PmMonitoringDevice::getModifyTime, new Date()));
    }
}
