package org.jeecg.pm.entity;

import com.baomidou.mybatisplus.extension.handlers.AbstractJsonTypeHandler;
import com.chanjx.utils.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/17
 */
@Slf4j
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Coordinate implements Serializable {

    private Float x;

    private Float y;

    @Slf4j
    public static class TypeHandler extends AbstractJsonTypeHandler<Coordinate> {
        @Override
        protected Coordinate parse(String json) {
            try {
               return JsonUtils.json2Obj(json, Coordinate.class);
            } catch (JsonProcessingException e) {
                log.error("Json反序列化失败！", e);
            }
            return null;
        }

        @Override
        protected String toJson(Coordinate obj) {
            try {
                return JsonUtils.obj2Json(obj);
            } catch (JsonProcessingException e) {
                log.error("Json序列化失败！", e);
            }
            return null;
        }
    }
}
