package org.jeecg.pm.hikvision.sdk.entity.body.eps;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionBodyModel;
import org.jeecg.pm.hikvision.sdk.json.serialize.ListJoinWithCommaSerialize;

import java.util.List;

/**
 * @author: JJww
 * @Date:2022/3/23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionSubscribeEventsFromMQEx extends HikvisionBodyModel {

    /**
     * 事件类型集
     */
    @JsonSerialize(using = ListJoinWithCommaSerialize.class)
    private List<String> eventTypes;

    /**
     * 事件类型集与子系统编码不能同时为空。
     * 如果同时传入两个参数，必须子系统必须匹配。
     * 如果只传入子系统编码不传入事件类型集，则代表取消订阅该子系统的所有事件
     */
    private String subSystemUui;

}
