package org.jeecg.modules.demo.pm.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecg.common.aspect.annotation.Dict;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: pm_monitoring_device
 * @Author: jeecg-boot
 * @Date: 2022-03-15
 * @Version: V1.0
 */
@Data
@TableName(value = "pm_monitoring_device", autoResultMap = true)
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "pm_monitoring_device对象", description = "pm_monitoring_device")
public class PmMonitoringDevice implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private Integer id;
    /**
     * 设备编码
     */
    @Excel(name = "设备编码", width = 15)
    @ApiModelProperty(value = "设备编码")
    private String code;
    /**
     * 设备类型
     */
    @Excel(name = "设备类型", width = 15)
    @ApiModelProperty(value = "设备类型")
    private String type;
    /**
     * 设备名称
     */
    @Excel(name = "设备名称", width = 15)
    @ApiModelProperty(value = "设备名称")
    private String name;
    /**
     * 设备ip
     */
    @Excel(name = "设备ip", width = 15)
    @ApiModelProperty(value = "设备ip")
    private String ip;
    /**
     * 楼栋
     */
    @Excel(name = "楼栋", width = 15)
    @ApiModelProperty(value = "楼栋")
    private String buildingName;
    /**
     * 楼层
     */
    @Excel(name = "楼层", width = 15)
    @ApiModelProperty(value = "楼层")
    private String floor;
    /**
     * 设备位置
     */
    @Excel(name = "设备位置", width = 15)
    @ApiModelProperty(value = "设备位置")
    private String place;
    /**
     * xy值
     */
    @Excel(name = "xy值", width = 15)
    @ApiModelProperty(value = "xy值")
    @TableField(typeHandler = Coordinate.TypeHandler.class)
    private Coordinate coordinate;
    /**
     * 生产日期
     */
    @Excel(name = "生产日期", width = 15, format = "yyyy-MM-dd")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "生产日期")
    private Date dateOfProduction;
    /**
     * 安装日期
     */
    @Excel(name = "安装日期", width = 15, format = "yyyy-MM-dd")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "安装日期")
    private Date installationDate;
    /**
     * 保修截止日期
     */
    @Excel(name = "保修截止日期", width = 15, format = "yyyy-MM-dd")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "保修截止日期")
    private Date warrantyPeriod;
    /**
     * 生产厂商
     */
    @Excel(name = "生产厂商", width = 15)
    @ApiModelProperty(value = "生产厂商")
    private String manufacturer;
    /**
     * 状态
     */
    @Excel(name = "状态", width = 15)
    @ApiModelProperty(value = "状态")
    private String status;
    /**
     * 创建人Id（sys_user）
     */
    @Excel(name = "创建人Id（sys_user）", width = 15)
    @ApiModelProperty(value = "创建人Id（sys_user）")
    @Dict(dictTable = "sys_user", dicText = "realname", dicCode = "id")
    private String createUserId;
    /**
     * 修改人Id（sys_user）
     */
    @Excel(name = "修改人Id（sys_user）", width = 15)
    @ApiModelProperty(value = "修改人Id（sys_user）")
    @Dict(dictTable = "sys_user", dicText = "realname", dicCode = "id")
    private String modifyUserId;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 修改时间
     */
    @Excel(name = "修改时间", width = 15, format = "yyyy-MM-dd")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;
}
