package org.jeecg.pm.hikvision.sdk.result.vss.res;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.pm.hikvision.sdk.json.deserialize.ListJoinWithCommaDeserialize;
import org.jeecg.pm.hikvision.sdk.result.HikvisionBaseResult;
import org.jeecg.pm.hikvision.sdk.result.HikvisionPageResultData;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/23
 */
@Slf4j
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetCamerasExResult extends HikvisionBaseResult {

    /**
     * 返回数据
     */
    private HikvisionPageResultData<Camera> data;

    @Slf4j
    @Data
    @EqualsAndHashCode(callSuper = false)
    @Accessors(chain = true)
    public static class Camera implements Serializable {

        /**
         * 监控点 UUID
         */
        private String cameraUuid;

        /**
         * 监控点名称
         */
        private String cameraName;

        /**
         * 监控点类型
         */
        private String cameraType;

        /**
         * 通道号
         */
        private Integer cameraChannelNum;

        /**
         * 专业智能类型码
         * @see org.jeecg.pm.hikvision.sdk.entity.body.vss.res.Constant#SMART_TYPE_LIST
         */
        private String smartType;

        /**
         * 是否支持智能
         * @see org.jeecg.pm.hikvision.sdk.entity.body.vss.res.Constant#SMART_SUPPORT_LIST
         */
        private Integer smartSupport;

        /**
         * 在线状态
         */
        @JsonFormat(shape = JsonFormat.Shape.NUMBER)
        private Boolean onLineStatus;

        /**
         * 键盘矩阵 UUID
         */
        private String keyBoardCode;

        /**
         * 排序字段
         */
        private Integer orderNum;

        /**
         * 更新时间
         */
        private Date updateTime;

        /**
         * 中心 UUID
         */
        private String unitUuid;

        /**
         * 区域 UUID
         */
        private String regionUuid;

        /**
         * 编码设备 UUID
         */
        private String encoderUuid;

        /**
         * 资源权限集
         */
        @JsonDeserialize(using = ListJoinWithCommaDeserialize.class)
        private List<String> resAuths;

    }
}
