package org.jeecg.pm.hikvision.sdk.request;

import com.chanjx.utils.HttpMethod;
import org.apache.http.entity.ContentType;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionBodyModel;
import org.jeecg.pm.hikvision.sdk.entity.query.HikvisionQueryModel;
import org.jeecg.pm.hikvision.sdk.response.HikvisionResponse;
import org.jeecg.pm.hikvision.sdk.result.HikvisionBaseResult;

import java.util.Map;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
public interface HikvisionRequest<T extends HikvisionResponse<R>, R extends HikvisionBaseResult> {


    /**
     * 获取请求体类型请求头
     *
     * @return 请求头
     */
    ContentType getContentType();

    /**
     * 得到当前API的响应结果类型
     *
     * @return 响应类型
     */
    Class<T> getResponseClazz();

    /**
     * 获取返回业务对象的响应结果类型
     *
     * @return 响应类型
     */
    Class<R> getResultClazz();

    /**
     * 获取业务对象
     *
     * @return model
     */
    HikvisionBodyModel getModel();

    /**
     * 设置业务实体，如需使用此方法
     *
     * @param model WangsuModel
     */
    void setModel(HikvisionBodyModel model);

    /**
     * 获取 URI 查询参数
     *
     * @return URI 查询参数
     */
    HikvisionQueryModel getQuery();

    /**
     * 设置 URI 查询参数
     *
     * @param query query
     */
    void setQuery(HikvisionQueryModel query);


    /**
     * 获取请求接口方法：GET POST ...
     *
     * @return method
     */
    HttpMethod getHttpMethod();

    /**
     * 获取请求路径
     *
     * @return path
     */
    String getReqPath();

    /**
     * 获取设置的请求头参数（有的请求参数在请求头里）
     *
     * @return headers
     */
    Map<String, String> getHeaders();
}
