package org.jeecg.pm.hikvision.sdk.entity.body.vss.res;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionPageModel;
import org.jeecg.pm.hikvision.sdk.json.serialize.ListJoinWithCommaSerialize;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/23
 */
@Slf4j
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetCamerasEx extends HikvisionPageModel {

    public HikvisionGetCamerasEx() {
    }

    public HikvisionGetCamerasEx(Integer pageNo, Integer pageSize) {
        super(pageNo, pageSize);
    }

    /**
     * 监控点 UUID 集
     */
    @JsonSerialize(using = ListJoinWithCommaSerialize.class)
    private List<String> cameraUuids;

    /**
     * 组织中心UUID集
     */
    @JsonSerialize(using = ListJoinWithCommaSerialize.class)
    private List<String> unitUuids;

    /**
     * 区域 UUID 集
     */
    @JsonSerialize(using = ListJoinWithCommaSerialize.class)
    private List<String> regionUuids;

    /**
     * 编码设备UUID集
     */
    @JsonSerialize(using = ListJoinWithCommaSerialize.class)
    private List<String> encoderUuids;

    /**
     * 监控点名称
     */
    private String cameraName;

    /**
     * 编码设备名称
     */
    private String encoderName;

    /**
     * 是否是智能监控点
     *
     * @see Constant#IS_SMART_LIST
     */
    private String isSmart;

    /**
     * 专业智能类型码
     *
     * @see Constant#SMART_TYPE_LIST
     */
    private String smartType;


    public HikvisionGetCamerasEx setIsSmart(String isSmart) {
        if (!Constant.IS_SMART_LIST.contains(isSmart)) {
            throw new JeecgBootException("不支持的值，支持值：" + Constant.IS_SMART_LIST);
        }
        this.isSmart = isSmart;
        return this;
    }

    public HikvisionGetCamerasEx setSmartType(String smartType) {
        if (!Constant.SMART_TYPE_LIST.contains(smartType)) {
            throw new JeecgBootException("不支持的专业智能类型码，支持类码列表：" + Constant.SMART_TYPE_LIST);
        }
        this.smartType = smartType;
        return this;
    }
}
