package org.jeecg.pm.controller;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.pm.entity.EquipmentType;
import org.jeecg.pm.service.IEquipmentTypeService;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 设备状态
 * @Author: jeecg-boot
 * @Date:   2022-04-25
 * @Version: V1.0
 */
@Api(tags="设备状态")
@RestController
@RequestMapping("/pm/equipmentType")
@Slf4j
public class EquipmentTypeController extends JeecgController<EquipmentType, IEquipmentTypeService> {
	@Autowired
	private IEquipmentTypeService equipmentTypeService;
	
	/**
	 * 分页列表查询
	 *
	 * @param equipmentType
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "设备状态-分页列表查询")
	@ApiOperation(value="设备状态-分页列表查询", notes="设备状态-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<EquipmentType>> queryPageList(EquipmentType equipmentType,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<EquipmentType> queryWrapper = QueryGenerator.initQueryWrapper(equipmentType, req.getParameterMap());
		Page<EquipmentType> page = new Page<EquipmentType>(pageNo, pageSize);
		IPage<EquipmentType> pageList = equipmentTypeService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param equipmentType
	 * @return
	 */
	@AutoLog(value = "设备状态-添加")
	@ApiOperation(value="设备状态-添加", notes="设备状态-添加")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody EquipmentType equipmentType) {
		equipmentTypeService.save(equipmentType);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param equipmentType
	 * @return
	 */
	@AutoLog(value = "设备状态-编辑")
	@ApiOperation(value="设备状态-编辑", notes="设备状态-编辑")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody EquipmentType equipmentType) {
		equipmentTypeService.updateById(equipmentType);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "设备状态-通过id删除")
	@ApiOperation(value="设备状态-通过id删除", notes="设备状态-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		equipmentTypeService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "设备状态-批量删除")
	@ApiOperation(value="设备状态-批量删除", notes="设备状态-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.equipmentTypeService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "设备状态-通过id查询")
	@ApiOperation(value="设备状态-通过id查询", notes="设备状态-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<EquipmentType> queryById(@RequestParam(name="id",required=true) String id) {
		EquipmentType equipmentType = equipmentTypeService.getById(id);
		if(equipmentType==null) {
			return Result.error("未找到对应数据",null);
		}
		return Result.OK(equipmentType);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param equipmentType
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, EquipmentType equipmentType) {
        return super.exportXls(request, equipmentType, EquipmentType.class, "设备状态");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, EquipmentType.class);
    }

}
