package org.jeecg.pm.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecg.common.aspect.annotation.Dict;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: pm_access_control_device_record
 * @Author: jeecg-boot
 * @Date: 2022-03-15
 * @Version: V1.0
 */
@Data
@TableName("pm_access_control_device_record")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "pm_access_control_device_record对象", description = "pm_access_control_device_record")
public class PmAccessControlDeviceRecord implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private Integer id;
    /**
     * 门禁设备Id
     */
    @ApiModelProperty(value = "门禁设备Id")
    private Long pmAccessControlDeviceId;

    /**
     * 图片地址
     */
    @Excel(name = "图片地址", width = 15)
    @ApiModelProperty(value = "图片地址")
    private String pictureUrl;
    /**
     * 姓名
     */
    @Excel(name = "姓名", width = 15)
    @ApiModelProperty(value = "姓名")
    private String compellation;

    /**
     * 状态
     */
    @Excel(name = "员工归类", width = 15,dicCode = "access_control_classify")
    @Dict(dicCode = "access_control_classify")
    @ApiModelProperty(value = "员工归类 1:员工  2:访客 3:租户")
    private Integer classify;

    /**
     * 创建时间
     */
    @Excel(name = "创建时间", width = 15, format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 修改时间
     */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;
}
