package org.jeecg.pm.entity;

import java.io.Serializable;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.jeecg.common.aspect.annotation.Dict;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 车位管理
 * @Author: jeecg-boot
 * @Date:   2022-04-25
 * @Version: V1.0
 */
@Data
@TableName("parking_management")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="parking_management对象", description="车位管理")
public class ParkingManagement implements Serializable {
    private static final long serialVersionUID = 1L;

	/**id*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private Integer id;
	/**车位号*/
	@Excel(name = "车位号", width = 15)
    @ApiModelProperty(value = "车位号")
    private String parkingNo;
	/**停车场区域名称*/
	@Excel(name = "停车场区域名称", width = 15)
    @ApiModelProperty(value = "停车场区域名称")
    private String districtName;
	/**停车场区域ID*/
	@Excel(name = "停车场区域ID", width = 15)
    @ApiModelProperty(value = "停车场区域ID")
    private Integer districtId;
	/**停车车牌号*/
	@Excel(name = "停车车牌号", width = 15)
    @ApiModelProperty(value = "停车车牌号")
    private String plateNo;
	/**车位状态*/
    @Excel(name = "车位状态", width = 15,dicCode = "parking_management_status")
    @Dict(dicCode = "parking_management_status")
    @ApiModelProperty(value = "车位状态")
    private Integer status;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;
	/**删除状态*/
    @ApiModelProperty(value = "删除状态")
    private Boolean deleted;
}
