package org.jeecg.pm.controller;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.pm.entity.AlarmQuery;
import org.jeecg.pm.service.IAlarmQueryService;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 报警查询
 * @Author: jeecg-boot
 * @Date:   2022-04-25
 * @Version: V1.0
 */
@Api(tags="报警查询")
@RestController
@RequestMapping("/pm/alarmQuery")
@Slf4j
public class AlarmQueryController extends JeecgController<AlarmQuery, IAlarmQueryService> {
	@Autowired
	private IAlarmQueryService alarmQueryService;
	
	/**
	 * 分页列表查询
	 *
	 * @param alarmQuery
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "报警查询-分页列表查询")
	@ApiOperation(value="报警查询-分页列表查询", notes="报警查询-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<AlarmQuery>> queryPageList(AlarmQuery alarmQuery,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		Result<IPage<AlarmQuery>> result = new Result<IPage<AlarmQuery>>();
		QueryWrapper<AlarmQuery> queryWrapper = QueryGenerator.initQueryWrapper(alarmQuery, req.getParameterMap());
		Page<AlarmQuery> page = new Page<AlarmQuery>(pageNo, pageSize);
		IPage<AlarmQuery> pageList = alarmQueryService.page(page, queryWrapper);
		result.setSuccess(true);
		result.setResult(pageList);
		return result;
	}
	
	/**
	 *   添加
	 *
	 * @param alarmQuery
	 * @return
	 */
	@AutoLog(value = "报警查询-添加")
	@ApiOperation(value="报警查询-添加", notes="报警查询-添加")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody AlarmQuery alarmQuery) {
		alarmQueryService.save(alarmQuery);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param alarmQuery
	 * @return
	 */
	@AutoLog(value = "报警查询-编辑")
	@ApiOperation(value="报警查询-编辑", notes="报警查询-编辑")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody AlarmQuery alarmQuery) {
		alarmQueryService.updateById(alarmQuery);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "报警查询-通过id删除")
	@ApiOperation(value="报警查询-通过id删除", notes="报警查询-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		alarmQueryService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "报警查询-批量删除")
	@ApiOperation(value="报警查询-批量删除", notes="报警查询-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.alarmQueryService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "报警查询-通过id查询")
	@ApiOperation(value="报警查询-通过id查询", notes="报警查询-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<AlarmQuery> queryById(@RequestParam(name="id",required=true) String id) {
		AlarmQuery alarmQuery = alarmQueryService.getById(id);
		if(alarmQuery==null) {
			return Result.error("未找到对应数据",null);
		}
		return Result.OK(alarmQuery);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param alarmQuery
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, AlarmQuery alarmQuery) {
        return super.exportXls(request, alarmQuery, AlarmQuery.class, "报警查询");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, AlarmQuery.class);
    }

}
