package org.jeecg.pm.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.pm.entity.AdvertisingScreenSetting;
import org.jeecg.pm.service.IAdvertisingScreenSettingService;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 广告屏设置
 * @Author: jeecg-boot
 * @Date:   2022-05-18
 * @Version: V1.0
 */
@Api(tags="广告屏设置")
@RestController
@RequestMapping("/pm/advertisingScreenSetting")
@Slf4j
public class AdvertisingScreenSettingController extends JeecgController<AdvertisingScreenSetting, IAdvertisingScreenSettingService> {
	@Autowired
	private IAdvertisingScreenSettingService advertisingScreenSettingService;
	
	/**
	 * 分页列表查询
	 *
	 * @param advertisingScreenSetting
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "广告屏设置-分页列表查询")
	@ApiOperation(value="广告屏设置-分页列表查询", notes="广告屏设置-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<AdvertisingScreenSetting>> queryPageList(AdvertisingScreenSetting advertisingScreenSetting,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<AdvertisingScreenSetting> queryWrapper = QueryGenerator.initQueryWrapper(advertisingScreenSetting, req.getParameterMap());
		Page<AdvertisingScreenSetting> page = new Page<AdvertisingScreenSetting>(pageNo, pageSize);
		IPage<AdvertisingScreenSetting> pageList = advertisingScreenSettingService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param advertisingScreenSetting
	 * @return
	 */
	@AutoLog(value = "广告屏设置-添加")
	@ApiOperation(value="广告屏设置-添加", notes="广告屏设置-添加")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody AdvertisingScreenSetting advertisingScreenSetting) {
		advertisingScreenSetting.setDeleted(false);
		advertisingScreenSetting.setCreateTime(new Date());
		advertisingScreenSettingService.save(advertisingScreenSetting);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param advertisingScreenSetting
	 * @return
	 */
	@AutoLog(value = "广告屏设置-编辑")
	@ApiOperation(value="广告屏设置-编辑", notes="广告屏设置-编辑")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody AdvertisingScreenSetting advertisingScreenSetting) {
		advertisingScreenSettingService.updateById(advertisingScreenSetting);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "广告屏设置-通过id删除")
	@ApiOperation(value="广告屏设置-通过id删除", notes="广告屏设置-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		advertisingScreenSettingService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "广告屏设置-批量删除")
	@ApiOperation(value="广告屏设置-批量删除", notes="广告屏设置-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.advertisingScreenSettingService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "广告屏设置-通过id查询")
	@ApiOperation(value="广告屏设置-通过id查询", notes="广告屏设置-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<AdvertisingScreenSetting> queryById(@RequestParam(name="id",required=true) String id) {
		AdvertisingScreenSetting advertisingScreenSetting = advertisingScreenSettingService.getById(id);
		if(advertisingScreenSetting==null) {
			return Result.error("未找到对应数据",null);
		}
		return Result.OK(advertisingScreenSetting);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param advertisingScreenSetting
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, AdvertisingScreenSetting advertisingScreenSetting) {
        return super.exportXls(request, advertisingScreenSetting, AdvertisingScreenSetting.class, "广告屏设置");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, AdvertisingScreenSetting.class);
    }

}
