package org.jeecg.pm.hikvision.sdk.result.eps;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecg.pm.hikvision.sdk.result.HikvisionBaseResult;

import java.io.Serializable;

/**
 * @author: JJww
 * @Date:2022/3/23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionSubscribeEventsFromMQExResult extends HikvisionBaseResult {

    /**
     * 返回数据
     */
    private MQInfo data;

    @Data
    @EqualsAndHashCode(callSuper = false)
    @Accessors(chain = true)
    public static class MQInfo implements Serializable {
        /**
         * MQ 的地址和端口
         */
        private String mqURL;

        /**
         * 订阅名称
         */
        private String destination;
    }
}
