package org.jeecg.pm.mq;


import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.pm.entity.eps.EventDis;
import org.jeecg.pm.entity.event.PmEventInfo;
import org.jeecg.pm.service.event.IPmEventInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import javax.jms.BytesMessage;

/**
 * @author: JJww
 * @Date:2022/3/23
 */
@Slf4j
@Component
public class EventMessageListener {

    /**
     * 视频事件
     */
    private final static String VSS_TOPIC = "openapi.vss.topic";

    /**
     * 报警事件
     */
    private final static String EPS_TOPIC = "openapi.eps.topic";

    @Autowired
    private IPmEventInfoService pmEventInfoService;


    @JmsListener(destination = VSS_TOPIC)
    public void vssProcessMessage(BytesMessage bytesMessage) throws Exception {
        final byte[] bytes = new byte[(int) bytesMessage.getBodyLength()];
        bytesMessage.readBytes(bytes);
        // 壳文件字段，EventDis类为event_dis.proto文件解析而来，CommEventLog类为事件壳文件类
        final EventDis.CommEventLog commEventLog = EventDis.CommEventLog.parseFrom(bytes);
        PmEventInfo pmEventInfo = new PmEventInfo()
                .setEventCategory(PmEventInfo.VSS)
                .setId(IdWorker.getId())
                .setLogId(commEventLog.getLogId())
                .setEventState(commEventLog.getEventState())
                .setEventLevel(commEventLog.getEventLevel())
                .setUnitIdx(commEventLog.getUnitIdx())
                .setEventType(commEventLog.getEventType())
                .setEventTypeName(commEventLog.getEventTypeName())
                .setSubSysType(commEventLog.getSubSysType())
                .setEventName(commEventLog.getEventName())
                .setStartTime(commEventLog.getStartTime())
                .setStopTime(commEventLog.getStopTime())
                .setSourceIdx(commEventLog.getSourceIdx())
                .setSourceType(commEventLog.getSourceType())
                .setSourceName(commEventLog.getSourceName())
                .setLogTxt(commEventLog.getLogTxt())
                .setRegionIdx(commEventLog.getRegionIdx())
                .setExtInfo(commEventLog.getExtInfo().toString());
        log.info(pmEventInfo.toString());
        pmEventInfoService.save(pmEventInfo);
    }


    @JmsListener(destination = EPS_TOPIC)
    public void epsProcessMessage(BytesMessage bytesMessage) throws Exception {
        final byte[] bytes = new byte[(int) bytesMessage.getBodyLength()];
        bytesMessage.readBytes(bytes);
        // 壳文件字段，EventDis类为event_dis.proto文件解析而来，CommEventLog类为事件壳文件类
        final EventDis.CommEventLog commEventLog = EventDis.CommEventLog.parseFrom(bytes);
        // 扩展字段，此字段为设备上报事件内容，部分事件需要使用pb文件再次解析
        System.out.println(commEventLog);
    }

}
