package org.jeecg.pm.hikvision.sdk.request.eps;

import com.chanjx.utils.HttpMethod;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.http.entity.ContentType;
import org.jeecg.pm.hikvision.sdk.entity.body.eps.HikvisionGetEventTypes;
import org.jeecg.pm.hikvision.sdk.request.HikvisionAbstractRequest;
import org.jeecg.pm.hikvision.sdk.response.eps.HikvisionGetEventTypesRespsonse;
import org.jeecg.pm.hikvision.sdk.result.eps.HikvisionGetEventTypesResult;

/**
 * @author: JJww
 * @Date:2022/3/24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetEventTypesRequest extends HikvisionAbstractRequest<HikvisionGetEventTypesRespsonse, HikvisionGetEventTypesResult> {

    public HikvisionGetEventTypesRequest(HikvisionGetEventTypes hikvisionGetEventTypes) {
        super(hikvisionGetEventTypes);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Class<HikvisionGetEventTypesRespsonse> getResponseClazz() {
        return HikvisionGetEventTypesRespsonse.class;
    }

    @Override
    public Class<HikvisionGetEventTypesResult> getResultClazz() {
        return HikvisionGetEventTypesResult.class;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getReqPath() {
        return "/openapi/service/eps/getEventTypes";
    }

}
