package org.jeecg.pm.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.pm.entity.PmAccessControlDevice;
import org.jeecg.pm.service.IPmAccessControlDeviceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * @Description: pm_access_control_device
 * @Author: jeecg-boot
 * @Date: 2022-03-15
 * @Version: V1.0
 */
@Api(tags = "pm_access_control_device")
@RestController
@RequestMapping("/pm/pmAccessControlDevice")
@Slf4j
public class PmAccessControlDeviceController extends JeecgController<PmAccessControlDevice, IPmAccessControlDeviceService> {

    private static final List<String> TYPES = Arrays.asList("出入口闸机", "访客一体机", "自助访客机", "身份证读卡器", "人脸识别");

    @Autowired
    private IPmAccessControlDeviceService pmAccessControlDeviceService;

    /**
     * 分页列表查询
     *
     * @param pmAccessControlDevice
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    //@AutoLog(value = "pm_access_control_device-分页列表查询")
    @ApiOperation(value = "pm_access_control_device-分页列表查询", notes = "pm_access_control_device-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<PmAccessControlDevice>> queryPageList(PmAccessControlDevice pmAccessControlDevice,
                                                              @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                              @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                              HttpServletRequest req) {
        QueryWrapper<PmAccessControlDevice> queryWrapper = QueryGenerator.initQueryWrapper(pmAccessControlDevice, req.getParameterMap());
        Page<PmAccessControlDevice> page = new Page<>(pageNo, pageSize);
        IPage<PmAccessControlDevice> pageList = pmAccessControlDeviceService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param pmAccessControlDevice
     * @return
     */
    @AutoLog(value = "pm_access_control_device-添加")
    @ApiOperation(value = "pm_access_control_device-添加", notes = "pm_access_control_device-添加")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody PmAccessControlDevice pmAccessControlDevice) {
        pmAccessControlDeviceService.save(pmAccessControlDevice);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param pmAccessControlDevice
     * @return
     */
    @AutoLog(value = "pm_access_control_device-编辑")
    @ApiOperation(value = "pm_access_control_device-编辑", notes = "pm_access_control_device-编辑")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody PmAccessControlDevice pmAccessControlDevice) {
        pmAccessControlDeviceService.updateById(pmAccessControlDevice);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "pm_access_control_device-通过id删除")
    @ApiOperation(value = "pm_access_control_device-通过id删除", notes = "pm_access_control_device-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {
        pmAccessControlDeviceService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "pm_access_control_device-批量删除")
    @ApiOperation(value = "pm_access_control_device-批量删除", notes = "pm_access_control_device-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.pmAccessControlDeviceService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    //@AutoLog(value = "pm_access_control_device-通过id查询")
    @ApiOperation(value = "pm_access_control_device-通过id查询", notes = "pm_access_control_device-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<PmAccessControlDevice> queryById(@RequestParam(name = "id", required = true) String id) {
        PmAccessControlDevice pmAccessControlDevice = pmAccessControlDeviceService.getById(id);
        if (pmAccessControlDevice == null) {
            return Result.error("未找到对应数据", null);
        }
        return Result.OK(pmAccessControlDevice);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param pmAccessControlDevice
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, PmAccessControlDevice pmAccessControlDevice) {
        return super.exportXls(request, pmAccessControlDevice, PmAccessControlDevice.class, "pm_access_control_device");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, PmAccessControlDevice.class);
    }

    @GetMapping("/types")
    public Result<List<String>> getTypes() {
        return Result.OK(TYPES);
    }
}
