package org.jeecg.modules.pm.config;

import com.google.protobuf.InvalidProtocolBufferException;
import org.jeecg.modules.pm.entity.eps.EventDis;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.JmsListener;

import javax.jms.BytesMessage;
import javax.jms.JMSException;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/29
 */
@Configuration
public class HikvisionMQ {

    @JmsListener(destination = "openapi.vss.topic")
    public void processMessage(BytesMessage bytesMessage) throws JMSException, InvalidProtocolBufferException {
        final byte[] bytes = new byte[(int) bytesMessage.getBodyLength()];
        bytesMessage.readBytes(bytes);
        final EventDis.CommEventLog commEventLog = EventDis.CommEventLog.parseFrom(bytes);
        System.out.println(commEventLog);
    }
}
