package org.jeecg.modules.demo.pm.controller;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.demo.pm.entity.PmBuildingInfo;
import org.jeecg.pm.hikvision.sdk.client.HikvisionClient;
import org.jeecg.pm.hikvision.sdk.entity.body.vss.preview.HikvisiongetPreviewParamByCameraUuid;
import org.jeecg.pm.hikvision.sdk.entity.body.vss.res.HikvisionGetCamerasEx;
import org.jeecg.pm.hikvision.sdk.request.base.netzone.HikvisionGetNetZonesRequest;
import org.jeecg.pm.hikvision.sdk.request.vss.preview.HikvisionPreviewParamByCameraUuidRequest;
import org.jeecg.pm.hikvision.sdk.request.vss.res.HikvisionGetCamerasExRequest;
import org.jeecg.pm.hikvision.sdk.response.base.netzone.HikvisionGetNetZonesResponse;
import org.jeecg.pm.hikvision.sdk.response.vss.preview.HikvisionPreviewParamByCameraUuidResponse;
import org.jeecg.pm.hikvision.sdk.response.vss.res.HikvisionGetCamerasExResponse;
import org.jeecg.pm.hikvision.sdk.result.base.netzone.HikvisionGetNetZonesResult;
import org.jeecg.pm.hikvision.sdk.result.vss.preview.HikvisionPreviewParamByCameraUuidResult;
import org.jeecg.pm.hikvision.sdk.result.vss.res.HikvisionGetCamerasExResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/17
 */
@Api(tags = "pm_access_control_device")
@RestController
@RequestMapping("/pm/pmBuildingInfo")
@Slf4j
public class PmBuildingInfoController {

    @Autowired
    private HikvisionClient hikvisionClient;

    private static final List<PmBuildingInfo> BUILDING_INFOS = Arrays.asList(
            new PmBuildingInfo()
                    .setName("望海路1号楼")
                    .setFloorList(Arrays.asList("-2F", "-1F", "1F", "2F", "3F")),
            new PmBuildingInfo()
                    .setName("望海路2号楼")
                    .setFloorList(Arrays.asList("-3F", "-2F", "-1F", "1F", "2F", "3F", "4F"))
    );

    @GetMapping("/list")
    public Result<List<PmBuildingInfo>> list() {
        return Result.OK(BUILDING_INFOS);
    }

    @GetMapping("/hik")
    public Result<HikvisionPreviewParamByCameraUuidResult> hik() {
        final HikvisionGetCamerasEx camerasEx = new HikvisionGetCamerasEx(1, 10);
        final HikvisionGetCamerasExResponse camerasExResponse = hikvisionClient.execute(new HikvisionGetCamerasExRequest(camerasEx));
        final HikvisionGetCamerasExResult camerasExResult = camerasExResponse.getResult();
        final String cameraUuid = camerasExResult.getData().getList().get(0).getCameraUuid();

        final HikvisionGetNetZonesResponse netZonesResponse = hikvisionClient.execute(new HikvisionGetNetZonesRequest());
        final List<HikvisionGetNetZonesResult.NetZone> netZones = netZonesResponse.getResult().getData();
        final HikvisionPreviewParamByCameraUuidResponse response = hikvisionClient.execute(
                new HikvisionPreviewParamByCameraUuidRequest(
                        new HikvisiongetPreviewParamByCameraUuid(cameraUuid, netZones.get(0).getNetZoneUuid())));
        return Result.OK(response.getResult());
    }
}
