package org.jeecg.modules.demo.pm.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.demo.pm.entity.PmMonitoringDevice;
import org.jeecg.modules.demo.pm.service.IPmMonitoringDeviceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * @Description: pm_monitoring_device
 * @Author: jeecg-boot
 * @Date: 2022-03-15
 * @Version: V1.0
 */
@Api(tags = "pm_monitoring_device")
@RestController
@RequestMapping("/pm/pmMonitoringDevice")
@Slf4j
public class PmMonitoringDeviceController extends JeecgController<PmMonitoringDevice, IPmMonitoringDeviceService> {
    @Autowired
    private IPmMonitoringDeviceService pmMonitoringDeviceService;

    /**
     * 分页列表查询
     *
     * @param pmMonitoringDevice
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    //@AutoLog(value = "pm_monitoring_device-分页列表查询")
    @ApiOperation(value = "pm_monitoring_device-分页列表查询", notes = "pm_monitoring_device-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<PmMonitoringDevice>> queryPageList(PmMonitoringDevice pmMonitoringDevice,
                                                           @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                           @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                           HttpServletRequest req) {
        QueryWrapper<PmMonitoringDevice> queryWrapper = QueryGenerator.initQueryWrapper(pmMonitoringDevice, req.getParameterMap());
        Page<PmMonitoringDevice> page = new Page<PmMonitoringDevice>(pageNo, pageSize);
        IPage<PmMonitoringDevice> pageList = pmMonitoringDeviceService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    @GetMapping("/listByFloorId")
    public Result<List<PmMonitoringDevice>> listByFloorId(Long floorId) {
        return null;
    }

    /**
     * 添加
     *
     * @param pmMonitoringDevice
     * @return
     */
    @AutoLog(value = "pm_monitoring_device-添加")
    @ApiOperation(value = "pm_monitoring_device-添加", notes = "pm_monitoring_device-添加")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody PmMonitoringDevice pmMonitoringDevice) {
        pmMonitoringDeviceService.save(pmMonitoringDevice);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param pmMonitoringDevice
     * @return
     */
    @AutoLog(value = "pm_monitoring_device-编辑")
    @ApiOperation(value = "pm_monitoring_device-编辑", notes = "pm_monitoring_device-编辑")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody PmMonitoringDevice pmMonitoringDevice) {
        pmMonitoringDeviceService.updateById(pmMonitoringDevice);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "pm_monitoring_device-通过id删除")
    @ApiOperation(value = "pm_monitoring_device-通过id删除", notes = "pm_monitoring_device-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {
        pmMonitoringDeviceService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "pm_monitoring_device-批量删除")
    @ApiOperation(value = "pm_monitoring_device-批量删除", notes = "pm_monitoring_device-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.pmMonitoringDeviceService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    //@AutoLog(value = "pm_monitoring_device-通过id查询")
    @ApiOperation(value = "pm_monitoring_device-通过id查询", notes = "pm_monitoring_device-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<PmMonitoringDevice> queryById(@RequestParam(name = "id", required = true) String id) {
        PmMonitoringDevice pmMonitoringDevice = pmMonitoringDeviceService.getById(id);
        if (pmMonitoringDevice == null) {
            return Result.error("未找到对应数据", null);
        }
        return Result.OK(pmMonitoringDevice);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param pmMonitoringDevice
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, PmMonitoringDevice pmMonitoringDevice) {
        return super.exportXls(request, pmMonitoringDevice, PmMonitoringDevice.class, "pm_monitoring_device");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, PmMonitoringDevice.class);
    }

}
