package org.jeecg.pm.hikvision.sdk.entity.body.vss.playback;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.pm.hikvision.sdk.entity.Constant;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionBodyModel;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/24
 */
@Slf4j
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetPlaybackParamByPlanUuid extends HikvisionBodyModel {

    public HikvisionGetPlaybackParamByPlanUuid(String recordPlanUuid, Integer planType, String netZoneUuid) {
        this.recordPlanUuid = recordPlanUuid;
        this.planType = planType;
        this.netZoneUuid = netZoneUuid;
    }

    /**
     * 录像计划 UUID
     */
    private String recordPlanUuid;

    /**
     * 录像计划类型
     * @see Constant#PLAN_TYPE_LIST
     */
    private Integer planType;

    /**
     * 网域 UUID
     */
    private String netZoneUuid;
}
