package org.jeecg.pm.hikvision.sdk.entity.body;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.exception.JeecgBootException;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/23
 */
@Slf4j
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public abstract class HikvisionPageModel extends HikvisionBodyModel {

    public HikvisionPageModel() {
    }

    public HikvisionPageModel(Integer pageNo, Integer pageSize) {
        if (pageNo < 1) {
            throw new JeecgBootException("当前页码不可小于1！");
        }
        if (pageSize > 1000) {
            throw new JeecgBootException("每页数据记录不可大于1000");
        }
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    /**
     * 当前页码
     */
    private Integer pageNo;

    /**
     * 每页数据最大记录数
     */
    private Integer pageSize;
}
