package org.jeecg.pm.hikvision.sdk.result.eps;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecg.pm.hikvision.sdk.result.HikvisionBaseResult;

import java.io.Serializable;
import java.util.List;

/**
 * @author: JJww
 * @Date:2022/3/24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetEventTypesResult extends HikvisionBaseResult {

    private List<EventType> data;

    @Data
    @EqualsAndHashCode(callSuper = false)
    @Accessors(chain = true)
    public static class EventType implements Serializable {
        /**
         * 子系统UUID
         */
        private String subSystemUuid;

        /**
         * 事件类型
         */
        private Integer eventType;

        /**
         * 事件名称
         */
        private String eventTypeName;
    }
}
