package org.jeecg.pm.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.pm.entity.PmEventInfo;
import org.jeecg.pm.mapper.PmEventInfoMapper;
import org.jeecg.pm.service.IPmEventInfoService;
import org.springframework.stereotype.Service;

/**
 * @Description: pm_event_info
 * @Author: jeecg-boot
 * @Date: 2022-04-01
 * @Version: V1.0
 */
@Slf4j
@Service
public class PmEventInfoServiceImpl extends ServiceImpl<PmEventInfoMapper, PmEventInfo> implements IPmEventInfoService {

    @Override
    public void saveEvent(PmEventInfo pmEventInfo) {
        final PmEventInfo eventInfo = baseMapper.selectOne(new QueryWrapper<PmEventInfo>().lambda().eq(PmEventInfo::getLogId, pmEventInfo.getLogId()));//事件唯一ID
        pmEventInfo.setId(eventInfo == null ? IdWorker.getId() : eventInfo.getId());
        this.saveOrUpdate(pmEventInfo);
    }


}
