package org.jeecg.pm.hikvision.sdk.request.vss.res;

import com.chanjx.utils.HttpMethod;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.http.entity.ContentType;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionBodyModel;
import org.jeecg.pm.hikvision.sdk.entity.body.vss.res.HikvisionGetCamerasEx;
import org.jeecg.pm.hikvision.sdk.request.HikvisionAbstractRequest;
import org.jeecg.pm.hikvision.sdk.response.vss.res.HikvisionGetCamerasExResponse;
import org.jeecg.pm.hikvision.sdk.result.vss.res.HikvisionGetCamerasExResult;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetCamerasExRequest extends HikvisionAbstractRequest<HikvisionGetCamerasExResponse, HikvisionGetCamerasExResult> {

    private HikvisionGetCamerasEx hikvisionGetCamerasEx;

    public HikvisionGetCamerasExRequest(HikvisionGetCamerasEx hikvisionGetCamerasEx) {
        this.hikvisionGetCamerasEx = hikvisionGetCamerasEx;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Class<HikvisionGetCamerasExResponse> getResponseClazz() {
        return HikvisionGetCamerasExResponse.class;
    }

    @Override
    public Class<HikvisionGetCamerasExResult> getResultClazz() {
        return HikvisionGetCamerasExResult.class;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getReqPath() {
        return "/openapi/service/vss/res/getCamerasEx";
    }

    @Override
    public HikvisionBodyModel getModel() {
        return hikvisionGetCamerasEx;
    }

    @Override
    public void setModel(HikvisionBodyModel model) {
        this.hikvisionGetCamerasEx = (HikvisionGetCamerasEx) model;
    }
}
