package org.jeecg.pm.hikvision.sdk.json.serialize;

import com.chanjx.utils.StringUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;

/**
 * <p>
 * Jackson自定义序列化：将迭代器序列化成以逗号分隔的字符串
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/23
 */
public class ListJoinWithCommaSerialize extends JsonSerializer<Iterable<Object>> {

    @Override
    public void serialize(Iterable<Object> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeObject(StringUtils.joinWithComma(value));
    }

}
