CREATE database if NOT EXISTS `jeecg-boot` default character set utf8mb4 collate utf8mb4_general_ci;
use `jeecg-boot`;

/*
 Navicat Premium Data Transfer

 Source Server         : mysql5.7
 Source Server Type    : MySQL
 Source Server Version : 50727
 Source Host           : 127.0.0.1:3306
 Source Schema         : jeecg-boot

 Target Server Type    : MySQL
 Target Server Version : 50727
 File Encoding         : 65001

 Date: 23/02/2022 23:08:40
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for ces_field_kongj
-- ----------------------------
DROP TABLE IF EXISTS `ces_field_kongj`;
CREATE TABLE `ces_field_kongj`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户名',
  `sex` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '下拉框',
  `radio` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'radio',
  `checkbox` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'checkbox',
  `sel_mut` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '下拉多选',
  `sel_search` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '下拉搜索',
  `birthday` datetime NULL DEFAULT NULL COMMENT '时间',
  `pic` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片',
  `files` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件',
  `remakr` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT 'markdown',
  `fuwenb` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '富文本',
  `user_sel` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '选择用户',
  `dep_sel` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '选择部门',
  `ddd` double(10, 0) NULL DEFAULT NULL COMMENT 'DD类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ces_field_kongj
-- ----------------------------
INSERT INTO `ces_field_kongj` VALUES ('1260185893546840066', 'admin', '2020-05-12 20:31:44', 'admin', '2020-09-11 17:02:30', 'A01', 'A011', '2', '2', '1,2', '', '', NULL, '', '', '', '', 'zhagnxiao', 'A01', NULL);
INSERT INTO `ces_field_kongj` VALUES ('1260185911146139650', 'admin', '2020-05-12 20:31:49', 'admin', '2020-07-20 17:10:05', 'A01', 'A011', NULL, '1', '1,2', NULL, 'admin', NULL, 'd52a2834349b033b6d20d5cc16ce36d3d539bd7f_1594438138364.jpg', '', '', NULL, 'admin', 'A01', NULL);
INSERT INTO `ces_field_kongj` VALUES ('1285112866127577089', 'admin', '2020-07-20 15:22:38', 'admin', '2021-07-22 17:25:08', 'A01', '11', NULL, '2', NULL, NULL, NULL, NULL, '', '', '11', NULL, NULL, NULL, NULL);
INSERT INTO `ces_field_kongj` VALUES ('1369290708802387969', 'admin', '2021-03-09 22:15:19', 'admin', '2021-07-22 19:37:48', 'A01', 'admin44', '1', '2', '2', '2', 'jeecg', NULL, '20180607175028Fn1Lq7zw_1615299331700.png', '', '', '', 'admin', 'A01', NULL);

-- ----------------------------
-- Table structure for ces_order_customer
-- ----------------------------
DROP TABLE IF EXISTS `ces_order_customer`;
CREATE TABLE `ces_order_customer`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户名字',
  `sex` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户性别',
  `birthday` datetime NULL DEFAULT NULL COMMENT '客户生日',
  `age` int(11) NULL DEFAULT NULL COMMENT '年龄',
  `address` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '常用地址',
  `order_main_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ces_order_customer
-- ----------------------------
INSERT INTO `ces_order_customer` VALUES ('1281792646935842818', 'admin', '2020-07-11 11:29:16', NULL, NULL, 'A01', NULL, NULL, NULL, NULL, NULL, '1260135645520654338');
INSERT INTO `ces_order_customer` VALUES ('1281794386984779777', 'admin', '2020-07-11 11:36:11', NULL, NULL, 'A01', '管理员', '1', '2018-12-05 00:00:00', NULL, NULL, '1281794386716344321');
INSERT INTO `ces_order_customer` VALUES ('1335894537933430785', 'admin', '2020-12-07 18:30:52', NULL, NULL, 'A01', '张三', '', NULL, NULL, NULL, '1335894537597886465');
INSERT INTO `ces_order_customer` VALUES ('15889531549290863128', 'admin', '2020-05-08 23:54:00', NULL, NULL, 'A01', '小王', '1', '2020-05-08 00:00:00', 1, '', '1258787241599250433');
INSERT INTO `ces_order_customer` VALUES ('15889531551231672264', 'admin', '2020-05-08 23:54:00', NULL, NULL, 'A01', '校长', '2', '2020-05-23 00:00:00', 2, '', '1258787241599250433');
INSERT INTO `ces_order_customer` VALUES ('15889531554322486243', 'admin', '2020-05-08 23:54:00', NULL, NULL, 'A01', '小明', '2', '2020-05-03 00:00:00', 3, '', '1258787241599250433');
INSERT INTO `ces_order_customer` VALUES ('15892741044590530487', 'admin', '2020-05-12 17:02:32', NULL, NULL, 'A01A05', '111', '1', '2020-05-12 00:00:00', NULL, '', '1260133243631562754');
INSERT INTO `ces_order_customer` VALUES ('15892741436981375151', 'admin', '2020-05-12 17:02:32', NULL, NULL, 'A01A05', '11', '1', '2020-05-14 00:00:00', NULL, '', '1260133243631562754');

-- ----------------------------
-- Table structure for ces_order_goods
-- ----------------------------
DROP TABLE IF EXISTS `ces_order_goods`;
CREATE TABLE `ces_order_goods`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  `good_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名字',
  `price` double NULL DEFAULT NULL COMMENT '价格',
  `num` int(11) NULL DEFAULT NULL COMMENT '数量',
  `zong_price` double NULL DEFAULT NULL COMMENT '单品总价',
  `order_main_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ces_order_goods
-- ----------------------------
INSERT INTO `ces_order_goods` VALUES ('1335894537799213058', 'admin', '2020-12-07 18:30:52', NULL, NULL, 'A01', '11', NULL, NULL, NULL, '1335894537597886465');
INSERT INTO `ces_order_goods` VALUES ('1335894537857933313', 'admin', '2020-12-07 18:30:52', NULL, NULL, 'A01', '22', NULL, NULL, NULL, '1335894537597886465');
INSERT INTO `ces_order_goods` VALUES ('1335894537878904833', 'admin', '2020-12-07 18:30:52', NULL, NULL, 'A01', '22', NULL, NULL, NULL, '1335894537597886465');
INSERT INTO `ces_order_goods` VALUES ('15889531536650244013', 'admin', '2020-05-08 23:54:00', NULL, NULL, 'A01', '显示器', 11, 1, 11, '1258787241599250433');
INSERT INTO `ces_order_goods` VALUES ('15889531538491119218', 'admin', '2020-05-08 23:54:00', NULL, NULL, 'A01', '鼠标', 22, 2, 44, '1258787241599250433');
INSERT INTO `ces_order_goods` VALUES ('15889532051192650399', 'admin', '2020-05-08 23:54:00', NULL, NULL, 'A01', '键盘', 33, 3, 99, '1258787241599250433');
INSERT INTO `ces_order_goods` VALUES ('15892741033410312304', 'admin', '2020-05-12 17:02:32', NULL, NULL, 'A01A05', '雷蛇键盘', 200, 2, NULL, '1260133243631562754');
INSERT INTO `ces_order_goods` VALUES ('15892741162151118866', 'admin', '2020-05-12 17:02:32', NULL, NULL, 'A01A05', '樱桃键盘', 200, 4, NULL, '1260133243631562754');
INSERT INTO `ces_order_goods` VALUES ('15892747180850346324', 'admin', '2020-07-11 11:29:16', NULL, NULL, 'A01', '11', 11, NULL, NULL, '1260135645520654338');
INSERT INTO `ces_order_goods` VALUES ('15892934593221167669', 'admin', '2020-07-11 11:29:16', NULL, NULL, 'A01', '', NULL, NULL, NULL, '1260135645520654338');
INSERT INTO `ces_order_goods` VALUES ('15892934594762635052', 'admin', '2020-07-11 11:29:16', NULL, NULL, 'A01', '', NULL, NULL, NULL, '1260135645520654338');
INSERT INTO `ces_order_goods` VALUES ('15944385645060861881', 'admin', '2020-07-11 11:36:11', NULL, NULL, 'A01', '11', NULL, NULL, NULL, '1281794386716344321');
INSERT INTO `ces_order_goods` VALUES ('15944385663981814101', 'admin', '2020-07-11 11:36:11', NULL, NULL, 'A01', '22', NULL, NULL, NULL, '1281794386716344321');

-- ----------------------------
-- Table structure for ces_order_main
-- ----------------------------
DROP TABLE IF EXISTS `ces_order_main`;
CREATE TABLE `ces_order_main`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  `order_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单编码',
  `xd_date` datetime NULL DEFAULT NULL COMMENT '下单时间',
  `money` double NULL DEFAULT NULL COMMENT '订单总额',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ces_order_main
-- ----------------------------
INSERT INTO `ces_order_main` VALUES ('1258787241599250433', 'admin', '2020-05-08 23:54:00', NULL, NULL, 'A01', '20200508-0001', '2020-05-08 23:52:32', 50000, NULL);
INSERT INTO `ces_order_main` VALUES ('1260133243631562754', 'admin', '2020-05-12 17:02:32', NULL, NULL, 'A01A05', '202005120001', '2020-05-12 17:01:39', NULL, NULL);
INSERT INTO `ces_order_main` VALUES ('1260135645520654338', 'admin', '2020-05-12 17:12:04', 'admin', '2020-07-11 11:29:16', 'A01', 'JDFX2020051217115656', '2020-07-11 11:29:12', NULL, NULL);
INSERT INTO `ces_order_main` VALUES ('1281794386716344321', 'admin', '2020-07-11 11:36:11', NULL, NULL, 'A01', 'CN2020071111360067', '2020-07-11 11:36:00', NULL, NULL);
INSERT INTO `ces_order_main` VALUES ('1335894537597886465', 'admin', '2020-12-07 18:30:52', NULL, NULL, 'A01', 'CN2020120718303277', '2020-12-16 18:30:32', NULL, NULL);

-- ----------------------------
-- Table structure for ces_shop_goods
-- ----------------------------
DROP TABLE IF EXISTS `ces_shop_goods`;
CREATE TABLE `ces_shop_goods`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名字',
  `price` decimal(10, 5) NULL DEFAULT NULL COMMENT '价格',
  `chuc_date` datetime NULL DEFAULT NULL COMMENT '出厂时间',
  `contents` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '商品简介',
  `good_type_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品分类',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ces_shop_goods
-- ----------------------------
INSERT INTO `ces_shop_goods` VALUES ('1258408897326149634', 'admin', '2020-05-07 22:50:35', 'admin', '2020-05-07 22:52:17', 'A01', '华为手机note', 5000.00000, '2020-05-07 00:00:00', '<div class=\"page1-content\" style=\"margin: 0px 0px 20px; padding: 0px; display: flex; justify-content: space-around; color: #2c3e50; font-family: Avenir, Helvetica, Arial, sans-serif; text-align: center; background-color: #eeeeee;\">\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(166, 55, 112, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/soo.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">快速开发</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(191, 188, 21, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/rule.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">数据权限</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(73, 101, 166, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/bpm2.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">工作流</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(135, 85, 255, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/report1.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">丰富组件库</span></div>\n</div>\n</div>\n<div class=\"page1-content\" style=\"margin: 0px; padding: 0px; display: flex; justify-content: space-around; color: #2c3e50; font-family: Avenir, Helvetica, Arial, sans-serif; text-align: center; background-color: #eeeeee;\">\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(166, 55, 112, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/icon1.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">代码生成器</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(191, 188, 21, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/Automation.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">Online在线开发</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(73, 101, 166, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/form2.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">表单设计器</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(135, 85, 255, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/bpm3.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">流程设计器</span></div>\n</div>\n</div>', '1258408044439597058');
INSERT INTO `ces_shop_goods` VALUES ('1258783909887422466', 'admin', '2020-05-08 23:40:45', 'admin', '2020-05-08 23:43:03', 'A01', '雷蛇鼠标', 500.00000, '2020-05-08 00:00:00', '', '1258408003595464706');
INSERT INTO `ces_shop_goods` VALUES ('1285114089585082370', 'admin', '2020-07-20 15:27:29', NULL, NULL, 'A01', NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for ces_shop_type
-- ----------------------------
DROP TABLE IF EXISTS `ces_shop_type`;
CREATE TABLE `ces_shop_type`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类名字',
  `content` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `pics` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片',
  `pid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '父级节点',
  `has_child` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否有子节点',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ces_shop_type
-- ----------------------------
INSERT INTO `ces_shop_type` VALUES ('1258408003595464706', 'admin', '2020-05-07 22:47:02', NULL, NULL, 'A01', '衣服', NULL, 'e1fe9925bc315c60addea1b98eb1cb1349547719_1588862821565.jpg', '0', '0');
INSERT INTO `ces_shop_type` VALUES ('1258408044439597058', 'admin', '2020-05-07 22:47:12', NULL, NULL, 'A01', '鞋子', NULL, 'jeewxshop测试号_1588862831749.jpg', '0', '1');
INSERT INTO `ces_shop_type` VALUES ('1258408076693794818', 'admin', '2020-05-07 22:47:20', 'admin', '2020-07-10 16:51:10', 'A01', '耐克', NULL, 'd52a2834349b033b6d20d5cc16ce36d3d539bd7f_1594371069797.jpg', '1258408044439597058', '0');
INSERT INTO `ces_shop_type` VALUES ('1258408105487691777', 'admin', '2020-05-07 22:47:27', 'admin', '2020-11-26 15:21:57', 'A01', '阿迪', '', 'temp/20180607175028Fn1Lq7zw_1589293474710.png', '1258408044439597058', '0');

-- ----------------------------
-- Table structure for demo
-- ----------------------------
DROP TABLE IF EXISTS `demo`;
CREATE TABLE `demo`  (
  `id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '姓名',
  `key_word` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '关键词',
  `punch_time` datetime NULL DEFAULT NULL COMMENT '打卡时间',
  `salary_money` decimal(10, 3) NULL DEFAULT NULL COMMENT '工资',
  `bonus_money` double(10, 2) NULL DEFAULT NULL COMMENT '奖金',
  `sex` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '性别 {男:1,女:2}',
  `age` int(11) NULL DEFAULT NULL COMMENT '年龄',
  `birthday` date NULL DEFAULT NULL COMMENT '生日',
  `email` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '邮箱',
  `content` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '个人简介',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `sys_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属部门编码',
  `tenant_id` int(10) NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of demo
-- ----------------------------
INSERT INTO `demo` VALUES ('1353563050407936002', '小红帽4', '44', '2021-01-26 12:39:04', NULL, NULL, '2', 22, '2021-01-25', NULL, NULL, 'admin', '2021-01-25 12:39:14', 'admin', '2021-06-04 16:39:24', 'A01', 0);
INSERT INTO `demo` VALUES ('1400734875399024641', 'aaa', NULL, NULL, NULL, NULL, '2', NULL, NULL, NULL, NULL, 'admin', '2021-06-04 16:43:13', 'admin', '2021-08-13 15:59:53', 'A01', 0);
INSERT INTO `demo` VALUES ('1dc29e80be14d1400f165b5c6b30c707', 'zhang daihao', NULL, NULL, NULL, NULL, '2', NULL, NULL, 'zhangdaiscott@163.com', NULL, NULL, NULL, NULL, NULL, NULL, 0);
INSERT INTO `demo` VALUES ('304e651dc769d5c9b6e08fb30457a602', '小白兔', NULL, NULL, NULL, NULL, '2', 28, NULL, NULL, NULL, 'scott', '2019-01-19 13:12:53', 'qinfeng', '2019-01-19 13:13:12', NULL, 0);
INSERT INTO `demo` VALUES ('4', 'Sandy', '开源，很好', '2018-12-15 00:00:00', NULL, NULL, '2', 21, '2018-12-15', 'test4@baomidou.com', '聪明00', NULL, NULL, 'admin', '2019-02-25 16:29:27', NULL, 0);
INSERT INTO `demo` VALUES ('4981637bf71b0c1ed1365241dfcfa0ea', '小虎', NULL, NULL, NULL, NULL, '2', 28, NULL, NULL, NULL, 'scott5', '2019-01-19 13:12:53', 'qinfeng', '2019-01-19 13:13:12', 'A02', 0);
INSERT INTO `demo` VALUES ('7', 'zhangdaiscott', NULL, NULL, NULL, NULL, '1', NULL, '2019-01-03', NULL, NULL, NULL, NULL, NULL, NULL, 'A02A01A01', 0);
INSERT INTO `demo` VALUES ('73bc58611012617ca446d8999379e4ac', '郭靖', '777', '2018-12-07 00:00:00', NULL, NULL, '1', NULL, NULL, NULL, NULL, 'jeecg-boot', '2019-03-28 18:16:39', 'admin', '2020-05-02 18:14:14', 'A02A01A02', 0);
INSERT INTO `demo` VALUES ('917e240eaa0b1b2d198ae869b64a81c3', 'zhang daihao', NULL, NULL, NULL, NULL, '2', 0, '2018-11-29', 'zhangdaiscott@163.com', NULL, NULL, NULL, NULL, NULL, 'A02', 0);
INSERT INTO `demo` VALUES ('94420c5d8fc4420dde1e7196154b3a24', '秦风', NULL, NULL, NULL, NULL, '2', NULL, NULL, NULL, NULL, 'scott', '2019-01-19 12:54:58', 'admin', '2020-05-02 18:14:33', NULL, 0);
INSERT INTO `demo` VALUES ('b86897900c770503771c7bb88e5d1e9b', 'scott1', '开源、很好、hello', NULL, NULL, NULL, '1', NULL, NULL, 'zhangdaiscott@163.com', NULL, 'scott', '2019-01-19 12:22:34', NULL, NULL, NULL, 0);
INSERT INTO `demo` VALUES ('c28fa8391ef81d6fabd8bd894a7615aa', '小麦', NULL, NULL, NULL, NULL, '2', NULL, NULL, 'zhangdaiscott@163.com', NULL, 'jeecg-boot', '2019-04-04 17:18:09', NULL, NULL, NULL, 0);
INSERT INTO `demo` VALUES ('c2c0d49e3c01913067cf8d1fb3c971d2', 'zhang daihao', '', NULL, NULL, NULL, '2', NULL, NULL, 'zhangdaiscott@163.com', '', 'admin', '2019-01-19 23:37:18', 'admin', '2019-01-21 16:49:06', '', 0);
INSERT INTO `demo` VALUES ('c96279c666b4b82e3ef1e4e2978701ce', '报名时间', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'jeecg-boot', '2019-03-28 18:00:52', NULL, NULL, NULL, 0);
INSERT INTO `demo` VALUES ('d24668721446e8478eeeafe4db66dcff', 'zhang daihao999', NULL, NULL, NULL, NULL, '1', NULL, NULL, 'zhangdaiscott@163.com', NULL, NULL, NULL, NULL, NULL, NULL, 0);
INSERT INTO `demo` VALUES ('eaa6c1116b41dc10a94eae34cf990133', 'zhang daihao', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'zhangdaiscott@163.com', NULL, NULL, NULL, NULL, NULL, NULL, 0);

-- ----------------------------
-- Table structure for demo_field_def_val_main
-- ----------------------------
DROP TABLE IF EXISTS `demo_field_def_val_main`;
CREATE TABLE `demo_field_def_val_main`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '姓名',
  `sex` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '性别',
  `address` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址',
  `address_param` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址（传参）',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of demo_field_def_val_main
-- ----------------------------
INSERT INTO `demo_field_def_val_main` VALUES ('1256548579457114114', 'q', 'q', '1', 'q', 'q', 'admin', '2020-05-02 19:38:21', 'admin', '2020-05-03 01:02:51', 'A01');

-- ----------------------------
-- Table structure for demo_field_def_val_sub
-- ----------------------------
DROP TABLE IF EXISTS `demo_field_def_val_sub`;
CREATE TABLE `demo_field_def_val_sub`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
  `date` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '日期',
  `main_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主表ID',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of demo_field_def_val_sub
-- ----------------------------
INSERT INTO `demo_field_def_val_sub` VALUES ('15884194974080425602', '133', '管理员', '2020-05-02', '1256548579457114114', 'admin', '2020-05-03 01:02:51', NULL, NULL, 'A01');
INSERT INTO `demo_field_def_val_sub` VALUES ('15884194979201535108', '1144', '管理员', '2020-05-02', '1256548579457114114', 'admin', '2020-05-03 01:02:51', NULL, NULL, 'A01');

-- ----------------------------
-- Table structure for jeecg_monthly_growth_analysis
-- ----------------------------
DROP TABLE IF EXISTS `jeecg_monthly_growth_analysis`;
CREATE TABLE `jeecg_monthly_growth_analysis`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `month` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '月份',
  `main_income` decimal(18, 2) NULL DEFAULT 0.00 COMMENT '佣金/主营收入',
  `other_income` decimal(18, 2) NULL DEFAULT 0.00 COMMENT '其他收入',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 25 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jeecg_monthly_growth_analysis
-- ----------------------------
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (1, '2018', '1月', 114758.90, 4426054.19);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (2, '2018', '2月', 8970734.12, 1230188.67);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (3, '2018', '3月', 26755421.23, 2048836.84);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (4, '2018', '4月', 2404990.63, 374171.44);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (5, '2018', '5月', 5450793.02, 502306.10);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (6, '2018', '6月', 17186212.11, 1375154.97);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (7, '2018', '7月', 579975.67, 461483.99);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (8, '2018', '8月', 1393590.06, 330403.76);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (9, '2018', '9月', 735761.21, 1647474.92);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (10, '2018', '10月', 1670442.44, 3423368.33);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (11, '2018', '11月', 2993130.34, 3552024.00);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (12, '2018', '12月', 4206227.26, 3645614.92);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (13, '2019', '1月', 483834.66, 418046.77);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (14, '2019', '2月', 11666578.65, 731352.20);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (15, '2019', '3月', 27080982.08, 1878538.81);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (16, '2019', '4月', 0.00, 0.00);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (17, '2019', '5月', 0.00, 0.00);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (18, '2019', '6月', 0.00, 0.00);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (19, '2019', '7月', 0.00, 0.00);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (20, '2019', '8月', 0.00, 0.00);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (21, '2019', '9月', 0.00, 0.00);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (22, '2019', '10月', 0.00, 0.00);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (23, '2019', '11月', 0.00, 0.00);
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (24, '2019', '12月', 0.00, 0.00);

-- ----------------------------
-- Table structure for jeecg_order_customer
-- ----------------------------
DROP TABLE IF EXISTS `jeecg_order_customer`;
CREATE TABLE `jeecg_order_customer`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '客户名',
  `sex` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '性别',
  `idcard` varchar(18) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '身份证号码',
  `idcard_pic` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '身份证扫描件',
  `telphone` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '电话1',
  `order_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '外键',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jeecg_order_customer
-- ----------------------------
INSERT INTO `jeecg_order_customer` VALUES ('1256527640480821249', 'scott', '2', NULL, NULL, NULL, 'b190737bd04cca8360e6f87c9ef9ec4e', 'admin', '2020-05-02 18:15:09', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('1256527640531152898', 'x秦风', '1', NULL, NULL, NULL, 'b190737bd04cca8360e6f87c9ef9ec4e', 'admin', '2020-05-02 18:15:09', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('1256527874216800257', '小王1', '1', '', NULL, '', '9a57c850e4f68cf94ef7d8585dbaf7e6', 'admin', '2020-05-02 18:17:37', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('15538561502720', '3333', '1', '', NULL, '', '0d4a2e67b538ee1bc881e5ed34f670f0', 'jeecg-boot', '2019-03-29 18:42:55', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('15538561512681', '3332333', '2', '', NULL, '', '0d4a2e67b538ee1bc881e5ed34f670f0', 'jeecg-boot', '2019-03-29 18:42:55', 'admin', '2019-03-29 18:43:12');
INSERT INTO `jeecg_order_customer` VALUES ('15538561550142', '4442', '2', '', NULL, '', '0d4a2e67b538ee1bc881e5ed34f670f0', 'jeecg-boot', '2019-03-29 18:42:55', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('15541168497342', '444', '', '', '', '', 'f71f7f8930b5b6b1703d9948d189982b', 'admin', '2019-04-01 19:08:45', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('15541168499553', '5555', '', '', '', '', 'f71f7f8930b5b6b1703d9948d189982b', 'admin', '2019-04-01 19:08:45', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('18dc5eb1068ccdfe90e358951ca1a3d6', 'dr2', '', '', '', '', '8ab1186410a65118c4d746eb085d3bed', 'admin', '2019-04-04 17:25:33', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('195d280490fe88ca1475512ddcaf2af9', '12', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('217a2bf83709775d2cd85bf598392327', '2', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('22bc052ae53ed09913b946abba93fa89', '1', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('23bafeae88126c3bf3322a29a04f0d5e', 'x秦风', NULL, NULL, NULL, NULL, '163e2efcbc6d7d54eb3f8a137da8a75a', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('25c4a552c6843f36fad6303bfa99a382', '1', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('2d32144e2bee63264f3f16215c258381', '33333', '2', NULL, NULL, NULL, 'd908bfee3377e946e59220c4a4eb414a', 'admin', '2019-04-01 16:27:03', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('2d43170d6327f941bd1a017999495e25', '1', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('2e5f62a8b6e0a0ce19b52a6feae23d48', '3', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('34a1c5cf6cee360ed610ed0bed70e0f9', '导入秦风', NULL, NULL, NULL, NULL, 'a2cce75872cc8fcc47f78de9ffd378c2', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('3c87400f8109b4cf43c5598f0d40e34d', '2', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('40964bcbbecb38e5ac15e6d08cf3cd43', '233', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('41e3dee0b0b6e6530eccb7fbb22fd7a3', '4555', '1', '370285198602058823', NULL, '18611788674', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('4808ae8344c7679a4a2f461db5dc3a70', '44', '1', '370285198602058823', NULL, '18611788674', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('4b6cef12f195fad94d57279b2241770d', 'dr12', '', '', '', '', '8ab1186410a65118c4d746eb085d3bed', 'admin', '2019-04-04 17:25:33', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('524e695283f8e8c256cc24f39d6d8542', '小王', '2', '370285198604033222', NULL, '18611788674', 'eb13ab35d2946a2b0cfe3452bca1e73f', 'admin', '2019-02-25 16:29:41', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('57c2a8367db34016114cbc9fa368dba0', '2', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('5df36a1608b8c7ac99ad9bc408fe54bf', '4', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('6c6fd2716c2dcd044ed03c2c95d261f8', '李四', '2', '370285198602058833', '', '18611788676', 'f71f7f8930b5b6b1703d9948d189982b', 'admin', '2019-04-01 19:08:45', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('742d008214dee0afff2145555692973e', '秦风', '1', '370285198602058822', NULL, '18611788676', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('7469c3e5d371767ff90a739d297689b5', '导入秦风', '2', NULL, NULL, NULL, '3a867ebf2cebce9bae3f79676d8d86f3', 'jeecg-boot', '2019-03-29 18:43:59', 'admin', '2019-04-08 17:35:02');
INSERT INTO `jeecg_order_customer` VALUES ('7a96e2c7b24847d4a29940dbc0eda6e5', 'drscott', NULL, NULL, NULL, NULL, 'e73434dad84ebdce2d4e0c2a2f06d8ea', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('7f5a40818e225ee18bda6da7932ac5f9', '2', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('8011575abfd7c8085e71ff66df1124b9', '1', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('8404f31d7196221a573c9bd6c8f15003', '小张', '1', '370285198602058211', NULL, '18611788676', 'eb13ab35d2946a2b0cfe3452bca1e73f', 'admin', '2019-02-25 16:29:41', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('859020e10a2f721f201cdbff78cf7b9f', 'scott', NULL, NULL, NULL, NULL, '163e2efcbc6d7d54eb3f8a137da8a75a', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('8cc3c4d26e3060975df3a2adb781eeb4', 'dr33', NULL, NULL, NULL, NULL, 'b2feb454e43c46b2038768899061e464', 'jeecg-boot', '2019-04-04 17:23:09', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('8d1725c23a6a50685ff0dedfd437030d', '4', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('933cae3a79f60a93922d59aace5346ce', '小王', NULL, '370285198604033222', NULL, '18611788674', '6a719071a29927a14f19482f8693d69a', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('9bdb5400b709ba4eaf3444de475880d7', 'dr22', NULL, NULL, NULL, NULL, '22c17790dcd04b296c4a2a089f71895f', 'jeecg-boot', '2019-04-04 17:23:09', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('9f87677f70e5f864679314389443a3eb', '33', '2', '370285198602058823', NULL, '18611788674', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('a2c2b7101f75c02deb328ba777137897', '44', '2', '370285198602058823', NULL, '18611788674', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('ab4d002dc552c326147e318c87d3bed4', '小红1', '1', '370285198604033222', NULL, '18611755848', '9a57c850e4f68cf94ef7d8585dbaf7e6', 'admin', '2020-05-02 18:17:37', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('ad116f722a438e5f23095a0b5fcc8e89', 'dr秦风', NULL, NULL, NULL, NULL, 'e73434dad84ebdce2d4e0c2a2f06d8ea', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('b1ba147b75f5eaa48212586097fc3fd1', '2', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('b43bf432c251f0e6b206e403b8ec29bc', 'lisi', NULL, NULL, NULL, NULL, 'f8889aaef6d1bccffd98d2889c0aafb5', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('bcdd300a7d44c45a66bdaac14903c801', '33', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('beb983293e47e2dc1a9b3d649aa3eb34', 'ddd3', NULL, NULL, NULL, NULL, 'd908bfee3377e946e59220c4a4eb414a', 'admin', '2019-04-01 16:27:03', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('c219808196406f1b8c7f1062589de4b5', '44', '1', '370285198602058823', NULL, '18611788674', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('c8ed061d4b27c0c7a64e100f2b1c8ab5', '张经理', '2', '370285198602058823', NULL, '18611788674', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('cc5de4af7f06cd6d250965ebe92a0395', '1', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('cf8817bd703bf7c7c77a2118edc26cc7', '1', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('d72b26fae42e71270fce2097a88da58a', '导入scott', NULL, 'www', NULL, NULL, '3a867ebf2cebce9bae3f79676d8d86f3', 'jeecg-boot', '2019-03-29 18:43:59', 'admin', '2019-04-08 17:35:05');
INSERT INTO `jeecg_order_customer` VALUES ('dbdc60a6ac1a8c43f24afee384039b68', 'xiaowang', NULL, NULL, NULL, NULL, 'f8889aaef6d1bccffd98d2889c0aafb5', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('dc5883b50466de94d900919ed96d97af', '33', '1', '370285198602058823', NULL, '18611788674', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('deeb73e553ad8dc0a0b3cfd5a338de8e', '3333', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('e2570278bf189ac05df3673231326f47', '1', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('e39cb23bb950b2bdedfc284686c6128a', '1', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('e46fe9111a9100844af582a18a2aa402', '1', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('ee7af0acb9beb9bf8d8b3819a8a7fdc3', '2', NULL, NULL, NULL, NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('f5d2605e844192d9e548f9bd240ac908', '小张', NULL, '370285198602058211', NULL, '18611788676', '6a719071a29927a14f19482f8693d69a', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_customer` VALUES ('f6db6547382126613a3e46e7cd58a5f2', '导入scott', NULL, NULL, NULL, NULL, 'a2cce75872cc8fcc47f78de9ffd378c2', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);

-- ----------------------------
-- Table structure for jeecg_order_main
-- ----------------------------
DROP TABLE IF EXISTS `jeecg_order_main`;
CREATE TABLE `jeecg_order_main`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `order_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单号',
  `ctype` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单类型',
  `order_date` datetime NULL DEFAULT NULL COMMENT '订单日期',
  `order_money` double(10, 3) NULL DEFAULT NULL COMMENT '订单金额',
  `content` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单备注',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jeecg_order_main
-- ----------------------------
INSERT INTO `jeecg_order_main` VALUES ('163e2efcbc6d7d54eb3f8a137da8a75a', 'B100', NULL, NULL, 3000.000, NULL, 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_main` VALUES ('3a867ebf2cebce9bae3f79676d8d86f3', '导入B100', '2222', NULL, 3000.000, NULL, 'jeecg-boot', '2019-03-29 18:43:59', 'admin', '2019-04-08 17:35:13');
INSERT INTO `jeecg_order_main` VALUES ('4cba137333127e8e31df7ad168cc3732', '青岛订单A0001', '2', '2019-04-03 10:56:07', NULL, NULL, 'admin', '2019-04-03 10:56:11', NULL, NULL);
INSERT INTO `jeecg_order_main` VALUES ('54e739bef5b67569c963c38da52581ec', 'NC911', '1', '2019-02-18 09:58:51', 40.000, NULL, 'admin', '2019-02-18 09:58:47', 'admin', '2019-02-18 09:58:59');
INSERT INTO `jeecg_order_main` VALUES ('6a719071a29927a14f19482f8693d69a', 'c100', NULL, NULL, 5000.000, NULL, 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_main` VALUES ('8ab1186410a65118c4d746eb085d3bed', '导入400', '1', '2019-02-18 09:58:51', 40.000, NULL, 'admin', '2019-02-18 09:58:47', 'admin', '2019-02-18 09:58:59');
INSERT INTO `jeecg_order_main` VALUES ('9a57c850e4f68cf94ef7d8585dbaf7e6', 'halou001', '1', '2019-04-04 17:30:32', 500.000, NULL, 'admin', '2019-04-04 17:30:41', 'admin', '2020-05-02 18:17:36');
INSERT INTO `jeecg_order_main` VALUES ('a2cce75872cc8fcc47f78de9ffd378c2', '导入B100', NULL, NULL, 3000.000, NULL, 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_main` VALUES ('b190737bd04cca8360e6f87c9ef9ec4e', 'B0018888', '1', NULL, NULL, NULL, 'admin', '2019-02-15 18:39:29', 'admin', '2020-05-02 18:15:09');
INSERT INTO `jeecg_order_main` VALUES ('d908bfee3377e946e59220c4a4eb414a', 'SSSS001', NULL, NULL, 599.000, NULL, 'admin', '2019-04-01 15:43:03', 'admin', '2019-04-01 16:26:52');
INSERT INTO `jeecg_order_main` VALUES ('e73434dad84ebdce2d4e0c2a2f06d8ea', '导入200', NULL, NULL, 3000.000, NULL, 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_main` VALUES ('eb13ab35d2946a2b0cfe3452bca1e73f', 'BJ9980', '1', NULL, 90.000, NULL, 'admin', '2019-02-16 17:36:42', 'admin', '2019-02-16 17:46:16');
INSERT INTO `jeecg_order_main` VALUES ('f71f7f8930b5b6b1703d9948d189982b', 'BY911', NULL, '2019-04-06 19:08:39', NULL, NULL, 'admin', '2019-04-01 16:36:02', 'admin', '2019-04-01 16:36:08');
INSERT INTO `jeecg_order_main` VALUES ('f8889aaef6d1bccffd98d2889c0aafb5', 'A100', NULL, '2018-10-10 00:00:00', 6000.000, NULL, 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);

-- ----------------------------
-- Table structure for jeecg_order_ticket
-- ----------------------------
DROP TABLE IF EXISTS `jeecg_order_ticket`;
CREATE TABLE `jeecg_order_ticket`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `ticket_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '航班号',
  `tickect_date` datetime NULL DEFAULT NULL COMMENT '航班时间',
  `order_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '外键',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jeecg_order_ticket
-- ----------------------------
INSERT INTO `jeecg_order_ticket` VALUES ('0f0e3a40a215958f807eea08a6e1ac0a', '88', NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('0fa3bd0bbcf53650c0bb3c0cac6d8cb7', 'ffff', '2019-02-21 00:00:00', 'eb13ab35d2946a2b0cfe3452bca1e73f', 'admin', '2019-02-25 16:29:41', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('1256527640543735810', '222', '2019-02-23 00:00:00', 'b190737bd04cca8360e6f87c9ef9ec4e', 'admin', '2020-05-02 18:15:09', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('1256527640560513025', '111', '2019-02-01 00:00:00', 'b190737bd04cca8360e6f87c9ef9ec4e', 'admin', '2020-05-02 18:15:09', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('14221afb4f5f749c1deef26ac56fdac3', '33', '2019-03-09 00:00:00', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('15538561502730', '222', NULL, '0d4a2e67b538ee1bc881e5ed34f670f0', 'jeecg-boot', '2019-03-29 18:42:55', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('15538561526461', '2244', '2019-03-29 00:00:00', '0d4a2e67b538ee1bc881e5ed34f670f0', 'jeecg-boot', '2019-03-29 18:42:55', 'admin', '2019-03-29 18:43:26');
INSERT INTO `jeecg_order_ticket` VALUES ('15541168478913', 'hhhhh', NULL, 'f71f7f8930b5b6b1703d9948d189982b', 'admin', '2019-04-01 19:08:45', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('18905bc89ee3851805aab38ed3b505ec', '44', NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('1f809cbd26f4e574697e1c10de575d72', 'A100', NULL, 'e73434dad84ebdce2d4e0c2a2f06d8ea', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('21051adb51529bdaa8798b5a3dd7f7f7', 'C10029', '2019-02-20 00:00:00', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('269576e766b917f8b6509a2bb0c4d4bd', 'A100', NULL, '163e2efcbc6d7d54eb3f8a137da8a75a', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('2d473ffc79e5b38a17919e15f8b7078e', '66', '2019-03-29 00:00:00', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('3655b66fca5fef9c6aac6d70182ffda2', 'AA123', '2019-04-01 00:00:00', 'd908bfee3377e946e59220c4a4eb414a', 'admin', '2019-04-01 16:27:03', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('365d5919155473ade45840fd626c51a9', 'dddd', '2019-04-04 17:25:29', '8ab1186410a65118c4d746eb085d3bed', 'admin', '2019-04-04 17:25:33', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('4889a782e78706ab4306a925cfb163a5', 'C34', '2019-04-01 00:00:00', 'd908bfee3377e946e59220c4a4eb414a', 'admin', '2019-04-01 16:35:00', 'admin', '2019-04-01 16:35:07');
INSERT INTO `jeecg_order_ticket` VALUES ('48d385796382cf87fa4bdf13b42d9a28', '导入A100', NULL, '3a867ebf2cebce9bae3f79676d8d86f3', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('541faed56efbeb4be9df581bd8264d3a', '88', NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('57a27a7dfd6a48e7d981f300c181b355', '6', '2019-03-30 00:00:00', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('5ce4dc439c874266e42e6c0ff8dc8b5c', '导入A100', NULL, 'a2cce75872cc8fcc47f78de9ffd378c2', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('645a06152998a576c051474157625c41', '88', '2019-04-04 17:25:31', '8ab1186410a65118c4d746eb085d3bed', 'admin', '2019-04-04 17:25:33', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('6e3562f2571ea9e96b2d24497b5f5eec', '55', '2019-03-23 00:00:00', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('8fd2b389151568738b1cc4d8e27a6110', '导入A100', NULL, 'a2cce75872cc8fcc47f78de9ffd378c2', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('93f1a84053e546f59137432ff5564cac', '55', NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('969ddc5d2e198d50903686917f996470', 'A10029', '2019-04-01 00:00:00', 'f71f7f8930b5b6b1703d9948d189982b', 'admin', '2019-04-01 19:08:45', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('96e7303a8d22a5c384e08d7bcf7ac2bf', 'A100', NULL, 'e73434dad84ebdce2d4e0c2a2f06d8ea', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('9e8a3336f6c63f558f2b68ce2e1e666e', '深圳1001', '2020-05-02 00:00:00', '9a57c850e4f68cf94ef7d8585dbaf7e6', 'admin', '2020-05-02 18:17:37', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('a28db02c810c65660015095cb81ed434', 'A100', NULL, 'f8889aaef6d1bccffd98d2889c0aafb5', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('b217bb0e4ec6a45b6cbf6db880060c0f', 'A100', NULL, '6a719071a29927a14f19482f8693d69a', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('ba708df70bb2652ed1051a394cfa0bb3', '333', NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('beabbfcb195d39bedeeafe8318794562', 'A1345', '2019-04-01 00:00:00', 'd908bfee3377e946e59220c4a4eb414a', 'admin', '2019-04-01 16:27:04', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('bf450223cb505f89078a311ef7b6ed16', '777', '2019-03-30 00:00:00', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('c06165b6603e3e1335db187b3c841eef', '北京2001', '2020-05-23 00:00:00', '9a57c850e4f68cf94ef7d8585dbaf7e6', 'admin', '2020-05-02 18:17:37', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('c113136abc26ace3a6da4e41d7dc1c7e', '44', '2019-03-15 00:00:00', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('c1abdc2e30aeb25de13ad6ee3488ac24', '77', '2019-03-22 00:00:00', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('c23751a7deb44f553ce50a94948c042a', '33', '2019-03-09 00:00:00', '8ab1186410a65118c4d746eb085d3bed', 'admin', '2019-04-04 17:25:33', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('c64547666b634b3d6a0feedcf05f25ce', 'C10019', '2019-04-01 00:00:00', 'f71f7f8930b5b6b1703d9948d189982b', 'admin', '2019-04-01 19:08:45', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('c8b8d3217f37da78dddf711a1f7da485', 'A100', NULL, '163e2efcbc6d7d54eb3f8a137da8a75a', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('cab691c1c1ff7a6dfd7248421917fd3c', 'A100', NULL, 'f8889aaef6d1bccffd98d2889c0aafb5', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('cca10a9a850b456d9b72be87da7b0883', '77', NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('d2fbba11f4814d9b1d3cb1a3f342234a', 'C10019', '2019-02-18 00:00:00', '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('dbdb07a16826808e4276e84b2aa4731a', '导入A100', NULL, '3a867ebf2cebce9bae3f79676d8d86f3', 'jeecg-boot', '2019-03-29 18:43:59', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('e7075639c37513afc0bbc4bf7b5d98b9', '88', NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('fa759dc104d0371f8aa28665b323dab6', '888', NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);
INSERT INTO `jeecg_order_ticket` VALUES ('ff197da84a9a3af53878eddc91afbb2e', '33', NULL, '54e739bef5b67569c963c38da52581ec', 'admin', '2019-03-15 16:50:15', NULL, NULL);

-- ----------------------------
-- Table structure for jeecg_project_nature_income
-- ----------------------------
DROP TABLE IF EXISTS `jeecg_project_nature_income`;
CREATE TABLE `jeecg_project_nature_income`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nature` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '项目性质',
  `insurance_fee` decimal(18, 2) NULL DEFAULT 0.00 COMMENT '保险经纪佣金费',
  `risk_consulting_fee` decimal(18, 2) NULL DEFAULT 0.00 COMMENT '风险咨询费',
  `evaluation_fee` decimal(18, 2) NULL DEFAULT 0.00 COMMENT '承保公估评估费',
  `insurance_evaluation_fee` decimal(18, 2) NULL DEFAULT 0.00 COMMENT '保险公估费',
  `bidding_consulting_fee` decimal(18, 2) NULL DEFAULT 0.00 COMMENT '投标咨询费',
  `interol_consulting_fee` decimal(18, 2) NULL DEFAULT 0.00 COMMENT '内控咨询费',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jeecg_project_nature_income
-- ----------------------------
INSERT INTO `jeecg_project_nature_income` VALUES (1, '市场化-电商业务', 4865.41, 0.00, 0.00, 0.00, 0.00, 0.00);
INSERT INTO `jeecg_project_nature_income` VALUES (2, '统筹型', 35767081.88, 0.00, 0.00, 0.00, 0.00, 0.00);
INSERT INTO `jeecg_project_nature_income` VALUES (3, '市场化-非股东', 1487045.35, 0.00, 0.00, 0.00, 0.00, 0.00);
INSERT INTO `jeecg_project_nature_income` VALUES (4, '市场化-参控股', 382690.56, 0.00, 0.00, 0.00, 0.00, 0.00);
INSERT INTO `jeecg_project_nature_income` VALUES (5, '市场化-员工福利', 256684.91, 0.00, 0.00, 0.00, 0.00, 0.00);
INSERT INTO `jeecg_project_nature_income` VALUES (6, '市场化-再保险', 563451.03, 0.00, 0.00, 0.00, 0.00, 0.00);
INSERT INTO `jeecg_project_nature_income` VALUES (7, '市场化-海外业务', 760576.25, 770458.75, 0.00, 0.00, 0.00, 0.00);
INSERT INTO `jeecg_project_nature_income` VALUES (8, '市场化-风险咨询', 910183.93, 0.00, 0.00, 0.00, 0.00, 226415.09);

-- ----------------------------
-- Table structure for jimu_dict
-- ----------------------------
DROP TABLE IF EXISTS `jimu_dict`;
CREATE TABLE `jimu_dict`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `dict_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典名称',
  `dict_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典编码',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `del_flag` int(1) NULL DEFAULT NULL COMMENT '删除状态',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `type` int(1) UNSIGNED ZEROFILL NULL DEFAULT 0 COMMENT '字典类型0为string,1为number',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_sd_dict_code`(`dict_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jimu_dict
-- ----------------------------
INSERT INTO `jimu_dict` VALUES ('0b5d19e1fce4b2e6647e6b4a17760c14', '通告类型', 'msg_category', '消息类型1:通知公告2:系统消息', 0, 'admin', '2019-04-22 18:01:35', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('1174509082208395266', '职务职级', 'position_rank', '职务表职级字典', 0, 'admin', '2019-09-19 10:22:41', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('1174511106530525185', '机构类型', 'org_category', '机构类型 1公司，2部门 3岗位', 0, 'admin', '2019-09-19 10:30:43', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('1178295274528845826', '表单权限策略', 'form_perms_type', '', 0, 'admin', '2019-09-29 21:07:39', 'admin', '2019-09-29 21:08:26', NULL);
INSERT INTO `jimu_dict` VALUES ('1199517671259906049', '紧急程度', 'urgent_level', '日程计划紧急程度', 0, 'admin', '2019-11-27 10:37:53', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('1199518099888414722', '日程计划类型', 'eoa_plan_type', '', 0, 'admin', '2019-11-27 10:39:36', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('1199520177767587841', '分类栏目类型', 'eoa_cms_menu_type', '', 0, 'admin', '2019-11-27 10:47:51', 'admin', '2019-11-27 10:49:35', 0);
INSERT INTO `jimu_dict` VALUES ('1199525215290306561', '日程计划状态', 'eoa_plan_status', '', 0, 'admin', '2019-11-27 11:07:52', 'admin', '2019-11-27 11:10:11', 0);
INSERT INTO `jimu_dict` VALUES ('1209733563293962241', '数据库类型', 'database_type', '', 0, 'admin', '2019-12-25 15:12:12', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('1232913193820581889', 'Online表单业务分类', 'ol_form_biz_type', '', 0, 'admin', '2020-02-27 14:19:46', 'admin', '2020-02-27 14:20:23', 0);
INSERT INTO `jimu_dict` VALUES ('1250687930947620866', '定时任务状态', 'quartz_status', '', 0, 'admin', '2020-04-16 15:30:14', '', NULL, NULL);
INSERT INTO `jimu_dict` VALUES ('1280401766745718786', '租户状态', 'tenant_status', '租户状态', 0, 'admin', '2020-07-07 15:22:25', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('1356445645198135298', '开关', 'is_open', '', 0, 'admin', '2021-02-02 11:33:38', 'admin', '2021-02-02 15:28:12', 0);
INSERT INTO `jimu_dict` VALUES ('236e8a4baff0db8c62c00dd95632834f', '同步工作流引擎', 'activiti_sync', '同步工作流引擎', 0, 'admin', '2019-05-15 15:27:33', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('2e02df51611a4b9632828ab7e5338f00', '权限策略', 'perms_type', '权限策略', 0, 'admin', '2019-04-26 18:26:55', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('2f0320997ade5dd147c90130f7218c3e', '推送类别', 'msg_type', '', 0, 'admin', '2019-03-17 21:21:32', 'admin', '2019-03-26 19:57:45', 0);
INSERT INTO `jimu_dict` VALUES ('3486f32803bb953e7155dab3513dc68b', '删除状态', 'del_flag', NULL, 0, 'admin', '2019-01-18 21:46:26', 'admin', '2019-03-30 11:17:11', 0);
INSERT INTO `jimu_dict` VALUES ('3d9a351be3436fbefb1307d4cfb49bf2', '性别', 'sex', NULL, 0, NULL, '2019-01-04 14:56:32', 'admin', '2019-03-30 11:28:27', 1);
INSERT INTO `jimu_dict` VALUES ('4274efc2292239b6f000b153f50823ff', '全局权限策略', 'global_perms_type', '全局权限策略', 0, 'admin', '2019-05-10 17:54:05', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('4c03fca6bf1f0299c381213961566349', 'Online图表展示模板', 'online_graph_display_template', 'Online图表展示模板', 0, 'admin', '2019-04-12 17:28:50', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('4c753b5293304e7a445fd2741b46529d', '字典状态', 'dict_item_status', NULL, 0, 'admin', '2020-06-18 23:18:42', 'admin', '2019-03-30 19:33:52', 1);
INSERT INTO `jimu_dict` VALUES ('4d7fec1a7799a436d26d02325eff295e', '优先级', 'priority', '优先级', 0, 'admin', '2019-03-16 17:03:34', 'admin', '2019-04-16 17:39:23', 0);
INSERT INTO `jimu_dict` VALUES ('4e4602b3e3686f0911384e188dc7efb4', '条件规则', 'rule_conditions', '', 0, 'admin', '2019-04-01 10:15:03', 'admin', '2019-04-01 10:30:47', 0);
INSERT INTO `jimu_dict` VALUES ('4f69be5f507accea8d5df5f11346181a', '发送消息类型', 'msgType', NULL, 0, 'admin', '2019-04-11 14:27:09', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('68168534ff5065a152bfab275c2136f8', '有效无效状态', 'valid_status', '有效无效状态', 0, 'admin', '2020-09-26 19:21:14', 'admin', '2019-04-26 19:21:23', 0);
INSERT INTO `jimu_dict` VALUES ('6b78e3f59faec1a4750acff08030a79b', '用户类型', 'user_type', NULL, 0, NULL, '2019-01-04 14:59:01', 'admin', '2019-03-18 23:28:18', 0);
INSERT INTO `jimu_dict` VALUES ('72cce0989df68887546746d8f09811aa', 'Online表单类型', 'cgform_table_type', '', 0, 'admin', '2019-01-27 10:13:02', 'admin', '2019-03-30 11:37:36', 0);
INSERT INTO `jimu_dict` VALUES ('78bda155fe380b1b3f175f1e88c284c6', '流程状态', 'bpm_status', '流程状态', 0, 'admin', '2019-05-09 16:31:52', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('83bfb33147013cc81640d5fd9eda030c', '日志类型', 'log_type', NULL, 0, 'admin', '2019-03-18 23:22:19', NULL, NULL, 1);
INSERT INTO `jimu_dict` VALUES ('845da5006c97754728bf48b6a10f79cc', '状态', 'status', NULL, 0, 'admin', '2019-03-18 21:45:25', 'admin', '2019-03-18 21:58:25', 0);
INSERT INTO `jimu_dict` VALUES ('880a895c98afeca9d9ac39f29e67c13e', '操作类型', 'operate_type', '操作类型', 0, 'admin', '2019-07-22 10:54:29', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('8dfe32e2d29ea9430a988b3b558bf233', '发布状态', 'send_status', '发布状态', 0, 'admin', '2019-04-16 17:40:42', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('a7adbcd86c37f7dbc9b66945c82ef9e6', '1是0否', 'yn', '', 0, 'admin', '2019-05-22 19:29:29', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('a9d9942bd0eccb6e89de92d130ec4c4a', '消息发送状态', 'msgSendStatus', NULL, 0, 'admin', '2019-04-12 18:18:17', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('ac2f7c0c5c5775fcea7e2387bcb22f01', '菜单类型', 'menu_type', NULL, 0, 'admin', '2020-12-18 23:24:32', 'admin', '2019-04-01 15:27:06', 1);
INSERT INTO `jimu_dict` VALUES ('ad7c65ba97c20a6805d5dcdf13cdaf36', 'onlineT类型', 'ceshi_online', NULL, 0, 'admin', '2019-03-22 16:31:49', 'admin', '2019-03-22 16:34:16', 0);
INSERT INTO `jimu_dict` VALUES ('bd1b8bc28e65d6feefefb6f3c79f42fd', 'Online图表数据类型', 'online_graph_data_type', 'Online图表数据类型', 0, 'admin', '2019-04-12 17:24:24', 'admin', '2019-04-12 17:24:57', 0);
INSERT INTO `jimu_dict` VALUES ('c36169beb12de8a71c8683ee7c28a503', '部门状态', 'depart_status', NULL, 0, 'admin', '2019-03-18 21:59:51', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('c5a14c75172783d72cbee6ee7f5df5d1', 'Online图表类型', 'online_graph_type', 'Online图表类型', 0, 'admin', '2019-04-12 17:04:06', NULL, NULL, 0);
INSERT INTO `jimu_dict` VALUES ('d6e1152968b02d69ff358c75b48a6ee1', '流程类型', 'bpm_process_type', NULL, 0, 'admin', '2021-02-22 19:26:54', 'admin', '2019-03-30 18:14:44', 0);
INSERT INTO `jimu_dict` VALUES ('fc6cd58fde2e8481db10d3a1e68ce70c', '用户状态', 'user_status', NULL, 0, 'admin', '2019-03-18 21:57:25', 'admin', '2019-03-18 23:11:58', 1);

-- ----------------------------
-- Table structure for jimu_dict_item
-- ----------------------------
DROP TABLE IF EXISTS `jimu_dict_item`;
CREATE TABLE `jimu_dict_item`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `dict_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字典id',
  `item_text` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典项文本',
  `item_value` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典项值',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `sort_order` int(10) NULL DEFAULT NULL COMMENT '排序',
  `status` int(11) NULL DEFAULT NULL COMMENT '状态（1启用 0不启用）',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` datetime NULL DEFAULT NULL,
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `update_time` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_sdi_role_dict_id`(`dict_id`) USING BTREE,
  INDEX `idx_sdi_role_sort_order`(`sort_order`) USING BTREE,
  INDEX `idx_sdi_status`(`status`) USING BTREE,
  INDEX `idx_sdi_dict_val`(`dict_id`, `item_value`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jimu_dict_item
-- ----------------------------
INSERT INTO `jimu_dict_item` VALUES ('0072d115e07c875d76c9b022e2179128', '4d7fec1a7799a436d26d02325eff295e', '低', 'L', '低', 3, 1, 'admin', '2019-04-16 17:04:59', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('05a2e732ce7b00aa52141ecc3e330b4e', '3486f32803bb953e7155dab3513dc68b', '已删除', '1', NULL, NULL, 1, 'admin', '2025-10-18 21:46:56', 'admin', '2019-03-28 22:23:20');
INSERT INTO `jimu_dict_item` VALUES ('096c2e758d823def3855f6376bc736fb', 'bd1b8bc28e65d6feefefb6f3c79f42fd', 'SQL', 'sql', NULL, 1, 1, 'admin', '2019-04-12 17:26:26', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('0c9532916f5cd722017b46bc4d953e41', '2f0320997ade5dd147c90130f7218c3e', '指定用户', 'USER', NULL, NULL, 1, 'admin', '2019-03-17 21:22:19', 'admin', '2019-03-17 21:22:28');
INSERT INTO `jimu_dict_item` VALUES ('0ca4beba9efc4f9dd54af0911a946d5c', '72cce0989df68887546746d8f09811aa', '附表', '3', NULL, 3, 1, 'admin', '2019-03-27 10:13:43', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1030a2652608f5eac3b49d70458b8532', '2e02df51611a4b9632828ab7e5338f00', '禁用', '2', '禁用', 2, 1, 'admin', '2021-03-26 18:27:28', 'admin', '2019-04-26 18:39:11');
INSERT INTO `jimu_dict_item` VALUES ('1174509082208395266', '1174511106530525185', '岗位', '3', '岗位', 1, 1, 'admin', '2019-09-19 10:31:16', '', NULL);
INSERT INTO `jimu_dict_item` VALUES ('1174509601047994369', '1174509082208395266', '员级', '1', '', 1, 1, 'admin', '2019-09-19 10:24:45', 'admin', '2019-09-23 11:46:39');
INSERT INTO `jimu_dict_item` VALUES ('1174509667297026049', '1174509082208395266', '助级', '2', '', 2, 1, 'admin', '2019-09-19 10:25:01', 'admin', '2019-09-23 11:46:47');
INSERT INTO `jimu_dict_item` VALUES ('1174509713568587777', '1174509082208395266', '中级', '3', '', 3, 1, 'admin', '2019-09-19 10:25:12', 'admin', '2019-09-23 11:46:56');
INSERT INTO `jimu_dict_item` VALUES ('1174509788361416705', '1174509082208395266', '副高级', '4', '', 4, 1, 'admin', '2019-09-19 10:25:30', 'admin', '2019-09-23 11:47:06');
INSERT INTO `jimu_dict_item` VALUES ('1174509835803189250', '1174509082208395266', '正高级', '5', '', 5, 1, 'admin', '2019-09-19 10:25:41', 'admin', '2019-09-23 11:47:12');
INSERT INTO `jimu_dict_item` VALUES ('1174511197735665665', '1174511106530525185', '公司', '1', '公司', 1, 1, 'admin', '2019-09-19 10:31:05', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1174511244036587521', '1174511106530525185', '部门', '2', '部门', 1, 1, 'admin', '2019-09-19 10:31:16', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1178295553450061826', '1178295274528845826', '可编辑(未授权禁用)', '2', '', 2, 1, 'admin', '2019-09-29 21:08:46', 'admin', '2019-09-29 21:09:18');
INSERT INTO `jimu_dict_item` VALUES ('1178295639554928641', '1178295274528845826', '可见(未授权不可见)', '1', '', 1, 1, 'admin', '2019-09-29 21:09:06', 'admin', '2019-09-29 21:09:24');
INSERT INTO `jimu_dict_item` VALUES ('1199517884758368257', '1199517671259906049', '一般', '1', '', 1, 1, 'admin', '2019-11-27 10:38:44', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1199517914017832962', '1199517671259906049', '重要', '2', '', 1, 1, 'admin', '2019-11-27 10:38:51', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1199517941339529217', '1199517671259906049', '紧急', '3', '', 1, 1, 'admin', '2019-11-27 10:38:58', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1199518186144276482', '1199518099888414722', '日常记录', '1', '', 1, 1, 'admin', '2019-11-27 10:39:56', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1199518214858481666', '1199518099888414722', '本周工作', '2', '', 1, 1, 'admin', '2019-11-27 10:40:03', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1199518235943247874', '1199518099888414722', '下周计划', '3', '', 1, 1, 'admin', '2019-11-27 10:40:08', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1199520817285701634', '1199520177767587841', '列表', '1', '', 1, 1, 'admin', '2019-11-27 10:50:24', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1199520835035996161', '1199520177767587841', '链接', '2', '', 1, 1, 'admin', '2019-11-27 10:50:28', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1199525468672405505', '1199525215290306561', '未开始', '0', '', 1, 1, 'admin', '2019-11-27 11:08:52', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1199525490575060993', '1199525215290306561', '进行中', '1', '', 1, 1, 'admin', '2019-11-27 11:08:58', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1199525506429530114', '1199525215290306561', '已完成', '2', '', 1, 1, 'admin', '2019-11-27 11:09:02', 'admin', '2019-11-27 11:10:02');
INSERT INTO `jimu_dict_item` VALUES ('1199607547704647681', '4f69be5f507accea8d5df5f11346181a', '系统', '4', '', 1, 1, 'admin', '2019-11-27 16:35:02', 'admin', '2019-11-27 19:37:46');
INSERT INTO `jimu_dict_item` VALUES ('1209733775114702850', '1209733563293962241', 'MySQL5.5', '1', '', 1, 1, 'admin', '2019-12-25 15:13:02', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1209733839933476865', '1209733563293962241', 'Oracle', '2', '', 3, 1, 'admin', '2019-12-25 15:13:18', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1209733903020003330', '1209733563293962241', 'SQLServer', '3', '', 4, 1, 'admin', '2019-12-25 15:13:33', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1232913424813486081', '1232913193820581889', '官方示例', 'demo', '', 1, 1, 'admin', '2020-02-27 14:20:42', 'admin', '2020-02-27 14:21:37');
INSERT INTO `jimu_dict_item` VALUES ('1232913493717512194', '1232913193820581889', '流程表单', 'bpm', '', 2, 1, 'admin', '2020-02-27 14:20:58', 'admin', '2020-02-27 14:22:20');
INSERT INTO `jimu_dict_item` VALUES ('1232913605382467585', '1232913193820581889', '测试表单', 'temp', '', 4, 1, 'admin', '2020-02-27 14:21:25', 'admin', '2020-02-27 14:22:16');
INSERT INTO `jimu_dict_item` VALUES ('1232914232372195330', '1232913193820581889', '导入表单', 'bdfl_include', '', 5, 1, 'admin', '2020-02-27 14:23:54', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1234371726545010689', '4e4602b3e3686f0911384e188dc7efb4', '左模糊', 'LEFT_LIKE', '左模糊', 7, 1, 'admin', '2020-03-02 14:55:27', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1234371809495760898', '4e4602b3e3686f0911384e188dc7efb4', '右模糊', 'RIGHT_LIKE', '右模糊', 7, 1, 'admin', '2020-03-02 14:55:47', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1250688147579228161', '1250687930947620866', '正常', '0', '', 1, 1, 'admin', '2020-04-16 15:31:05', '', NULL);
INSERT INTO `jimu_dict_item` VALUES ('1250688201064992770', '1250687930947620866', '停止', '-1', '', 1, 1, 'admin', '2020-04-16 15:31:18', '', NULL);
INSERT INTO `jimu_dict_item` VALUES ('1280401815068295170', '1280401766745718786', '正常', '1', '', 1, 1, 'admin', '2020-07-07 15:22:36', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1280401847607705602', '1280401766745718786', '冻结', '0', '', 1, 1, 'admin', '2020-07-07 15:22:44', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1305827309355302914', 'bd1b8bc28e65d6feefefb6f3c79f42fd', 'API', 'api', '', 3, 1, 'admin', '2020-09-15 19:14:26', 'admin', '2020-09-15 19:14:41');
INSERT INTO `jimu_dict_item` VALUES ('1334440962954936321', '1209733563293962241', 'MYSQL5.7', '4', NULL, 1, 1, 'admin', '2020-12-03 18:16:02', 'admin', '2020-12-03 18:16:02');
INSERT INTO `jimu_dict_item` VALUES ('1356445705549975553', '1356445645198135298', '是', 'Y', '', 1, 1, 'admin', '2021-02-02 11:33:52', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1356445754212290561', '1356445645198135298', '否', 'N', '', 1, 1, 'admin', '2021-02-02 11:34:04', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('147c48ff4b51545032a9119d13f3222a', 'd6e1152968b02d69ff358c75b48a6ee1', '测试流程', 'test', NULL, 1, 1, 'admin', '2019-03-22 19:27:05', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1543fe7e5e26fb97cdafe4981bedc0c8', '4c03fca6bf1f0299c381213961566349', '单排布局', 'single', NULL, 2, 1, 'admin', '2022-07-12 17:43:39', 'admin', '2019-04-12 17:43:57');
INSERT INTO `jimu_dict_item` VALUES ('1ce390c52453891f93514c1bd2795d44', 'ad7c65ba97c20a6805d5dcdf13cdaf36', '000', '00', NULL, 1, 1, 'admin', '2019-03-22 16:34:34', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('1db531bcff19649fa82a644c8a939dc4', '4c03fca6bf1f0299c381213961566349', '组合布局', 'combination', '', 4, 1, 'admin', '2019-05-11 16:07:08', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('222705e11ef0264d4214affff1fb4ff9', '4f69be5f507accea8d5df5f11346181a', '短信', '1', '', 1, 1, 'admin', '2023-02-28 10:50:36', 'admin', '2019-04-28 10:58:11');
INSERT INTO `jimu_dict_item` VALUES ('23a5bb76004ed0e39414e928c4cde155', '4e4602b3e3686f0911384e188dc7efb4', '不等于', '!=', '不等于', 3, 1, 'admin', '2019-04-01 16:46:15', 'admin', '2019-04-01 17:48:40');
INSERT INTO `jimu_dict_item` VALUES ('25847e9cb661a7c711f9998452dc09e6', '4e4602b3e3686f0911384e188dc7efb4', '小于等于', '<=', '小于等于', 6, 1, 'admin', '2019-04-01 16:44:34', 'admin', '2019-04-01 17:49:10');
INSERT INTO `jimu_dict_item` VALUES ('2d51376643f220afdeb6d216a8ac2c01', '68168534ff5065a152bfab275c2136f8', '有效', '1', '有效', 2, 1, 'admin', '2019-04-26 19:22:01', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('308c8aadf0c37ecdde188b97ca9833f5', '8dfe32e2d29ea9430a988b3b558bf233', '已发布', '1', '已发布', 2, 1, 'admin', '2019-04-16 17:41:24', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('333e6b2196e01ef9a5f76d74e86a6e33', '8dfe32e2d29ea9430a988b3b558bf233', '未发布', '0', '未发布', 1, 1, 'admin', '2019-04-16 17:41:12', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('337ea1e401bda7233f6258c284ce4f50', 'bd1b8bc28e65d6feefefb6f3c79f42fd', 'JSON', 'json', NULL, 1, 1, 'admin', '2019-04-12 17:26:33', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('33bc9d9f753cf7dc40e70461e50fdc54', 'a9d9942bd0eccb6e89de92d130ec4c4a', '发送失败', '2', NULL, 3, 1, 'admin', '2019-04-12 18:20:02', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('3fbc03d6c994ae06d083751248037c0e', '78bda155fe380b1b3f175f1e88c284c6', '已完成', '3', '已完成', 3, 1, 'admin', '2019-05-09 16:33:25', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('41d7aaa40c9b61756ffb1f28da5ead8e', '0b5d19e1fce4b2e6647e6b4a17760c14', '通知公告', '1', NULL, 1, 1, 'admin', '2019-04-22 18:01:57', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('41fa1e9571505d643aea87aeb83d4d76', '4e4602b3e3686f0911384e188dc7efb4', '等于', '=', '等于', 4, 1, 'admin', '2019-04-01 16:45:24', 'admin', '2019-04-01 17:49:00');
INSERT INTO `jimu_dict_item` VALUES ('43d2295b8610adce9510ff196a49c6e9', '845da5006c97754728bf48b6a10f79cc', '正常', '1', NULL, NULL, 1, 'admin', '2019-03-18 21:45:51', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('4f05fb5376f4c61502c5105f52e4dd2b', '83bfb33147013cc81640d5fd9eda030c', '操作日志', '2', NULL, NULL, 1, 'admin', '2019-03-18 23:22:49', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('50223341bfb5ba30bf6319789d8d17fe', 'd6e1152968b02d69ff358c75b48a6ee1', '业务办理', 'business', NULL, 3, 1, 'admin', '2023-04-22 19:28:05', 'admin', '2019-03-22 23:24:39');
INSERT INTO `jimu_dict_item` VALUES ('51222413e5906cdaf160bb5c86fb827c', 'a7adbcd86c37f7dbc9b66945c82ef9e6', '是', '1', '', 1, 1, 'admin', '2019-05-22 19:29:45', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('538fca35afe004972c5f3947c039e766', '2e02df51611a4b9632828ab7e5338f00', '显示', '1', '显示', 1, 1, 'admin', '2025-03-26 18:27:13', 'admin', '2019-04-26 18:39:07');
INSERT INTO `jimu_dict_item` VALUES ('5584c21993bde231bbde2b966f2633ac', '4e4602b3e3686f0911384e188dc7efb4', '自定义SQL表达式', 'USE_SQL_RULES', '自定义SQL表达式', 9, 1, 'admin', '2019-04-01 10:45:24', 'admin', '2019-04-01 17:49:27');
INSERT INTO `jimu_dict_item` VALUES ('58b73b344305c99b9d8db0fc056bbc0a', '72cce0989df68887546746d8f09811aa', '主表', '2', NULL, 2, 1, 'admin', '2019-03-27 10:13:36', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('5b65a88f076b32e8e69d19bbaadb52d5', '2f0320997ade5dd147c90130f7218c3e', '全体用户', 'ALL', NULL, NULL, 1, 'admin', '2020-10-17 21:22:43', 'admin', '2019-03-28 22:17:09');
INSERT INTO `jimu_dict_item` VALUES ('5d833f69296f691843ccdd0c91212b6b', '880a895c98afeca9d9ac39f29e67c13e', '修改', '3', '', 3, 1, 'admin', '2019-07-22 10:55:07', 'admin', '2019-07-22 10:55:41');
INSERT INTO `jimu_dict_item` VALUES ('5d84a8634c8fdfe96275385075b105c9', '3d9a351be3436fbefb1307d4cfb49bf2', '女', '2', NULL, 2, 1, NULL, '2019-01-04 14:56:56', NULL, '2019-01-04 17:38:12');
INSERT INTO `jimu_dict_item` VALUES ('66c952ae2c3701a993e7db58f3baf55e', '4e4602b3e3686f0911384e188dc7efb4', '大于', '>', '大于', 1, 1, 'admin', '2019-04-01 10:45:46', 'admin', '2019-04-01 17:48:29');
INSERT INTO `jimu_dict_item` VALUES ('6937c5dde8f92e9a00d4e2ded9198694', 'ad7c65ba97c20a6805d5dcdf13cdaf36', 'easyui', '3', NULL, 1, 1, 'admin', '2019-03-22 16:32:15', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('69cacf64e244100289ddd4aa9fa3b915', 'a9d9942bd0eccb6e89de92d130ec4c4a', '未发送', '0', NULL, 1, 1, 'admin', '2019-04-12 18:19:23', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('6a7a9e1403a7943aba69e54ebeff9762', '4f69be5f507accea8d5df5f11346181a', '邮件', '2', '', 2, 1, 'admin', '2031-02-28 10:50:44', 'admin', '2019-04-28 10:59:03');
INSERT INTO `jimu_dict_item` VALUES ('6c682d78ddf1715baf79a1d52d2aa8c2', '72cce0989df68887546746d8f09811aa', '单表', '1', NULL, 1, 1, 'admin', '2019-03-27 10:13:29', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('6d404fd2d82311fbc87722cd302a28bc', '4e4602b3e3686f0911384e188dc7efb4', '模糊', 'LIKE', '模糊', 7, 1, 'admin', '2019-04-01 16:46:02', 'admin', '2019-04-01 17:49:20');
INSERT INTO `jimu_dict_item` VALUES ('6d4e26e78e1a09699182e08516c49fc4', '4d7fec1a7799a436d26d02325eff295e', '高', 'H', '高', 1, 1, 'admin', '2019-04-16 17:04:24', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('700e9f030654f3f90e9ba76ab0713551', '6b78e3f59faec1a4750acff08030a79b', '333', '333', NULL, NULL, 1, 'admin', '2019-02-21 19:59:47', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('7050c1522702bac3be40e3b7d2e1dfd8', 'c5a14c75172783d72cbee6ee7f5df5d1', '柱状图', 'bar', NULL, 1, 1, 'admin', '2019-04-12 17:05:17', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('71b924faa93805c5c1579f12e001c809', 'd6e1152968b02d69ff358c75b48a6ee1', 'OA办公', 'oa', NULL, 2, 1, 'admin', '2021-03-22 19:27:17', 'admin', '2019-03-22 23:24:36');
INSERT INTO `jimu_dict_item` VALUES ('75b260d7db45a39fc7f21badeabdb0ed', 'c36169beb12de8a71c8683ee7c28a503', '不启用', '0', NULL, NULL, 1, 'admin', '2019-03-18 23:29:41', 'admin', '2019-03-18 23:29:54');
INSERT INTO `jimu_dict_item` VALUES ('7688469db4a3eba61e6e35578dc7c2e5', 'c36169beb12de8a71c8683ee7c28a503', '启用', '1', NULL, NULL, 1, 'admin', '2019-03-18 23:29:28', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('78ea6cadac457967a4b1c4eb7aaa418c', 'fc6cd58fde2e8481db10d3a1e68ce70c', '正常', '1', NULL, NULL, 1, 'admin', '2019-03-18 23:30:28', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('7ccf7b80c70ee002eceb3116854b75cb', 'ac2f7c0c5c5775fcea7e2387bcb22f01', '按钮权限', '2', NULL, NULL, 1, 'admin', '2019-03-18 23:25:40', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('81fb2bb0e838dc68b43f96cc309f8257', 'fc6cd58fde2e8481db10d3a1e68ce70c', '冻结', '2', NULL, NULL, 1, 'admin', '2019-03-18 23:30:37', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('83250269359855501ec4e9c0b7e21596', '4274efc2292239b6f000b153f50823ff', '可见/可访问(授权后可见/可访问)', '1', '', 1, 1, 'admin', '2019-05-10 17:54:51', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('84778d7e928bc843ad4756db1322301f', '4e4602b3e3686f0911384e188dc7efb4', '大于等于', '>=', '大于等于', 5, 1, 'admin', '2019-04-01 10:46:02', 'admin', '2019-04-01 17:49:05');
INSERT INTO `jimu_dict_item` VALUES ('848d4da35ebd93782029c57b103e5b36', 'c5a14c75172783d72cbee6ee7f5df5d1', '饼图', 'pie', NULL, 3, 1, 'admin', '2019-04-12 17:05:49', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('84dfc178dd61b95a72900fcdd624c471', '78bda155fe380b1b3f175f1e88c284c6', '处理中', '2', '处理中', 2, 1, 'admin', '2019-05-09 16:33:01', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('86f19c7e0a73a0bae451021ac05b99dd', 'ac2f7c0c5c5775fcea7e2387bcb22f01', '子菜单', '1', NULL, NULL, 1, 'admin', '2019-03-18 23:25:27', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('8bccb963e1cd9e8d42482c54cc609ca2', '4f69be5f507accea8d5df5f11346181a', '微信', '3', NULL, 3, 1, 'admin', '2021-05-11 14:29:12', 'admin', '2019-04-11 14:29:31');
INSERT INTO `jimu_dict_item` VALUES ('8c618902365ca681ebbbe1e28f11a548', '4c753b5293304e7a445fd2741b46529d', '启用', '1', '', 0, 1, 'admin', '2020-07-18 23:19:27', 'admin', '2019-05-17 14:51:18');
INSERT INTO `jimu_dict_item` VALUES ('8cdf08045056671efd10677b8456c999', '4274efc2292239b6f000b153f50823ff', '可编辑(未授权时禁用)', '2', '', 2, 1, 'admin', '2019-05-10 17:55:38', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('8ff48e657a7c5090d4f2a59b37d1b878', '4d7fec1a7799a436d26d02325eff295e', '中', 'M', '中', 2, 1, 'admin', '2019-04-16 17:04:40', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('948923658baa330319e59b2213cda97c', '880a895c98afeca9d9ac39f29e67c13e', '添加', '2', '', 2, 1, 'admin', '2019-07-22 10:54:59', 'admin', '2019-07-22 10:55:36');
INSERT INTO `jimu_dict_item` VALUES ('9a96c4a4e4c5c9b4e4d0cbf6eb3243cc', '4c753b5293304e7a445fd2741b46529d', '不启用', '0', NULL, 1, 1, 'admin', '2019-03-18 23:19:53', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('a1e7d1ca507cff4a480c8caba7c1339e', '880a895c98afeca9d9ac39f29e67c13e', '导出', '6', '', 6, 1, 'admin', '2019-07-22 12:06:50', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('a2be752dd4ec980afaec1efd1fb589af', '8dfe32e2d29ea9430a988b3b558bf233', '已撤销', '2', '已撤销', 3, 1, 'admin', '2019-04-16 17:41:39', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('aa0d8a8042a18715a17f0a888d360aa4', 'ac2f7c0c5c5775fcea7e2387bcb22f01', '一级菜单', '0', NULL, NULL, 1, 'admin', '2019-03-18 23:24:52', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('adcf2a1fe93bb99a84833043f475fe0b', '4e4602b3e3686f0911384e188dc7efb4', '包含', 'IN', '包含', 8, 1, 'admin', '2019-04-01 16:45:47', 'admin', '2019-04-01 17:49:24');
INSERT INTO `jimu_dict_item` VALUES ('b029a41a851465332ee4ee69dcf0a4c2', '0b5d19e1fce4b2e6647e6b4a17760c14', '系统消息', '2', NULL, 1, 1, 'admin', '2019-02-22 18:02:08', 'admin', '2019-04-22 18:02:13');
INSERT INTO `jimu_dict_item` VALUES ('b2a8b4bb2c8e66c2c4b1bb086337f393', '3486f32803bb953e7155dab3513dc68b', '正常', '0', NULL, NULL, 1, 'admin', '2022-10-18 21:46:48', 'admin', '2019-03-28 22:22:20');
INSERT INTO `jimu_dict_item` VALUES ('b57f98b88363188daf38d42f25991956', '6b78e3f59faec1a4750acff08030a79b', '22', '222', NULL, NULL, 0, 'admin', '2019-02-21 19:59:43', 'admin', '2019-03-11 21:23:27');
INSERT INTO `jimu_dict_item` VALUES ('b5f3bd5f66bb9a83fecd89228c0d93d1', '68168534ff5065a152bfab275c2136f8', '无效', '0', '无效', 1, 1, 'admin', '2019-04-26 19:21:49', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('b9fbe2a3602d4a27b45c100ac5328484', '78bda155fe380b1b3f175f1e88c284c6', '待提交', '1', '待提交', 1, 1, 'admin', '2019-05-09 16:32:35', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('ba27737829c6e0e582e334832703d75e', '236e8a4baff0db8c62c00dd95632834f', '同步', '1', '同步', 1, 1, 'admin', '2019-05-15 15:28:15', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('bcec04526b04307e24a005d6dcd27fd6', '880a895c98afeca9d9ac39f29e67c13e', '导入', '5', '', 5, 1, 'admin', '2019-07-22 12:06:41', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('c53da022b9912e0aed691bbec3c78473', '880a895c98afeca9d9ac39f29e67c13e', '查询', '1', '', 1, 1, 'admin', '2019-07-22 10:54:51', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('c5700a71ad08994d18ad1dacc37a71a9', 'a7adbcd86c37f7dbc9b66945c82ef9e6', '否', '0', '', 1, 1, 'admin', '2019-05-22 19:29:55', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('cbfcc5b88fc3a90975df23ffc8cbe29c', 'c5a14c75172783d72cbee6ee7f5df5d1', '曲线图', 'line', NULL, 2, 1, 'admin', '2019-05-12 17:05:30', 'admin', '2019-04-12 17:06:06');
INSERT INTO `jimu_dict_item` VALUES ('d217592908ea3e00ff986ce97f24fb98', 'c5a14c75172783d72cbee6ee7f5df5d1', '数据列表', 'table', NULL, 4, 1, 'admin', '2019-04-12 17:05:56', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('df168368dcef46cade2aadd80100d8aa', '3d9a351be3436fbefb1307d4cfb49bf2', '男', '1', NULL, 1, 1, NULL, '2027-08-04 14:56:49', 'admin', '2019-03-23 22:44:44');
INSERT INTO `jimu_dict_item` VALUES ('e6329e3a66a003819e2eb830b0ca2ea0', '4e4602b3e3686f0911384e188dc7efb4', '小于', '<', '小于', 2, 1, 'admin', '2019-04-01 16:44:15', 'admin', '2019-04-01 17:48:34');
INSERT INTO `jimu_dict_item` VALUES ('e94eb7af89f1dbfa0d823580a7a6e66a', '236e8a4baff0db8c62c00dd95632834f', '不同步', '0', '不同步', 2, 1, 'admin', '2019-05-15 15:28:28', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('f0162f4cc572c9273f3e26b2b4d8c082', 'ad7c65ba97c20a6805d5dcdf13cdaf36', 'booostrap', '1', NULL, 1, 1, 'admin', '2021-08-22 16:32:04', 'admin', '2019-03-22 16:33:57');
INSERT INTO `jimu_dict_item` VALUES ('f16c5706f3ae05c57a53850c64ce7c45', 'a9d9942bd0eccb6e89de92d130ec4c4a', '发送成功', '1', NULL, 2, 1, 'admin', '2019-04-12 18:19:43', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('f2a7920421f3335afdf6ad2b342f6b5d', '845da5006c97754728bf48b6a10f79cc', '冻结', '2', NULL, NULL, 1, 'admin', '2019-03-18 21:46:02', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('f37f90c496ec9841c4c326b065e00bb2', '83bfb33147013cc81640d5fd9eda030c', '登录日志', '1', NULL, NULL, 1, 'admin', '2019-03-18 23:22:37', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('f753aff60ff3931c0ecb4812d8b5e643', '4c03fca6bf1f0299c381213961566349', '双排布局', 'double', NULL, 3, 1, 'admin', '2019-04-12 17:43:51', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('f80a8f6838215753b05e1a5ba3346d22', '880a895c98afeca9d9ac39f29e67c13e', '删除', '4', '', 4, 1, 'admin', '2019-07-22 10:55:14', 'admin', '2019-07-22 10:55:30');
INSERT INTO `jimu_dict_item` VALUES ('fcec03570f68a175e1964808dc3f1c91', '4c03fca6bf1f0299c381213961566349', 'Tab风格', 'tab', NULL, 1, 1, 'admin', '2019-04-12 17:43:31', NULL, NULL);
INSERT INTO `jimu_dict_item` VALUES ('fe50b23ae5e68434def76f67cef35d2d', '78bda155fe380b1b3f175f1e88c284c6', '已作废', '4', '已作废', 4, 1, 'admin', '2021-09-09 16:33:43', 'admin', '2019-05-09 16:34:40');

-- ----------------------------
-- Table structure for jimu_report
-- ----------------------------
DROP TABLE IF EXISTS `jimu_report`;
CREATE TABLE `jimu_report`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `note` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '说明',
  `status` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态',
  `type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型',
  `json_str` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'json字符串',
  `api_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求地址',
  `thumb` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '缩略图',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `del_flag` tinyint(1) NULL DEFAULT NULL COMMENT '删除标识0-正常,1-已删除',
  `api_method` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求方法0-get,1-post',
  `api_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求编码',
  `template` tinyint(1) NULL DEFAULT NULL COMMENT '是否是模板 0不是,1是',
  `view_count` bigint(15) NULL DEFAULT 0 COMMENT '浏览次数',
  `css_str` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'css增强',
  `js_str` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'js增强',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uniq_jmreport_code`(`code`) USING BTREE,
  INDEX `uniq_jmreport_createby`(`create_by`) USING BTREE,
  INDEX `uniq_jmreport_delflag`(`del_flag`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '在线excel设计器' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jimu_report
-- ----------------------------
INSERT INTO `jimu_report` VALUES ('01a1e07ed4b12348b29d5a47ac7f0228', '566960792', '销售公司出库单副本0792', '', NULL, 'printinfo', '{\"area\":{\"sri\":4,\"sci\":0,\"eri\":4,\"eci\":0,\"width\":32,\"height\":25},\"printElWidth\":794,\"excel_config_id\":\"ff9bd143582a6dfed897ba8b6f93b175\",\"printElHeight\":800,\"rows\":{\"0\":{\"cells\":{\"0\":{\"style\":11,\"text\":\"医疗器械销售公司出货单\",\"merge\":[0,9]}},\"height\":83},\"1\":{\"cells\":{\"0\":{\"text\":\"供货单位：\",\"style\":20,\"merge\":[0,1]},\"1\":{\"style\":30},\"2\":{\"text\":\"${gongsi.gname}\",\"style\":19},\"3\":{\"style\":19},\"4\":{\"text\":\"供货日期：\",\"style\":19},\"5\":{\"text\":\"${gongsi.gdata}\",\"style\":19,\"merge\":[0,1]},\"6\":{\"style\":19},\"7\":{\"text\":\"编号：\",\"style\":20},\"8\":{\"text\":\"${gongsi.num}\",\"style\":19,\"merge\":[0,1]},\"9\":{\"style\":19}},\"isDrag\":true},\"2\":{\"cells\":{\"0\":{\"text\":\"行号\",\"style\":39},\"1\":{\"text\":\"产品代码\",\"style\":39},\"2\":{\"text\":\"产品名称\",\"style\":39},\"3\":{\"text\":\"规格型号\",\"style\":39},\"4\":{\"text\":\"单位\",\"style\":39},\"5\":{\"text\":\"实发数量\",\"style\":39},\"6\":{\"text\":\"销售单价(元)\",\"style\":39},\"7\":{\"text\":\"折扣率（%）\",\"style\":39},\"8\":{\"text\":\"销售金额(元)\",\"style\":39},\"9\":{\"text\":\"备注\",\"style\":39}}},\"3\":{\"cells\":{\"0\":{\"style\":35,\"text\":\"#{xiaoshou.id}\"},\"1\":{\"style\":35,\"text\":\"#{xiaoshou.hnum}\"},\"2\":{\"style\":35,\"text\":\"#{xiaoshou.hname}\"},\"3\":{\"style\":35,\"text\":\"#{xiaoshou.xinghao}\"},\"4\":{\"style\":35,\"text\":\"#{xiaoshou.danwei}\"},\"5\":{\"style\":35,\"text\":\"#{xiaoshou.num}\"},\"6\":{\"style\":35,\"text\":\"#{xiaoshou.danjia}\"},\"7\":{\"style\":35,\"text\":\"#{xiaoshou.zhekoulv}\"},\"8\":{\"style\":35,\"text\":\"#{xiaoshou.xiaoshoujine}\"},\"9\":{\"style\":35,\"text\":\"#{xiaoshou.xiaoshoujine}\"}}},\"4\":{\"cells\":{\"0\":{\"style\":4},\"1\":{}},\"isDrag\":true},\"len\":84,\"-1\":{\"cells\":{\"0\":{\"text\":\"#{gongsi.gdata}\"},\"-1\":{\"text\":\"#{gongsi.didian}\"}},\"isDrag\":true}},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":794,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\"},{\"font\":{\"size\":16}},{\"font\":{\"size\":16},\"align\":\"center\"},{\"align\":\"center\"},{\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"right\"},{\"align\":\"right\"},{\"align\":\"center\",\"font\":{\"size\":14}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true}},{\"align\":\"center\",\"font\":{\"size\":9}},{\"font\":{\"size\":9}},{\"align\":\"right\",\"font\":{\"size\":9}},{\"align\":\"center\",\"font\":{\"size\":8}},{\"font\":{\"size\":8}},{\"align\":\"right\",\"font\":{\"size\":8}},{\"align\":\"center\",\"font\":{\"size\":8},\"color\":\"#7f7f7f\"},{\"font\":{\"size\":8},\"color\":\"#7f7f7f\"},{\"align\":\"right\",\"font\":{\"size\":8},\"color\":\"#7f7f7f\"},{\"align\":\"center\",\"font\":{\"size\":8},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":8},\"color\":\"#3f3f3f\"},{\"align\":\"right\",\"font\":{\"size\":8},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"font\":{\"size\":8},\"color\":\"#262626\"},{\"font\":{\"size\":8},\"color\":\"#262626\"},{\"align\":\"right\",\"font\":{\"size\":8},\"color\":\"#262626\"},{\"align\":\"center\",\"font\":{\"size\":8},\"color\":\"#0c0c0c\"},{\"font\":{\"size\":8},\"color\":\"#0c0c0c\"},{\"align\":\"right\",\"font\":{\"size\":8},\"color\":\"#0c0c0c\"},{\"align\":\"right\",\"color\":\"#7f7f7f\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"bgcolor\":\"#71ae47\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#71ae47\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"align\":\"center\",\"bgcolor\":\"#71ae47\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"bgcolor\":\"#71ae47\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]}},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"align\":\"center\",\"bgcolor\":\"#c5e0b3\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"bgcolor\":\"#c5e0b3\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"align\":\"center\",\"bgcolor\":\"#a7d08c\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"bgcolor\":\"#a7d08c\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":32},\"1\":{\"width\":65},\"2\":{\"width\":115},\"3\":{\"width\":70},\"4\":{\"width\":52},\"5\":{\"width\":70},\"6\":{\"width\":93},\"7\":{\"width\":86},\"8\":{\"width\":75},\"9\":{\"width\":136},\"10\":{\"width\":81},\"len\":24},\"merges\":[\"F2:G2\",\"F2:G2\",\"I2:J2\",\"A2:B2\",\"C2:D2\",\"A2:B2\",\"A1:J1\"]}', '', 'https://static.jeecg.com/designreport/images/医疗器械_1607070355110.png', 'admin', '2021-01-19 10:46:43', 'admin', '2021-02-02 19:00:59', 1, NULL, NULL, 0, 766, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1314846205892759552', '20201010163252', 'XXX有限公司员工登记表', NULL, NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":{\"sri\":10,\"sci\":11,\"eri\":10,\"eci\":11,\"width\":85,\"height\":38},\"excel_config_id\":\"1314846205892759552\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"0\":{\"cells\":{\"0\":{\"merge\":[0,8]},\"9\":{}},\"height\":22},\"1\":{\"cells\":{\"1\":{\"style\":87,\"text\":\" \"},\"2\":{\"style\":87,\"text\":\" \"},\"3\":{\"style\":87,\"text\":\" \"},\"4\":{\"style\":87,\"text\":\" \"},\"5\":{\"style\":87,\"text\":\" \"},\"6\":{\"style\":87,\"text\":\" \"},\"7\":{\"style\":87,\"text\":\" \"},\"8\":{\"style\":87,\"text\":\" \"}},\"height\":24},\"2\":{\"cells\":{\"0\":{\"text\":\"所在部门\",\"style\":93},\"1\":{\"text\":\"${yuangongjiben.department}\",\"style\":23,\"merge\":[0,2]},\"4\":{\"text\":\"职务\",\"style\":93},\"5\":{\"text\":\"${yuangongjiben.post}\",\"style\":23},\"6\":{\"text\":\"填写日期\",\"style\":93},\"7\":{\"text\":\"${yuangongjiben.data}\",\"style\":23,\"merge\":[0,1]}},\"isDrag\":true,\"height\":36},\"3\":{\"cells\":{\"0\":{\"text\":\"姓名\",\"style\":93},\"1\":{\"text\":\"${yuangongjiben.name}\",\"style\":23},\"2\":{\"text\":\"性别\",\"style\":93},\"3\":{\"text\":\"${yuangongjiben.sex}\",\"style\":23},\"4\":{\"text\":\"出生日期\",\"style\":93},\"5\":{\"text\":\"${yuangongjiben.birth}\",\"style\":23},\"6\":{\"text\":\"政治面貌\",\"style\":93},\"7\":{\"text\":\"${yuangongjiben.political}\",\"style\":130,\"merge\":[0,1]}},\"isDrag\":true,\"height\":33},\"4\":{\"cells\":{\"0\":{\"text\":\"机关\",\"style\":93},\"1\":{\"text\":\"${yuangongjiben.office}\",\"style\":23},\"2\":{\"style\":93,\"text\":\"民族\"},\"3\":{\"text\":\"${yuangongjiben.nation}\",\"style\":23},\"4\":{\"style\":93,\"text\":\"健康状况\"},\"5\":{\"text\":\"${yuangongjiben.health}\",\"style\":23},\"6\":{\"style\":93,\"text\":\"户籍类型\",\"virtual\":\"1KT8bnqRT4bi8Z7b\"},\"7\":{\"text\":\"${yuangongjiben.register}\",\"style\":26,\"virtual\":\"1KT8bnqRT4bi8Z7b\"},\"8\":{\"merge\":[3,0],\"height\":104,\"style\":35,\"text\":\" \",\"virtual\":\"cvkWDQVZhfJPgcS4\"}},\"isDrag\":true,\"height\":31},\"5\":{\"cells\":{\"0\":{\"text\":\"最高学历\",\"style\":93},\"1\":{\"text\":\"${yuangongjiben.education}\",\"style\":23},\"2\":{\"text\":\"所学专业\",\"style\":93},\"3\":{\"text\":\"${yuangongjiben.major}\",\"style\":23,\"merge\":[0,2]},\"6\":{\"text\":\"毕业时间\",\"style\":93},\"7\":{\"text\":\"${yuangongjiben.gdata}\",\"style\":23}},\"isDrag\":true,\"height\":35},\"6\":{\"cells\":{\"0\":{\"text\":\"电子邮箱\",\"style\":93},\"1\":{\"text\":\"${yuangongjiben.mailbox}\",\"style\":23},\"2\":{\"text\":\"手机号\",\"style\":93},\"3\":{\"text\":\"${yuangongjiben.telphone}\",\"style\":23,\"merge\":[0,2]},\"6\":{\"text\":\"家庭电话\",\"style\":93},\"7\":{\"text\":\"${yuangongjiben.homephone}\",\"style\":23}},\"isDrag\":true,\"height\":38},\"7\":{\"cells\":{\"0\":{\"merge\":[0,1],\"text\":\"第一次参加工作时间\",\"style\":93},\"2\":{\"text\":\"${yuangongjiben.pworktime}\",\"style\":133,\"merge\":[0,2]},\"5\":{\"style\":93,\"text\":\"入职时间\"},\"6\":{\"text\":\"${yuangongjiben.entrytime}\",\"style\":24,\"merge\":[0,1]}},\"isDrag\":true,\"height\":27},\"8\":{\"cells\":{\"0\":{\"merge\":[0,1],\"text\":\"毕业院校\",\"style\":93},\"2\":{\"text\":\"${yuangongjiben.school}\",\"style\":24,\"merge\":[0,2]},\"5\":{\"style\":93,\"text\":\"身份证号\"},\"6\":{\"text\":\"${yuangongjiben.idcard}\",\"style\":24,\"merge\":[0,2]}},\"isDrag\":true,\"height\":34},\"9\":{\"cells\":{\"0\":{\"merge\":[0,1],\"text\":\"入党（团）时间、地点\",\"style\":94},\"2\":{\"text\":\"${yuangongjiben.entrytime}\",\"style\":24,\"merge\":[0,2]},\"5\":{\"text\":\"婚姻状况\",\"style\":93},\"6\":{\"text\":\"${yuangongjiben.marital}\",\"style\":23},\"7\":{\"text\":\"有无子女\",\"style\":93},\"8\":{\"text\":\"${yuangongjiben.children}\",\"style\":23}},\"isDrag\":true,\"height\":33},\"10\":{\"cells\":{\"0\":{\"merge\":[0,1],\"text\":\"户口所在街道名称\",\"style\":93},\"2\":{\"text\":\"${yuangongjiben.hukoustreet}\",\"style\":24,\"merge\":[0,2]},\"5\":{\"merge\":[0,1],\"text\":\"户口所在地邮编\",\"style\":93},\"7\":{\"text\":\"${yuangongjiben.hukounum}\",\"style\":23,\"merge\":[0,1]}},\"isDrag\":true,\"height\":38},\"11\":{\"cells\":{\"0\":{\"text\":\"户口所在地地址\",\"style\":96,\"merge\":[2,1]},\"2\":{\"text\":\"${yuangongjiben.hukoudi}\",\"style\":26,\"merge\":[2,6]}},\"isDrag\":true},\"12\":{\"cells\":{}},\"13\":{\"cells\":{\"11\":{\"text\":\"\"}},\"isDrag\":true},\"14\":{\"cells\":{\"0\":{\"merge\":[0,1],\"text\":\"现居住地址\",\"style\":98},\"2\":{\"text\":\"${yuangongjiben.currentdi}\",\"style\":26,\"merge\":[0,2]},\"5\":{\"style\":98,\"merge\":[0,1],\"text\":\"现居住地址邮编\"},\"7\":{\"text\":\"${yuangongjiben.currentnum}\",\"style\":26,\"merge\":[0,1]}},\"isDrag\":true,\"height\":33},\"15\":{\"cells\":{\"0\":{\"merge\":[0,1],\"text\":\"是否参加社保\",\"style\":98},\"2\":{\"text\":\"${yuangongjiben.socialsecurity}\",\"style\":27,\"merge\":[0,1]},\"4\":{\"text\":\"有无公积金\",\"style\":98},\"5\":{\"text\":\"${yuangongjiben.providentfund}\",\"style\":27,\"merge\":[0,1]},\"7\":{\"text\":\"兴趣爱好\",\"style\":98},\"8\":{\"text\":\"${yuangongjiben.hobby}\",\"style\":27}},\"isDrag\":true,\"height\":34},\"16\":{\"cells\":{\"0\":{\"merge\":[0,1],\"text\":\"参加社保类型\",\"style\":98},\"2\":{\"text\":\"${yuangongjiben.sbtype}\",\"style\":116,\"merge\":[0,6]}},\"isDrag\":true,\"height\":30},\"17\":{\"cells\":{\"0\":{\"merge\":[0,1],\"text\":\"个人档案存放地\",\"style\":98},\"2\":{\"text\":\"${yuangongjiben.archivesdi}\",\"style\":116,\"merge\":[0,6]}},\"isDrag\":true,\"height\":33},\"18\":{\"cells\":{\"0\":{\"text\":\" \",\"style\":7},\"1\":{\"text\":\" \",\"style\":7},\"2\":{\"text\":\" \",\"style\":7},\"3\":{\"text\":\" \",\"style\":7},\"4\":{\"text\":\" \",\"style\":7},\"5\":{\"text\":\" \",\"style\":7},\"6\":{\"text\":\" \",\"style\":7},\"7\":{\"text\":\" \",\"style\":7},\"8\":{\"text\":\" \",\"style\":7}}},\"19\":{\"cells\":{\"0\":{\"merge\":[0,4],\"text\":\"学历、经历（从高中开始写）\",\"style\":99},\"5\":{\"style\":7,\"text\":\" \"},\"6\":{\"style\":7,\"text\":\" \"},\"7\":{\"style\":7,\"text\":\" \"},\"8\":{\"style\":7,\"text\":\" \"},\"9\":{\"style\":112,\"text\":\" \"}}},\"20\":{\"cells\":{\"0\":{\"text\":\"由_年_月\",\"merge\":[0,1],\"style\":36},\"2\":{\"merge\":[0,1],\"text\":\"至_年_月\",\"style\":38},\"4\":{\"merge\":[0,1],\"text\":\"就读学校\",\"style\":38},\"6\":{\"merge\":[0,1],\"text\":\"专业\",\"style\":38},\"8\":{\"text\":\"担任职务\",\"style\":38},\"9\":{\"style\":112,\"text\":\" \"}}},\"21\":{\"cells\":{\"0\":{\"style\":90,\"merge\":[0,1],\"text\":\"#{xueli.kdate}\"},\"2\":{\"style\":90,\"text\":\"#{xueli.jdate}\",\"merge\":[0,1]},\"4\":{\"style\":90,\"text\":\"#{xueli.jstudent}\",\"merge\":[0,1]},\"6\":{\"style\":90,\"text\":\"#{xueli.zhuanye}\",\"merge\":[0,1]},\"8\":{\"style\":90,\"text\":\"#{xueli.zhiwu}\"},\"9\":{\"style\":112,\"text\":\" \"}},\"isDrag\":true},\"22\":{\"cells\":{\"0\":{\"style\":7,\"text\":\" \"},\"1\":{\"style\":7,\"text\":\" \"},\"2\":{\"style\":7,\"text\":\" \"},\"3\":{\"style\":7,\"text\":\" \"},\"4\":{\"style\":7,\"text\":\" \"},\"5\":{\"style\":7,\"text\":\" \"},\"6\":{\"style\":7,\"text\":\" \"},\"7\":{\"style\":7,\"text\":\" \"},\"8\":{\"style\":7,\"text\":\" \"},\"9\":{\"style\":112,\"text\":\" \"}}},\"23\":{\"cells\":{\"0\":{\"merge\":[0,4],\"text\":\"工作经历\",\"style\":124},\"5\":{\"style\":7,\"text\":\" \"},\"6\":{\"style\":7,\"text\":\" \"},\"7\":{\"style\":7,\"text\":\" \"},\"8\":{\"style\":7,\"text\":\" \"},\"9\":{\"style\":112,\"text\":\" \"}},\"height\":27},\"24\":{\"cells\":{\"0\":{\"text\":\"由_年_月\",\"merge\":[0,1],\"style\":36},\"2\":{\"merge\":[0,1],\"text\":\"至_年_月\",\"style\":38},\"4\":{\"text\":\"工作单位及职称\",\"style\":38,\"merge\":[0,1]},\"6\":{\"merge\":[0,1],\"text\":\"证明人\",\"style\":38},\"8\":{\"text\":\"联系方式\",\"style\":38},\"9\":{\"style\":112,\"text\":\" \"}}},\"25\":{\"cells\":{\"0\":{\"text\":\"#{uu.kdate}\",\"style\":90,\"merge\":[0,1]},\"2\":{\"text\":\"#{uu.jdate}\",\"style\":90,\"merge\":[0,1]},\"4\":{\"text\":\"#{uu.jstudent}\",\"style\":90,\"merge\":[0,1]},\"6\":{\"text\":\"#{uu.zmname}\",\"style\":90,\"merge\":[0,1]},\"8\":{\"text\":\"#{uu.zmphone}\",\"style\":90},\"9\":{\"style\":112,\"text\":\" \"}},\"isDrag\":true},\"26\":{\"cells\":{\"0\":{\"style\":7,\"text\":\" \"},\"1\":{\"style\":7,\"text\":\" \"},\"2\":{\"style\":7,\"text\":\" \"},\"3\":{\"style\":7,\"text\":\" \"},\"4\":{\"style\":7,\"text\":\" \"},\"5\":{\"style\":7,\"text\":\" \"},\"6\":{\"style\":7,\"text\":\" \"},\"7\":{\"style\":7,\"text\":\" \"},\"8\":{\"style\":7,\"text\":\" \"},\"9\":{\"style\":112,\"text\":\" \"}}},\"27\":{\"cells\":{\"0\":{\"merge\":[0,4],\"text\":\"职称/资格、证书\",\"style\":125},\"5\":{\"style\":7,\"text\":\" \"},\"6\":{\"style\":7,\"text\":\" \"},\"7\":{\"style\":7,\"text\":\" \"},\"8\":{\"style\":7,\"text\":\" \"},\"9\":{\"style\":112,\"text\":\" \"}},\"height\":46},\"28\":{\"cells\":{\"0\":{\"text\":\"发证时间\",\"merge\":[0,1],\"style\":36},\"2\":{\"merge\":[0,1],\"text\":\"职称名称\",\"style\":38},\"4\":{\"text\":\"级别\",\"style\":38,\"merge\":[0,1]},\"6\":{\"text\":\"发证单位\",\"style\":38,\"merge\":[0,1]},\"8\":{\"text\":\"备注\",\"style\":38},\"9\":{\"style\":112,\"text\":\" \"}}},\"29\":{\"cells\":{\"0\":{\"text\":\"#{zhengshu.fdate}\",\"style\":90,\"merge\":[0,1]},\"2\":{\"text\":\"#{zhengshu.zcname}\",\"style\":90,\"merge\":[0,1]},\"4\":{\"text\":\"#{zhengshu.jibie}\",\"style\":90,\"merge\":[0,1]},\"6\":{\"text\":\"#{zhengshu.danwei}\",\"style\":90,\"merge\":[0,1]},\"8\":{\"text\":\"#{zhengshu.beizhu}\",\"style\":90},\"9\":{\"style\":112,\"text\":\" \"}},\"isDrag\":true},\"30\":{\"cells\":{\"0\":{\"style\":7,\"text\":\" \"},\"1\":{\"style\":7,\"text\":\" \"},\"2\":{\"style\":7,\"text\":\" \"},\"3\":{\"style\":7,\"text\":\" \"},\"4\":{\"style\":7,\"text\":\" \"},\"5\":{\"style\":7,\"text\":\" \"},\"6\":{\"style\":7,\"text\":\" \"},\"7\":{\"style\":7,\"text\":\" \"},\"8\":{\"style\":7,\"text\":\" \"},\"9\":{\"style\":112,\"text\":\" \"}}},\"31\":{\"cells\":{\"0\":{\"merge\":[0,1],\"text\":\"家庭成员\",\"style\":125},\"2\":{\"style\":7,\"text\":\" \"},\"3\":{\"style\":7,\"text\":\" \"},\"4\":{\"style\":7,\"text\":\" \"},\"5\":{\"style\":7,\"text\":\" \"},\"6\":{\"style\":7,\"text\":\" \"},\"7\":{\"style\":7,\"text\":\" \"},\"8\":{\"style\":7,\"text\":\" \"},\"9\":{\"style\":112,\"text\":\" \"}},\"height\":42},\"32\":{\"cells\":{\"0\":{\"merge\":[0,1],\"text\":\"姓名\",\"style\":38},\"2\":{\"merge\":[0,1],\"text\":\"关系\",\"style\":38},\"4\":{\"text\":\"年龄\",\"style\":38},\"5\":{\"text\":\"工作单位\",\"style\":38,\"merge\":[0,1]},\"7\":{\"text\":\"政治面貌\",\"style\":38},\"8\":{\"text\":\"联系方式\",\"style\":38},\"9\":{\"style\":112,\"text\":\" \"}}},\"33\":{\"cells\":{\"0\":{\"text\":\"#{jtcy.name}\",\"style\":90,\"merge\":[0,1]},\"2\":{\"text\":\"#{jtcy.guanxi}\",\"style\":90,\"merge\":[0,1]},\"4\":{\"text\":\"#{jtcy.age}\",\"style\":90},\"5\":{\"text\":\"#{jtcy.danwei}\",\"style\":90,\"merge\":[0,1]},\"7\":{\"text\":\"#{jtcy.zzmm}\",\"style\":90},\"8\":{\"text\":\"#{jtcy.phone}\",\"style\":90},\"9\":{\"style\":112,\"text\":\" \"}},\"isDrag\":true},\"34\":{\"cells\":{\"0\":{\"text\":\" \",\"style\":7},\"1\":{\"text\":\" \",\"style\":7},\"2\":{\"text\":\" \",\"style\":7},\"3\":{\"text\":\" \",\"style\":7},\"4\":{\"text\":\" \",\"style\":7},\"5\":{\"text\":\" \",\"style\":7},\"6\":{\"text\":\" \",\"style\":7},\"7\":{\"text\":\" \",\"style\":7},\"8\":{\"text\":\" \",\"style\":7},\"9\":{\"style\":112,\"text\":\" \"}}},\"35\":{\"cells\":{\"0\":{\"merge\":[0,2],\"text\":\"所获奖励\",\"style\":125},\"3\":{\"text\":\" \",\"style\":7},\"4\":{\"text\":\" \",\"style\":7},\"5\":{\"text\":\" \",\"style\":7},\"6\":{\"text\":\" \",\"style\":7},\"7\":{\"text\":\" \",\"style\":7},\"8\":{\"text\":\" \",\"style\":7},\"9\":{\"style\":112,\"text\":\" \"}},\"height\":47},\"36\":{\"cells\":{\"0\":{\"text\":\"时间\",\"style\":90,\"merge\":[0,2]},\"3\":{\"style\":90,\"text\":\"地点\",\"merge\":[0,2]},\"6\":{\"style\":90,\"text\":\"所获得的奖励名称\",\"merge\":[0,2]},\"9\":{\"style\":112,\"text\":\" \"}}},\"37\":{\"cells\":{\"0\":{\"text\":\"#{jiangli.date}\",\"style\":90,\"merge\":[0,2]},\"3\":{\"text\":\"#{jiangli.didian}\",\"style\":90,\"merge\":[0,2]},\"6\":{\"text\":\"#{jiangli.mingcheng}\",\"style\":90,\"merge\":[0,2]},\"9\":{\"style\":112,\"text\":\" \"}},\"isDrag\":true},\"len\":98},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":703,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":16}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true}},{\"align\":\"center\",\"font\":{\"name\":\"仿宋\"}},{\"font\":{\"name\":\"仿宋\"}},{\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"size\":12}},{\"font\":{\"name\":\"宋体\",\"size\":12}},{\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"size\":8}},{\"font\":{\"name\":\"宋体\",\"size\":8}},{\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"size\":10}},{\"font\":{\"name\":\"宋体\",\"size\":10}},{\"align\":\"center\",\"font\":{\"name\":\"隶书\",\"size\":10}},{\"font\":{\"name\":\"隶书\",\"size\":10}},{\"align\":\"center\",\"font\":{\"name\":\"华文中宋\",\"size\":10}},{\"font\":{\"name\":\"华文中宋\",\"size\":10}},{\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\",\"size\":10}},{\"font\":{\"name\":\"Microsoft YaHei\",\"size\":10}},{\"textwrap\":true},{\"textwrap\":true,\"align\":\"center\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"font\":{\"name\":\"宋体\",\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"font\":{\"bold\":true}},{\"font\":{\"bold\":true,\"size\":12}},{\"font\":{\"bold\":true,\"size\":10}},{\"font\":{\"bold\":true,\"size\":10},\"align\":\"center\"},{\"font\":{\"bold\":true},\"align\":\"center\"},{\"font\":{\"bold\":true,\"size\":10},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"bold\":true},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"bold\":true,\"size\":10,\"name\":\"宋体\"},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"bold\":true,\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"font\":{\"bold\":true,\"name\":\"宋体\"},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"bold\":true,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true},\"border\":{\"top\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"medium\",\"#000\"],\"left\":[\"medium\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true},\"border\":{\"top\":[\"medium\",\"#000\"]}},{\"border\":{\"top\":[\"medium\",\"#000\"],\"right\":[\"medium\",\"#000\"]}},{\"border\":{\"left\":[\"medium\",\"#000\"]}},{\"border\":{\"right\":[\"medium\",\"#000\"]}},{\"border\":{\"bottom\":[\"medium\",\"#000\"],\"left\":[\"medium\",\"#000\"]}},{\"border\":{\"bottom\":[\"medium\",\"#000\"]}},{\"border\":{\"bottom\":[\"medium\",\"#000\"],\"right\":[\"medium\",\"#000\"]}},{\"border\":{\"top\":[\"medium\",\"#000\"],\"left\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true,\"name\":\"Microsoft YaHei\"},\"border\":{\"top\":[\"medium\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true,\"name\":\"Microsoft YaHei\"}},{\"border\":{\"top\":[\"medium\",\"#000\"],\"right\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"border\":{\"left\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\",\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"right\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"font\":{\"name\":\"Microsoft YaHei\",\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"font\":{\"name\":\"Microsoft YaHei\"}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\"}},{\"font\":{\"name\":\"Microsoft YaHei\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\"}},{\"font\":{\"bold\":true,\"size\":10,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"bold\":true,\"size\":10,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"font\":{\"bold\":true,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"bold\":true,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"border\":{\"bottom\":[\"medium\",\"#000\"],\"left\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"border\":{\"bottom\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"border\":{\"bottom\":[\"medium\",\"#000\"],\"right\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\",\"size\":8},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"font\":{\"name\":\"Microsoft YaHei\",\"size\":8}},{\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\",\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\",\"size\":8}},{\"border\":{\"top\":[\"medium\",\"#000\"],\"left\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true,\"name\":\"宋体\"},\"border\":{\"top\":[\"medium\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true,\"name\":\"宋体\"}},{\"border\":{\"left\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"size\":8},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"medium\",\"#000\"],\"left\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"medium\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"size\":10,\"bold\":true},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"font\":{\"name\":\"宋体\",\"size\":10,\"bold\":true},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"font\":{\"name\":\"宋体\",\"size\":10,\"bold\":true}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"bold\":true},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"bold\":true}},{\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"bold\":true},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"font\":{\"name\":\"宋体\",\"bold\":true}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true,\"name\":\"宋体\"},\"border\":{\"top\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"border\":{\"left\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"border\":{\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"]},\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true,\"name\":\"宋体\"},\"border\":{\"top\":[\"thin\",\"#ffffff\"]}},{\"border\":{\"top\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"border\":{\"left\":[\"thin\",\"#ffffff\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"right\":[\"thin\",\"#ffffff\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"left\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"align\":\"left\",\"font\":{\"name\":\"宋体\"}},{\"font\":{\"name\":\"宋体\",\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"name\":\"宋体\",\"size\":10},\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"name\":\"宋体\",\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"name\":\"宋体\",\"bold\":true},\"align\":\"right\"},{\"font\":{\"name\":\"宋体\",\"bold\":true},\"align\":\"right\",\"valign\":\"bottom\"},{\"font\":{\"name\":\"宋体\",\"bold\":true},\"align\":\"left\",\"valign\":\"bottom\"},{\"font\":{\"name\":\"宋体\",\"bold\":true},\"valign\":\"bottom\"},{\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"name\":\"宋体\",\"size\":10,\"bold\":true},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"bold\":true},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"font\":{\"name\":\"宋体\",\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"format\":\"datetime\"},{\"font\":{\"name\":\"宋体\",\"size\":10},\"format\":\"datetime\"},{\"font\":{\"name\":\"宋体\",\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"format\":\"normal\"},{\"font\":{\"name\":\"宋体\",\"size\":10},\"format\":\"normal\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":73},\"1\":{\"width\":71},\"2\":{\"width\":69},\"3\":{\"width\":89},\"4\":{\"width\":64},\"5\":{\"width\":47},\"6\":{\"width\":68},\"7\":{\"width\":100},\"8\":{\"width\":103},\"9\":{\"width\":19},\"10\":{\"width\":146},\"11\":{\"width\":85},\"len\":50},\"merges\":[\"H3:I3\",\"B3:D3\",\"A2:I2\",\"D6:F6\",\"D7:F7\",\"A8:B8\",\"G8:H8\",\"A9:B9\",\"A10:B10\",\"C10:E10\",\"C8:E8\",\"C9:E9\",\"A11:B11\",\"C11:E11\",\"F11:G11\",\"H11:I11\",\"C12:I14\",\"A15:B15\",\"C15:E15\",\"F15:G15\",\"H15:I15\",\"A16:B16\",\"A17:B17\",\"A18:B18\",\"C17:I17\",\"C18:I18\",\"A20:E20\",\"A21:B21\",\"C21:D21\",\"E21:F21\",\"G21:H21\",\"A22:B22\",\"A24:E24\",\"A25:B25\",\"C25:D25\",\"G25:H25\",\"A26:B26\",\"A28:E28\",\"A29:B29\",\"C29:D29\",\"A30:B30\",\"A32:B32\",\"A33:B33\",\"C33:D33\",\"A34:B34\",\"C34:D34\",\"A36:C36\",\"C16:D16\",\"F16:G16\",\"QAAAAAACI1:JAAAAAABJ38\",\"A1:I1\",\"H4:I4\",\"G9:I9\",\"G22:H22\",\"E22:F22\",\"C22:D22\",\"C26:D26\",\"G26:H26\",\"C30:D30\",\"G30:H30\",\"E30:F30\",\"D37:F37\",\"D38:F38\",\"A38:C38\",\"A37:C37\",\"G37:I37\",\"G38:I38\",\"E29:F29\",\"G29:H29\",\"E25:F25\",\"E26:F26\",\"F33:G33\",\"F34:G34\",\"A12:B14\",\"I5:I8\"],\"imgList\":[{\"row\":4,\"col\":8,\"width\":\"101\",\"height\":\"128\",\"src\":\"https://jimureport.oss-cn-beijing.aliyuncs.com/designreport/images/QQ截图20210115102648_1610694177544_1617244906979.png\",\"layer_id\":\"cvkWDQVZhfJPgcS4\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[4,8]]}]}', NULL, 'https://static.jeecg.com/designreport/images/1122_1607312336469.png', 'admin', '2020-10-10 16:32:53', 'admin', '2021-04-01 02:42:07', 0, NULL, NULL, 1, 606, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1316944968992034816', '20201016113231', '员工信息登记', NULL, NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":false,\"printElWidth\":718,\"excel_config_id\":\"1316944968992034816\",\"printElHeight\":1047,\"rows\":{\"1\":{\"cells\":{\"0\":{\"text\":\"员工信息登记表\",\"merge\":[0,6],\"style\":28},\"1\":{\"style\":21,\"text\":\" \"},\"2\":{\"style\":21,\"text\":\" \"},\"3\":{\"style\":21,\"text\":\" \"},\"4\":{\"style\":21,\"text\":\" \"},\"5\":{\"style\":21,\"text\":\" \"},\"6\":{\"style\":21,\"text\":\" \"}},\"height\":46},\"2\":{\"cells\":{\"0\":{\"text\":\"编号:\",\"style\":29},\"1\":{\"text\":\"${employee.num}\",\"style\":30,\"merge\":[0,3]},\"2\":{\"text\":\" \",\"style\":24},\"3\":{\"text\":\" \",\"style\":24},\"4\":{\"text\":\" \",\"style\":24},\"5\":{\"text\":\"填写日期:\",\"style\":29},\"6\":{\"text\":\"${employee.create_time}\",\"style\":36}},\"isDrag\":true,\"height\":44},\"3\":{\"cells\":{\"0\":{\"text\":\"姓名:\",\"style\":29},\"1\":{\"text\":\"${employee.name}\",\"style\":30},\"2\":{\"text\":\"性别:\",\"style\":29},\"3\":{\"text\":\"${employee.sex}\",\"style\":30},\"4\":{\"text\":\"出生年月:\",\"style\":29},\"5\":{\"text\":\"${employee.birthday}\",\"style\":36},\"6\":{\"style\":3,\"text\":\" \",\"merge\":[4,0],\"virtual\":\"Ym8ny6lYTdutY5tT\"}},\"isDrag\":true,\"height\":42},\"4\":{\"cells\":{\"0\":{\"text\":\"民族:\",\"style\":29},\"1\":{\"text\":\"${employee.nation}\",\"style\":30},\"2\":{\"text\":\"政治面貌:\",\"style\":29},\"3\":{\"text\":\"${employee.political}\",\"style\":30},\"4\":{\"text\":\"籍贯:\",\"style\":29},\"5\":{\"text\":\"${employee.native_place}\",\"style\":30}},\"isDrag\":true,\"height\":38},\"5\":{\"cells\":{\"0\":{\"text\":\"身高(cm):\",\"style\":29},\"1\":{\"text\":\"${employee.height}\",\"style\":30},\"2\":{\"text\":\"体重(kg):\",\"style\":29},\"3\":{\"text\":\"${employee.weight}\",\"style\":30},\"4\":{\"text\":\"健康状况:\",\"style\":29},\"5\":{\"text\":\"${employee.health}\",\"style\":30}},\"isDrag\":true,\"height\":38},\"6\":{\"cells\":{\"0\":{\"text\":\"身份证号:\",\"style\":29},\"1\":{\"text\":\"${employee.id_card}\",\"style\":30,\"merge\":[0,2]},\"2\":{\"text\":\" \",\"style\":24},\"3\":{\"text\":\" \",\"style\":24},\"4\":{\"text\":\"学历:\",\"style\":29},\"5\":{\"text\":\"${employee.education}\",\"style\":30}},\"isDrag\":true,\"height\":40},\"7\":{\"cells\":{\"0\":{\"text\":\"毕业学校:\",\"style\":29},\"1\":{\"text\":\"${employee.school}\",\"style\":30,\"merge\":[0,2]},\"2\":{\"text\":\" \",\"style\":24},\"3\":{\"text\":\" \",\"style\":24},\"4\":{\"text\":\"专业:\",\"style\":29},\"5\":{\"text\":\"${employee.major}\",\"style\":30}},\"isDrag\":true,\"height\":44},\"8\":{\"cells\":{\"0\":{\"text\":\"联系地址:\",\"style\":29},\"1\":{\"text\":\"${employee.address}\",\"style\":30,\"merge\":[0,2]},\"2\":{\"text\":\" \",\"style\":24},\"3\":{\"text\":\" \",\"style\":24},\"4\":{\"text\":\"邮编:\",\"style\":29},\"5\":{\"text\":\"${employee.zip_code}\",\"style\":30,\"merge\":[0,1]},\"6\":{\"text\":\" \",\"style\":24}},\"isDrag\":true,\"height\":45},\"9\":{\"cells\":{\"0\":{\"text\":\"Email:\",\"style\":29},\"1\":{\"text\":\"${employee.email}\",\"style\":30,\"merge\":[0,2]},\"2\":{\"text\":\" \",\"style\":24},\"3\":{\"text\":\" \",\"style\":24},\"4\":{\"text\":\"手机号:\",\"style\":29},\"5\":{\"text\":\"${employee.phone}\",\"style\":30,\"merge\":[0,1]},\"6\":{\"text\":\" \",\"style\":24}},\"isDrag\":true,\"height\":40},\"10\":{\"cells\":{\"0\":{\"text\":\"外语语种:\",\"style\":29},\"1\":{\"text\":\"${employee.foreign_language}\",\"style\":30},\"2\":{\"text\":\"外语水平:\",\"style\":29},\"3\":{\"text\":\"${employee.foreign_language_level}\",\"style\":30},\"4\":{\"text\":\"计算机水平:\",\"style\":29},\"5\":{\"text\":\"${employee.computer_level}\",\"style\":30,\"merge\":[0,1]},\"6\":{\"text\":\" \",\"style\":24}},\"isDrag\":true,\"height\":41},\"11\":{\"cells\":{\"0\":{\"text\":\"毕业时间:\",\"style\":29},\"1\":{\"text\":\"${employee.graduation_time}\",\"style\":34},\"2\":{\"text\":\"到职时间:\",\"style\":29},\"3\":{\"text\":\"${employee.arrival_time}\",\"style\":34},\"4\":{\"text\":\"职称:\",\"style\":29},\"5\":{\"text\":\"${employee.positional_titles}\",\"style\":30,\"merge\":[0,1]},\"6\":{\"text\":\" \",\"style\":24}},\"isDrag\":true,\"height\":42},\"12\":{\"cells\":{\"0\":{\"text\":\"教育经历:\",\"style\":32},\"1\":{\"text\":\"\",\"style\":35,\"merge\":[0,5]},\"2\":{\"text\":\" \",\"style\":40},\"3\":{\"text\":\" \",\"style\":40},\"4\":{\"text\":\" \",\"style\":40},\"5\":{\"text\":\" \",\"style\":40},\"6\":{\"text\":\" \",\"style\":40}},\"isDrag\":true,\"height\":39},\"13\":{\"cells\":{\"0\":{\"text\":\"${employee.education_experience}\",\"style\":33,\"merge\":[0,6]},\"1\":{\"style\":27,\"text\":\" \"},\"2\":{\"style\":27,\"text\":\" \"},\"3\":{\"style\":27,\"text\":\" \"},\"4\":{\"style\":27,\"text\":\" \"},\"5\":{\"style\":27,\"text\":\" \"},\"6\":{\"style\":27,\"text\":\" \"}},\"isDrag\":true,\"height\":70},\"14\":{\"cells\":{\"0\":{\"text\":\"工作经历:\",\"style\":32},\"1\":{\"merge\":[0,5],\"style\":30,\"text\":\" \"},\"2\":{\"text\":\" \",\"style\":24},\"3\":{\"text\":\" \",\"style\":24},\"4\":{\"text\":\" \",\"style\":24},\"5\":{\"text\":\" \",\"style\":24},\"6\":{\"text\":\" \",\"style\":24}},\"height\":43},\"15\":{\"cells\":{\"0\":{\"text\":\"${employee.work_experience}\",\"style\":30,\"merge\":[0,6]},\"1\":{\"text\":\" \",\"style\":24},\"2\":{\"text\":\" \",\"style\":24},\"3\":{\"text\":\" \",\"style\":24},\"4\":{\"text\":\" \",\"style\":24},\"5\":{\"text\":\" \",\"style\":24},\"6\":{\"text\":\" \",\"style\":24}},\"isDrag\":true,\"height\":61},\"17\":{\"cells\":{\"1\":{\"text\":\"\",\"style\":37}}},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[\"sex1\"],\"freeze\":\"A1\",\"dataRectWidth\":712,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":true}},{\"font\":{\"bold\":true}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":false}},{\"font\":{\"bold\":false}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":true},\"align\":\"right\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16},\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]},\"font\":{\"bold\":true},\"align\":\"right\"},{\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]},\"font\":{\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]},\"font\":{\"bold\":false}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16},\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"bold\":true},\"align\":\"right\"},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"bold\":false}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16,\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16,\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"bold\":true,\"name\":\"宋体\"},\"align\":\"right\"},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"name\":\"宋体\"}},{\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"bold\":true,\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"bold\":false,\"name\":\"宋体\"}},{\"font\":{\"bold\":false,\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16,\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":true,\"name\":\"宋体\"},\"align\":\"right\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":true,\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false,\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"宋体\"},\"format\":\"date2\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"宋体\"},\"format\":\"normal\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"宋体\"},\"format\":\"date\"},{\"format\":\"date2\"},{\"font\":{\"name\":\"宋体\"},\"format\":\"date2\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"宋体\"},\"format\":\"time\"},{\"font\":{\"name\":\"宋体\"},\"format\":\"normal\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":79},\"1\":{\"width\":92},\"2\":{\"width\":76},\"3\":{\"width\":106},\"5\":{\"width\":123},\"6\":{\"width\":136},\"len\":50},\"merges\":[\"A2:G2\",\"B3:E3\",\"B7:D7\",\"B8:D8\",\"B9:D9\",\"B10:D10\",\"F9:G9\",\"F10:G10\",\"F11:G11\",\"F12:G12\",\"B13:G13\",\"A14:G14\",\"B15:G15\",\"A16:G16\",\"G4:G8\"],\"imgList\":[{\"row\":3,\"col\":6,\"width\":\"135\",\"height\":\"192\",\"src\":\"https://static.jeecg.com/designreport/images/QQ截图20210108095848_1610071294294.png\",\"layer_id\":\"Ym8ny6lYTdutY5tT\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[3,6]]}]}', NULL, 'https://static.jeecg.com/designreport/images/1133_1607312428261.png', 'admin', '2020-10-16 11:32:32', 'admin', '2021-02-03 13:59:35', 0, NULL, NULL, 1, 1410, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1331503965770223616', '20201125155042', '房屋销售综合展示大屏', NULL, NULL, 'chartinfo', '{\"loopBlockList\":[],\"chartList\":[{\"row\":1,\"col\":1,\"width\":\"338\",\"height\":\"378\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"interval\\\":0,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"data\\\":[\\\"缤纷南郡\\\",\\\"中航华府\\\",\\\"3中家属楼\\\",\\\"幸福家园\\\",\\\"水晶国际\\\",\\\"绿城小区\\\",\\\"缤纷南郡二期\\\",\\\"国奥家园\\\",\\\"西西胡同\\\",\\\"融创学府\\\",\\\"蓝湾国际\\\",\\\"广发小区\\\"],\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type\\\":\\\"category\\\"},\\\"xAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type \\\":\\\"value\\\"},\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"房子\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"grid\\\":{\\\"top\\\":60,\\\"left\\\":71,\\\"bottom\\\":39,\\\"right\\\":29},\\\"series\\\":[{\\\"barWidth\\\":13,\\\"data\\\":[2,2,2,3,4,3,3,5,2,7,4,8],\\\"name\\\":\\\"房子\\\",\\\"itemStyle\\\":{\\\"color\\\":\\\"#67994B\\\",\\\"barBorderRadius\\\":7},\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"top\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"bar\\\",\\\"barMinHeight\\\":2,\\\"typeData\\\":[]}],\\\"tooltip\\\":{\\\"show\\\":true,\\\"axisPointer\\\":{\\\"type\\\":\\\"shadow\\\"},\\\"trigger\\\":\\\"axis\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"padding\\\":[5,20,5,20],\\\"left\\\":\\\"left\\\",\\\"show\\\":true,\\\"text\\\":\\\"各楼盘成交量排名\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"14\\\",\\\"fontWeight\\\":\\\"normal\\\"},\\\"top\\\":10},\\\"backgroundColor\\\":{\\\"src\\\":\\\"https://jimureport.oss-cn-beijing.aliyuncs.com/designreport/images/bg1_1606961907450_1617248229528.png\\\"}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1331511745851731969\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"chengjiao\",\"chartType\":\"bar.multi.horizontal\",\"isTiming\":true,\"intervalTime\":\"5\"},\"layer_id\":\"5ggWQtDUvSopC4iL\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[1,1],[1,2],[1,3]]},{\"row\":1,\"col\":12,\"width\":\"327\",\"height\":\"152\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":12}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"name\\\":\\\"\\\",\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false}},\\\"xAxis\\\":{\\\"axisLabel\\\":{\\\"rotate\\\":34,\\\"interval\\\":0,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"data\\\":[\\\"高层\\\",\\\"小高层\\\",\\\"写字楼\\\",\\\"厂房\\\",\\\"公寓\\\",\\\"别墅\\\",\\\"厂房\\\",\\\"四合院\\\",\\\"loft\\\"],\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"name\\\":\\\"\\\",\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false}},\\\"grid\\\":{\\\"top\\\":50,\\\"left\\\":30,\\\"bottom\\\":44,\\\"right\\\":24},\\\"series\\\":[{\\\"areaStyle\\\":null,\\\"data\\\":[20,25,10,5,9,1,5,1,20],\\\"showSymbol\\\":true,\\\"lineStyle\\\":{\\\"width\\\":2},\\\"symbolSize\\\":5,\\\"isArea\\\":false,\\\"name\\\":\\\"销量\\\",\\\"itemStyle\\\":{\\\"color\\\":\\\"#D04672\\\"},\\\"step\\\":false,\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"top\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"line\\\",\\\"smooth\\\":true}],\\\"tooltip\\\":{\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":true,\\\"top\\\":10,\\\"text\\\":\\\"房形分析\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontWeight\\\":\\\"normal\\\",\\\"fontSize\\\":\\\"14\\\"},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,10]},\\\"backgroundColor\\\":{\\\"src\\\":\\\"https://static.jeecg.com/designreport/images/bg1_1607938818911.png\\\"}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1331922734933987329\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"fangyuan\",\"chartType\":\"line.smooth\",\"isTiming\":true,\"intervalTime\":\"5\"},\"layer_id\":\"nk6I2RCefm9scS1k\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[1,12],[1,13],[1,14],[1,15]]},{\"row\":7,\"col\":12,\"width\":\"324\",\"height\":\"215\",\"config\":\"{\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"1室\\\",\\\"2室\\\",\\\"3室\\\",\\\"4室\\\",\\\"5室\\\"],\\\"top\\\":\\\"bottom\\\",\\\"orient\\\":\\\"vertical\\\",\\\"left\\\":\\\"right\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"series\\\":[{\\\"isRose\\\":false,\\\"data\\\":[{\\\"name\\\":\\\"1室\\\",\\\"value\\\":10,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(53,165,180,1)\\\"}},{\\\"name\\\":\\\"2室\\\",\\\"value\\\":30,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(60,140,198,1)\\\"}},{\\\"name\\\":\\\"3室\\\",\\\"value\\\":20,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(93,144,81,1)\\\"}},{\\\"name\\\":\\\"4室\\\",\\\"value\\\":5,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(191,146,68,1)\\\"}},{\\\"name\\\":\\\"5室\\\",\\\"value\\\":3,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(188,69,117,1)\\\"}}],\\\"isRadius\\\":true,\\\"roseType\\\":\\\"\\\",\\\"notCount\\\":false,\\\"center\\\":[\\\"160\\\",\\\"120\\\"],\\\"name\\\":\\\"访问来源\\\",\\\"minAngle\\\":0,\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"outside\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"\\\",\\\"fontSize\\\":\\\"8\\\",\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"pie\\\",\\\"radius\\\":[\\\"40%\\\",\\\"50%\\\"],\\\"autoSort\\\":false}],\\\"tooltip\\\":{\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":true,\\\"top\\\":10,\\\"text\\\":\\\"不同户型销售\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontWeight\\\":\\\"normal\\\",\\\"fontSize\\\":\\\"14\\\"},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,10]},\\\"backgroundColor\\\":{\\\"src\\\":\\\"https://static.jeecg.com/designreport/images/bg1_1608536502813.png\\\"}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1331919172472524801\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"huxingxiaoshou\",\"chartType\":\"pie.doughnut\",\"isTiming\":true,\"intervalTime\":\"5\",\"id\":\"MCJP8uqwe57YoCvF\"},\"layer_id\":\"MCJP8uqwe57YoCvF\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[7,12],[7,13],[7,14],[7,15]]},{\"row\":7,\"col\":4,\"width\":\"662\",\"height\":\"222\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type \\\":\\\"value\\\"},\\\"xAxis\\\":{\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"interval\\\":0,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"data\\\":[\\\"1月\\\",\\\"2月\\\",\\\"3月\\\",\\\"4月\\\",\\\"5月\\\",\\\"6月\\\",\\\"7月\\\",\\\"8月\\\",\\\"9月\\\",\\\"10月\\\",\\\"11月\\\",\\\"12月\\\"],\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#A98E8E\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type\\\":\\\"category\\\"},\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"成交量\\\",\\\"成交价\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"vertical\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#FBF8F8\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"grid\\\":{\\\"top\\\":58,\\\"left\\\":30,\\\"bottom\\\":43,\\\"right\\\":32},\\\"series\\\":[{\\\"barWidth\\\":15,\\\"stack\\\":\\\"1\\\",\\\"data\\\":[10,7,5,5,7,9,3,6,5,8,6,6],\\\"name\\\":\\\"成交量\\\",\\\"itemStyle\\\":{\\\"color\\\":\\\"#37A5B1\\\",\\\"barBorderRadius\\\":13},\\\"type\\\":\\\"bar\\\",\\\"barMinHeight\\\":7,\\\"typeData\\\":[{\\\"name\\\":\\\"成交量\\\",\\\"type\\\":\\\"\\\",\\\"_index\\\":0,\\\"_rowKey\\\":136,\\\"stack\\\":\\\"1\\\"},{\\\"name\\\":\\\"成交价\\\",\\\"type\\\":\\\"\\\",\\\"stack\\\":\\\"1\\\",\\\"_index\\\":1,\\\"_rowKey\\\":139}]},{\\\"barWidth\\\":15,\\\"stack\\\":\\\"1\\\",\\\"data\\\":[5,5,12,5,5,5,5,10,5,5,5,5],\\\"name\\\":\\\"成交价\\\",\\\"itemStyle\\\":{\\\"color\\\":\\\"#2E72A7\\\",\\\"barBorderRadius\\\":13},\\\"type\\\":\\\"bar\\\",\\\"barMinHeight\\\":7,\\\"typeData\\\":[{\\\"name\\\":\\\"成交量\\\",\\\"type\\\":\\\"\\\",\\\"_index\\\":0,\\\"_rowKey\\\":136,\\\"stack\\\":\\\"1\\\"},{\\\"name\\\":\\\"成交价\\\",\\\"type\\\":\\\"\\\",\\\"stack\\\":\\\"1\\\",\\\"_index\\\":1,\\\"_rowKey\\\":139}]}],\\\"tooltip\\\":{\\\"show\\\":true,\\\"axisPointer\\\":{\\\"type\\\":\\\"shadow\\\"},\\\"trigger\\\":\\\"axis\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"padding\\\":[5,20,5,20],\\\"left\\\":\\\"left\\\",\\\"show\\\":true,\\\"text\\\":\\\"成交量和成交价趋势\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"14\\\",\\\"fontWeight\\\":\\\"normal\\\"},\\\"top\\\":10},\\\"backgroundColor\\\":{\\\"src\\\":\\\"https://static.jeecg.com/designreport/images/QQ截图20201207201434_1607343287788.png\\\"}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1331872643531526146\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"chengjiao1\",\"chartType\":\"bar.stack\",\"chartId\":\"\",\"isTiming\":true,\"intervalTime\":\"5\"},\"layer_id\":\"Nf6Xud4fZqEfvQw4\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[7,4],[7,5],[7,6],[7,7],[7,8],[7,9],[7,10],[7,11]]},{\"row\":16,\"col\":12,\"width\":\"326\",\"height\":\"200\",\"config\":\"{\\\"radar\\\":[{\\\"indicator\\\":[{\\\"name\\\":\\\"房产证\\\",\\\"max\\\":520},{\\\"name\\\":\\\"购房发票\\\",\\\"max\\\":310},{\\\"name\\\":\\\"购房合同\\\",\\\"max\\\":380},{\\\"name\\\":\\\"预售合同\\\",\\\"max\\\":450},{\\\"name\\\":\\\"抵押合同\\\",\\\"max\\\":600},{\\\"name\\\":\\\"预收合同\\\",\\\"max\\\":350}],\\\"shape\\\":\\\"polygon\\\",\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"gray\\\",\\\"opacity\\\":0.5}},\\\"center\\\":[\\\"50%\\\",\\\"50%\\\"],\\\"name\\\":{\\\"formatter\\\":\\\"【{value}】\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#72ACD1\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"gray\\\",\\\"opacity\\\":0.5}}}],\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"售后产权\\\",\\\"单位产权\\\",\\\"个人产权\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"series\\\":[{\\\"type\\\":\\\"radar\\\",\\\"data\\\":[{\\\"name\\\":\\\"售后产权\\\",\\\"value\\\":[43,100,280,350,500,250],\\\"areaStyle\\\":{\\\"color\\\":\\\"#3F9AFB\\\",\\\"opacity\\\":1},\\\"lineStyle\\\":{\\\"color\\\":\\\"#2D8CF0\\\"}},{\\\"name\\\":\\\"单位产权\\\",\\\"value\\\":[190,50,140,280,310,150],\\\"areaStyle\\\":{\\\"color\\\":\\\"#A6F65C\\\",\\\"opacity\\\":1},\\\"lineStyle\\\":{\\\"color\\\":\\\"#55FE4D\\\"}},{\\\"name\\\":\\\"个人产权\\\",\\\"value\\\":[420,210,160,0,120,130],\\\"areaStyle\\\":{\\\"color\\\":\\\"rgba(188,69,117,1)\\\",\\\"opacity\\\":1},\\\"lineStyle\\\":{\\\"color\\\":\\\"rgba(188,69,117,1)\\\"}}]}],\\\"tooltip\\\":{\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":true,\\\"top\\\":10,\\\"text\\\":\\\"不同产权、证件成交量\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#ffffff\\\",\\\"fontWeight\\\":\\\"normal\\\",\\\"fontSize\\\":\\\"14\\\"},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,20]},\\\"backgroundColor\\\":{\\\"src\\\":\\\"https://static.jeecg.com/designreport/images/bg1_1608274537110.png\\\"}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1331916030221602818\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"btchanquan\",\"chartType\":\"radar.basic\",\"isTiming\":true,\"intervalTime\":\"10\",\"id\":\"IWoBtyiRxjkEbkfD\"},\"layer_id\":\"IWoBtyiRxjkEbkfD\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[16,12],[16,13],[16,14],[16,15]]},{\"row\":16,\"col\":1,\"width\":\"337\",\"height\":\"205\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"interval\\\":0,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"data\\\":[\\\"马小姐\\\",\\\"孙小姐\\\",\\\"王先生\\\",\\\"李先生\\\",\\\"赵小姐\\\"],\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type\\\":\\\"category\\\"},\\\"xAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type \\\":\\\"value\\\"},\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"房子\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"grid\\\":{\\\"top\\\":55,\\\"left\\\":70,\\\"bottom\\\":40,\\\"right\\\":24},\\\"series\\\":[{\\\"barWidth\\\":13,\\\"data\\\":[20,15,12,10,7],\\\"name\\\":\\\"房子\\\",\\\"itemStyle\\\":{\\\"color\\\":\\\"#37A5B1\\\",\\\"barBorderRadius\\\":7},\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"top\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"bar\\\",\\\"barMinHeight\\\":2,\\\"typeData\\\":[]}],\\\"tooltip\\\":{\\\"show\\\":true,\\\"axisPointer\\\":{\\\"type\\\":\\\"shadow\\\"},\\\"trigger\\\":\\\"axis\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"padding\\\":[5,20,5,20],\\\"left\\\":\\\"left\\\",\\\"show\\\":true,\\\"text\\\":\\\"销售量成交排行榜\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"14\\\",\\\"fontWeight\\\":\\\"normal\\\"},\\\"top\\\":10},\\\"backgroundColor\\\":{\\\"src\\\":\\\"https://static.jeecg.com/designreport/images/bg1_1606961907450.png\\\"}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1331514838211407873\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"cjpaihang\",\"chartType\":\"bar.multi.horizontal\",\"isTiming\":true,\"intervalTime\":\"5\"},\"layer_id\":\"Cror94F1kmbP71ip\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[16,1],[16,2],[16,3]]},{\"row\":16,\"col\":4,\"width\":\"334\",\"height\":\"206\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"interval\\\":0,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"data\\\":[\\\"马小姐\\\",\\\"孙小姐\\\",\\\"王先生\\\",\\\"李先生\\\",\\\"赵小姐\\\"],\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type\\\":\\\"category\\\"},\\\"xAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type \\\":\\\"value\\\"},\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"房子\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"grid\\\":{\\\"top\\\":55,\\\"left\\\":56,\\\"bottom\\\":38,\\\"right\\\":30},\\\"series\\\":[{\\\"barWidth\\\":13,\\\"data\\\":[20,15,12,10,7],\\\"name\\\":\\\"房子\\\",\\\"itemStyle\\\":{\\\"color\\\":\\\"#2E72A7\\\",\\\"barBorderRadius\\\":7},\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"top\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"bar\\\",\\\"barMinHeight\\\":2,\\\"typeData\\\":[]}],\\\"tooltip\\\":{\\\"show\\\":true,\\\"axisPointer\\\":{\\\"type\\\":\\\"shadow\\\"},\\\"trigger\\\":\\\"axis\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"padding\\\":[5,20,5,20],\\\"left\\\":\\\"left\\\",\\\"show\\\":true,\\\"text\\\":\\\"销售员成交金额\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"14\\\",\\\"fontWeight\\\":\\\"normal\\\"},\\\"top\\\":10},\\\"backgroundColor\\\":{\\\"src\\\":\\\"https://static.jeecg.com/designreport/images/bg1_1606961918589.png\\\"}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1331514838211407873\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"cjpaihang\",\"chartType\":\"bar.multi.horizontal\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartId\":\"\"},\"layer_id\":\"pBOwp0Q0g4iuJCVm\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[16,4],[16,5],[16,6],[16,7]]},{\"row\":16,\"col\":8,\"width\":\"324\",\"height\":\"206\",\"config\":\"{\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"简装\\\",\\\"中装\\\",\\\"精装\\\",\\\"豪装\\\",\\\"毛坯\\\"],\\\"top\\\":\\\"bottom\\\",\\\"orient\\\":\\\"vertical\\\",\\\"left\\\":\\\"left\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"series\\\":[{\\\"isRose\\\":false,\\\"data\\\":[{\\\"name\\\":\\\"简装\\\",\\\"value\\\":10,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(52,158,172,1)\\\"}},{\\\"name\\\":\\\"中装\\\",\\\"value\\\":10,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(56,131,185,1)\\\"}},{\\\"name\\\":\\\"精装\\\",\\\"value\\\":10,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(103,153,75,1)\\\"}},{\\\"name\\\":\\\"豪装\\\",\\\"value\\\":10,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(230,165,55,1)\\\"}},{\\\"name\\\":\\\"毛坯\\\",\\\"value\\\":10,\\\"itemStyle\\\":{\\\"color\\\":\\\"\\\"}}],\\\"isRadius\\\":false,\\\"roseType\\\":\\\"\\\",\\\"notCount\\\":false,\\\"center\\\":[\\\"180\\\",\\\"100\\\"],\\\"name\\\":\\\"访问来源\\\",\\\"minAngle\\\":0,\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"outside\\\",\\\"textStyle\\\":{\\\"fontSize\\\":\\\"10\\\",\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"pie\\\",\\\"radius\\\":\\\"52%\\\",\\\"autoSort\\\":false}],\\\"tooltip\\\":{\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":true,\\\"top\\\":10,\\\"text\\\":\\\"不同装修类型销售销量\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#ffffff\\\",\\\"fontWeight\\\":\\\"normal\\\",\\\"fontSize\\\":\\\"14\\\"},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,10]},\\\"backgroundColor\\\":{\\\"src\\\":\\\"https://static.jeecg.com/designreport/images/bg1_1608535503498.png\\\"}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1331878107552010242\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"zhuangxiu\",\"chartType\":\"pie.simple\",\"isTiming\":true,\"intervalTime\":\"5\",\"id\":\"rQgkcYfLy4x0EP6h\"},\"layer_id\":\"rQgkcYfLy4x0EP6h\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[16,8],[16,9],[16,10],[16,11]]}],\"area\":{\"sri\":16,\"sci\":1,\"eri\":23,\"eci\":3,\"width\":340,\"height\":200},\"excel_config_id\":\"1331503965770223616\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"0\":{\"cells\":{\"0\":{\"text\":\"\"},\"1\":{\"style\":60,\"merge\":[0,13],\"text\":\"房屋销售综合展示大屏\"}},\"height\":113},\"1\":{\"cells\":{\"1\":{\"merge\":[14,2],\"style\":43,\"text\":\" \",\"virtual\":\"5ggWQtDUvSopC4iL\"},\"2\":{\"text\":\" \",\"virtual\":\"5ggWQtDUvSopC4iL\"},\"3\":{\"text\":\" \",\"virtual\":\"5ggWQtDUvSopC4iL\"},\"4\":{\"style\":53,\"text\":\"成交量：\",\"merge\":[2,0],\"virtual\":\"5ggWQtDUvSopC4iL\"},\"5\":{\"text\":\"#{qingkuang.cjl}\",\"style\":64,\"merge\":[2,0]},\"7\":{\"style\":53,\"text\":\"成交金额：\",\"merge\":[2,0]},\"8\":{\"text\":\"#{qingkuang.cjje}\",\"style\":68,\"merge\":[2,0]},\"10\":{\"style\":53,\"text\":\"销售面积：\",\"merge\":[2,0]},\"11\":{\"text\":\"#{qingkuang.xsmj}\",\"style\":64,\"merge\":[2,0]},\"12\":{\"text\":\" \",\"virtual\":\"nk6I2RCefm9scS1k\"},\"13\":{\"text\":\" \",\"virtual\":\"nk6I2RCefm9scS1k\"},\"14\":{\"text\":\" \",\"virtual\":\"nk6I2RCefm9scS1k\"},\"15\":{\"text\":\" \",\"virtual\":\"nk6I2RCefm9scS1k\"}},\"isDrag\":true},\"2\":{\"cells\":{\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"3\":{\"cells\":{\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"4\":{\"cells\":{\"4\":{\"style\":58,\"text\":\"成交均价：\",\"merge\":[2,0]},\"5\":{\"text\":\"#{qingkuang.cjjj}\",\"style\":65,\"merge\":[2,0]},\"7\":{\"style\":58,\"text\":\"售房佣金：\",\"merge\":[2,0]},\"8\":{\"text\":\"#{qingkuang.sfyj}\",\"style\":65,\"merge\":[2,0]},\"10\":{\"style\":58,\"text\":\"预定客户：\",\"merge\":[2,0]},\"11\":{\"text\":\"#{qingkuang.ydkh}\",\"style\":65,\"merge\":[2,0]},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}},\"isDrag\":true,\"height\":25},\"5\":{\"cells\":{\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"6\":{\"cells\":{\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"7\":{\"cells\":{\"4\":{\"text\":\" \",\"virtual\":\"Nf6Xud4fZqEfvQw4\"},\"5\":{\"text\":\" \",\"virtual\":\"Nf6Xud4fZqEfvQw4\"},\"6\":{\"text\":\" \",\"virtual\":\"Nf6Xud4fZqEfvQw4\"},\"7\":{\"text\":\" \",\"virtual\":\"Nf6Xud4fZqEfvQw4\"},\"8\":{\"text\":\" \",\"virtual\":\"Nf6Xud4fZqEfvQw4\"},\"9\":{\"text\":\" \",\"virtual\":\"Nf6Xud4fZqEfvQw4\"},\"10\":{\"text\":\" \",\"virtual\":\"Nf6Xud4fZqEfvQw4\"},\"11\":{\"text\":\" \",\"virtual\":\"Nf6Xud4fZqEfvQw4\"},\"12\":{\"text\":\" \",\"virtual\":\"MCJP8uqwe57YoCvF\"},\"13\":{\"text\":\" \",\"virtual\":\"MCJP8uqwe57YoCvF\"},\"14\":{\"text\":\" \",\"virtual\":\"MCJP8uqwe57YoCvF\"},\"15\":{\"text\":\" \",\"virtual\":\"MCJP8uqwe57YoCvF\"}}},\"8\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"9\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"10\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"11\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"12\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"13\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"14\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"15\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"16\":{\"cells\":{\"1\":{\"style\":43,\"text\":\" \",\"merge\":[7,2],\"virtual\":\"Cror94F1kmbP71ip\"},\"2\":{\"text\":\" \",\"virtual\":\"Cror94F1kmbP71ip\"},\"3\":{\"text\":\" \",\"virtual\":\"Cror94F1kmbP71ip\"},\"4\":{\"text\":\" \",\"virtual\":\"pBOwp0Q0g4iuJCVm\"},\"5\":{\"text\":\" \",\"virtual\":\"pBOwp0Q0g4iuJCVm\"},\"6\":{\"text\":\" \",\"virtual\":\"pBOwp0Q0g4iuJCVm\"},\"7\":{\"text\":\" \",\"virtual\":\"pBOwp0Q0g4iuJCVm\"},\"8\":{\"text\":\" \",\"virtual\":\"rQgkcYfLy4x0EP6h\"},\"9\":{\"text\":\" \",\"virtual\":\"rQgkcYfLy4x0EP6h\"},\"10\":{\"text\":\" \",\"virtual\":\"rQgkcYfLy4x0EP6h\"},\"11\":{\"text\":\" \",\"virtual\":\"rQgkcYfLy4x0EP6h\"},\"12\":{\"text\":\" \",\"virtual\":\"IWoBtyiRxjkEbkfD\"},\"13\":{\"text\":\" \",\"virtual\":\"IWoBtyiRxjkEbkfD\"},\"14\":{\"text\":\" \",\"virtual\":\"IWoBtyiRxjkEbkfD\"},\"15\":{\"text\":\" \",\"virtual\":\"IWoBtyiRxjkEbkfD\"}}},\"17\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"18\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"19\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"20\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"21\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"22\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"23\":{\"cells\":{\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"24\":{\"cells\":{\"1\":{\"text\":\" \"},\"2\":{\"text\":\" \"},\"3\":{\"text\":\" \"},\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"text\":\" \"},\"13\":{\"text\":\" \"},\"14\":{\"text\":\" \"}}},\"len\":98},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":1546,\"displayConfig\":{},\"background\":{\"path\":\"https://static.jeecg.com/designreport/images/bg_1606961893275.png\",\"repeat\":\"repeat\",\"width\":\"\",\"height\":\"\"},\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"font\":{\"bold\":true}},{\"font\":{\"bold\":true,\"name\":\"宋体\"}},{\"font\":{\"name\":\"宋体\"}},{\"font\":{\"bold\":true,\"name\":\"Microsoft YaHei\"}},{\"font\":{\"name\":\"Microsoft YaHei\"}},{\"font\":{\"bold\":true,\"name\":\"Microsoft YaHei\",\"size\":18}},{\"font\":{\"name\":\"Microsoft YaHei\",\"size\":18}},{\"font\":{\"bold\":true,\"name\":\"Microsoft YaHei\",\"size\":16}},{\"font\":{\"name\":\"Microsoft YaHei\",\"size\":16}},{\"font\":{\"bold\":true,\"name\":\"Microsoft YaHei\",\"size\":16},\"align\":\"center\"},{\"font\":{\"name\":\"Microsoft YaHei\",\"size\":16},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"right\"},{\"align\":\"right\"},{\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"right\",\"font\":{\"size\":14}},{\"align\":\"right\",\"font\":{\"size\":14}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"right\",\"font\":{\"size\":12}},{\"align\":\"right\",\"font\":{\"size\":12}},{\"align\":\"center\",\"font\":{\"size\":12}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"center\",\"font\":{\"size\":12}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"size\":12}},{\"font\":{\"size\":12}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"right\",\"font\":{\"size\":11}},{\"align\":\"right\",\"font\":{\"size\":11}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"center\",\"font\":{\"size\":11}},{\"align\":\"center\",\"font\":{\"size\":11}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"size\":11}},{\"font\":{\"size\":11}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"right\",\"font\":{\"size\":11,\"bold\":true}},{\"align\":\"right\",\"font\":{\"size\":11,\"bold\":true}},{\"font\":{\"bold\":true,\"name\":\"Microsoft YaHei\",\"size\":16},\"align\":\"center\",\"color\":\"#ffffff\"},{\"color\":\"#ffffff\"},{\"font\":{\"bold\":true,\"name\":\"Microsoft YaHei\",\"size\":22},\"align\":\"center\",\"color\":\"#ffffff\"},{\"color\":\"#ffffff\",\"font\":{\"size\":22}},{\"font\":{\"bold\":true,\"name\":\"Microsoft YaHei\",\"size\":22},\"align\":\"center\",\"color\":\"#000100\"},{\"color\":\"#000100\",\"font\":{\"size\":22}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"right\",\"font\":{\"size\":11,\"bold\":true},\"color\":\"#ffffff\"},{\"align\":\"right\",\"font\":{\"size\":11,\"bold\":true},\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"center\",\"font\":{\"size\":11},\"color\":\"#ffffff\"},{\"align\":\"center\",\"font\":{\"size\":11},\"color\":\"#ffffff\"},{\"font\":{\"size\":11},\"color\":\"#ffffff\"},{},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"right\",\"font\":{\"size\":11,\"bold\":false},\"color\":\"#ffffff\"},{\"align\":\"right\",\"font\":{\"size\":11,\"bold\":false},\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"right\",\"font\":{\"size\":11,\"bold\":true,\"name\":\"宋体\"},\"color\":\"#ffffff\"},{\"align\":\"right\",\"font\":{\"size\":11,\"bold\":true,\"name\":\"宋体\"},\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"right\",\"font\":{\"size\":11,\"bold\":false,\"name\":\"宋体\"},\"color\":\"#ffffff\"},{\"align\":\"right\",\"font\":{\"size\":11,\"bold\":false,\"name\":\"宋体\"},\"color\":\"#ffffff\"},{\"align\":\"center\",\"font\":{\"size\":11},\"color\":\"#ffffff\",\"border\":{\"right\":[\"thin\",\"#eee\"]}},{\"align\":\"right\",\"font\":{\"size\":16,\"bold\":false,\"name\":\"宋体\"},\"color\":\"#ffffff\"},{\"align\":\"right\",\"font\":{\"size\":15,\"bold\":false,\"name\":\"宋体\"},\"color\":\"#ffffff\"},{\"align\":\"right\",\"font\":{\"size\":14,\"bold\":false,\"name\":\"宋体\"},\"color\":\"#ffffff\"},{\"align\":\"center\",\"font\":{\"size\":14},\"color\":\"#ffffff\"},{\"font\":{\"size\":14},\"color\":\"#ffffff\"},{\"align\":\"left\",\"font\":{\"size\":14},\"color\":\"#ffffff\"},{\"align\":\"left\",\"font\":{\"size\":14,\"bold\":false,\"name\":\"宋体\"},\"color\":\"#ffffff\"},{\"align\":\"right\",\"font\":{\"size\":14,\"bold\":false,\"name\":\"宋体\"},\"color\":\"#ffffff\",\"valign\":\"top\"},{\"align\":\"left\",\"font\":{\"size\":14},\"color\":\"#ffffff\",\"valign\":\"top\"},{\"font\":{\"bold\":true,\"name\":\"宋体\",\"size\":22},\"align\":\"center\",\"color\":\"#ffffff\"},{\"color\":\"#ffffff\",\"font\":{\"size\":22,\"name\":\"宋体\"}},{\"align\":\"left\",\"font\":{\"size\":14,\"name\":\"宋体\"},\"color\":\"#ffffff\",\"valign\":\"top\"},{\"align\":\"left\",\"font\":{\"size\":14,\"name\":\"宋体\"},\"color\":\"#ffffff\"},{\"align\":\"left\",\"font\":{\"size\":14,\"name\":\"宋体\"},\"color\":\"#ffff01\"},{\"align\":\"left\",\"font\":{\"size\":14,\"name\":\"宋体\"},\"color\":\"#ffff01\",\"valign\":\"top\"},{\"align\":\"left\",\"font\":{\"size\":14,\"name\":\"宋体\"},\"color\":\"#ffffff\",\"bgcolor\":\"#ffff01\"},{\"align\":\"left\",\"font\":{\"size\":14,\"name\":\"宋体\"},\"color\":\"#ffffff\",\"bgcolor\":\"\"},{\"align\":\"left\",\"font\":{\"size\":14,\"name\":\"宋体\"},\"color\":\"#ffff01\",\"bgcolor\":\"\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":117},\"3\":{\"width\":140},\"4\":{\"width\":136},\"5\":{\"width\":79},\"6\":{\"width\":1},\"7\":{\"width\":123},\"8\":{\"width\":102},\"9\":{\"width\":24},\"11\":{\"width\":100},\"14\":{\"width\":124},\"len\":50},\"merges\":[\"B2:D16\",\"E8:L16\",\"B17:D24\",\"E17:H24\",\"E2:E4\",\"F2:F4\",\"E5:E7\",\"F5:F7\",\"H2:H4\",\"H5:H7\",\"I5:I7\",\"I2:I4\",\"K2:K4\",\"L2:L4\",\"K5:K7\",\"L5:L7\",\"M17:O24\",\"B1:O1\"]}', NULL, 'https://static.jeecg.com/designreport/images/QQ截图20201125161646_1606705892603.png', 'admin', '2020-11-25 15:50:43', 'admin', '2021-04-01 03:37:15', 0, NULL, NULL, 1, 707, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1334378897302753280', '20201203140834', '区域销售表', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"area\":false,\"printElWidth\":718,\"excel_config_id\":\"1334378897302753280\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{\"1\":{\"text\":\"区域销售表\",\"merge\":[0,22],\"style\":10},\"2\":{\"style\":10},\"3\":{\"style\":10},\"4\":{\"style\":10},\"5\":{\"style\":10},\"6\":{\"style\":10},\"7\":{\"style\":10},\"8\":{\"style\":10},\"9\":{\"style\":10},\"10\":{\"style\":10},\"11\":{\"style\":10},\"12\":{\"style\":10},\"13\":{\"style\":10},\"14\":{\"style\":10},\"15\":{\"style\":10},\"16\":{\"style\":10},\"17\":{\"style\":10},\"18\":{\"style\":10},\"19\":{\"style\":10},\"20\":{\"style\":10},\"21\":{\"style\":10},\"22\":{\"style\":10},\"23\":{\"style\":10}},\"height\":72},\"1\":{\"cells\":{\"0\":{\"style\":64},\"1\":{\"text\":\"区域\",\"merge\":[1,0],\"style\":65},\"2\":{\"text\":\"省份\",\"merge\":[1,0],\"style\":65},\"3\":{\"text\":\"1月\",\"merge\":[0,2],\"style\":65},\"4\":{\"style\":66,\"text\":\" \"},\"5\":{\"style\":66,\"text\":\" \"},\"6\":{\"text\":\"2月\",\"merge\":[0,2],\"style\":65},\"7\":{\"style\":66,\"text\":\" \"},\"8\":{\"style\":66,\"text\":\" \"},\"9\":{\"text\":\"3月\",\"merge\":[0,2],\"style\":65},\"10\":{\"style\":66,\"text\":\" \"},\"11\":{\"style\":66,\"text\":\" \"},\"12\":{\"text\":\"4月\",\"merge\":[0,2],\"style\":65},\"13\":{\"style\":66,\"text\":\" \"},\"14\":{\"style\":66,\"text\":\" \"},\"15\":{\"text\":\"5月\",\"merge\":[0,2],\"style\":65},\"16\":{\"style\":66,\"text\":\" \"},\"17\":{\"style\":66,\"text\":\" \"},\"18\":{\"text\":\"6月\",\"merge\":[0,2],\"style\":65},\"19\":{\"style\":66,\"text\":\" \"},\"20\":{\"style\":66,\"text\":\" \"},\"21\":{\"text\":\"总合计\",\"merge\":[0,2],\"style\":65},\"22\":{\"style\":66,\"text\":\" \"},\"23\":{\"style\":66,\"text\":\" \"},\"24\":{\"style\":64},\"25\":{\"style\":64}},\"height\":22},\"2\":{\"cells\":{\"0\":{\"style\":64},\"1\":{\"style\":66,\"text\":\" \"},\"2\":{\"style\":65,\"text\":\" \"},\"3\":{\"text\":\"销售额\",\"style\":65},\"4\":{\"text\":\"搭赠\",\"style\":65},\"5\":{\"text\":\"比例\",\"style\":65},\"6\":{\"text\":\"销售额\",\"style\":65},\"7\":{\"text\":\"搭赠\",\"style\":65},\"8\":{\"text\":\"比例\",\"style\":65},\"9\":{\"text\":\"销售额\",\"style\":65},\"10\":{\"text\":\"搭赠\",\"style\":65},\"11\":{\"text\":\"比例\",\"style\":65},\"12\":{\"text\":\"销售额\",\"style\":65},\"13\":{\"text\":\"搭赠\",\"style\":65},\"14\":{\"text\":\"比例\",\"style\":65},\"15\":{\"text\":\"销售额\",\"style\":65},\"16\":{\"text\":\"搭赠\",\"style\":65},\"17\":{\"text\":\"比例\",\"style\":65},\"18\":{\"text\":\"销售额\",\"style\":65},\"19\":{\"text\":\"搭赠\",\"style\":65},\"20\":{\"text\":\"比例\",\"style\":65},\"21\":{\"text\":\"销售额\",\"style\":65},\"22\":{\"text\":\"搭赠\",\"style\":65},\"23\":{\"text\":\"比例\",\"style\":65},\"24\":{\"style\":64},\"25\":{\"style\":64}},\"height\":24},\"3\":{\"cells\":{\"0\":{\"style\":67},\"1\":{\"text\":\"#{quyuxiaoshou.group(region)}\",\"style\":52,\"aggregate\":\"group\"},\"2\":{\"text\":\"#{quyuxiaoshou.province}\",\"style\":53},\"3\":{\"text\":\"#{quyuxiaoshou.sales_1}\",\"style\":17},\"4\":{\"text\":\"#{quyuxiaoshou.gift_1}\",\"style\":17},\"5\":{\"text\":\"#{quyuxiaoshou.proportion_1}\",\"style\":17},\"6\":{\"text\":\"#{quyuxiaoshou.sales_2}\",\"style\":17},\"7\":{\"text\":\"#{quyuxiaoshou.gift_2}\",\"style\":17},\"8\":{\"text\":\"#{quyuxiaoshou.proportion_2}\",\"style\":17},\"9\":{\"text\":\"#{quyuxiaoshou.sales_3}\",\"style\":17},\"10\":{\"text\":\"#{quyuxiaoshou.gift_3}\",\"style\":17},\"11\":{\"text\":\"#{quyuxiaoshou.proportion_3}\",\"style\":17},\"12\":{\"text\":\"#{quyuxiaoshou.sales_4}\",\"style\":17},\"13\":{\"text\":\"#{quyuxiaoshou.gift_4}\",\"style\":17},\"14\":{\"text\":\"#{quyuxiaoshou.proportion_4}\",\"style\":17},\"15\":{\"text\":\"#{quyuxiaoshou.sales_5}\",\"style\":17},\"16\":{\"text\":\"#{quyuxiaoshou.gift_5}\",\"style\":17},\"17\":{\"text\":\"#{quyuxiaoshou.proportion_5}\",\"style\":15},\"18\":{\"text\":\"#{quyuxiaoshou.sales_6}\",\"style\":15},\"19\":{\"text\":\"#{quyuxiaoshou.gift_6}\",\"style\":15},\"20\":{\"text\":\"#{quyuxiaoshou.proportion_6}\",\"style\":15},\"21\":{\"text\":\"#{quyuxiaoshou.sales_z}\",\"style\":15},\"22\":{\"text\":\"#{quyuxiaoshou.gift_z}\",\"style\":15},\"23\":{\"text\":\"#{quyuxiaoshou.proportion_z}\",\"style\":15},\"24\":{\"style\":67},\"25\":{\"style\":67}},\"isDrag\":true,\"height\":56},\"4\":{\"cells\":{\"0\":{\"style\":64},\"1\":{\"style\":39,\"text\":\"总计\",\"merge\":[0,1]},\"3\":{\"style\":68,\"text\":\"=SUM(D4)\"},\"4\":{\"style\":69,\"text\":\"=SUM(E4)\"},\"5\":{\"style\":70,\"text\":\"=SUM(F4)\"},\"6\":{\"style\":69,\"text\":\"=SUM(G4)\"},\"7\":{\"style\":69,\"text\":\"=SUM(H4)\"},\"8\":{\"style\":70,\"text\":\"=SUM(I4)\"},\"9\":{\"style\":69,\"text\":\"=SUM(J4)\"},\"10\":{\"style\":69,\"text\":\"=SUM(K4)\"},\"11\":{\"style\":70,\"text\":\"=SUM(L4)\"},\"12\":{\"style\":69,\"text\":\"=SUM(M4)\"},\"13\":{\"style\":69,\"text\":\"=SUM(N4)\"},\"14\":{\"style\":70,\"text\":\"=SUM(O4)\"},\"15\":{\"style\":69,\"text\":\"=SUM(P4)\"},\"16\":{\"style\":69,\"text\":\"=SUM(Q4)\"},\"17\":{\"style\":70,\"text\":\"=SUM(R4)\"},\"18\":{\"style\":69,\"text\":\"=SUM(S4)\"},\"19\":{\"style\":69,\"text\":\"=SUM(T4)\"},\"20\":{\"style\":70,\"text\":\"=SUM(U4)\"},\"21\":{\"style\":69,\"text\":\"=SUM(V4)\"},\"22\":{\"style\":69,\"text\":\"=SUM(W4)\"},\"23\":{\"style\":69,\"text\":\"=SUM(X4)\"},\"24\":{\"style\":64},\"25\":{\"style\":64}},\"height\":38},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"groupField\":\"quyuxiaoshou.region\",\"freeze\":\"A1\",\"dataRectWidth\":1554,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"bgcolor\":\"\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\"},{\"bgcolor\":\"#02a274\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"bfbfbf\"],\"top\":[\"thin\",\"bfbfbf\"],\"left\":[\"thin\",\"bfbfbf\"],\"right\":[\"thin\",\"bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"bfbfbf\"],\"top\":[\"thin\",\"bfbfbf\"],\"left\":[\"thin\",\"bfbfbf\"],\"right\":[\"thin\",\"bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"font\":{\"size\":16}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"隶书\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#7f7f7f\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":true}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"font\":{\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#ddefe8\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":true,\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"font\":{\"bold\":true,\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"华文中宋\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Arial\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#aedac8\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"bgcolor\":\"#aedac8\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#aedac8\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"bgcolor\":\"#aedac8\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"bgcolor\":\"#aedac8\",\"align\":\"center\",\"format\":\"number\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"bgcolor\":\"#aedac8\",\"align\":\"center\",\"format\":\"normal\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#aedac8\",\"align\":\"center\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"font\":{\"bold\":false,\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#aedac8\"},{\"font\":{\"size\":10}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10},\"bgcolor\":\"#aedac8\",\"align\":\"center\",\"format\":\"normal\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10},\"bgcolor\":\"#aedac8\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#aedac8\",\"font\":{\"size\":10}},{\"font\":{\"size\":10},\"bgcolor\":\"#aedac8\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":10}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"font\":{\"bold\":false,\"size\":10}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#ddefe8\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#ddefe8\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":10,\"name\":\"宋体\"}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"font\":{\"bold\":false,\"size\":10,\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#ddefe8\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"宋体\"},\"align\":\"center\",\"color\":\"#262626\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#aedac8\"},{\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"宋体\"},\"bgcolor\":\"#aedac8\",\"align\":\"center\",\"format\":\"normal\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"宋体\"},\"bgcolor\":\"#aedac8\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#aedac8\",\"font\":{\"size\":10,\"name\":\"宋体\"}},{\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":10,\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"font\":{\"bold\":false,\"size\":10,\"name\":\"Microsoft YaHei\"}},{\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"},\"bgcolor\":\"#aedac8\",\"align\":\"center\",\"format\":\"normal\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"},\"bgcolor\":\"#aedac8\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#aedac8\",\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"}}],\"validations\":[],\"isGroup\":true,\"cols\":{\"0\":{\"width\":20},\"1\":{\"width\":84},\"2\":{\"width\":81},\"3\":{\"width\":75},\"4\":{\"width\":63},\"5\":{\"width\":59},\"6\":{\"width\":70},\"7\":{\"width\":57},\"8\":{\"width\":60},\"9\":{\"width\":75},\"10\":{\"width\":66},\"11\":{\"width\":64},\"12\":{\"width\":70},\"13\":{\"width\":61},\"14\":{\"width\":61},\"15\":{\"width\":70},\"16\":{\"width\":58},\"17\":{\"width\":63},\"18\":{\"width\":60},\"19\":{\"width\":63},\"20\":{\"width\":59},\"21\":{\"width\":73},\"22\":{\"width\":69},\"23\":{\"width\":73},\"len\":50},\"merges\":[\"B2:B3\",\"C2:C3\",\"D2:F2\",\"G2:I2\",\"J2:L2\",\"M2:O2\",\"P2:R2\",\"S2:U2\",\"V2:X2\",\"B1:X1\",\"B5:C5\"]}', NULL, 'https://static.jeecg.com/designreport/images/quyu_1607069899537.png', 'admin', '2020-12-03 14:08:34', 'admin', '2021-02-03 13:59:12', 0, NULL, NULL, 1, 441, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1334420681185566722', '202012031408346166', '学校经费一览表', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"area\":{\"sri\":7,\"sci\":1,\"eri\":7,\"eci\":2,\"width\":216,\"height\":25},\"printElWidth\":718,\"excel_config_id\":\"1334420681185566722\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{\"1\":{\"text\":\"学校经费一览表\",\"merge\":[0,22],\"style\":10},\"2\":{\"style\":10},\"3\":{\"style\":10},\"4\":{\"style\":10},\"5\":{\"style\":10},\"6\":{\"style\":10},\"7\":{\"style\":10},\"8\":{\"style\":10},\"9\":{\"style\":10},\"10\":{\"style\":10},\"11\":{\"style\":10},\"12\":{\"style\":10},\"13\":{\"style\":10},\"14\":{\"style\":10},\"15\":{\"style\":10},\"16\":{\"style\":10},\"17\":{\"style\":10},\"18\":{\"style\":10},\"19\":{\"style\":10},\"20\":{\"style\":10},\"21\":{\"style\":10},\"22\":{\"style\":10},\"23\":{\"style\":10}},\"height\":72},\"1\":{\"cells\":{\"1\":{\"text\":\"学校类别\",\"style\":221,\"merge\":[4,0]},\"2\":{\"merge\":[4,0],\"style\":222,\"text\":\"学校名称\"},\"3\":{\"text\":\"财政教育经费投入（万元）\",\"merge\":[0,8],\"style\":84},\"4\":{\"style\":40,\"text\":\" \"},\"5\":{\"style\":40,\"text\":\" \"},\"6\":{\"style\":40,\"text\":\" \"},\"7\":{\"style\":40,\"text\":\" \"},\"8\":{\"style\":40,\"text\":\" \"},\"9\":{\"style\":40,\"text\":\" \"},\"10\":{\"style\":40,\"text\":\" \"},\"11\":{\"style\":40,\"text\":\" \"},\"12\":{\"text\":\"其他投入\",\"merge\":[0,7],\"style\":84},\"13\":{\"text\":\" \",\"style\":40},\"14\":{\"text\":\" \",\"style\":40},\"15\":{\"text\":\" \",\"style\":40},\"16\":{\"text\":\" \",\"style\":40},\"17\":{\"text\":\" \",\"style\":40},\"18\":{\"text\":\" \",\"style\":40},\"19\":{\"text\":\" \",\"style\":40},\"20\":{\"style\":84,\"text\":\"补充资料\",\"merge\":[0,4]},\"21\":{\"text\":\" \",\"style\":40},\"22\":{\"text\":\" \",\"style\":40},\"23\":{\"text\":\" \",\"style\":40},\"24\":{\"text\":\" \",\"style\":40}},\"height\":28},\"2\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":40},\"2\":{\"style\":222,\"text\":\" \"},\"3\":{\"text\":\"总计\",\"style\":117,\"merge\":[3,0]},\"4\":{\"text\":\"教育事业费\",\"style\":117,\"merge\":[0,6]},\"5\":{\"style\":118,\"text\":\" \"},\"6\":{\"style\":118,\"text\":\" \"},\"7\":{\"style\":118,\"text\":\" \"},\"8\":{\"style\":118,\"text\":\" \"},\"9\":{\"style\":118,\"text\":\" \"},\"10\":{\"style\":118,\"text\":\" \"},\"11\":{\"text\":\"基础拨款\",\"style\":117,\"merge\":[3,0]},\"12\":{\"text\":\"村投入\",\"style\":117,\"merge\":[0,4]},\"13\":{\"text\":\" \",\"style\":223},\"14\":{\"text\":\" \",\"style\":223},\"15\":{\"text\":\" \",\"style\":223},\"16\":{\"text\":\" \",\"style\":223},\"17\":{\"text\":\"社会捐款\",\"style\":117,\"merge\":[0,2]},\"18\":{\"text\":\" \",\"style\":223},\"19\":{\"text\":\" \",\"style\":223},\"20\":{\"style\":126,\"merge\":[0,4],\"text\":\"信息化建设\"},\"21\":{\"style\":122,\"text\":\" \"},\"22\":{\"style\":122,\"text\":\" \"},\"23\":{\"style\":122,\"text\":\" \"},\"24\":{\"style\":122,\"text\":\" \"}},\"height\":24},\"3\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":40},\"2\":{\"style\":222,\"text\":\" \"},\"3\":{\"style\":118,\"text\":\" \"},\"4\":{\"merge\":[0,1],\"text\":\"合计\",\"style\":121},\"5\":{\"style\":122,\"text\":\" \"},\"6\":{\"merge\":[2,0],\"text\":\"人员经费\",\"style\":121},\"7\":{\"merge\":[2,0],\"text\":\"日常公用费用\",\"style\":123},\"8\":{\"merge\":[0,2],\"text\":\"项目经费\",\"style\":121},\"9\":{\"style\":122,\"text\":\" \"},\"10\":{\"style\":122,\"text\":\" \"},\"11\":{\"style\":118,\"text\":\" \"},\"12\":{\"merge\":[2,0],\"text\":\"合计\",\"style\":121},\"13\":{\"merge\":[0,3],\"text\":\"其中\",\"style\":121},\"14\":{\"text\":\" \",\"style\":223},\"15\":{\"text\":\" \",\"style\":223},\"16\":{\"text\":\" \",\"style\":223},\"17\":{\"merge\":[2,0],\"text\":\"合计\",\"style\":121},\"18\":{\"merge\":[0,1],\"text\":\"其中\",\"style\":121},\"19\":{\"style\":122,\"text\":\" \"},\"20\":{\"merge\":[2,0],\"text\":\"本年投入金额（万元）\",\"style\":230},\"21\":{\"merge\":[0,1],\"text\":\"电脑数（台数）\",\"style\":121},\"22\":{\"style\":122,\"text\":\" \"},\"23\":{\"merge\":[0,1],\"text\":\"校园网数（个）\",\"style\":121},\"24\":{\"style\":122,\"text\":\" \"}}},\"4\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":40},\"2\":{\"style\":222,\"text\":\" \"},\"3\":{\"style\":118,\"text\":\" \"},\"4\":{\"merge\":[1,0],\"text\":\"金额\",\"style\":126},\"5\":{\"merge\":[1,0],\"text\":\"比上年增长（%）\",\"style\":127},\"6\":{\"style\":122,\"text\":\" \"},\"7\":{\"style\":123,\"text\":\" \"},\"8\":{\"merge\":[1,0],\"text\":\"合计\",\"style\":121},\"9\":{\"merge\":[0,1],\"text\":\"其中\",\"style\":121},\"10\":{\"style\":122,\"text\":\" \"},\"11\":{\"style\":118,\"text\":\" \"},\"12\":{\"style\":121,\"text\":\" \"},\"13\":{\"merge\":[1,0],\"text\":\"人员经费\",\"style\":131},\"14\":{\"merge\":[1,0],\"text\":\"日常公用费用\",\"style\":131},\"15\":{\"merge\":[1,0],\"text\":\"项目经费\",\"style\":131},\"16\":{\"merge\":[1,0],\"text\":\"基建投入\",\"style\":131},\"17\":{\"style\":121,\"text\":\" \"},\"18\":{\"merge\":[1,0],\"text\":\"项目经费\",\"style\":131},\"19\":{\"merge\":[1,0],\"text\":\"基础投入\",\"style\":131},\"20\":{\"style\":231,\"text\":\" \"},\"21\":{\"merge\":[1,0],\"text\":\"合计\",\"style\":121},\"22\":{\"merge\":[1,0],\"text\":\"本年购置数\",\"style\":121},\"23\":{\"style\":121,\"merge\":[1,0],\"text\":\"合计\"},\"24\":{\"merge\":[1,0],\"text\":\"本年建成数\",\"style\":121}}},\"5\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":40},\"2\":{\"style\":222,\"text\":\" \"},\"3\":{\"style\":118,\"text\":\" \"},\"4\":{\"style\":126,\"text\":\" \"},\"5\":{\"style\":129,\"text\":\" \"},\"6\":{\"style\":121,\"text\":\" \"},\"7\":{\"style\":130,\"text\":\" \"},\"8\":{\"style\":121,\"text\":\" \"},\"9\":{\"text\":\"标准化建设\",\"style\":131},\"10\":{\"text\":\"信息化建设\",\"style\":121},\"11\":{\"style\":118,\"text\":\" \"},\"12\":{\"style\":121,\"text\":\" \"},\"13\":{\"text\":\" \",\"style\":223},\"14\":{\"style\":131,\"text\":\" \"},\"15\":{\"text\":\" \",\"style\":223},\"16\":{\"style\":131,\"text\":\" \"},\"17\":{\"style\":121,\"text\":\" \"},\"18\":{\"text\":\" \",\"style\":223},\"19\":{\"style\":131,\"text\":\" \"},\"20\":{\"style\":231,\"text\":\" \"},\"21\":{\"style\":121,\"text\":\" \"},\"22\":{\"style\":122,\"text\":\" \"},\"23\":{\"style\":131,\"text\":\" \"},\"24\":{\"style\":122,\"text\":\" \"}}},\"6\":{\"cells\":{\"0\":{\"style\":236},\"1\":{\"text\":\"#{laiyuan.group(class)}\",\"style\":233,\"aggregate\":\"group\"},\"2\":{\"text\":\"#{laiyuan.school}\",\"style\":234},\"3\":{\"style\":15,\"text\":\"=SUM(E7,I7)\"},\"4\":{\"style\":15,\"text\":\"=SUM(G7,H7)\"},\"5\":{\"text\":\"#{laiyuan.lv}\",\"style\":12},\"6\":{\"text\":\"#{laiyuan.renyuan_jy}\",\"style\":12},\"7\":{\"text\":\"#{laiyuan.richang_jy}\",\"style\":12},\"8\":{\"style\":12,\"text\":\"=SUM(J7,K7)\"},\"9\":{\"text\":\"#{laiyuan.biaozhun_jy}\",\"style\":12},\"10\":{\"text\":\"#{laiyuan.xinxi_jy}\",\"style\":12},\"11\":{\"text\":\"#{laiyuan.jichubokuan_jy}\",\"style\":12},\"12\":{\"style\":12,\"text\":\"=SUM(N7,O7)\"},\"13\":{\"text\":\"#{laiyuan.renyuan_ct}\",\"style\":12},\"14\":{\"text\":\"#{laiyuan.richang_ct}\",\"style\":12},\"15\":{\"text\":\"#{laiyuan.xiangmu_ct}\",\"style\":12},\"16\":{\"text\":\"#{laiyuan.jichubokuan_ct}\",\"style\":12},\"17\":{\"style\":12,\"text\":\"=SUM(S7,T7)\"},\"18\":{\"text\":\"#{laiyuan.xiangmu_sh}\",\"style\":12},\"19\":{\"text\":\"#{laiyuan.jichubokuan_sh}\",\"style\":12},\"20\":{\"style\":12,\"text\":\"=SUM(V7,X7)\"},\"21\":{\"style\":12,\"text\":\"#{laiyuan.diannao}\"},\"22\":{\"text\":\"#{laiyuan.diannao}\",\"style\":12},\"23\":{\"style\":12,\"text\":\"#{laiyuan.xiaoyuanwang}\"},\"24\":{\"text\":\"#{laiyuan.xiaoyuanwang}\",\"style\":12},\"25\":{\"style\":236}},\"isDrag\":true},\"7\":{\"cells\":{\"1\":{\"text\":\"总计\",\"style\":226,\"rendered\":\"\",\"merge\":[0,1]},\"3\":{\"style\":228,\"text\":\"=SUM(D7)\"},\"4\":{\"style\":228,\"text\":\"=SUM(E7)\"},\"5\":{\"style\":228,\"text\":\"\"},\"6\":{\"style\":228,\"text\":\"=SUM(G7)\"},\"7\":{\"style\":228,\"text\":\"=SUM(H7)\"},\"8\":{\"style\":228,\"text\":\"=SUM(I7)\"},\"9\":{\"style\":228,\"text\":\"=SUM(J7)\"},\"10\":{\"style\":228,\"text\":\"=SUM(K7)\"},\"11\":{\"style\":228,\"text\":\"=SUM(L7)\"},\"12\":{\"style\":228,\"text\":\"=SUM(M7)\"},\"13\":{\"style\":229,\"text\":\"=SUM(N7)\"},\"14\":{\"style\":229,\"text\":\"=SUM(O7)\"},\"15\":{\"style\":229,\"text\":\"=SUM(P7)\"},\"16\":{\"style\":229,\"text\":\"=SUM(Q7)\"},\"17\":{\"style\":229,\"text\":\"=SUM(R7)\"},\"18\":{\"style\":229,\"text\":\"=SUM(S7)\"},\"19\":{\"style\":229,\"text\":\"=SUM(T7)\"},\"20\":{\"style\":229,\"text\":\"=SUM(U7)\"},\"21\":{\"style\":229,\"text\":\"=SUM(V8)\"},\"22\":{\"style\":229,\"text\":\"=SUM(W7)\"},\"23\":{\"style\":232,\"text\":\"=SUM(X7)\"},\"24\":{\"style\":229,\"text\":\"=SUM(Y7)\"}}},\"9\":{\"cells\":{\"4\":{\"lineStart\":\"leftbottom\",\"text\":\"\"}}},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"groupField\":\"laiyuan.class\",\"freeze\":\"A1\",\"dataRectWidth\":1738,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"bgcolor\":\"\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\"},{\"bgcolor\":\"#02a274\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"bfbfbf\"],\"top\":[\"thin\",\"bfbfbf\"],\"left\":[\"thin\",\"bfbfbf\"],\"right\":[\"thin\",\"bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"bfbfbf\"],\"top\":[\"thin\",\"bfbfbf\"],\"left\":[\"thin\",\"bfbfbf\"],\"right\":[\"thin\",\"bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"font\":{\"size\":16}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"隶书\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#7f7f7f\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":true}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"font\":{\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#ddefe8\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":true,\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"font\":{\"bold\":true,\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"华文中宋\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Arial\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#aedac8\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"bgcolor\":\"#aedac8\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#aedac8\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"bgcolor\":\"#aedac8\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"bgcolor\":\"#aedac8\",\"align\":\"center\",\"format\":\"number\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"bgcolor\":\"#aedac8\",\"align\":\"center\",\"format\":\"normal\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#aedac8\",\"align\":\"center\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"font\":{\"bold\":false,\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"color\":\"#262626\",\"bgcolor\":\"#aedac8\"},{\"font\":{\"size\":10}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10},\"bgcolor\":\"#aedac8\",\"align\":\"center\",\"format\":\"normal\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10},\"bgcolor\":\"#aedac8\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#aedac8\",\"font\":{\"size\":10}},{\"font\":{\"size\":10},\"bgcolor\":\"#aedac8\"},{\"bgcolor\":\"#02a274\",\"font\":{\"size\":9}},{\"bgcolor\":\"#02a274\",\"font\":{\"size\":9},\"align\":\"center\"},{\"bgcolor\":\"#02a274\",\"font\":{\"size\":9},\"align\":\"center\",\"color\":\"#ffffff\"},{\"textwrap\":true},{\"textwrap\":true,\"font\":{\"size\":9}},{\"textwrap\":true,\"font\":{\"size\":9},\"bgcolor\":\"#02a274\"},{\"textwrap\":true,\"font\":{\"size\":9},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":9}},{\"color\":\"#000100\"},{\"bgcolor\":\"#02a274\",\"font\":{\"size\":9},\"align\":\"center\",\"color\":\"#000100\"},{\"textwrap\":true,\"font\":{\"size\":9},\"bgcolor\":\"#02a274\",\"color\":\"#000100\"},{\"bgcolor\":\"\",\"font\":{\"size\":9},\"align\":\"center\",\"color\":\"#000100\"},{\"textwrap\":true,\"font\":{\"size\":9},\"bgcolor\":\"\",\"color\":\"#000100\"},{\"align\":\"center\",\"bgcolor\":\"\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":9}},{\"color\":\"#000100\",\"bgcolor\":\"\"},{\"textwrap\":true,\"font\":{\"size\":9},\"bgcolor\":\"\",\"color\":\"#000100\",\"align\":\"center\"},{\"font\":{\"size\":9}},{\"font\":{\"size\":9},\"align\":\"center\"},{\"textwrap\":true,\"align\":\"center\"},{\"font\":{\"size\":9},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#595959\"],\"top\":[\"thin\",\"#595959\"],\"left\":[\"thin\",\"#595959\"],\"right\":[\"thin\",\"#595959\"]}},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#595959\"],\"top\":[\"thin\",\"#595959\"],\"left\":[\"thin\",\"#595959\"],\"right\":[\"thin\",\"#595959\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#595959\"],\"top\":[\"thin\",\"#595959\"],\"left\":[\"thin\",\"#595959\"],\"right\":[\"thin\",\"#595959\"]}},{\"bgcolor\":\"\",\"font\":{\"size\":9},\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#595959\"],\"top\":[\"thin\",\"#595959\"],\"left\":[\"thin\",\"#595959\"],\"right\":[\"thin\",\"#595959\"]}},{\"textwrap\":true,\"font\":{\"size\":9},\"bgcolor\":\"\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#595959\"],\"top\":[\"thin\",\"#595959\"],\"left\":[\"thin\",\"#595959\"],\"right\":[\"thin\",\"#595959\"]}},{\"font\":{\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#595959\"],\"top\":[\"thin\",\"#595959\"],\"left\":[\"thin\",\"#595959\"],\"right\":[\"thin\",\"#595959\"]}},{\"font\":{\"size\":9},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"bgcolor\":\"\",\"font\":{\"size\":9},\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"textwrap\":true,\"font\":{\"size\":9},\"bgcolor\":\"\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"font\":{\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"font\":{\"size\":9},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#756f6f\"],\"top\":[\"thin\",\"#756f6f\"],\"left\":[\"thin\",\"#756f6f\"],\"right\":[\"thin\",\"#756f6f\"]}},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#756f6f\"],\"top\":[\"thin\",\"#756f6f\"],\"left\":[\"thin\",\"#756f6f\"],\"right\":[\"thin\",\"#756f6f\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#756f6f\"],\"top\":[\"thin\",\"#756f6f\"],\"left\":[\"thin\",\"#756f6f\"],\"right\":[\"thin\",\"#756f6f\"]}},{\"bgcolor\":\"\",\"font\":{\"size\":9},\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#756f6f\"],\"top\":[\"thin\",\"#756f6f\"],\"left\":[\"thin\",\"#756f6f\"],\"right\":[\"thin\",\"#756f6f\"]}},{\"textwrap\":true,\"font\":{\"size\":9},\"bgcolor\":\"\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#756f6f\"],\"top\":[\"thin\",\"#756f6f\"],\"left\":[\"thin\",\"#756f6f\"],\"right\":[\"thin\",\"#756f6f\"]}},{\"font\":{\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#756f6f\"],\"top\":[\"thin\",\"#756f6f\"],\"left\":[\"thin\",\"#756f6f\"],\"right\":[\"thin\",\"#756f6f\"]}},{\"align\":\"center\",\"bgcolor\":\"\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":9}},{\"bgcolor\":\"\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":10}},{\"align\":\"center\",\"bgcolor\":\"\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":10}},{\"color\":\"#000100\",\"font\":{\"size\":10}},{\"color\":\"#000100\",\"bgcolor\":\"\",\"font\":{\"size\":10}},{\"font\":{\"size\":10},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"font\":{\"size\":10},\"align\":\"center\"},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"font\":{\"size\":10}},{\"bgcolor\":\"\",\"font\":{\"size\":10},\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"textwrap\":true,\"font\":{\"size\":10},\"bgcolor\":\"\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"bgcolor\":\"\",\"font\":{\"size\":10},\"align\":\"center\",\"color\":\"#000100\"},{\"font\":{\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"color\":\"#000100\",\"bgcolor\":\"\",\"align\":\"center\"},{\"font\":{\"size\":10},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"bgcolor\":\"\",\"font\":{\"size\":10},\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"textwrap\":true,\"font\":{\"size\":10},\"bgcolor\":\"\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"color\":\"#000100\",\"bgcolor\":\"\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":10}},{\"color\":\"#000100\",\"font\":{\"size\":10},\"bgcolor\":\"#\"},{\"align\":\"center\",\"bgcolor\":\"#\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":9}},{\"bgcolor\":\"#\"},{\"font\":{\"size\":10},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#\"},{\"font\":{\"size\":10},\"align\":\"center\",\"bgcolor\":\"#\"},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10},\"bgcolor\":\"#\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#\"},{\"align\":\"center\",\"bgcolor\":\"#\"},{\"bgcolor\":\"#\",\"font\":{\"size\":10},\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"textwrap\":true,\"font\":{\"size\":10},\"bgcolor\":\"#\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"textwrap\":true,\"font\":{\"size\":10},\"bgcolor\":\"#\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"font\":{\"size\":10},\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10},\"bgcolor\":\"#\"},{\"align\":\"center\",\"bgcolor\":\"#ddefe8\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":10}},{\"color\":\"#000100\",\"font\":{\"size\":10},\"bgcolor\":\"#ddefe8\"},{\"align\":\"center\",\"bgcolor\":\"#ddefe8\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"bold\":false,\"size\":9}},{\"bgcolor\":\"#ddefe8\"},{\"font\":{\"size\":10},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\"},{\"font\":{\"size\":10},\"align\":\"center\",\"bgcolor\":\"#ddefe8\"},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10},\"bgcolor\":\"#ddefe8\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\"},{\"align\":\"center\",\"bgcolor\":\"#ddefe8\"},{\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":10},\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"textwrap\":true,\"font\":{\"size\":10},\"bgcolor\":\"#ddefe8\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\"},{\"textwrap\":true,\"font\":{\"size\":10},\"bgcolor\":\"#ddefe8\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"font\":{\"size\":10},\"bgcolor\":\"#ddefe8\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10},\"bgcolor\":\"#ddefe8\"},{\"color\":\"#000100\",\"bgcolor\":\"#fffff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#fffff\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#fffff\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#fffff\"},{\"textwrap\":true,\"bgcolor\":\"#fffff\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#fffff\"},{\"color\":\"#000100\",\"bgcolor\":\"#ffff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#ffff\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ffff\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ffff\"},{\"textwrap\":true,\"bgcolor\":\"#ffff\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ffff\"},{\"color\":\"#000100\",\"bgcolor\":\"#fff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#fff\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#fff\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#fff\"},{\"textwrap\":true,\"bgcolor\":\"#fff\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#fff\"},{\"color\":\"#000100\",\"bgcolor\":\"#ff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#ff\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ff\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ff\"},{\"textwrap\":true,\"bgcolor\":\"#ff\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ff\"},{\"color\":\"#000100\",\"bgcolor\":\"#f\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#f\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f\"},{\"textwrap\":true,\"bgcolor\":\"#f\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f\"},{\"color\":\"#000100\",\"bgcolor\":\"#\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#\"},{\"textwrap\":true,\"bgcolor\":\"#\"},{\"color\":\"#000100\",\"bgcolor\":\"#ddefe8\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\"},{\"textwrap\":true,\"bgcolor\":\"#ddefe8\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9}},{\"color\":\"#000100\",\"font\":{\"size\":9},\"bgcolor\":\"#ddefe8\"},{\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9}},{\"font\":{\"size\":9},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\"},{\"font\":{\"size\":9},\"align\":\"center\",\"bgcolor\":\"#ddefe8\"},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"bgcolor\":\"#ddefe8\"},{\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9},\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"textwrap\":true,\"font\":{\"size\":9},\"bgcolor\":\"#ddefe8\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9}},{\"textwrap\":true,\"font\":{\"size\":9},\"bgcolor\":\"#ddefe8\",\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"textwrap\":true,\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"font\":{\"size\":9},\"bgcolor\":\"#ddefe8\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9}},{\"textwrap\":true,\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#aedac8\"},{\"bgcolor\":\"#aedac8\"},{\"bgcolor\":\"#fffff\"},{\"bgcolor\":\"#ffff\"},{\"bgcolor\":\"#fff\"},{\"bgcolor\":\"#ff\"},{\"bgcolor\":\"#f\"},{\"align\":\"center\",\"bgcolor\":\"#aedac8\",\"font\":{\"size\":8}},{\"align\":\"center\",\"bgcolor\":\"#aedac8\",\"font\":{\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#aedac8\",\"font\":{\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Arial\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#aedac8\",\"font\":{\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"bold\":false,\"size\":9}},{\"bgcolor\":\"#02a274\",\"font\":{\"size\":9},\"align\":\"center\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"aedac8\"},{\"align\":\"center\",\"bgcolor\":\"aedac8\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\",\"color\":\"#ffffff\"},{\"align\":\"center\",\"bgcolor\":\"#aedac8\",\"color\":\"#ffffff\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\",\"color\":\"#ffffff\",\"font\":{\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#aedac8\",\"color\":\"#ffffff\",\"font\":{\"size\":9}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\",\"color\":\"#000100\",\"font\":{\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#aedac8\",\"color\":\"#000100\",\"font\":{\"size\":9}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\",\"color\":\"#000100\",\"font\":{\"size\":8}},{\"align\":\"center\",\"bgcolor\":\"#aedac8\",\"color\":\"#000100\",\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"##aedac8\"},{\"bgcolor\":\"##aedac8\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\",\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\",\"font\":{\"size\":8},\"align\":\"center\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\",\"font\":{\"size\":9}},{\"bgcolor\":\"#aedac8\",\"font\":{\"size\":8}},{\"bgcolor\":\"#aedac8\",\"font\":{\"size\":8},\"align\":\"left\"},{\"bgcolor\":\"#aedac8\",\"font\":{\"size\":8},\"align\":\"left\",\"valign\":\"middle\"},{\"align\":\"center\",\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"bold\":false,\"size\":10}},{\"bgcolor\":\"#02a274\",\"font\":{\"size\":10},\"align\":\"center\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]}},{\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":10}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\",\"color\":\"#000100\",\"font\":{\"size\":10}},{\"align\":\"center\",\"bgcolor\":\"#aedac8\",\"color\":\"#000100\",\"font\":{\"size\":10}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"bgcolor\":\"#aedac8\",\"font\":{\"size\":10},\"align\":\"center\"},{\"align\":\"center\",\"bgcolor\":\"#aedac8\",\"font\":{\"size\":10}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":10}},{\"textwrap\":true,\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":10}},{\"bgcolor\":\"#aedac8\",\"font\":{\"size\":10},\"align\":\"left\",\"valign\":\"middle\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"font\":{\"size\":9},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"font\":{\"size\":8}}],\"validations\":[],\"isGroup\":true,\"cols\":{\"0\":{\"width\":20},\"1\":{\"width\":84},\"2\":{\"width\":132},\"3\":{\"width\":75},\"4\":{\"width\":63},\"5\":{\"width\":59},\"6\":{\"width\":70},\"7\":{\"width\":61},\"8\":{\"width\":60},\"9\":{\"width\":75},\"10\":{\"width\":75},\"11\":{\"width\":64},\"12\":{\"width\":70},\"13\":{\"width\":63},\"14\":{\"width\":86},\"15\":{\"width\":64},\"16\":{\"width\":58},\"17\":{\"width\":63},\"18\":{\"width\":60},\"19\":{\"width\":63},\"20\":{\"width\":59},\"21\":{\"width\":73},\"22\":{\"width\":82},\"23\":{\"width\":73},\"24\":{\"width\":86},\"len\":50},\"merges\":[\"B1:X1\",\"D3:D6\",\"E5:E6\",\"F5:F6\",\"E4:F4\",\"G4:G6\",\"H4:H6\",\"I5:I6\",\"J5:K5\",\"I4:K4\",\"E3:K3\",\"L3:L6\",\"D2:L2\",\"M4:M6\",\"N5:N6\",\"O5:O6\",\"P5:P6\",\"Q5:Q6\",\"N4:Q4\",\"M3:Q3\",\"R4:R6\",\"R3:T3\",\"S4:T4\",\"S5:S6\",\"T5:T6\",\"U4:U6\",\"V4:W4\",\"V5:V6\",\"W5:W6\",\"X4:Y4\",\"X5:X6\",\"Y5:Y6\",\"U3:Y3\",\"M2:T2\",\"U2:Y2\",\"B2:B6\",\"C2:C6\",\"B8:C8\"]}', NULL, 'https://static.jeecg.com/designreport/images/jingfei_1607069843358.png', 'admin', '2020-12-03 16:54:17', 'admin', '2021-02-03 13:59:08', 0, NULL, NULL, 1, 436, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1334457419857793024', '20201203192154', '超市各地区销售额', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"area\":{\"sri\":1,\"sci\":26,\"eri\":4,\"eci\":28,\"width\":300,\"height\":100},\"excel_config_id\":\"1334457419857793024\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"0\":{\"cells\":{\"1\":{\"text\":\"各地区商品销售额一栏表\",\"merge\":[0,18],\"style\":13}},\"height\":82},\"1\":{\"cells\":{\"1\":{\"text\":\"地区/类别/时间\",\"merge\":[1,1],\"style\":46},\"3\":{\"text\":\"2020年\",\"style\":46,\"merge\":[0,12]},\"16\":{\"text\":\"2019年\",\"style\":46,\"merge\":[0,9]}}},\"2\":{\"cells\":{\"3\":{\"text\":\"12月\",\"style\":46},\"4\":{\"text\":\"11月\",\"style\":46},\"5\":{\"text\":\"10月\",\"style\":46},\"6\":{\"text\":\"9月\",\"style\":46},\"7\":{\"text\":\"8月\",\"style\":46},\"8\":{\"text\":\"7月\",\"style\":46},\"9\":{\"text\":\"6月\",\"style\":46},\"10\":{\"text\":\"5月\",\"style\":46},\"11\":{\"text\":\"4月\",\"style\":46},\"12\":{\"text\":\"3月\",\"style\":46},\"13\":{\"text\":\"2月\",\"style\":46},\"14\":{\"text\":\"1月\",\"style\":46},\"15\":{\"text\":\"本年小计\",\"style\":46},\"16\":{\"text\":\"12月\",\"style\":46},\"17\":{\"text\":\"11月\",\"style\":46},\"18\":{\"text\":\"10月\",\"style\":46},\"19\":{\"text\":\"9月\",\"style\":46},\"20\":{\"text\":\"8月\",\"style\":46},\"21\":{\"text\":\"7月\",\"style\":46},\"22\":{\"text\":\"6月\",\"style\":46},\"23\":{\"text\":\"5月\",\"style\":46},\"24\":{\"text\":\"4月\",\"style\":46},\"25\":{\"text\":\"本年小计\",\"style\":46}}},\"3\":{\"cells\":{\"1\":{\"text\":\"#{xiaoshou.group(diqu)}\",\"style\":51,\"aggregate\":\"group\"},\"2\":{\"text\":\"#{xiaoshou.class}\",\"style\":51},\"3\":{\"text\":\"#{xiaoshou.sales_11}\",\"style\":20},\"4\":{\"text\":\"#{xiaoshou.sales_12}\",\"style\":20},\"5\":{\"text\":\"#{xiaoshou.sales_13}\",\"style\":20},\"6\":{\"text\":\"#{xiaoshou.sales_14}\",\"style\":20},\"7\":{\"text\":\"#{xiaoshou.sales_15}\",\"style\":20},\"8\":{\"text\":\"#{xiaoshou.sales_16}\",\"style\":20},\"9\":{\"text\":\"#{xiaoshou.sales_17}\",\"style\":20},\"10\":{\"text\":\"#{xiaoshou.sales_18}\",\"style\":20},\"11\":{\"text\":\"#{xiaoshou.sales_19}\",\"style\":20},\"12\":{\"text\":\"#{xiaoshou.sales_20}\",\"style\":20},\"13\":{\"text\":\"#{xiaoshou.sales_21}\",\"style\":20},\"14\":{\"text\":\"#{xiaoshou.sales_22}\",\"style\":20},\"15\":{\"style\":48,\"text\":\"=SUM(D4:O4)\"},\"16\":{\"text\":\"#{xiaoshou.sales_31}\",\"style\":20},\"17\":{\"text\":\"#{xiaoshou.sales_32}\",\"style\":20},\"18\":{\"text\":\"#{xiaoshou.sales_33}\",\"style\":20},\"19\":{\"text\":\"#{xiaoshou.sales_34}\",\"style\":20},\"20\":{\"text\":\"#{xiaoshou.sales_35}\",\"style\":20},\"21\":{\"text\":\"#{xiaoshou.sales_36}\",\"style\":20},\"22\":{\"text\":\"#{xiaoshou.sales_37}\",\"style\":20},\"23\":{\"text\":\"#{xiaoshou.sales_38}\",\"style\":20},\"24\":{\"text\":\"#{xiaoshou.sales_39}\",\"style\":20},\"25\":{\"style\":48,\"text\":\"=SUM(Q4:Y4)\"}},\"isDrag\":true},\"4\":{\"cells\":{\"1\":{\"text\":\"合计\",\"style\":52,\"rendered\":\"\",\"merge\":[0,1]},\"3\":{\"text\":\"=SUM(D4)\",\"style\":55},\"4\":{\"text\":\"=SUM(E4)\",\"style\":55},\"5\":{\"text\":\"=SUM(F4)\",\"style\":55},\"6\":{\"text\":\"=SUM(G4)\",\"style\":55},\"7\":{\"text\":\"=SUM(H4)\",\"style\":55},\"8\":{\"text\":\"=SUM(I4)\",\"style\":55},\"9\":{\"text\":\"=SUM(J4)\",\"style\":55},\"10\":{\"text\":\"=SUM(K4)\",\"style\":55},\"11\":{\"text\":\"=SUM(L4)\",\"style\":55},\"12\":{\"text\":\"=SUM(M4)\",\"style\":55},\"13\":{\"text\":\"=SUM(N4)\",\"style\":55},\"14\":{\"text\":\"=SUM(O4)\",\"style\":55},\"15\":{\"text\":\"=SUM(P4)\",\"style\":55},\"16\":{\"text\":\"=SUM(Q4)\",\"style\":55},\"17\":{\"text\":\"=SUM(R4)\",\"style\":55},\"18\":{\"text\":\"=SUM(S4)\",\"style\":55},\"19\":{\"text\":\"=SUM(T4)\",\"style\":55},\"20\":{\"text\":\"=SUM(U4)\",\"style\":55},\"21\":{\"text\":\"=SUM(V4)\",\"style\":55},\"22\":{\"text\":\"=SUM(W4)\",\"style\":55},\"23\":{\"text\":\"=SUM(X4)\",\"style\":55},\"24\":{\"text\":\"=SUM(Y4)\",\"style\":55},\"25\":{\"text\":\"=SUM(Z4)\",\"style\":55}},\"isDrag\":true},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"groupField\":\"xiaoshou.diqu\",\"freeze\":\"A1\",\"dataRectWidth\":2464,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"bgcolor\":\"#\"},{\"bgcolor\":\"#d7f2f9\"},{\"bgcolor\":\"#d7f2f9\",\"align\":\"center\"},{\"align\":\"center\"},{\"align\":\"center\",\"bgcolor\":\"#\"},{\"bgcolor\":\"#d7f2f9\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"2896ea\"],\"top\":[\"thin\",\"2896ea\"],\"left\":[\"thin\",\"2896ea\"],\"right\":[\"thin\",\"2896ea\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"2896ea\"],\"top\":[\"thin\",\"2896ea\"],\"left\":[\"thin\",\"2896ea\"],\"right\":[\"thin\",\"2896ea\"]}},{\"border\":{\"bottom\":[\"thin\",\"2896ea\"],\"top\":[\"thin\",\"2896ea\"],\"left\":[\"thin\",\"2896ea\"],\"right\":[\"thin\",\"2896ea\"]}},{\"bgcolor\":\"#d7f2f9\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#2896ea\"],\"top\":[\"thin\",\"#2896ea\"],\"left\":[\"thin\",\"#2896ea\"],\"right\":[\"thin\",\"#2896ea\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#2896ea\"],\"top\":[\"thin\",\"#2896ea\"],\"left\":[\"thin\",\"#2896ea\"],\"right\":[\"thin\",\"#2896ea\"]}},{\"border\":{\"bottom\":[\"thin\",\"#2896ea\"],\"top\":[\"thin\",\"#2896ea\"],\"left\":[\"thin\",\"#2896ea\"],\"right\":[\"thin\",\"#2896ea\"]}},{\"font\":{\"bold\":true}},{\"font\":{\"bold\":true,\"size\":16}},{\"font\":{\"bold\":true,\"size\":16},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#2896ea\"],\"top\":[\"thin\",\"#2896ea\"],\"left\":[\"thin\",\"#2896ea\"],\"right\":[\"thin\",\"#2896ea\"]},\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#2896ea\"],\"top\":[\"thin\",\"#2896ea\"],\"left\":[\"thin\",\"#2896ea\"],\"right\":[\"thin\",\"#2896ea\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#2896ea\"],\"top\":[\"thin\",\"#2896ea\"],\"left\":[\"thin\",\"#2896ea\"],\"right\":[\"thin\",\"#2896ea\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#2896ea\"],\"top\":[\"thin\",\"#2896ea\"],\"left\":[\"thin\",\"#2896ea\"],\"right\":[\"thin\",\"#2896ea\"]}},{\"bgcolor\":\"#5b9cd6\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#9cc2e6\"],\"top\":[\"thin\",\"#9cc2e6\"],\"left\":[\"thin\",\"#9cc2e6\"],\"right\":[\"thin\",\"#9cc2e6\"]}},{\"border\":{\"bottom\":[\"thin\",\"#9cc2e6\"],\"top\":[\"thin\",\"#9cc2e6\"],\"left\":[\"thin\",\"#9cc2e6\"],\"right\":[\"thin\",\"#9cc2e6\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#9cc2e6\"],\"top\":[\"thin\",\"#9cc2e6\"],\"left\":[\"thin\",\"#9cc2e6\"],\"right\":[\"thin\",\"#9cc2e6\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]}},{\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#e7e5e6\"],\"top\":[\"thin\",\"#e7e5e6\"],\"left\":[\"thin\",\"#e7e5e6\"],\"right\":[\"thin\",\"#e7e5e6\"]}},{\"border\":{\"bottom\":[\"thin\",\"#e7e5e6\"],\"top\":[\"thin\",\"#e7e5e6\"],\"left\":[\"thin\",\"#e7e5e6\"],\"right\":[\"thin\",\"#e7e5e6\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#e7e5e6\"],\"top\":[\"thin\",\"#e7e5e6\"],\"left\":[\"thin\",\"#e7e5e6\"],\"right\":[\"thin\",\"#e7e5e6\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d0cecf\"],\"top\":[\"thin\",\"#d0cecf\"],\"left\":[\"thin\",\"#d0cecf\"],\"right\":[\"thin\",\"#d0cecf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#d0cecf\"],\"top\":[\"thin\",\"#d0cecf\"],\"left\":[\"thin\",\"#d0cecf\"],\"right\":[\"thin\",\"#d0cecf\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#d0cecf\"],\"top\":[\"thin\",\"#d0cecf\"],\"left\":[\"thin\",\"#d0cecf\"],\"right\":[\"thin\",\"#d0cecf\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d0cecf\"],\"top\":[\"thin\",\"#d0cecf\"],\"left\":[\"thin\",\"#d0cecf\"],\"right\":[\"thin\",\"#d0cecf\"]},\"color\":\"#ffffff\"},{\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#afabac\"],\"top\":[\"thin\",\"#afabac\"],\"left\":[\"thin\",\"#afabac\"],\"right\":[\"thin\",\"#afabac\"]},\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#afabac\"],\"top\":[\"thin\",\"#afabac\"],\"left\":[\"thin\",\"#afabac\"],\"right\":[\"thin\",\"#afabac\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#afabac\"],\"top\":[\"thin\",\"#afabac\"],\"left\":[\"thin\",\"#afabac\"],\"right\":[\"thin\",\"#afabac\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#f2f2f2\"],\"top\":[\"thin\",\"#f2f2f2\"],\"left\":[\"thin\",\"#f2f2f2\"],\"right\":[\"thin\",\"#f2f2f2\"]},\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#f2f2f2\"],\"top\":[\"thin\",\"#f2f2f2\"],\"left\":[\"thin\",\"#f2f2f2\"],\"right\":[\"thin\",\"#f2f2f2\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#f2f2f2\"],\"top\":[\"thin\",\"#f2f2f2\"],\"left\":[\"thin\",\"#f2f2f2\"],\"right\":[\"thin\",\"#f2f2f2\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\"},{\"bgcolor\":\"#5b9cd6\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"size\":8},\"align\":\"center\",\"bgcolor\":\"#d7f2f9\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\",\"bgcolor\":\"#deeaf6\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"size\":8},\"align\":\"center\",\"format\":\"number\",\"bgcolor\":\"#bdd7ee\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"size\":10},\"align\":\"center\",\"bgcolor\":\"#d7f2f9\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"font\":{\"size\":9},\"align\":\"center\",\"bgcolor\":\"#d7f2f9\"},{\"align\":\"center\",\"bgcolor\":\"#bdd7ee\"},{\"bgcolor\":\"#bdd7ee\"},{\"bgcolor\":\"#bdd7ee\",\"format\":\"number\"},{\"bgcolor\":\"#bdd7ee\",\"format\":\"number\",\"align\":\"center\"}],\"validations\":[],\"isGroup\":true,\"cols\":{\"0\":{\"width\":21},\"1\":{\"width\":63},\"2\":{\"width\":85},\"3\":{\"width\":95},\"4\":{\"width\":83},\"5\":{\"width\":81},\"6\":{\"width\":88},\"7\":{\"width\":89},\"8\":{\"width\":87},\"9\":{\"width\":95},\"10\":{\"width\":92},\"11\":{\"width\":95},\"12\":{\"width\":96},\"13\":{\"width\":98},\"14\":{\"width\":98},\"15\":{\"width\":78},\"16\":{\"width\":110},\"17\":{\"width\":111},\"18\":{\"width\":102},\"19\":{\"width\":102},\"20\":{\"width\":114},\"21\":{\"width\":111},\"22\":{\"width\":113},\"23\":{\"width\":107},\"24\":{\"width\":115},\"25\":{\"width\":135},\"len\":49},\"merges\":[\"D2:P2\",\"B2:C3\",\"Q2:Z2\",\"B1:T1\",\"B5:C5\"]}', NULL, 'https://static.jeecg.com/designreport/images/chaoshi_1607069609875.png', 'admin', '2020-12-03 19:21:55', 'admin', '2021-04-05 18:47:20', 0, NULL, NULL, 1, 372, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1334696790477377536', '20201204111149', '学校收入一览表', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"area\":{\"sri\":1,\"sci\":24,\"eri\":5,\"eci\":24,\"width\":100,\"height\":138},\"excel_config_id\":\"1334696790477377536\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"0\":{\"cells\":{\"1\":{\"text\":\"学校收入一览表\",\"merge\":[0,13],\"style\":25}},\"height\":71},\"1\":{\"cells\":{\"1\":{\"text\":\"校园信息\",\"merge\":[1,2],\"style\":40},\"4\":{\"text\":\"学生信息\",\"merge\":[1,2],\"style\":40},\"7\":{\"merge\":[1,5],\"style\":42,\"text\":\"收款信息\"},\"13\":{\"merge\":[0,10],\"text\":\"确认收入信息\",\"style\":43}},\"height\":23},\"2\":{\"cells\":{\"13\":{\"merge\":[0,3],\"text\":\"2020.09\",\"style\":46},\"17\":{\"merge\":[0,3],\"text\":\"2020.10\",\"style\":46},\"21\":{\"text\":\"合计\",\"style\":46,\"merge\":[0,2]}},\"height\":40},\"3\":{\"cells\":{\"1\":{\"text\":\"所属城际\",\"style\":50},\"2\":{\"text\":\"所属校园\",\"style\":50},\"3\":{\"text\":\"NC帐套\",\"style\":50},\"4\":{\"text\":\"学号\",\"style\":50},\"5\":{\"text\":\"姓名\",\"style\":50},\"6\":{\"text\":\"性质\",\"style\":50},\"7\":{\"text\":\"缴费金额\",\"style\":50},\"8\":{\"text\":\"缴费时间\",\"style\":50},\"9\":{\"text\":\"缴费性质\",\"style\":50},\"10\":{\"text\":\"缴费所属期间\",\"style\":50},\"11\":{\"text\":\"缴费月份数\",\"style\":50},\"12\":{\"text\":\"缴费方式\",\"style\":50},\"13\":{\"text\":\"全部\",\"style\":50},\"14\":{\"text\":\"学费\",\"style\":50},\"15\":{\"text\":\"餐费\",\"style\":50},\"16\":{\"text\":\"校车费\",\"style\":50},\"17\":{\"text\":\"全部\",\"style\":50},\"18\":{\"text\":\"学费\",\"style\":50},\"19\":{\"text\":\"餐费\",\"style\":50},\"20\":{\"text\":\"校车费\",\"style\":50},\"21\":{\"text\":\"全部\",\"style\":50},\"22\":{\"text\":\"学费\",\"style\":50},\"23\":{\"text\":\"餐费\",\"style\":50}}},\"4\":{\"cells\":{\"1\":{\"text\":\"#{shouru.group(city)}\",\"style\":45,\"aggregate\":\"group\"},\"2\":{\"text\":\"#{shouru.group(school)}\",\"style\":45,\"aggregate\":\"group\"},\"3\":{\"text\":\"#{shouru.group(ncnum)}\",\"style\":35,\"aggregate\":\"group\"},\"4\":{\"text\":\"#{shouru.num}\",\"style\":35},\"5\":{\"text\":\"#{shouru.name}\",\"style\":35},\"6\":{\"text\":\"#{shouru.class}\",\"style\":35},\"7\":{\"text\":\"#{shouru.pay}\",\"style\":35},\"8\":{\"text\":\"#{shouru.paytime}\",\"style\":35},\"9\":{\"text\":\"#{shouru.payclass}\",\"style\":35},\"10\":{\"text\":\"#{shouru.pay1}\",\"style\":35},\"11\":{\"text\":\"#{shouru.paymoth}\",\"style\":35},\"12\":{\"text\":\"#{shouru.pay2}\",\"style\":35},\"13\":{\"style\":33,\"text\":\"=SUM(O5:Q5)\"},\"14\":{\"text\":\"#{shouru.tuition_09}\",\"style\":35},\"15\":{\"text\":\"#{shouru.meals_09}\",\"style\":35},\"16\":{\"text\":\"#{shouru.busfee_09}\",\"style\":35},\"17\":{\"style\":33,\"text\":\"=SUM(S5:U5)\"},\"18\":{\"text\":\"#{shouru.tuition_10}\",\"style\":35},\"19\":{\"text\":\"#{shouru.meals_10}\",\"style\":35},\"20\":{\"text\":\"#{shouru.busfee_10}\",\"style\":35},\"21\":{\"style\":33,\"text\":\"=SUM(W5,X5)\"},\"22\":{\"style\":35,\"text\":\"=SUM(O5,S5)\"},\"23\":{\"style\":35,\"text\":\"=SUM(P5,T5)\"}},\"isDrag\":true,\"height\":25},\"5\":{\"cells\":{\"1\":{\"style\":66,\"text\":\"合计\"},\"2\":{\"text\":\" \",\"style\":66},\"3\":{\"style\":66,\"text\":\" \"},\"4\":{\"style\":66,\"text\":\" \"},\"5\":{\"style\":66,\"text\":\" \"},\"6\":{\"style\":66,\"text\":\" \"},\"7\":{\"style\":66,\"text\":\" \"},\"8\":{\"style\":66,\"text\":\" \"},\"9\":{\"style\":66,\"text\":\" \"},\"10\":{\"style\":66,\"text\":\" \"},\"11\":{\"style\":66,\"text\":\" \"},\"12\":{\"style\":66,\"text\":\" \"},\"13\":{\"style\":66,\"text\":\" \"},\"14\":{\"style\":66,\"text\":\" \"},\"15\":{\"style\":66,\"text\":\" \"},\"16\":{\"style\":66,\"text\":\" \"},\"17\":{\"style\":66,\"text\":\" \"},\"18\":{\"text\":\" \",\"style\":66},\"19\":{\"style\":66,\"text\":\" \"},\"20\":{\"style\":66,\"text\":\" \"},\"21\":{\"style\":15,\"text\":\"=SUM(V5)\"},\"22\":{\"style\":15,\"text\":\"=SUM(W5)\"},\"23\":{\"style\":15,\"text\":\"=SUM(X5)\"}}},\"9\":{\"cells\":{}},\"11\":{\"cells\":{}},\"len\":101},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"groupField\":\"shouru.city\",\"freeze\":\"A1\",\"dataRectWidth\":1881,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"bgcolor\":\"#\"},{\"align\":\"center\",\"bgcolor\":\"#309fc6\"},{\"bgcolor\":\"#ffffff\"},{\"align\":\"center\",\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\"},{\"align\":\"center\",\"bgcolor\":\"#b2ddec\"},{\"align\":\"center\",\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\",\"font\":{\"size\":8}},{\"align\":\"center\",\"bgcolor\":\"#b2ddec\",\"font\":{\"size\":8}},{\"align\":\"center\",\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\",\"font\":{\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#b2ddec\",\"font\":{\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\",\"font\":{\"size\":10}},{\"align\":\"center\",\"bgcolor\":\"\"},{\"align\":\"center\",\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\",\"font\":{\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#b2ddec\",\"font\":{\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#b2ddec\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"font\":{\"size\":9}},{\"align\":\"center\",\"font\":{\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"#dff2f9\"},{\"bgcolor\":\"\"},{\"bgcolor\":\"#309fc6\"},{\"align\":\"center\",\"color\":\"#ffffff\"},{\"align\":\"center\",\"bgcolor\":\"#dff2f9\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"font\":{\"size\":16}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#b2ddec\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#dff2f9\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"b2ddec\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"￥b2ddec\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":8}},{\"align\":\"center\",\"bgcolor\":\"#b2ddec\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8}},{\"align\":\"center\",\"bgcolor\":\"#dff2f9\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\",\"font\":{\"size\":8}},{\"align\":\"center\",\"bgcolor\":\"#dff2f9\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\",\"font\":{\"size\":9}},{\"align\":\"center\",\"bgcolor\":\"\",\"color\":\"#ffffff\",\"font\":{\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"font\":{\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"align\":\"center\",\"bgcolor\":\"#d7f2f9\",\"font\":{\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#d7f2f9\",\"font\":{\"size\":8},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#5b9cd6\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"bgcolor\":\"#bdd7ee\",\"font\":{\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"font\":{\"size\":8}},{\"align\":\"center\",\"bgcolor\":\"#bdd7ee\",\"font\":{\"size\":8},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"font\":{\"size\":10}},{\"align\":\"center\",\"bgcolor\":\"#bdd7ee\",\"font\":{\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"font\":{\"size\":10}},{\"align\":\"center\",\"bgcolor\":\"#d7f2f9\",\"font\":{\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\",\"font\":{\"size\":10}},{\"font\":{\"size\":12}},{\"align\":\"center\",\"bgcolor\":\"#bdd7ee\",\"font\":{\"size\":12},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"font\":{\"size\":12}},{\"align\":\"center\",\"bgcolor\":\"#d7f2f9\",\"font\":{\"size\":12},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\",\"font\":{\"size\":12}},{\"font\":{\"size\":10.5}},{\"align\":\"center\",\"bgcolor\":\"#bdd7ee\",\"font\":{\"size\":10.5},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"center\",\"font\":{\"size\":10.5}},{\"align\":\"center\",\"bgcolor\":\"#d7f2f9\",\"font\":{\"size\":10.5},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\",\"font\":{\"size\":10.5}},{\"align\":\"left\",\"bgcolor\":\"#b2ddec\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"align\":\"left\"}],\"validations\":[],\"isGroup\":true,\"cols\":{\"0\":{\"width\":37},\"1\":{\"width\":79},\"2\":{\"width\":87},\"3\":{\"width\":79},\"4\":{\"width\":92},\"5\":{\"width\":90},\"6\":{\"width\":77},\"7\":{\"width\":83},\"8\":{\"width\":89},\"9\":{\"width\":79},\"10\":{\"width\":89},\"11\":{\"width\":84},\"12\":{\"width\":76},\"13\":{\"width\":67},\"14\":{\"width\":74},\"15\":{\"width\":69},\"16\":{\"width\":74},\"17\":{\"width\":68},\"18\":{\"width\":76},\"19\":{\"width\":79},\"20\":{\"width\":78},\"21\":{\"width\":74},\"22\":{\"width\":81},\"len\":49},\"merges\":[\"B2:D3\",\"E2:G3\",\"H2:M3\",\"N3:Q3\",\"R3:U3\",\"V3:X3\",\"N2:X2\",\"B1:O1\"]}', NULL, 'https://static.jeecg.com/designreport/images/xuexiao_1607069724407.png', 'admin', '2020-12-04 11:11:50', 'admin', '2021-04-01 02:46:23', 0, NULL, NULL, 1, 429, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1334757703079301120', '20201204151358', '车间零件完工一览表', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"area\":false,\"printElWidth\":718,\"excel_config_id\":\"1334757703079301120\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{\"1\":{\"text\":\"车间零件完工一览表\",\"merge\":[0,12],\"style\":23}},\"height\":81},\"1\":{\"cells\":{\"0\":{\"style\":11},\"1\":{\"text\":\"车间\",\"style\":22},\"2\":{\"text\":\"成品名称\",\"style\":22},\"3\":{\"text\":\"半成品名称\",\"style\":22},\"4\":{\"text\":\"完工时间\",\"style\":22},\"5\":{\"text\":\"状态\",\"style\":22},\"6\":{\"text\":\"成品属性\",\"style\":22},\"7\":{\"text\":\"工单号\",\"style\":22},\"8\":{\"text\":\"工单数量\",\"style\":22},\"9\":{\"text\":\"计划数量\",\"style\":22},\"10\":{\"text\":\"完成数量\",\"style\":22},\"11\":{\"text\":\"UPH\",\"style\":22},\"12\":{\"text\":\"H/C\",\"style\":22},\"13\":{\"text\":\"计划时间\",\"style\":22},\"14\":{\"text\":\"良率\",\"style\":22},\"15\":{\"text\":\"备注\",\"style\":22},\"16\":{\"style\":11},\"17\":{\"style\":11},\"18\":{\"style\":11},\"19\":{\"style\":11},\"20\":{\"style\":11},\"21\":{\"style\":11},\"22\":{\"style\":11},\"23\":{\"style\":11},\"24\":{\"style\":11},\"25\":{\"style\":11},\"26\":{\"style\":11}},\"height\":55},\"2\":{\"cells\":{\"0\":{\"style\":13},\"1\":{\"text\":\"#{chejian.group(city)}\",\"style\":16,\"aggregate\":\"group\"},\"2\":{\"text\":\"#{chejian.finish}\",\"style\":14},\"3\":{\"text\":\"#{chejian.semifinish}\",\"style\":14},\"4\":{\"text\":\"#{chejian.time}\",\"style\":14},\"5\":{\"text\":\"#{chejian.state}\",\"style\":14},\"6\":{\"text\":\"#{chejian.attribute}\",\"style\":14},\"7\":{\"text\":\"#{chejian.num}\",\"style\":14},\"8\":{\"text\":\"#{chejian.gnum}\",\"style\":14},\"9\":{\"text\":\"#{chejian.jnum}\",\"style\":14},\"10\":{\"text\":\"#{chejian.wnum}\",\"style\":14},\"11\":{\"text\":\"#{chejian.uph}\",\"style\":14},\"12\":{\"text\":\"#{chejian.hc}\",\"style\":14},\"13\":{\"text\":\"#{chejian.jtime}\",\"style\":14},\"14\":{\"text\":\"#{chejian.yield}\",\"style\":14},\"15\":{\"text\":\"#{chejian.beizhu}\",\"style\":14},\"16\":{\"style\":13},\"17\":{\"style\":13},\"18\":{\"style\":13},\"19\":{\"style\":13},\"20\":{\"style\":13},\"21\":{\"style\":13},\"22\":{\"style\":13},\"23\":{\"style\":13},\"24\":{\"style\":13},\"25\":{\"style\":13},\"26\":{\"style\":13}},\"isDrag\":true,\"height\":35},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"groupField\":\"chejian.city\",\"freeze\":\"A1\",\"dataRectWidth\":1494,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"bgcolor\":\"#\"},{\"align\":\"center\",\"bgcolor\":\"#309fc6\"},{\"align\":\"center\",\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\"},{\"bgcolor\":\"#309fc6\"},{\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\"},{\"align\":\"center\",\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"font\":{\"bold\":true}},{\"font\":{\"bold\":true,\"size\":16}},{\"font\":{\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9}},{\"font\":{\"size\":9},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"align\":\"center\",\"bgcolor\":\"#\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"align\":\"center\",\"bgcolor\":\"#b2ddec\"},{\"font\":{\"size\":8}},{\"align\":\"center\",\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8}},{\"font\":{\"size\":8},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"align\":\"center\",\"bgcolor\":\"#b2ddec\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8},\"align\":\"center\"},{\"align\":\"center\",\"bgcolor\":\"#309fc6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9}},{\"font\":{\"bold\":true,\"size\":16},\"align\":\"center\"}],\"validations\":[],\"isGroup\":true,\"cols\":{\"0\":{\"width\":45},\"1\":{\"width\":106},\"2\":{\"width\":121},\"3\":{\"width\":124},\"4\":{\"width\":87},\"5\":{\"width\":76},\"6\":{\"width\":82},\"7\":{\"width\":81},\"8\":{\"width\":69},\"9\":{\"width\":76},\"10\":{\"width\":81},\"15\":{\"width\":146},\"len\":50},\"merges\":[\"B1:N1\"]}', NULL, 'https://static.jeecg.com/designreport/images/QQ截图20201216185352_1608116050060.png', 'admin', '2020-12-04 15:13:58', 'admin', '2021-04-05 18:47:24', 0, NULL, NULL, 1, 519, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1338370016550195200', '20201214142804', '条形码报表', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"area\":false,\"printElWidth\":718,\"excel_config_id\":\"1338370016550195200\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{\"1\":{\"merge\":[1,3],\"text\":\"居民身份证申领登记表\",\"style\":39},\"2\":{\"style\":39},\"3\":{\"style\":39},\"4\":{\"style\":39},\"5\":{\"merge\":[0,2],\"text\":\"\",\"rendered\":\"\",\"display\":\"text\"},\"-1\":{\"text\":\"${tm.tp}\"}},\"height\":27},\"1\":{\"cells\":{\"1\":{\"style\":39},\"2\":{\"style\":39},\"3\":{\"style\":39},\"4\":{\"style\":39},\"5\":{\"style\":2,\"virtual\":\"ZiOFmILaRjdmVs6E\",\"rendered\":\"NUsGZXpylLVeKQ7J\",\"display\":\"barcode\",\"text\":\"${tm.tm}\",\"merge\":[0,2]}},\"height\":52},\"2\":{\"cells\":{\"1\":{\"text\":\"受理单位（盖章）珠海市公安局\",\"merge\":[0,3],\"style\":36},\"2\":{\"style\":36},\"3\":{\"style\":36},\"4\":{\"style\":36},\"5\":{\"style\":6},\"6\":{\"style\":6},\"7\":{\"style\":6},\"8\":{\"text\":\"\",\"rendered\":\"\"}},\"height\":34},\"3\":{\"cells\":{\"1\":{\"text\":\"姓名\",\"style\":24},\"2\":{\"text\":\"${tm.name}\",\"style\":7,\"rendered\":\"\"},\"3\":{\"text\":\"性别\",\"style\":16},\"4\":{\"text\":\"${tm.sex}\",\"style\":7,\"isDict\":1,\"dictCode\":\"sex1\",\"rendered\":\"\"},\"5\":{\"text\":\"民族\",\"style\":16},\"6\":{\"text\":\"${tm.nation}\",\"style\":7},\"7\":{\"text\":\"${tm.tp}\",\"style\":7,\"merge\":[2,0],\"rendered\":\"ftkUSZOje4A5gVO3\",\"display\":\"img\"},\"9\":{\"text\":\"\",\"rendered\":\"\"}},\"isDrag\":true,\"height\":47},\"4\":{\"cells\":{\"1\":{\"text\":\"出生日期\",\"style\":24},\"2\":{\"text\":\"${tm.birth}\",\"style\":32,\"merge\":[0,4]},\"3\":{\"style\":33},\"4\":{\"style\":33},\"5\":{\"style\":33},\"6\":{\"style\":33},\"8\":{\"text\":\"\",\"rendered\":\"\"}},\"isDrag\":true,\"height\":51},\"5\":{\"cells\":{\"1\":{\"text\":\"常住户口所在地住址\",\"style\":21},\"2\":{\"text\":\"${tm.zhuzhi}\",\"style\":7,\"merge\":[0,4]},\"8\":{\"text\":\"\",\"rendered\":\"\"}},\"isDrag\":true,\"height\":62},\"6\":{\"cells\":{\"1\":{\"text\":\"公民身份证\",\"style\":24},\"2\":{\"text\":\"${tm.card}\",\"style\":7,\"merge\":[0,5]}},\"isDrag\":true,\"height\":55},\"7\":{\"cells\":{\"1\":{\"text\":\"有限期限\",\"style\":24},\"2\":{\"text\":\"${tm.ydate}\",\"style\":34,\"merge\":[0,1]},\"3\":{\"style\":35},\"4\":{\"text\":\"签发机关\",\"style\":24},\"5\":{\"text\":\"${tm.qfjg}\",\"style\":7,\"merge\":[0,2]}},\"isDrag\":true,\"height\":52},\"8\":{\"cells\":{\"1\":{\"text\":\"申领原因\",\"style\":24},\"2\":{\"text\":\"${tm.slyy}\",\"style\":7,\"merge\":[0,5]}},\"isDrag\":true,\"height\":55},\"9\":{\"cells\":{\"1\":{\"text\":\"受理时间\",\"style\":24},\"2\":{\"text\":\"${tm.sdate}\",\"style\":32,\"merge\":[0,1]},\"3\":{\"style\":33},\"4\":{\"text\":\"受理号\",\"style\":24},\"5\":{\"text\":\"${tm.shao}\",\"style\":7,\"merge\":[0,2]}},\"isDrag\":true,\"height\":49},\"10\":{\"cells\":{\"1\":{\"text\":\"承办人\",\"style\":24},\"2\":{\"text\":\"${tm.cbr}\",\"style\":7,\"merge\":[0,1]},\"4\":{\"text\":\"受理单位领导\",\"style\":24},\"5\":{\"text\":\"${tm.sld}\",\"style\":7,\"merge\":[0,2]}},\"isDrag\":true,\"height\":42},\"11\":{\"cells\":{\"1\":{\"text\":\"申请（监护）人签名\",\"style\":21},\"2\":{\"text\":\"${tm.sr}\",\"style\":7,\"merge\":[0,1]},\"4\":{\"text\":\"申请（监护）人联系电话\",\"style\":21},\"5\":{\"text\":\"${tm.jphone}\",\"style\":7,\"merge\":[0,2]}},\"isDrag\":true,\"height\":59},\"12\":{\"cells\":{\"1\":{\"text\":\"领证人签名\",\"style\":24},\"2\":{\"text\":\"${tm.lzr}\",\"style\":7,\"merge\":[0,1]},\"4\":{\"text\":\"领证时间\",\"style\":24},\"5\":{\"text\":\"${tm.ldate}\",\"style\":32,\"merge\":[0,2]},\"6\":{\"style\":33},\"7\":{\"style\":33}},\"isDrag\":true,\"height\":57},\"13\":{\"cells\":{\"1\":{\"text\":\"是否通过邮政特快专递方式领取二代\",\"merge\":[0,1],\"style\":24},\"2\":{\"text\":\" \",\"style\":25},\"3\":{\"text\":\"${tm.sk}\",\"style\":7,\"merge\":[0,4]}},\"isDrag\":true,\"height\":50},\"14\":{\"cells\":{\"1\":{\"text\":\"投递地址\",\"style\":24},\"2\":{\"text\":\"${tm.dizhi}\",\"style\":7,\"merge\":[0,2]},\"5\":{\"text\":\"收件人\",\"style\":24},\"6\":{\"style\":7,\"text\":\" \",\"merge\":[0,1]}},\"isDrag\":true,\"height\":53},\"15\":{\"cells\":{\"1\":{\"text\":\"邮政编码\",\"style\":24},\"2\":{\"text\":\"\",\"style\":7,\"merge\":[0,1]},\"4\":{\"text\":\"备注\",\"style\":24},\"5\":{\"text\":\"\",\"style\":7,\"merge\":[0,2]}},\"isDrag\":true,\"height\":47},\"16\":{\"cells\":{\"1\":{\"merge\":[0,6],\"text\":\"公安部治安管理局治\",\"style\":31},\"2\":{\"style\":31},\"3\":{\"style\":31},\"4\":{\"style\":31},\"5\":{\"style\":31},\"6\":{\"style\":31},\"7\":{\"style\":31}}},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[\"sex1\",\"sex1\",\"sex1\"],\"freeze\":\"A1\",\"dataRectWidth\":704,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"font\":{\"size\":16}},{\"font\":{\"size\":16},\"align\":\"center\"},{\"align\":\"center\"},{\"textwrap\":true},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"font\":{\"name\":\"宋体\",\"size\":9}},{\"font\":{\"name\":\"宋体\",\"size\":9},\"color\":\"#3f3f3f\"},{\"font\":{\"name\":\"宋体\",\"size\":9},\"color\":\"#0c0c0c\"},{\"font\":{\"name\":\"宋体\",\"size\":9},\"color\":\"#7f7f7f\"},{\"font\":{\"name\":\"宋体\",\"size\":9},\"color\":\"#595959\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"align\":\"right\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\",\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\",\"bold\":false}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\",\"bold\":false}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\",\"bold\":false},\"align\":\"center\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\",\"bold\":true}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\",\"bold\":true},\"align\":\"center\"},{\"font\":{\"name\":\"宋体\",\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\",\"bold\":true},\"align\":\"right\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\",\"bold\":true},\"align\":\"center\"},{\"font\":{\"name\":\"宋体\",\"bold\":true},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"align\":\"center\"},{\"font\":{\"size\":8}},{\"font\":{\"size\":8},\"align\":\"center\"},{\"font\":{\"size\":8},\"align\":\"right\"},{\"font\":{\"size\":10},\"align\":\"right\"},{\"font\":{\"size\":10},\"align\":\"right\",\"color\":\"#7f7f7f\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"format\":\"date2\"},{\"format\":\"date2\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"format\":\"date\"},{\"format\":\"date\"},{\"font\":{\"name\":\"宋体\",\"size\":9},\"color\":\"#595959\",\"valign\":\"bottom\"},{\"align\":\"center\",\"font\":{\"bold\":true}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16},\"valign\":\"bottom\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":16},\"1\":{\"width\":103},\"2\":{\"width\":156},\"3\":{\"width\":51},\"4\":{\"width\":96},\"5\":{\"width\":61},\"6\":{\"width\":106},\"7\":{\"width\":115},\"8\":{\"width\":135},\"len\":50},\"merges\":[\"B3:E3\",\"B14:C14\",\"C6:G6\",\"C5:G5\",\"C7:H7\",\"C8:D8\",\"F8:H8\",\"C9:H9\",\"D14:H14\",\"C10:D10\",\"F10:H10\",\"C11:D11\",\"F11:H11\",\"C13:D13\",\"C12:D12\",\"F12:H12\",\"F13:H13\",\"C15:E15\",\"G15:H15\",\"F16:H16\",\"C16:D16\",\"B17:H17\",\"H4:H6\",\"B1:E2\",\"F1:H1\",\"F2:H2\"]}', NULL, 'https://static.jeecg.com/designreport/images/未标题-1_1608118350039.png', 'admin', '2020-12-14 14:28:04', 'admin', '2021-02-03 13:58:47', 0, NULL, NULL, 1, 762, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1338744112815411200', '20201215151426', '简单条件查询报表', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"area\":false,\"printElWidth\":718,\"excel_config_id\":\"1338744112815411200\",\"printElHeight\":1047,\"rows\":{\"1\":{\"cells\":{\"1\":{\"text\":\"职务\",\"style\":51},\"2\":{\"text\":\"雇员ID\",\"style\":51},\"3\":{\"text\":\"姓名\",\"style\":51},\"4\":{\"text\":\"性别\",\"style\":51},\"5\":{\"text\":\"雇佣日期\",\"style\":51},\"6\":{\"text\":\"家庭电话\",\"style\":51},\"7\":{\"text\":\"出生日期\",\"style\":51},\"8\":{\"text\":\"户口所在地\",\"style\":51},\"9\":{\"text\":\"联系地址\",\"style\":51},\"10\":{\"text\":\"紧急联系人\",\"style\":52}},\"height\":37},\"2\":{\"cells\":{\"0\":{\"style\":18},\"1\":{\"style\":21,\"text\":\"#{jdcx.group(update_by)}\",\"aggregate\":\"group\"},\"2\":{\"style\":21,\"text\":\"#{jdcx.id}\"},\"3\":{\"style\":21,\"text\":\"#{jdcx.name}\"},\"4\":{\"style\":21,\"text\":\"#{jdcx.sex}\"},\"5\":{\"style\":24,\"text\":\"#{jdcx.gtime}\"},\"6\":{\"style\":21,\"text\":\"#{jdcx.jphone}\"},\"7\":{\"style\":24,\"text\":\"#{jdcx.birth}\"},\"8\":{\"style\":21,\"text\":\"#{jdcx.hukou}\"},\"9\":{\"style\":21,\"text\":\"#{jdcx.laddress}\"},\"10\":{\"style\":56,\"text\":\"#{jdcx.jperson}\"},\"11\":{\"style\":18},\"12\":{\"style\":18},\"13\":{\"style\":18},\"14\":{\"style\":18},\"15\":{\"style\":18},\"16\":{\"style\":18},\"17\":{\"style\":18},\"18\":{\"style\":18},\"19\":{\"style\":18},\"20\":{\"style\":18},\"21\":{\"style\":18},\"22\":{\"style\":18},\"23\":{\"style\":18},\"24\":{\"style\":18},\"25\":{\"style\":18},\"26\":{\"style\":18},\"27\":{\"style\":18},\"28\":{\"style\":18},\"29\":{\"style\":18},\"30\":{\"style\":18},\"31\":{\"style\":18},\"32\":{\"style\":18},\"33\":{\"style\":18},\"34\":{\"style\":18},\"35\":{\"style\":18},\"36\":{\"style\":18},\"37\":{\"style\":18},\"38\":{\"style\":18},\"39\":{\"style\":18},\"40\":{\"style\":18},\"41\":{\"style\":18},\"42\":{\"style\":18},\"43\":{\"style\":18},\"44\":{\"style\":18},\"45\":{\"style\":18},\"46\":{\"style\":18},\"47\":{\"style\":18},\"48\":{\"style\":18}},\"height\":34},\"3\":{\"cells\":{\"0\":{\"style\":39},\"1\":{\"style\":39},\"2\":{\"style\":39},\"3\":{\"style\":39},\"4\":{\"style\":39},\"5\":{\"style\":39},\"6\":{\"style\":39},\"7\":{\"style\":39},\"8\":{\"style\":39},\"9\":{\"style\":39},\"10\":{\"style\":39},\"11\":{\"style\":39},\"12\":{\"style\":39},\"13\":{\"style\":39},\"14\":{\"style\":39},\"15\":{\"style\":39},\"16\":{\"style\":39},\"17\":{\"style\":39},\"18\":{\"style\":39},\"19\":{\"style\":39},\"20\":{\"style\":39},\"21\":{\"style\":39},\"22\":{\"style\":39},\"23\":{\"style\":39},\"24\":{\"style\":39}}},\"4\":{\"cells\":{\"1\":{\"text\":\"备注：\",\"style\":62},\"2\":{\"style\":63,\"text\":\" \"},\"3\":{\"style\":63,\"text\":\" \"},\"4\":{\"style\":63,\"text\":\" \"},\"5\":{\"style\":63,\"text\":\" \"},\"6\":{\"style\":63,\"text\":\" \"},\"7\":{\"style\":64,\"text\":\" \"}}},\"5\":{\"cells\":{\"1\":{\"text\":\"1、支持模糊查询，需要输入 “*+字符串”或 “字符串+* ”或“*+字符串+*”，如：张* / *丽 / *亚*；\",\"style\":65,\"merge\":[0,6]}}},\"6\":{\"cells\":{\"1\":{\"text\":\"2、以上“出生日期”为时间类型；\",\"style\":65,\"merge\":[0,6]}}},\"7\":{\"cells\":{\"1\":{\"text\":\"3、以上“雇佣日期”为日期类型\",\"style\":65,\"merge\":[0,6]}}},\"8\":{\"cells\":{\"1\":{\"text\":\"4、以上“姓名”为字符串类型，支持精准查询和模糊查询；\",\"style\":67,\"merge\":[0,6]}}},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"groupField\":\"jdcx.update_by\",\"freeze\":\"A1\",\"dataRectWidth\":1242,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"bgcolor\":\"#5b9cd6\"},{\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"color\":\"#ffffff\"},{\"align\":\"center\"},{\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"align\":\"center\"},{\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"align\":\"center\"},{\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\"},{\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8}},{\"font\":{\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9}},{\"font\":{\"size\":9},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":9},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9},\"align\":\"left\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"align\":\"left\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"align\":\"center\",\"format\":\"date\"},{\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"name\":\"宋体\"}},{\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"left\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\",\"format\":\"date\"},{\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"left\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\",\"format\":\"date\"},{\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\"}},{\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"left\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"format\":\"date\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"format\":\"date2\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"format\":\"normal\"},{\"align\":\"center\",\"bgcolor\":\"#5b9cd6\"},{\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\",\"font\":{\"size\":9}},{\"border\":{\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"]}},{\"border\":{\"top\":[\"thin\",\"#000100\"]}},{\"border\":{\"top\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"top\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"top\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"宋体\"}},{\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"align\":\"center\",\"format\":\"number\"}],\"validations\":[],\"isGroup\":true,\"cols\":{\"0\":{\"width\":40},\"1\":{\"width\":88},\"2\":{\"width\":86},\"3\":{\"width\":97},\"4\":{\"width\":67},\"5\":{\"width\":103},\"6\":{\"width\":115},\"7\":{\"width\":90},\"8\":{\"width\":239},\"9\":{\"width\":217},\"len\":50},\"merges\":[\"B6:H6\",\"B7:H7\",\"B8:H8\",\"B9:H9\"]}', NULL, 'https://static.jeecg.com/designreport/images/QQ截图20201216112919_1608089379396.png', 'admin', '2020-12-15 15:14:27', 'admin', '2021-02-03 13:58:44', 0, NULL, NULL, 1, 1053, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1338769064067076098', '202012151514266124', '多选条件查询报表', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"area\":false,\"printElWidth\":718,\"excel_config_id\":\"1338769064067076098\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{\"0\":{\"style\":49},\"1\":{\"style\":49},\"2\":{\"style\":49},\"3\":{\"style\":49},\"4\":{\"style\":49},\"5\":{\"style\":49},\"6\":{\"style\":49},\"7\":{\"style\":49},\"8\":{\"style\":49},\"9\":{\"style\":49},\"10\":{\"style\":49},\"11\":{\"style\":49},\"12\":{\"style\":49},\"13\":{\"style\":49},\"14\":{\"style\":49},\"15\":{\"style\":49},\"16\":{\"style\":49},\"17\":{\"style\":49},\"18\":{\"style\":49},\"19\":{\"style\":49},\"20\":{\"style\":49},\"21\":{\"style\":49},\"22\":{\"style\":49},\"23\":{\"style\":49},\"24\":{\"style\":49},\"25\":{\"style\":49}}},\"1\":{\"cells\":{\"0\":{\"style\":50},\"1\":{\"text\":\"职务\",\"style\":51},\"2\":{\"text\":\"雇员ID\",\"style\":51},\"3\":{\"text\":\"姓名\",\"style\":51},\"4\":{\"style\":51,\"text\":\"性别\"},\"5\":{\"text\":\"雇佣日期\",\"style\":51},\"6\":{\"text\":\"家庭电话\",\"style\":51},\"7\":{\"text\":\"出生日期\",\"style\":51},\"8\":{\"text\":\"户口所在地\",\"style\":51},\"9\":{\"text\":\"联系地址\",\"style\":51},\"10\":{\"text\":\"紧急联系人\",\"style\":51},\"11\":{\"style\":50},\"12\":{\"style\":50},\"13\":{\"style\":50},\"14\":{\"style\":50},\"15\":{\"style\":50},\"16\":{\"style\":50},\"17\":{\"style\":50},\"18\":{\"style\":50},\"19\":{\"style\":50},\"20\":{\"style\":50},\"21\":{\"style\":50},\"22\":{\"style\":50},\"23\":{\"style\":50},\"24\":{\"style\":50},\"25\":{\"style\":50}},\"height\":46},\"2\":{\"cells\":{\"0\":{\"style\":52},\"1\":{\"text\":\"#{pop.group(update_by)}\",\"style\":53,\"aggregate\":\"group\"},\"2\":{\"text\":\"#{pop.group(id)}\",\"style\":54,\"aggregate\":\"group\"},\"3\":{\"text\":\"#{pop.group(name)}\",\"style\":54,\"aggregate\":\"group\"},\"4\":{\"text\":\"#{pop.sex}\",\"style\":55},\"5\":{\"text\":\"#{pop.gtime}\",\"style\":56},\"6\":{\"text\":\"#{pop.jphone}\",\"style\":57},\"7\":{\"text\":\"#{pop.birth}\",\"style\":56},\"8\":{\"text\":\"#{pop.hukou}\",\"style\":58},\"9\":{\"text\":\"#{pop.laddress}\",\"style\":57},\"10\":{\"text\":\"#{pop.jperson}\",\"style\":57},\"11\":{\"style\":52},\"12\":{\"style\":52},\"13\":{\"style\":52},\"14\":{\"style\":52},\"15\":{\"style\":52},\"16\":{\"style\":52},\"17\":{\"style\":52},\"18\":{\"style\":52},\"19\":{\"style\":52},\"20\":{\"style\":52},\"21\":{\"style\":52},\"22\":{\"style\":52},\"23\":{\"style\":52},\"24\":{\"style\":52},\"25\":{\"style\":52}},\"isDrag\":true,\"height\":35},\"5\":{\"cells\":{\"2\":{\"text\":\"\"}},\"isDrag\":true},\"len\":99},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"groupField\":\"pop.update_by\",\"freeze\":\"A1\",\"dataRectWidth\":1494,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"bgcolor\":\"#5b9cd6\"},{\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"color\":\"#ffffff\"},{\"align\":\"center\"},{\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"align\":\"center\"},{\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"align\":\"center\"},{\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\"},{\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":8}},{\"font\":{\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9}},{\"font\":{\"size\":9},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":9},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9},\"align\":\"left\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"align\":\"left\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9},\"align\":\"center\",\"format\":\"date\"},{\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"name\":\"宋体\"}},{\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"left\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\",\"format\":\"date\"},{\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#f1f9f6\",\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ddefe8\",\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"left\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\",\"format\":\"date\"},{\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#bdd7ee\",\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#deeaf6\",\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ffffff\",\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":10,\"name\":\"宋体\"},\"align\":\"center\",\"format\":\"normal\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#deeaf6\",\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#bdd7ee\",\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ffffff\",\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"宋体\"},\"align\":\"center\",\"format\":\"normal\"},{\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\"}},{\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"name\":\"Microsoft YaHei\"}},{\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#deeaf6\",\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#bdd7ee\",\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#ffffff\",\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"format\":\"date\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"format\":\"normal\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"font\":{\"size\":9,\"name\":\"Microsoft YaHei\"},\"align\":\"center\",\"format\":\"date2\"}],\"validations\":[],\"isGroup\":true,\"cols\":{\"0\":{\"width\":48},\"1\":{\"width\":107},\"3\":{\"width\":91},\"4\":{\"width\":142},\"5\":{\"width\":130},\"6\":{\"width\":131},\"7\":{\"width\":235},\"8\":{\"width\":230},\"9\":{\"width\":148},\"10\":{\"width\":132},\"len\":50},\"merges\":[]}', NULL, 'https://static.jeecg.com/designreport/images/QQ截图20201216185224_1608116008543.png', 'admin', '2020-12-15 16:53:13', 'admin', '2021-02-03 13:58:41', 0, NULL, NULL, 1, 901, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1347373863746539520', '20210108104603', '实习证明', NULL, NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":{\"sri\":16,\"sci\":5,\"eri\":16,\"eci\":5,\"width\":147,\"height\":25},\"excel_config_id\":\"1347373863746539520\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10,\"layout\":\"portrait\"},\"rows\":{\"0\":{\"cells\":{\"0\":{\"text\":\"\"},\"1\":{\"text\":\"\"}}},\"1\":{\"cells\":{\"0\":{\"text\":\"\"}}},\"3\":{\"cells\":{\"2\":{\"text\":\"\",\"rendered\":\"\"}}},\"5\":{\"cells\":{},\"height\":29},\"6\":{\"cells\":{\"2\":{\"text\":\"\",\"style\":2}},\"height\":34},\"7\":{\"cells\":{\"2\":{\"merge\":[0,4],\"text\":\"实习证明\",\"style\":2}},\"height\":41},\"8\":{\"cells\":{\"1\":{\"text\":\"\",\"style\":3},\"2\":{\"text\":\"\"}}},\"9\":{\"cells\":{\"1\":{\"text\":\"\",\"style\":3},\"2\":{\"text\":\"\",\"style\":3},\"3\":{\"text\":\"\"}},\"isDrag\":true,\"height\":33},\"10\":{\"cells\":{\"2\":{\"text\":\"${tt.name}\",\"style\":11},\"3\":{\"text\":\"同学在我公司与 2020年4月1日 至 2020年5月1日 实习。\",\"style\":19,\"merge\":[0,3],\"height\":34}},\"height\":34},\"11\":{\"cells\":{},\"height\":28},\"12\":{\"cells\":{\"1\":{\"text\":\"\",\"style\":6},\"2\":{\"style\":13,\"text\":\"${tt.pingjia}\",\"merge\":[3,4],\"height\":129}},\"height\":36},\"13\":{\"cells\":{},\"height\":29},\"14\":{\"cells\":{},\"height\":33},\"15\":{\"cells\":{},\"height\":31},\"16\":{\"cells\":{}},\"17\":{\"cells\":{\"1\":{\"text\":\"\"},\"2\":{\"text\":\"特此证明！\",\"style\":12}}},\"20\":{\"cells\":{\"2\":{\"text\":\"\"},\"3\":{\"text\":\"\",\"style\":3},\"4\":{\"text\":\"\"}}},\"21\":{\"cells\":{\"4\":{\"text\":\"\"}}},\"22\":{\"cells\":{\"3\":{\"text\":\"\",\"style\":3},\"4\":{\"text\":\"证明人：\",\"style\":11},\"5\":{\"text\":\"${tt.lingdao}\",\"style\":12}}},\"23\":{\"cells\":{\"4\":{\"text\":\"\"},\"5\":{\"text\":\"${tt.shijian}\",\"style\":15}}},\"len\":100},\"dbexps\":[],\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":576,\"displayConfig\":{},\"background\":{\"path\":\"https://static.jeecg.com/designreport/images/11_1611283832037.png\",\"repeat\":\"no-repeat\",\"width\":\"\",\"height\":\"\"},\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":14}},{\"align\":\"center\",\"font\":{\"size\":16}},{\"align\":\"right\"},{\"align\":\"left\"},{\"align\":\"left\",\"valign\":\"top\"},{\"align\":\"left\",\"valign\":\"top\",\"textwrap\":true},{\"font\":{\"size\":16}},{\"align\":\"left\",\"valign\":\"top\",\"textwrap\":false},{\"textwrap\":false},{\"textwrap\":true},{\"align\":\"right\",\"font\":{\"size\":12}},{\"font\":{\"size\":12}},{\"align\":\"left\",\"valign\":\"top\",\"textwrap\":true,\"font\":{\"size\":12}},{\"textwrap\":true,\"font\":{\"size\":12}},{\"align\":\"left\",\"font\":{\"size\":12}},{\"font\":{\"size\":12},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":14}},{\"font\":{\"size\":10}},{\"textwrap\":false,\"font\":{\"size\":12}}],\"validations\":[],\"cols\":{\"0\":{\"width\":69},\"1\":{\"width\":41},\"4\":{\"width\":119},\"5\":{\"width\":147},\"6\":{\"width\":31},\"len\":50},\"merges\":[\"C8:G8\",\"D11:G11\",\"C13:G16\"]}', NULL, 'https://static.jeecg.com/designreport/images/未标题-1_1610074948259.png', 'admin', '2021-01-08 10:46:04', 'admin', '2021-04-05 18:47:08', 0, NULL, NULL, 1, 122, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1347454742040809472', '20210108161240', '实例：年度各月份佣金收入', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"area\":false,\"printElWidth\":718,\"excel_config_id\":\"1347454742040809472\",\"printElHeight\":1047,\"rows\":{\"1\":{\"cells\":{\"1\":{\"text\":\" \",\"virtual\":\"pZTpI3BKFw0lh6D7\"},\"2\":{\"text\":\"年度各月份佣金收入\",\"style\":23,\"merge\":[0,3],\"virtual\":\"pZTpI3BKFw0lh6D7\"},\"3\":{\"style\":24},\"4\":{\"style\":24},\"5\":{\"style\":24},\"6\":{\"text\":\" \"}},\"height\":37},\"2\":{\"cells\":{\"1\":{\"text\":\" \"},\"2\":{\"text\":\" \"},\"3\":{\"text\":\" \"},\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"}}},\"4\":{\"cells\":{\"1\":{\"text\":\"查询年度：2019\"},\"4\":{\"text\":\"查询机构：总公司\"},\"6\":{\"text\":\"单位：元\"}}},\"6\":{\"cells\":{\"1\":{\"text\":\"月份\",\"style\":12},\"2\":{\"text\":\"佣金/主营业收入\",\"style\":12},\"3\":{\"text\":\"累计\",\"style\":12},\"4\":{\"text\":\"历史最低水平\",\"style\":12},\"5\":{\"text\":\"历史平均水平\",\"style\":12},\"6\":{\"text\":\"历史最高水平\",\"style\":12}}},\"7\":{\"cells\":{\"1\":{\"text\":\"#{tmp_report_data_1.monty}\",\"style\":0},\"2\":{\"text\":\"#{tmp_report_data_1.main_income}\",\"style\":0},\"3\":{\"text\":\"#{tmp_report_data_1.total}\",\"style\":18},\"4\":{\"text\":\"#{tmp_report_data_1.his_lowest}\",\"style\":0},\"5\":{\"text\":\"#{tmp_report_data_1.his_average}\",\"style\":0},\"6\":{\"text\":\"#{tmp_report_data_1.his_highest}\",\"style\":0}},\"isDrag\":true},\"9\":{\"cells\":{\"1\":{\"merge\":[1,1]}}},\"len\":99},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":678,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":true}},{\"font\":{\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":false}},{\"font\":{\"bold\":false}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":true},\"align\":\"center\"},{\"font\":{\"bold\":true},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":true,\"size\":15},\"align\":\"center\"},{\"font\":{\"bold\":true,\"size\":15},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#01b0f1\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#33CCCC\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#33CCCC\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#33CCCC\",\"align\":\"left\"},{\"font\":{\"bold\":true,\"size\":16}},{\"font\":{\"bold\":true,\"size\":24}},{\"font\":{\"bold\":true,\"size\":22}},{\"font\":{\"bold\":true,\"size\":22},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"format\":\"usd\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"format\":\"rmb\"},{\"font\":{\"bold\":true,\"name\":\"黑体\"}},{\"font\":{\"bold\":true,\"name\":\"黑体\",\"size\":22}},{\"font\":{\"bold\":true,\"name\":\"宋体\",\"size\":22}},{\"font\":{\"bold\":true,\"name\":\"楷体\",\"size\":22}},{\"font\":{\"bold\":true,\"name\":\"楷体\",\"size\":22},\"align\":\"center\"},{\"align\":\"center\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":29},\"1\":{\"width\":111},\"2\":{\"width\":116},\"4\":{\"width\":122},\"len\":50},\"merges\":[\"B10:C11\",\"C2:F2\"],\"imgList\":[{\"row\":1,\"col\":1,\"width\":\"148\",\"height\":\"56\",\"src\":\"https://static.jeecg.com/designreport/images/kunlunlog_1610591367645.png\",\"layer_id\":\"pZTpI3BKFw0lh6D7\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[1,1],[1,2]]}]}', NULL, NULL, 'admin', '2021-01-08 16:12:40', 'admin', '2021-02-03 13:58:38', 0, NULL, NULL, 1, 50, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1347459370216198144', '20210108164121', '实例:来源收入统计', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"chartList\":[{\"row\":1,\"col\":1,\"width\":\"624\",\"height\":\"281\",\"config\":\"{\\\"legend\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":\\\"12\\\"},\\\"top\\\":\\\"top\\\",\\\"left\\\":\\\"right\\\",\\\"orient\\\":\\\"vertical\\\",\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"中国石油全资（集团所属）\\\",\\\"中国石油全资（股份所属）\\\",\\\"中石油控股或有控股权\\\",\\\"中石油参股\\\",\\\"非中石油\\\"],\\\"show\\\":true},\\\"series\\\":[{\\\"isRose\\\":false,\\\"data\\\":[{\\\"name\\\":\\\"中国石油全资（集团所属）\\\",\\\"value\\\":38460270.57,\\\"itemStyle\\\":{\\\"color\\\":\\\"#E46C8A\\\"}},{\\\"name\\\":\\\"中国石油全资（股份所属）\\\",\\\"value\\\":227595.77,\\\"itemStyle\\\":{\\\"color\\\":\\\"#FCDE43\\\"}},{\\\"name\\\":\\\"中石油控股或有控股权\\\",\\\"value\\\":679926.75,\\\"itemStyle\\\":{\\\"color\\\":\\\"#01A8E1\\\"}},{\\\"name\\\":\\\"中石油参股\\\",\\\"value\\\":72062.75,\\\"itemStyle\\\":{\\\"color\\\":\\\"#99CC00\\\"}},{\\\"name\\\":\\\"非中石油\\\",\\\"value\\\":1698597.62,\\\"itemStyle\\\":{\\\"color\\\":\\\"#800080\\\"}}],\\\"isRadius\\\":false,\\\"roseType\\\":\\\"\\\",\\\"notCount\\\":false,\\\"center\\\":[320,180],\\\"name\\\":\\\"访问来源\\\",\\\"minAngle\\\":0,\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"outside\\\",\\\"textStyle\\\":{\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"pie\\\",\\\"radius\\\":\\\"55%\\\",\\\"autoSort\\\":false}],\\\"tooltip\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"},\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true},\\\"title\\\":{\\\"show\\\":true,\\\"top\\\":5,\\\"text\\\":\\\"来源收入统计\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#c23531\\\",\\\"fontWeight\\\":\\\"bolder\\\",\\\"fontSize\\\":18},\\\"left\\\":\\\"center\\\",\\\"padding\\\":[5,20,5,10]},\\\"backgroundColor\\\":\\\"#fff\\\"}\",\"url\":\"\",\"extData\":{\"dataType\":\"sql\",\"apiStatus\":\"\",\"apiUrl\":\"\",\"dataId\":\"4af57d343f1d6521b71b85097b580786\",\"axisX\":\"biz_income\",\"axisY\":\"total\",\"series\":\"\",\"yText\":\"total\",\"xText\":\"biz_income\",\"dbCode\":\"tmp_report_data_income\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"pie.simple\",\"id\":\"\"},\"layer_id\":\"nVUy533exgQ70OPb\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[1,1],[1,2],[1,3],[1,4],[1,5],[1,6],[1,7],[1,8]]}],\"area\":{\"sri\":8,\"sci\":5,\"eri\":8,\"eci\":5,\"width\":63,\"height\":25},\"excel_config_id\":\"1347459370216198144\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"1\":{\"cells\":{\"1\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"2\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"3\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"4\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"5\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"6\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"7\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"8\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"}}},\"3\":{\"cells\":{}},\"16\":{\"cells\":{\"1\":{\"text\":\"业务来源\",\"style\":1},\"2\":{\"text\":\"保险经纪佣金费\",\"style\":1},\"3\":{\"text\":\"风险咨询费\",\"style\":1},\"4\":{\"text\":\"承保公证评估费\",\"style\":1},\"5\":{\"text\":\"保险公证费\",\"style\":1},\"6\":{\"text\":\"投标咨询费\",\"style\":1},\"7\":{\"text\":\"内控咨询费\",\"style\":1},\"8\":{\"text\":\"总计\",\"style\":1}}},\"17\":{\"cells\":{\"1\":{\"text\":\"#{tmp_report_data_income.biz_income}\",\"style\":0},\"2\":{\"text\":\"#{tmp_report_data_income.bx_jj_yongjin}\",\"style\":0},\"3\":{\"text\":\"#{tmp_report_data_income.bx_zx_money}\",\"style\":0},\"4\":{\"text\":\"#{tmp_report_data_income.chengbao_gz_money}\",\"style\":0},\"5\":{\"text\":\"#{tmp_report_data_income.bx_gg_moeny}\",\"style\":0},\"6\":{\"text\":\"#{tmp_report_data_income.tb_zx_money}\",\"style\":0},\"7\":{\"text\":\"#{tmp_report_data_income.neikong_zx_money}\",\"style\":0},\"8\":{\"text\":\"#{tmp_report_data_income.total}\",\"style\":0}},\"isDrag\":true,\"height\":24},\"len\":58},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":702,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#33CCCC\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":16},\"1\":{\"width\":105},\"2\":{\"width\":119},\"3\":{\"width\":87},\"4\":{\"width\":61},\"5\":{\"width\":63},\"6\":{\"width\":60},\"7\":{\"width\":91},\"len\":50},\"merges\":[]}', NULL, NULL, 'admin', '2021-01-08 16:41:21', 'admin', '2021-04-01 02:36:13', 0, NULL, NULL, 1, 53, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1352160857479581696', '20210121154924', 'redis', NULL, NULL, 'chartinfo', '{\"loopBlockList\":[],\"chartList\":[{\"row\":1,\"col\":7,\"width\":\"551\",\"height\":\"350\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#211F1E\\\",\\\"fontSize\\\":12}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#211E1E\\\"}},\\\"show\\\":false,\\\"name\\\":\\\"数量\\\",\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false}},\\\"xAxis\\\":{\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#171515\\\",\\\"fontSize\\\":12},\\\"rotate\\\":0,\\\"interval\\\":0},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#171515\\\"}},\\\"data\\\":[\\\"15:02:38\\\",\\\"15:02:39\\\",\\\"15:02:40\\\",\\\"15:02:41\\\",\\\"15:02:42\\\"],\\\"show\\\":true,\\\"name\\\":\\\"时间\\\"},\\\"grid\\\":{\\\"top\\\":60,\\\"left\\\":60,\\\"bottom\\\":60,\\\"right\\\":60},\\\"series\\\":[{\\\"areaStyle\\\":{\\\"color\\\":\\\"rgba(231,69,193,1)\\\",\\\"opacity\\\":0.2},\\\"data\\\":[59,59,59,59,59],\\\"showSymbol\\\":true,\\\"lineStyle\\\":{\\\"width\\\":5},\\\"symbolSize\\\":5,\\\"isArea\\\":true,\\\"name\\\":\\\"销量\\\",\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(241,71,214,1)\\\"},\\\"step\\\":false,\\\"label\\\":{\\\"show\\\":true,\\\"position\\\":\\\"top\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"line\\\",\\\"smooth\\\":true}],\\\"tooltip\\\":{\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":18}},\\\"title\\\":{\\\"show\\\":true,\\\"top\\\":0,\\\"text\\\":\\\"redis数量\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#9031C2\\\",\\\"fontWeight\\\":\\\"bolder\\\",\\\"fontSize\\\":18},\\\"left\\\":\\\"center\\\",\\\"padding\\\":[5,20,5,10]}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"d4a29dfda94357308faf62be2b94db08\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"keysSizeForReport\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"line.area\",\"id\":\"NbjJrEsYcliaQRGO\"},\"layer_id\":\"NbjJrEsYcliaQRGO\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[1,7],[1,8],[1,9],[1,10],[1,11],[1,12]]},{\"row\":1,\"col\":1,\"width\":\"597\",\"height\":\"350\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#2692DD\\\",\\\"fontSize\\\":12}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#469BDC\\\"}},\\\"show\\\":false,\\\"name\\\":\\\"内存（kb）\\\",\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false}},\\\"xAxis\\\":{\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#00FFF2\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#398DD3\\\",\\\"fontSize\\\":12},\\\"rotate\\\":0,\\\"interval\\\":0},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#1E88D0\\\"}},\\\"data\\\":[\\\"15:02:38\\\",\\\"15:02:39\\\",\\\"15:02:40\\\",\\\"15:02:41\\\",\\\"15:02:42\\\"],\\\"show\\\":true,\\\"name\\\":\\\"时间\\\"},\\\"grid\\\":{\\\"top\\\":60,\\\"left\\\":60,\\\"bottom\\\":60,\\\"right\\\":60},\\\"series\\\":[{\\\"areaStyle\\\":{\\\"color\\\":\\\"#74BCFF\\\",\\\"opacity\\\":0.3},\\\"data\\\":[875,875,875,875,875],\\\"showSymbol\\\":true,\\\"lineStyle\\\":{\\\"width\\\":5},\\\"symbolSize\\\":5,\\\"isArea\\\":true,\\\"name\\\":\\\"销量\\\",\\\"itemStyle\\\":{\\\"color\\\":\\\"#1890FF\\\"},\\\"step\\\":false,\\\"label\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"},\\\"show\\\":true,\\\"position\\\":\\\"top\\\"},\\\"type\\\":\\\"line\\\",\\\"smooth\\\":true}],\\\"tooltip\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":18},\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true},\\\"title\\\":{\\\"show\\\":true,\\\"top\\\":5,\\\"text\\\":\\\"redis内存占用情况\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#4C87E4\\\",\\\"fontWeight\\\":\\\"bolder\\\",\\\"fontSize\\\":18},\\\"left\\\":\\\"center\\\",\\\"padding\\\":[5,20,5,10]}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"6a1d22ca4c95e8fab655d3ceed43a84d\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"memoryForReport\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"line.area\",\"id\":\"YW0FQUwafBUTagh3\"},\"layer_id\":\"YW0FQUwafBUTagh3\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[1,1],[1,2],[1,3],[1,4],[1,5],[1,6]]}],\"area\":false,\"printElWidth\":1565,\"excel_config_id\":\"1352160857479581696\",\"printElHeight\":1047,\"rows\":{\"1\":{\"cells\":{\"1\":{\"text\":\" \",\"virtual\":\"YW0FQUwafBUTagh3\",\"style\":19,\"merge\":[0,1]},\"2\":{\"text\":\" \",\"virtual\":\"YW0FQUwafBUTagh3\"},\"3\":{\"style\":19,\"virtual\":\"YW0FQUwafBUTagh3\"},\"4\":{\"style\":19,\"virtual\":\"YW0FQUwafBUTagh3\"},\"5\":{\"style\":19,\"virtual\":\"YW0FQUwafBUTagh3\"},\"6\":{\"style\":19,\"virtual\":\"YW0FQUwafBUTagh3\"},\"7\":{\"text\":\" \",\"virtual\":\"NbjJrEsYcliaQRGO\"},\"8\":{\"text\":\" \",\"virtual\":\"NbjJrEsYcliaQRGO\"},\"9\":{\"text\":\" \",\"virtual\":\"NbjJrEsYcliaQRGO\"},\"10\":{\"text\":\" \",\"virtual\":\"NbjJrEsYcliaQRGO\"},\"11\":{\"text\":\" \",\"virtual\":\"NbjJrEsYcliaQRGO\"},\"12\":{\"text\":\" \",\"virtual\":\"NbjJrEsYcliaQRGO\"}}},\"2\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"3\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"4\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"5\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"6\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"7\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"8\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"9\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"10\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"11\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"12\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"13\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"14\":{\"cells\":{\"1\":{\"style\":19},\"2\":{\"style\":19},\"3\":{\"style\":19},\"4\":{\"style\":19},\"5\":{\"style\":19},\"6\":{\"style\":19},\"7\":{\"text\":\" \"}}},\"17\":{\"cells\":{\"1\":{}}},\"18\":{\"cells\":{\"1\":{\"text\":\"redis详细信息\",\"style\":5,\"merge\":[1,1]}}},\"19\":{\"cells\":{}},\"20\":{\"cells\":{\"1\":{\"text\":\"key\",\"merge\":[0,1],\"style\":46},\"2\":{\"text\":\" \",\"style\":47},\"3\":{\"merge\":[0,1],\"style\":46,\"text\":\"value\"},\"4\":{\"text\":\" \",\"style\":47},\"5\":{\"merge\":[0,9],\"style\":46,\"text\":\"desc\"},\"6\":{\"text\":\" \",\"style\":47},\"7\":{\"text\":\" \",\"style\":47},\"8\":{\"text\":\" \",\"style\":47},\"9\":{\"text\":\" \",\"style\":47},\"10\":{\"text\":\" \",\"style\":47},\"11\":{\"text\":\" \",\"style\":47},\"12\":{\"text\":\" \",\"style\":47},\"13\":{\"text\":\" \",\"style\":47},\"14\":{\"text\":\" \",\"style\":47}}},\"21\":{\"cells\":{\"1\":{\"merge\":[0,1],\"text\":\"#{infoForReport.key}\",\"style\":52},\"2\":{\"text\":\" \",\"style\":53},\"3\":{\"merge\":[0,1],\"text\":\"#{infoForReport.value}\",\"style\":52},\"4\":{\"text\":\" \",\"style\":53},\"5\":{\"text\":\"#{infoForReport.description}\",\"style\":52,\"merge\":[0,9]}}},\"len\":98},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":1500,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"font\":{\"bold\":true}},{\"font\":{\"bold\":true},\"align\":\"center\"},{\"align\":\"center\"},{\"font\":{\"bold\":true,\"size\":18},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":18}},{\"font\":{\"bold\":true,\"size\":14},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":14}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#d8d8d8\"},{\"bgcolor\":\"#d8d8d8\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#d8d8d8\",\"align\":\"center\"},{\"bgcolor\":\"#d8d8d8\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#f2f2f2\",\"align\":\"center\"},{\"bgcolor\":\"#f2f2f2\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#a5a5a5\",\"align\":\"center\"},{\"bgcolor\":\"#a5a5a5\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#bfbfbf\",\"align\":\"center\"},{\"bgcolor\":\"#bfbfbf\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#ffffff\"},{\"bgcolor\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#f2f2f2\"},{\"bgcolor\":\"#f2f2f2\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#5b9cd6\"},{\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#deeaf6\",\"align\":\"center\"},{\"bgcolor\":\"#deeaf6\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#9cc2e6\"},{\"bgcolor\":\"#9cc2e6\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#93d051\",\"align\":\"center\"},{\"bgcolor\":\"#93d051\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#a7d08c\",\"align\":\"center\"},{\"bgcolor\":\"#a7d08c\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#c5e0b3\",\"align\":\"center\"},{\"bgcolor\":\"#c5e0b3\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#deeaf6\"},{\"bgcolor\":\"#deeaf6\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#d5dce4\"},{\"bgcolor\":\"#d5dce4\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#93d051\"},{\"bgcolor\":\"#93d051\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#756f6f\"},{\"bgcolor\":\"#756f6f\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#c5e0b3\"},{\"bgcolor\":\"#c5e0b3\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#a7d08c\"},{\"bgcolor\":\"#a7d08c\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#71ae47\"},{\"bgcolor\":\"#71ae47\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#01b0f1\"},{\"bgcolor\":\"#01b0f1\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#0170c1\"},{\"bgcolor\":\"#0170c1\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#8eaada\"},{\"bgcolor\":\"#8eaada\"}],\"validations\":[],\"cols\":{\"len\":50},\"merges\":[\"D19:E19\",\"F19:M19\",\"D20:E20\",\"F20:M20\",\"B2:C2\",\"B19:C20\",\"B22:C22\",\"D22:E22\",\"B21:C21\",\"D21:E21\",\"F21:O21\",\"F22:O22\"]}', NULL, NULL, 'admin', '2021-01-21 15:49:25', 'admin', '2021-06-01 19:21:17', 1, NULL, NULL, 0, 107, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('1cd9d574d0c42f3915046dc61d9f33bd', '202012171553133795', '企业实时报表副本3795', NULL, NULL, 'chartinfo', '{\"chartList\":[{\"row\":6,\"col\":1,\"width\":\"302\",\"height\":\"337\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"interval\\\":0,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"data\\\":[\\\"江苏\\\",\\\"山东\\\",\\\"安徽\\\",\\\"江西\\\",\\\"河北\\\",\\\"吉林\\\",\\\"黑龙江\\\",\\\"重庆\\\",\\\"广东\\\",\\\"上海\\\",\\\"哈尔滨\\\",\\\"福建\\\",\\\"四川\\\"],\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type\\\":\\\"category\\\"},\\\"xAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#333\\\"}},\\\"show\\\":false,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type \\\":\\\"value\\\"},\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"销售额\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"grid\\\":{\\\"top\\\":20,\\\"left\\\":45,\\\"bottom\\\":16,\\\"right\\\":46},\\\"series\\\":[{\\\"barWidth\\\":13,\\\"data\\\":[100,800,1200,1700,2500,4000,5800,6500,7000,7500,8000,8800,9500],\\\"name\\\":\\\"销售额\\\",\\\"itemStyle\\\":{\\\"barBorderRadius\\\":5,\\\"color\\\":\\\"rgba(67,184,251,1)\\\"},\\\"label\\\":{\\\"show\\\":true,\\\"position\\\":\\\"right\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#689AFB\\\",\\\"fontSize\\\":\\\"10\\\",\\\"fontWeight\\\":\\\"normal\\\"}},\\\"type\\\":\\\"bar\\\",\\\"barMinHeight\\\":2,\\\"typeData\\\":[],\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontWeight\\\":\\\"bolder\\\"}}],\\\"tooltip\\\":{\\\"show\\\":true,\\\"axisPointer\\\":{\\\"type\\\":\\\"shadow\\\"},\\\"trigger\\\":\\\"axis\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":false,\\\"top\\\":5,\\\"text\\\":\\\"销售额省份排名\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontWeight\\\":\\\"normal\\\",\\\"fontSize\\\":\\\"14\\\"},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,20]}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1339491107951640577\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"xiaoshoue\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"bar.multi.horizontal\",\"chartId\":\"pie.doughnut\"},\"layer_id\":\"IFj1lg5S5aNG1wPx\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[6,1],[6,2],[6,3],[6,4]]},{\"row\":6,\"col\":10,\"width\":\"247\",\"height\":\"124\",\"config\":\"{\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"销售额\\\",\\\"其他\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"series\\\":[{\\\"isRose\\\":false,\\\"data\\\":[{\\\"name\\\":\\\"销售额\\\",\\\"value\\\":6000000,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(43,193,254,1)\\\"}},{\\\"name\\\":\\\"其他\\\",\\\"value\\\":3400879,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(42,45,76,0.59)\\\"}}],\\\"isRadius\\\":true,\\\"roseType\\\":\\\"\\\",\\\"notCount\\\":false,\\\"name\\\":\\\"访问来源\\\",\\\"minAngle\\\":0,\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"outside\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"\\\",\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"pie\\\",\\\"radius\\\":[\\\"45%\\\",\\\"55%\\\"],\\\"autoSort\\\":false}],\\\"tooltip\\\":{\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":false,\\\"top\\\":5,\\\"text\\\":\\\"销售进度\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontWeight\\\":\\\"normal\\\",\\\"fontSize\\\":\\\"14\\\"},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,10]}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1339498906765000705\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"xsjd\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"pie.doughnut\",\"chartId\":\"pie.doughnut\"},\"layer_id\":\"Yb2TIGEAxnvN9ITx\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[6,10],[6,11]]},{\"row\":6,\"col\":12,\"width\":\"244\",\"height\":\"128\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"interval\\\":0,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"data\\\":[\\\"北京\\\",\\\"青岛\\\",\\\"合肥\\\",\\\"深圳\\\",\\\"石家庄\\\",\\\"重庆\\\",\\\"保定\\\",\\\"邯郸\\\"],\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type\\\":\\\"category\\\"},\\\"xAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#333\\\"}},\\\"show\\\":false,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type \\\":\\\"value\\\"},\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"销售额\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"grid\\\":{\\\"top\\\":10,\\\"left\\\":49,\\\"bottom\\\":16,\\\"right\\\":45},\\\"series\\\":[{\\\"barWidth\\\":9,\\\"data\\\":[80,500,800,1000,1200,1500,1600,2000],\\\"name\\\":\\\"销售额\\\",\\\"itemStyle\\\":{\\\"barBorderRadius\\\":0,\\\"color\\\":\\\"rgba(146,119,252,1)\\\"},\\\"label\\\":{\\\"show\\\":true,\\\"position\\\":\\\"right\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#689AFB\\\",\\\"fontSize\\\":\\\"10\\\",\\\"fontWeight\\\":\\\"normal\\\"}},\\\"type\\\":\\\"bar\\\",\\\"barMinHeight\\\":2,\\\"typeData\\\":[],\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontWeight\\\":\\\"bolder\\\"}}],\\\"tooltip\\\":{\\\"show\\\":true,\\\"axisPointer\\\":{\\\"type\\\":\\\"shadow\\\"},\\\"trigger\\\":\\\"axis\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":false,\\\"top\\\":5,\\\"text\\\":\\\"销售额城市排名\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontWeight\\\":\\\"normal\\\",\\\"fontSize\\\":\\\"14\\\"},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,20]}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1339495346077728770\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"chengshi\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"bar.multi.horizontal\",\"chartId\":\"bar.multi.horizontal\"},\"layer_id\":\"qQHpevWlqElpRQUl\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[6,12],[6,13],[6,14]]},{\"row\":6,\"col\":15,\"width\":\"230\",\"height\":\"127\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"interval\\\":0,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"data\\\":[\\\"北京\\\",\\\"青岛\\\",\\\"合肥\\\",\\\"深圳\\\",\\\"石家庄\\\",\\\"重庆\\\",\\\"保定\\\",\\\"邯郸\\\"],\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type\\\":\\\"category\\\"},\\\"xAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#333\\\"}},\\\"show\\\":false,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type \\\":\\\"value\\\"},\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"销售额\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"grid\\\":{\\\"top\\\":10,\\\"left\\\":49,\\\"bottom\\\":20,\\\"right\\\":48},\\\"series\\\":[{\\\"barWidth\\\":9,\\\"data\\\":[80,500,800,1000,1200,1500,1600,2000],\\\"name\\\":\\\"销售额\\\",\\\"itemStyle\\\":{\\\"barBorderRadius\\\":0,\\\"color\\\":\\\"rgba(146,119,252,1)\\\"},\\\"label\\\":{\\\"show\\\":true,\\\"position\\\":\\\"right\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#689AFB\\\",\\\"fontSize\\\":\\\"10\\\",\\\"fontWeight\\\":\\\"normal\\\"}},\\\"type\\\":\\\"bar\\\",\\\"barMinHeight\\\":2,\\\"typeData\\\":[],\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontWeight\\\":\\\"bolder\\\"}}],\\\"tooltip\\\":{\\\"show\\\":true,\\\"axisPointer\\\":{\\\"type\\\":\\\"shadow\\\"},\\\"trigger\\\":\\\"axis\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":false,\\\"top\\\":5,\\\"text\\\":\\\"某站点用户访问来源\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#c23531\\\",\\\"fontWeight\\\":\\\"bolder\\\",\\\"fontSize\\\":18},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,20]}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1339495346077728770\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"chengshi\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"bar.multi.horizontal\",\"chartId\":\"bar.multi.horizontal\"},\"layer_id\":\"phTmhkjHLebYlOEQ\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[6,15],[6,16],[6,17],[6,18]]},{\"row\":7,\"col\":5,\"width\":\"430\",\"height\":\"293\",\"config\":\"{\\\"geo\\\":{\\\"map\\\":\\\"china\\\",\\\"zoom\\\":0.5,\\\"label\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"8\\\",\\\"show\\\":true},\\\"itemStyle\\\":{\\\"borderWidth\\\":0.5,\\\"areaColor\\\":\\\"#8284FB\\\",\\\"borderColor\\\":\\\"#000\\\"},\\\"emphasis\\\":{\\\"label\\\":{\\\"color\\\":\\\"#fff\\\"},\\\"itemStyle\\\":{\\\"areaColor\\\":\\\"#4195EF\\\"}},\\\"regions\\\":[],\\\"layoutSize\\\":600,\\\"roam\\\":true,\\\"layoutCenter\\\":[\\\"50%\\\",\\\"50%\\\"]},\\\"series\\\":[{\\\"encode\\\":{\\\"value\\\":[2]},\\\"data\\\":[{\\\"name\\\":\\\"河北\\\",\\\"value\\\":[114.502461,38.045474,279]},{\\\"name\\\":\\\"海南\\\",\\\"value\\\":[110.33119,20.031971,273]},{\\\"name\\\":\\\"山东\\\",\\\"value\\\":[117.000923,36.675807,229]},{\\\"name\\\":\\\"甘肃\\\",\\\"value\\\":[103.823557,36.058039,194]},{\\\"name\\\":\\\"宁夏\\\",\\\"value\\\":[106.278179,38.46637,193]},{\\\"name\\\":\\\"浙江\\\",\\\"value\\\":[120.153576,30.287459,177]},{\\\"name\\\":\\\"湖南\\\",\\\"value\\\":[112.982279,28.19409,119]},{\\\"name\\\":\\\"湖北\\\",\\\"value\\\":[114.298572,30.584355,79]},{\\\"name\\\":\\\"河南\\\",\\\"value\\\":[113.665412,34.757975,67]},{\\\"name\\\":\\\"北京\\\",\\\"value\\\":[116.405285,39.904989,58]},{\\\"name\\\":\\\"天津\\\",\\\"value\\\":[117.190182,39.125596,59]},{\\\"name\\\":\\\"上海\\\",\\\"value\\\":[121.472644,31.231706,63]}],\\\"name\\\":\\\"\\\",\\\"emphasis\\\":{\\\"label\\\":{\\\"show\\\":true}},\\\"itemStyle\\\":{\\\"color\\\":\\\"#FF1205\\\"},\\\"coordinateSystem\\\":\\\"geo\\\",\\\"label\\\":{\\\"formatter\\\":\\\"{b}\\\",\\\"show\\\":false,\\\"position\\\":\\\"right\\\"},\\\"type\\\":\\\"scatter\\\",\\\"symbolSize\\\":5}],\\\"chartType\\\":\\\"map\\\",\\\"tooltip\\\":{\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":false,\\\"top\\\":5,\\\"text\\\":\\\"主要城市空气质量\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#c23531\\\",\\\"fontWeight\\\":\\\"normal\\\",\\\"fontSize\\\":\\\"14\\\"},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,10]}}\",\"url\":\"\",\"extData\":{\"chartType\":\"map.scatter\"},\"layer_id\":\"YTri6J59av4gj1CY\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[7,5],[7,6],[7,7],[7,8]]},{\"row\":14,\"col\":12,\"width\":\"244\",\"height\":\"138\",\"config\":\"{\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"销售额\\\",\\\"其他\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"series\\\":[{\\\"isRose\\\":false,\\\"data\\\":[{\\\"name\\\":\\\"销售额\\\",\\\"value\\\":6000000,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(43,193,254,1)\\\"}},{\\\"name\\\":\\\"其他\\\",\\\"value\\\":3400879,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(42,45,76,0.59)\\\"}}],\\\"isRadius\\\":true,\\\"roseType\\\":\\\"\\\",\\\"notCount\\\":false,\\\"name\\\":\\\"访问来源\\\",\\\"minAngle\\\":0,\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"outside\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"\\\",\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"pie\\\",\\\"radius\\\":[\\\"50%\\\",\\\"60%\\\"],\\\"autoSort\\\":false}],\\\"tooltip\\\":{\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":false,\\\"top\\\":5,\\\"text\\\":\\\"\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#c23531\\\",\\\"fontWeight\\\":\\\"bolder\\\",\\\"fontSize\\\":18},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,10]}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1339498906765000705\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"xsjd\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"pie.doughnut\",\"chartId\":\"pie.doughnut\"},\"layer_id\":\"ARuuHLfjqV9l1tQD\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[14,12],[14,13],[14,14]]},{\"row\":14,\"col\":15,\"width\":\"230\",\"height\":\"139\",\"config\":\"{\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"销售额\\\",\\\"其他\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"series\\\":[{\\\"isRose\\\":false,\\\"data\\\":[{\\\"name\\\":\\\"销售额\\\",\\\"value\\\":6000000,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(43,193,254,1)\\\"}},{\\\"name\\\":\\\"其他\\\",\\\"value\\\":3400879,\\\"itemStyle\\\":{\\\"color\\\":\\\"rgba(42,45,76,0.59)\\\"}}],\\\"isRadius\\\":true,\\\"roseType\\\":\\\"\\\",\\\"notCount\\\":false,\\\"name\\\":\\\"访问来源\\\",\\\"minAngle\\\":0,\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"outside\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"\\\",\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"pie\\\",\\\"radius\\\":[\\\"45%\\\",\\\"55%\\\"],\\\"autoSort\\\":false}],\\\"tooltip\\\":{\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":false,\\\"top\\\":5,\\\"text\\\":\\\"某站点用户访问来源\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#c23531\\\",\\\"fontWeight\\\":\\\"bolder\\\",\\\"fontSize\\\":18},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,10]}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1339498906765000705\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"xsjd\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"pie.doughnut\",\"chartId\":\"\"},\"layer_id\":\"bcrMtWqTd2AJIjLd\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[14,15],[14,16],[14,17],[14,18]]},{\"row\":14,\"col\":10,\"width\":\"244\",\"height\":\"138\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"interval\\\":0,\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"data\\\":[\\\"北京\\\",\\\"青岛\\\",\\\"合肥\\\",\\\"深圳\\\",\\\"石家庄\\\",\\\"重庆\\\",\\\"保定\\\",\\\"邯郸\\\"],\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type\\\":\\\"category\\\"},\\\"xAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#333\\\"}},\\\"show\\\":false,\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false},\\\"type \\\":\\\"value\\\"},\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"销售额\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"left\\\":\\\"center\\\",\\\"show\\\":false,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"grid\\\":{\\\"top\\\":10,\\\"left\\\":49,\\\"bottom\\\":15,\\\"right\\\":45},\\\"series\\\":[{\\\"barWidth\\\":9,\\\"data\\\":[80,500,800,1000,1200,1500,1600,2000],\\\"name\\\":\\\"销售额\\\",\\\"itemStyle\\\":{\\\"barBorderRadius\\\":0,\\\"color\\\":\\\"rgba(146,119,252,1)\\\"},\\\"label\\\":{\\\"show\\\":true,\\\"position\\\":\\\"right\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#698AFB\\\",\\\"fontSize\\\":\\\"10\\\",\\\"fontWeight\\\":\\\"normal\\\"}},\\\"type\\\":\\\"bar\\\",\\\"barMinHeight\\\":2,\\\"typeData\\\":[],\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontWeight\\\":\\\"bolder\\\"}}],\\\"tooltip\\\":{\\\"show\\\":true,\\\"axisPointer\\\":{\\\"type\\\":\\\"shadow\\\"},\\\"trigger\\\":\\\"axis\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":false,\\\"top\\\":5,\\\"text\\\":\\\"某站点用户访问来源\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#c23531\\\",\\\"fontWeight\\\":\\\"bolder\\\",\\\"fontSize\\\":18},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,20]}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1339495346077728770\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"chengshi\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"bar.multi.horizontal\",\"chartId\":\"bar.multi.horizontal\"},\"layer_id\":\"Y1kgYOWBHIVQdSN5\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[14,10],[14,11]]},{\"row\":20,\"col\":1,\"width\":\"743\",\"height\":\"150\",\"config\":\"{\\\"yAxis\\\":{\\\"axisLabel\\\":{\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"name\\\":\\\"\\\",\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false}},\\\"xAxis\\\":{\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"interval\\\":0,\\\"textStyle\\\":{\\\"color\\\":\\\"#FEFEFE\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"data\\\":[\\\"2020-01-09\\\",\\\"2020-01-12\\\",\\\"2020-01-14\\\",\\\"2020-01-16\\\",\\\"2020-01-18\\\"],\\\"axisLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\"}},\\\"show\\\":true,\\\"name\\\":\\\"\\\",\\\"splitLine\\\":{\\\"lineStyle\\\":{\\\"color\\\":\\\"red\\\",\\\"width\\\":1,\\\"type\\\":\\\"solid\\\"},\\\"show\\\":false}},\\\"grid\\\":{\\\"top\\\":53,\\\"left\\\":22,\\\"bottom\\\":37,\\\"right\\\":20},\\\"series\\\":[{\\\"areaStyle\\\":{\\\"color\\\":\\\"#43B8FB\\\",\\\"opacity\\\":0.7},\\\"data\\\":[2,6,7,5,6],\\\"showSymbol\\\":true,\\\"lineStyle\\\":{\\\"width\\\":2},\\\"symbolSize\\\":5,\\\"isArea\\\":true,\\\"name\\\":\\\"销量\\\",\\\"itemStyle\\\":{\\\"color\\\":\\\"#43B8FB\\\"},\\\"step\\\":false,\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"top\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"black\\\",\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"line\\\",\\\"smooth\\\":false}],\\\"tooltip\\\":{\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":\\\"10\\\"}},\\\"title\\\":{\\\"show\\\":true,\\\"top\\\":14,\\\"text\\\":\\\"销售额增速\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#FFFFFF\\\",\\\"fontWeight\\\":\\\"normal\\\",\\\"fontSize\\\":\\\"14\\\"},\\\"left\\\":\\\"left\\\",\\\"padding\\\":[5,20,5,10]}}\",\"url\":\"\",\"extData\":{\"dataType\":\"api\",\"apiStatus\":\"1\",\"dataId\":\"1339538388453195777\",\"axisX\":\"name\",\"axisY\":\"value\",\"series\":\"type\",\"yText\":\"\",\"xText\":\"\",\"dbCode\":\"zhexian\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"line.area\",\"chartId\":\"\"},\"layer_id\":\"uChrZaHYoV04MQpT\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[20,1],[20,2],[20,3],[20,4],[20,5],[20,6],[20,7],[20,8],[20,9]]}],\"area\":{\"sri\":4,\"sci\":5,\"eri\":4,\"eci\":5,\"width\":105,\"height\":38},\"printElWidth\":1800,\"excel_config_id\":\"1339478701846433792\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{}},\"2\":{\"cells\":{\"1\":{\"merge\":[0,17],\"text\":\"企业实时销售数据\",\"style\":3}}},\"3\":{\"cells\":{},\"height\":35},\"4\":{\"cells\":{\"1\":{\"text\":\"  销售额省份排名\",\"style\":32,\"merge\":[0,1],\"virtual\":\"IFj1lg5S5aNG1wPx\"},\"2\":{\"style\":32,\"virtual\":\"IFj1lg5S5aNG1wPx\"},\"5\":{\"text\":\"  销售总额\",\"style\":69},\"10\":{\"text\":\"  销售进度\",\"style\":43},\"11\":{\"text\":\"\",\"style\":43},\"13\":{\"text\":\"  销售额城市排名\",\"style\":32,\"merge\":[0,1]},\"14\":{\"style\":32},\"15\":{\"text\":\"  个人业绩排名\",\"style\":32,\"merge\":[0,1]},\"16\":{\"style\":32},\"17\":{\"text\":\"\",\"style\":32,\"merge\":[0,1]},\"18\":{\"style\":32}},\"height\":38},\"5\":{\"cells\":{\"1\":{\"text\":\"   Sales ranking points\",\"virtual\":\"IFj1lg5S5aNG1wPx\",\"style\":62,\"merge\":[0,1]},\"2\":{\"style\":31},\"5\":{\"text\":\"12436025\",\"style\":52,\"merge\":[1,0]},\"6\":{\"merge\":[1,0],\"text\":\"元\",\"style\":22},\"10\":{\"text\":\"   Sales progress\",\"style\":33},\"11\":{\"text\":\"\",\"virtual\":\"Yb2TIGEAxnvN9ITx\",\"style\":33},\"13\":{\"text\":\"   Sales ranking\",\"virtual\":\"qQHpevWlqElpRQUl\",\"style\":31},\"14\":{\"style\":32},\"15\":{\"text\":\"   Personal  ranking\",\"style\":62,\"merge\":[0,1]},\"16\":{\"style\":62},\"17\":{\"text\":\"\",\"style\":62,\"merge\":[0,1]},\"18\":{\"style\":62}},\"height\":24},\"6\":{\"cells\":{\"1\":{\"text\":\"\",\"merge\":[0,1],\"style\":31,\"virtual\":\"IFj1lg5S5aNG1wPx\"},\"2\":{\"style\":31,\"virtual\":\"IFj1lg5S5aNG1wPx\"},\"3\":{\"text\":\" \",\"virtual\":\"IFj1lg5S5aNG1wPx\"},\"4\":{\"text\":\" \",\"virtual\":\"IFj1lg5S5aNG1wPx\"},\"5\":{\"style\":53},\"6\":{\"style\":22},\"10\":{\"text\":\" \",\"virtual\":\"Yb2TIGEAxnvN9ITx\"},\"11\":{\"text\":\"\",\"style\":33,\"virtual\":\"Yb2TIGEAxnvN9ITx\"},\"12\":{\"text\":\" \",\"virtual\":\"qQHpevWlqElpRQUl\"},\"13\":{\"text\":\"\",\"virtual\":\"qQHpevWlqElpRQUl\",\"style\":31},\"14\":{\"text\":\" \",\"virtual\":\"qQHpevWlqElpRQUl\"},\"15\":{\"text\":\" \",\"virtual\":\"phTmhkjHLebYlOEQ\"},\"16\":{\"text\":\" \",\"virtual\":\"phTmhkjHLebYlOEQ\"},\"17\":{\"text\":\" \",\"style\":31,\"virtual\":\"phTmhkjHLebYlOEQ\"},\"18\":{\"text\":\" \",\"virtual\":\"phTmhkjHLebYlOEQ\"}}},\"7\":{\"cells\":{\"5\":{\"style\":53,\"virtual\":\"YTri6J59av4gj1CY\"},\"6\":{\"style\":22,\"virtual\":\"YTri6J59av4gj1CY\"},\"7\":{\"text\":\" \",\"virtual\":\"YTri6J59av4gj1CY\"},\"8\":{\"text\":\" \",\"virtual\":\"YTri6J59av4gj1CY\"}}},\"8\":{\"cells\":{\"5\":{\"style\":18,\"text\":\"\",\"virtual\":\"YTri6J59av4gj1CY\"}}},\"9\":{\"cells\":{\"5\":{\"style\":21,\"text\":\"\"}}},\"10\":{\"cells\":{\"5\":{\"text\":\"\",\"style\":17}}},\"12\":{\"cells\":{\"10\":{\"text\":\"  品类销售排名\",\"style\":43},\"11\":{\"text\":\"\",\"style\":43},\"13\":{\"text\":\"  品类销售额占比\",\"style\":43,\"merge\":[0,1]},\"14\":{\"style\":54},\"15\":{\"text\":\"  一季度销售季度\",\"style\":43,\"merge\":[0,1]},\"16\":{\"style\":54},\"17\":{\"text\":\"\",\"style\":43,\"merge\":[0,1]},\"18\":{\"style\":54}}},\"13\":{\"cells\":{\"10\":{\"text\":\"   Category Sales  ranking\",\"style\":31},\"11\":{\"text\":\"\",\"style\":31},\"13\":{\"text\":\"   Type of Sales \",\"style\":31},\"15\":{\"text\":\"   Quarterly sales progree\",\"style\":58,\"merge\":[0,1]},\"16\":{\"style\":58},\"17\":{\"text\":\"\",\"style\":58,\"merge\":[0,1]},\"18\":{\"style\":58}}},\"14\":{\"cells\":{\"10\":{\"text\":\" \",\"virtual\":\"Y1kgYOWBHIVQdSN5\"},\"11\":{\"text\":\" \",\"virtual\":\"Y1kgYOWBHIVQdSN5\"},\"12\":{\"text\":\" \",\"virtual\":\"ARuuHLfjqV9l1tQD\"},\"13\":{\"text\":\" \",\"virtual\":\"ARuuHLfjqV9l1tQD\"},\"14\":{\"text\":\" \",\"virtual\":\"ARuuHLfjqV9l1tQD\"},\"15\":{\"text\":\" \",\"virtual\":\"bcrMtWqTd2AJIjLd\"},\"16\":{\"text\":\" \",\"virtual\":\"bcrMtWqTd2AJIjLd\"},\"17\":{\"text\":\" \",\"virtual\":\"bcrMtWqTd2AJIjLd\"},\"18\":{\"text\":\" \",\"virtual\":\"bcrMtWqTd2AJIjLd\"}}},\"15\":{\"cells\":{},\"height\":15},\"16\":{\"cells\":{\"11\":{\"text\":\"\",\"style\":43},\"13\":{\"text\":\"\",\"style\":43,\"merge\":[0,1]},\"14\":{\"style\":54},\"17\":{\"text\":\"\",\"style\":43,\"merge\":[0,1]},\"18\":{\"style\":54}}},\"17\":{\"cells\":{\"11\":{\"text\":\"\",\"style\":31},\"13\":{\"text\":\"\",\"style\":31},\"17\":{\"text\":\"\",\"merge\":[0,1],\"style\":58},\"18\":{\"style\":58}}},\"18\":{\"cells\":{}},\"20\":{\"cells\":{\"1\":{\"text\":\" \",\"virtual\":\"uChrZaHYoV04MQpT\"},\"2\":{\"text\":\" \",\"virtual\":\"uChrZaHYoV04MQpT\"},\"3\":{\"text\":\" \",\"virtual\":\"uChrZaHYoV04MQpT\"},\"4\":{\"text\":\" \",\"virtual\":\"uChrZaHYoV04MQpT\"},\"5\":{\"text\":\" \",\"virtual\":\"uChrZaHYoV04MQpT\"},\"6\":{\"text\":\" \",\"virtual\":\"uChrZaHYoV04MQpT\"},\"7\":{\"text\":\" \",\"virtual\":\"uChrZaHYoV04MQpT\"},\"8\":{\"text\":\" \",\"virtual\":\"uChrZaHYoV04MQpT\"},\"9\":{\"text\":\" \",\"virtual\":\"uChrZaHYoV04MQpT\"}},\"height\":39},\"22\":{\"cells\":{\"10\":{\"text\":\"企业经营指标\",\"style\":74},\"11\":{\"text\":\"1201043元\",\"style\":73},\"13\":{\"text\":\"企业经营指标\",\"style\":74},\"14\":{\"text\":\"1201043元\",\"style\":73},\"16\":{\"text\":\"企业经营指标\",\"style\":74},\"17\":{\"text\":\"1201043元\",\"style\":73}}},\"23\":{\"cells\":{\"10\":{\"text\":\"企业经营指标1\",\"style\":74},\"11\":{\"text\":\"1201043元\",\"style\":73},\"13\":{\"text\":\"企业经营指标1\",\"style\":74},\"14\":{\"text\":\"1201043元\",\"style\":73},\"16\":{\"text\":\"企业经营指标1\",\"style\":74},\"17\":{\"text\":\"1201043元\",\"style\":73}}},\"26\":{\"cells\":{},\"height\":33},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":1584,\"background\":{\"path\":\"https://static.jeecg.com/designreport/images/bg55_1608205385382.png\",\"repeat\":\"no-repeat\",\"width\":\"1525\",\"height\":\"700\"},\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"color\":\"#ffffff\"},{\"color\":\"#ffffff\",\"font\":{\"size\":16}},{\"color\":\"#ffffff\",\"font\":{\"size\":16},\"align\":\"center\"},{\"color\":\"#ffffff\",\"font\":{\"size\":18},\"align\":\"center\"},{\"font\":{\"size\":18}},{\"color\":\"#67b1ee\"},{\"color\":\"#67b1ee\",\"font\":{\"size\":14}},{\"color\":\"#67b1ee\",\"font\":{\"size\":12}},{\"font\":{\"size\":14}},{\"font\":{\"size\":18},\"bgcolor\":\"#ffffff\"},{\"font\":{\"size\":18},\"bgcolor\":\"#ffffff\",\"color\":\"#ffffff\"},{\"font\":{\"size\":16},\"bgcolor\":\"#ffffff\",\"color\":\"#ffffff\"},{\"color\":\"#67b1ee\",\"font\":{\"size\":12},\"align\":\"right\"},{\"font\":{\"size\":16},\"bgcolor\":\"#ffffff\",\"color\":\"#ffffff\",\"align\":\"right\"},{\"color\":\"#67b1ee\",\"font\":{\"size\":12},\"align\":\"center\"},{\"font\":{\"size\":16}},{\"font\":{\"size\":16},\"color\":\"#fe0000\"},{\"font\":{\"size\":16},\"color\":\"#fe0000\",\"align\":\"center\"},{\"color\":\"#67b1ee\",\"font\":{\"size\":12},\"align\":\"left\"},{\"align\":\"left\"},{\"align\":\"left\",\"font\":{\"size\":14}},{\"align\":\"left\",\"font\":{\"size\":14},\"color\":\"#ffffff\"},{\"font\":{\"size\":14},\"color\":\"#ffffff\"},{\"font\":{\"size\":12},\"color\":\"#ffffff\"},{\"font\":{\"size\":12,\"bold\":true},\"color\":\"#ffffff\"},{\"font\":{\"size\":12,\"bold\":false},\"color\":\"#ffffff\"},{\"font\":{\"size\":11,\"bold\":false},\"color\":\"#ffffff\"},{\"font\":{\"size\":8}},{\"font\":{\"size\":9}},{\"font\":{\"size\":9},\"color\":\"#67b1ee\"},{\"font\":{\"size\":9},\"color\":\"#67b1ee\",\"valign\":\"top\"},{\"font\":{\"size\":8},\"color\":\"#67b1ee\",\"valign\":\"top\"},{\"font\":{\"size\":11,\"bold\":false},\"color\":\"#ffffff\",\"valign\":\"bottom\"},{\"font\":{\"size\":8},\"color\":\"#67b1ee\"},{\"color\":\"#67b1ee\",\"font\":{\"size\":12},\"align\":\"left\",\"valign\":\"bottom\"},{\"align\":\"left\",\"valign\":\"bottom\"},{\"color\":\"#67b1ee\",\"font\":{\"size\":12},\"align\":\"center\",\"valign\":\"bottom\"},{\"align\":\"center\",\"valign\":\"bottom\"},{\"color\":\"#67b1ee\",\"font\":{\"size\":12},\"align\":\"left\",\"valign\":\"middle\"},{\"align\":\"left\",\"valign\":\"middle\"},{\"font\":{\"size\":11}},{\"font\":{\"size\":11},\"color\":\"#ffffff\"},{\"font\":{\"size\":11},\"color\":\"#ffffff\",\"valign\":\"middle\"},{\"font\":{\"size\":11},\"color\":\"#ffffff\",\"valign\":\"bottom\"},{\"color\":\"#ffffff\",\"font\":{\"size\":12},\"align\":\"left\",\"valign\":\"middle\"},{\"align\":\"left\",\"valign\":\"middle\",\"color\":\"#ffffff\"},{\"color\":\"#67b1ee\",\"font\":{\"size\":16}},{\"color\":\"#ffff01\",\"font\":{\"size\":16}},{\"color\":\"#ffffff\",\"font\":{\"size\":11},\"align\":\"left\",\"valign\":\"middle\"},{\"color\":\"#ffffff\",\"font\":{\"size\":14},\"align\":\"left\",\"valign\":\"middle\"},{\"color\":\"#ffff01\",\"font\":{\"size\":14},\"align\":\"left\",\"valign\":\"middle\"},{\"font\":{\"size\":14},\"color\":\"#ffff01\"},{\"color\":\"#ffff01\",\"font\":{\"size\":14},\"align\":\"right\",\"valign\":\"middle\"},{\"font\":{\"size\":14},\"color\":\"#ffff01\",\"align\":\"right\"},{\"color\":\"#ffffff\",\"valign\":\"bottom\"},{\"font\":{\"size\":8},\"bgcolor\":\"#67b1ee\"},{\"font\":{\"size\":8},\"bgcolor\":\"#ffffff\"},{\"font\":{\"size\":8},\"bgcolor\":\"#ffffff\",\"color\":\"#67b1ee\"},{\"font\":{\"size\":8},\"bgcolor\":\"#ffffff\",\"color\":\"#67b1ee\",\"valign\":\"top\"},{\"font\":{\"size\":8,\"bold\":false},\"color\":\"#ffffff\",\"valign\":\"bottom\"},{\"font\":{\"size\":8,\"bold\":false},\"color\":\"#ffffff\",\"valign\":\"top\"},{\"font\":{\"size\":8},\"valign\":\"top\"},{\"font\":{\"size\":8,\"bold\":false},\"color\":\"#67b1ee\",\"valign\":\"top\"},{\"color\":\"#ffffff\",\"font\":{\"size\":11},\"align\":\"center\",\"valign\":\"middle\"},{\"align\":\"center\"},{\"color\":\"#ffffff\",\"font\":{\"size\":11},\"align\":\"right\",\"valign\":\"middle\"},{\"align\":\"right\"},{\"color\":\"#ffffff\",\"font\":{\"size\":14},\"align\":\"right\",\"valign\":\"middle\"},{\"align\":\"right\",\"font\":{\"size\":14}},{\"color\":\"#ffffff\",\"font\":{\"size\":11},\"align\":\"left\",\"valign\":\"bottom\"},{\"color\":\"#67b1ee\",\"font\":{\"size\":11}},{\"color\":\"#67b1ee\",\"font\":{\"size\":11},\"align\":\"center\"},{\"font\":{\"size\":12}},{\"font\":{\"size\":12},\"color\":\"#ffff01\"},{\"color\":\"#67b1ee\",\"font\":{\"size\":11},\"align\":\"right\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":10},\"3\":{\"width\":102},\"4\":{\"width\":9},\"5\":{\"width\":105},\"6\":{\"width\":102},\"8\":{\"width\":124},\"9\":{\"width\":14},\"10\":{\"width\":136},\"11\":{\"width\":114},\"12\":{\"width\":15},\"13\":{\"width\":113},\"14\":{\"width\":129},\"15\":{\"width\":11},\"len\":27},\"merges\":[\"B7:C7\",\"N17:O17\",\"R17:S17\",\"R18:S18\",\"B3:S3\",\"R6:S6\",\"B5:C5\",\"B6:C6\",\"F6:F7\",\"G6:G7\",\"N5:O5\",\"R5:S5\",\"N13:O13\",\"R13:S13\",\"R14:S14\",\"P5:Q5\",\"P6:Q6\",\"P14:Q14\",\"P13:Q13\"]}', NULL, 'https://static.jeecg.com/designreport/images/QQ截图20201218200943_1608293404719.png', 'admin', '2021-01-18 13:21:10', 'admin', '2021-02-03 14:01:28', 0, NULL, NULL, 0, 660, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('519c1c6f4d1f584ae8fa5b43b45acdc7', '56623333333', '销售单', '', NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":false,\"excel_config_id\":\"519c1c6f4d1f584ae8fa5b43b45acdc7\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"0\":{\"cells\":{\"1\":{\"text\":\"销售单\",\"style\":40,\"merge\":[0,6]}},\"height\":99},\"1\":{\"cells\":{\"1\":{\"text\":\"商品编码\",\"style\":62},\"2\":{\"text\":\"商品名称\",\"style\":62},\"3\":{\"text\":\"销售时间\",\"style\":62},\"4\":{\"text\":\"销售数量\",\"style\":62},\"5\":{\"text\":\"定价\",\"style\":62},\"6\":{\"text\":\"优惠价\",\"style\":62},\"7\":{\"text\":\"付款金额\",\"style\":62}},\"height\":39},\"2\":{\"cells\":{\"1\":{\"text\":\"#{xiaoshou.bianma}\",\"style\":61},\"2\":{\"text\":\"#{xiaoshou.cname}\",\"style\":61},\"3\":{\"text\":\"#{xiaoshou.ctime}\",\"style\":61},\"4\":{\"text\":\"#{xiaoshou.cnum}\",\"style\":61},\"5\":{\"text\":\"#{xiaoshou.cprice}\",\"style\":61},\"6\":{\"text\":\"#{xiaoshou.yprice}\",\"style\":61},\"7\":{\"text\":\"#{xiaoshou.ctotal}\",\"style\":61}},\"isDrag\":true,\"height\":35},\"3\":{\"cells\":{\"1\":{\"style\":44,\"text\":\"\"},\"5\":{\"style\":44,\"text\":\"\"},\"6\":{\"text\":\"\",\"style\":45},\"7\":{\"style\":46,\"text\":\"=SUM(H3)\"}},\"isDrag\":true,\"height\":73},\"5\":{\"cells\":{},\"isDrag\":true},\"6\":{\"cells\":{},\"isDrag\":true},\"7\":{\"cells\":{\"2\":{\"text\":\"\"}},\"isDrag\":true},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":703,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#01b0f1\"],\"top\":[\"thin\",\"#01b0f1\"],\"left\":[\"thin\",\"#01b0f1\"],\"right\":[\"thin\",\"#01b0f1\"]}},{\"border\":{\"bottom\":[\"thin\",\"#01b0f1\"],\"top\":[\"thin\",\"#01b0f1\"],\"left\":[\"thin\",\"#01b0f1\"],\"right\":[\"thin\",\"#01b0f1\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#01b0f1\"],\"top\":[\"thin\",\"#01b0f1\"],\"left\":[\"thin\",\"#01b0f1\"],\"right\":[\"thin\",\"#01b0f1\"]},\"bgcolor\":\"#01b0f1\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#01b0f1\"},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"size\":18}},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"align\":\"center\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#fed964\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#fdc101\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#fdc101\"},{\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"align\":\"center\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#ffe59a\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#ffc001\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#fed964\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#ed7d31\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"align\":\"center\"},{\"font\":{\"size\":8}},{\"font\":{\"size\":8},\"color\":\"#7f7f7f\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#9cc2e6\"},{\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]}},{\"font\":{\"bold\":true}},{\"font\":{\"bold\":true,\"size\":12}},{\"font\":{\"bold\":true,\"size\":16}},{\"font\":{\"bold\":true,\"size\":18}},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"align\":\"right\"},{\"align\":\"right\"},{\"align\":\"left\"},{\"align\":\"right\",\"font\":{\"size\":16}},{\"align\":\"left\",\"font\":{\"size\":16}},{\"align\":\"right\",\"font\":{\"size\":14}},{\"align\":\"left\",\"font\":{\"size\":14}},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true,\"name\":\"宋体\"}},{\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"right\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"right\",\"font\":{\"size\":14,\"name\":\"宋体\"}},{\"align\":\"left\",\"font\":{\"size\":14,\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#2e75b5\"],\"top\":[\"thin\",\"#2e75b5\"],\"left\":[\"thin\",\"#2e75b5\"],\"right\":[\"thin\",\"#2e75b5\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#000100\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#ffff01\"],\"top\":[\"thin\",\"#ffff01\"],\"left\":[\"thin\",\"#ffff01\"],\"right\":[\"thin\",\"#ffff01\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"right\",\"font\":{\"size\":14,\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"color\":\"#ffffff\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#2e75b5\"],\"top\":[\"thin\",\"#2e75b5\"],\"left\":[\"thin\",\"#2e75b5\"],\"right\":[\"thin\",\"#2e75b5\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#ffffff\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#ffffff\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#ffffff\",\"bgcolor\":\"#5b9cd6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}}],\"validations\":[],\"cols\":{\"0\":{\"width\":18},\"1\":{\"width\":102},\"2\":{\"width\":132},\"3\":{\"width\":147},\"4\":{\"width\":66},\"5\":{\"width\":66},\"6\":{\"width\":84},\"7\":{\"width\":88},\"8\":{\"width\":121},\"len\":50},\"merges\":[\"B1:H1\"]}', '', 'https://static.jeecg.com/designreport/images/xiaoshou_1607310086160.png', 'jeecg', '2020-07-28 16:54:44', 'admin', '2021-04-01 03:09:25', 0, NULL, NULL, 1, 2085, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('537446834339098624', '20210401114849', 'oo', NULL, NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":{\"sri\":3,\"sci\":4,\"eri\":3,\"eci\":4,\"width\":100,\"height\":25},\"excel_config_id\":\"537446834339098624\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"3\":{\"cells\":{\"1\":{\"text\":\"#{pp.id}\"},\"2\":{\"text\":\"#{pp.cname}\"},\"3\":{\"text\":\"#{pp.cnum}\"},\"4\":{\"text\":\"#{pp.cprice}\"}}},\"len\":98,\"-1\":{\"cells\":{\"-1\":{\"text\":\"#{tt.id}\"}}}},\"dbexps\":[],\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":512,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[],\"validations\":[],\"cols\":{\"2\":{\"width\":109},\"3\":{\"width\":103},\"len\":50},\"merges\":[]}', NULL, NULL, 'admin', '2021-04-01 03:48:50', 'admin', '2021-04-01 05:56:45', 1, NULL, NULL, 0, 49, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('53c82a76f837d5661dceec7d93afafec', '5678', '阜阳检票数查询', '', NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":false,\"printElWidth\":718,\"excel_config_id\":\"53c82a76f837d5661dceec7d93afafec\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"text\":\"\",\"style\":66},\"2\":{\"style\":66},\"3\":{\"style\":67,\"merge\":[0,3],\"text\":\"阜阳火车站检票数\"},\"4\":{\"style\":67},\"5\":{\"style\":67},\"6\":{\"style\":67},\"7\":{\"style\":66},\"8\":{\"style\":66},\"9\":{\"style\":58}},\"height\":63},\"1\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"style\":66},\"2\":{\"style\":66},\"3\":{\"style\":66},\"4\":{\"style\":66},\"5\":{\"style\":66},\"6\":{\"style\":66},\"7\":{\"style\":66},\"8\":{\"style\":66},\"9\":{\"style\":58}},\"height\":20},\"2\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"text\":\"日期：\",\"style\":68},\"2\":{\"text\":\"${gongsi.tdata}\",\"style\":69},\"3\":{\"style\":66},\"4\":{\"style\":66,\"text\":\"制表人：\"},\"5\":{\"text\":\"${gongsi.gname}\",\"style\":66},\"6\":{\"style\":66},\"7\":{\"text\":\"\",\"merge\":[0,1],\"style\":70},\"8\":{\"style\":70},\"9\":{\"style\":58}},\"isDrag\":true},\"3\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"text\":\"班次\",\"merge\":[1,0],\"style\":71},\"2\":{\"text\":\"发车时间\",\"merge\":[1,0],\"style\":71},\"3\":{\"text\":\"是否放空\",\"merge\":[1,0],\"style\":71},\"4\":{\"text\":\"路线\",\"merge\":[0,1],\"style\":71},\"5\":{\"style\":72},\"6\":{\"text\":\"核载座位数\",\"merge\":[1,0],\"style\":71},\"7\":{\"merge\":[1,0],\"style\":71,\"text\":\"检票数\"},\"8\":{\"merge\":[1,0],\"style\":71,\"text\":\"实载率（%）\"},\"9\":{\"style\":58}}},\"4\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"style\":72},\"2\":{\"style\":71},\"3\":{\"style\":72},\"4\":{\"text\":\"从\",\"style\":71},\"5\":{\"text\":\"到\",\"style\":71},\"6\":{\"style\":72},\"7\":{\"style\":71},\"8\":{\"style\":72},\"9\":{\"style\":58}},\"height\":25},\"5\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"style\":73,\"text\":\"#{jianpiao.bnum}\"},\"2\":{\"style\":73,\"text\":\"#{jianpiao.ftime}\"},\"3\":{\"style\":73,\"text\":\"#{jianpiao.sfkong}\"},\"4\":{\"style\":73,\"text\":\"#{jianpiao.kaishi}\"},\"5\":{\"style\":73,\"text\":\"#{jianpiao.jieshu}\"},\"6\":{\"style\":73,\"text\":\"#{jianpiao.hezairen}\"},\"7\":{\"style\":73,\"text\":\"#{jianpiao.jpnum}\"},\"8\":{\"style\":73,\"text\":\"#{jianpiao.shihelv}\"},\"9\":{\"style\":58}},\"height\":33},\"6\":{\"cells\":{\"1\":{\"text\":\"\",\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}},\"isDrag\":true},\"7\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11,\"text\":\"\"},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"8\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"9\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"10\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"11\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"12\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"13\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"14\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"len\":96,\"-1\":{\"cells\":{\"-1\":{\"text\":\"${gongsi.id}\"}},\"isDrag\":true}},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":701,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"border\":{\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"]}},{\"border\":{\"top\":[\"thin\",\"#000100\"]}},{\"border\":{\"top\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"left\":[\"thin\",\"#000100\"]}},{\"border\":{\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"top\":[\"thin\",\"#7f7f7f\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"right\":[\"thin\",\"#7f7f7f\"],\"bottom\":[\"thin\",\"#7f7f7f\"]}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"]}},{\"border\":{\"right\":[\"thin\",\"#7f7f7f\"]}},{\"align\":\"center\",\"font\":{\"size\":16}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"font\":{\"bold\":true}},{\"font\":{\"bold\":false}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":true}},{\"align\":\"center\",\"font\":{\"bold\":true}},{\"align\":\"right\"},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":true},\"bgcolor\":\"#4371c6\"},{\"align\":\"center\",\"font\":{\"bold\":true},\"bgcolor\":\"#4371c6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#4371c6\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#4371c6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#2e75b5\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#2e75b5\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#0170c1\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#0170c1\"},{\"font\":{\"bold\":false},\"color\":\"#7f7f7f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#01b0f1\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#01b0f1\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true},\"valign\":\"bottom\"},{\"align\":\"center\",\"font\":{\"size\":22,\"bold\":true},\"valign\":\"bottom\"},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true},\"valign\":\"bottom\"},{\"font\":{\"bold\":false},\"color\":\"#7f7f7f\",\"align\":\"right\"},{\"color\":\"#7f7f7f\"},{\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true,\"name\":\"宋体\"},\"valign\":\"bottom\"},{\"font\":{\"bold\":false,\"name\":\"宋体\"},\"color\":\"#7f7f7f\",\"align\":\"right\"},{\"color\":\"#7f7f7f\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"right\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"bold\":false,\"name\":\"宋体\"},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"font\":{\"bold\":false,\"name\":\"宋体\"},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"name\":\"宋体\"}},{\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true,\"name\":\"Microsoft YaHei\"},\"valign\":\"bottom\"},{\"font\":{\"bold\":false,\"name\":\"Microsoft YaHei\"},\"color\":\"#7f7f7f\",\"align\":\"right\"},{\"color\":\"#7f7f7f\",\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"right\",\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"bold\":false,\"name\":\"Microsoft YaHei\"},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"font\":{\"bold\":false,\"name\":\"Microsoft YaHei\"},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"name\":\"Microsoft YaHei\"}}],\"validations\":[],\"cols\":{\"0\":{\"width\":17},\"1\":{\"width\":118},\"2\":{\"width\":75},\"3\":{\"width\":54},\"4\":{\"width\":95},\"5\":{\"width\":109},\"6\":{\"width\":75},\"7\":{\"width\":75},\"8\":{\"width\":83},\"9\":{\"width\":30},\"len\":50},\"merges\":[\"E4:F4\",\"B4:B5\",\"C4:C5\",\"D4:D5\",\"G4:G5\",\"H4:H5\",\"I4:I5\",\"D1:G1\",\"H3:I3\"]}', '', 'https://static.jeecg.com/designreport/images/25_1597233573577.png', 'jeecg', '2020-06-16 15:01:42', 'admin', '2021-02-03 12:11:37', 0, NULL, NULL, 1, 689, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('5485950d88c9918d03dece2ad24b4d72', '202101081612408899', '实例：年度各月份佣金收入副本8899', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"area\":{\"sri\":11,\"sci\":7,\"eri\":11,\"eci\":7,\"width\":100,\"height\":25},\"printElWidth\":749,\"excel_config_id\":\"1347454742040809472\",\"printElHeight\":1047,\"rows\":{\"1\":{\"cells\":{\"1\":{\"text\":\" \",\"virtual\":\"pZTpI3BKFw0lh6D7\"},\"2\":{\"text\":\"年度各月份佣金收入\",\"style\":23,\"merge\":[0,3],\"virtual\":\"pZTpI3BKFw0lh6D7\"},\"3\":{\"style\":24},\"4\":{\"style\":24},\"5\":{\"style\":24},\"6\":{\"text\":\" \"}},\"height\":37},\"2\":{\"cells\":{\"1\":{\"text\":\" \"},\"2\":{\"text\":\" \"},\"3\":{\"text\":\" \"},\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"}}},\"4\":{\"cells\":{\"1\":{\"text\":\"查询年度：2019\"},\"4\":{\"text\":\"查询机构：总公司\"},\"6\":{\"text\":\"单位：元\"}}},\"6\":{\"cells\":{\"1\":{\"text\":\"月份\",\"style\":12},\"2\":{\"text\":\"佣金/主营业收入\",\"style\":12},\"3\":{\"text\":\"累计\",\"style\":12},\"4\":{\"text\":\"历史最低水平\",\"style\":12},\"5\":{\"text\":\"历史平均水平\",\"style\":12},\"6\":{\"text\":\"历史最高水平\",\"style\":12}}},\"7\":{\"cells\":{\"1\":{\"text\":\"#{tmp_report_data_1.monty}\",\"style\":0},\"2\":{\"text\":\"#{tmp_report_data_1.main_income}\",\"style\":0},\"3\":{\"text\":\"#{tmp_report_data_1.total}\",\"style\":18},\"4\":{\"text\":\"#{tmp_report_data_1.his_lowest}\",\"style\":0},\"5\":{\"text\":\"#{tmp_report_data_1.his_average}\",\"style\":0},\"6\":{\"text\":\"#{tmp_report_data_1.his_highest}\",\"style\":0}},\"isDrag\":true},\"9\":{\"cells\":{\"1\":{\"merge\":[1,1]}}},\"len\":99},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":703,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":true}},{\"font\":{\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":false}},{\"font\":{\"bold\":false}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":true},\"align\":\"center\"},{\"font\":{\"bold\":true},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":true,\"size\":15},\"align\":\"center\"},{\"font\":{\"bold\":true,\"size\":15},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#01b0f1\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#33CCCC\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#33CCCC\",\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#33CCCC\",\"align\":\"left\"},{\"font\":{\"bold\":true,\"size\":16}},{\"font\":{\"bold\":true,\"size\":24}},{\"font\":{\"bold\":true,\"size\":22}},{\"font\":{\"bold\":true,\"size\":22},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"format\":\"usd\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"format\":\"rmb\"},{\"font\":{\"bold\":true,\"name\":\"黑体\"}},{\"font\":{\"bold\":true,\"name\":\"黑体\",\"size\":22}},{\"font\":{\"bold\":true,\"name\":\"宋体\",\"size\":22}},{\"font\":{\"bold\":true,\"name\":\"楷体\",\"size\":22}},{\"font\":{\"bold\":true,\"name\":\"楷体\",\"size\":22},\"align\":\"center\"},{\"align\":\"center\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":54},\"1\":{\"width\":111},\"2\":{\"width\":116},\"4\":{\"width\":122},\"len\":26},\"merges\":[\"B10:C11\",\"C2:F2\"],\"imgList\":[{\"row\":1,\"col\":1,\"width\":\"148\",\"height\":\"56\",\"src\":\"https://static.jeecg.com/designreport/images/kunlunlog_1610591367645.png\",\"layer_id\":\"pZTpI3BKFw0lh6D7\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[1,1],[1,2]]}]}', NULL, NULL, 'admin', '2021-01-19 10:45:44', 'admin', '2021-02-03 12:02:25', 1, NULL, NULL, 0, 43, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('6059e405dd9c66a6d38e00841d2e40cc', '566777', '处方笺', '', NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":{\"sri\":9,\"sci\":3,\"eri\":9,\"eci\":11,\"width\":593,\"height\":25},\"printElWidth\":718,\"excel_config_id\":\"6059e405dd9c66a6d38e00841d2e40cc\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{\"3\":{\"style\":80,\"text\":\" \"}},\"height\":96},\"1\":{\"cells\":{\"1\":{\"style\":24,\"text\":\" \"},\"2\":{\"style\":25,\"text\":\" \"},\"3\":{\"style\":25,\"text\":\" \"},\"4\":{\"style\":25,\"text\":\" \"},\"5\":{\"style\":25,\"text\":\" \"},\"6\":{\"style\":25,\"text\":\" \"},\"7\":{\"style\":25,\"text\":\" \"},\"8\":{\"style\":25,\"text\":\" \"},\"9\":{\"style\":25,\"text\":\" \"},\"10\":{\"style\":25,\"text\":\" \"},\"11\":{\"style\":25,\"text\":\" \"},\"12\":{\"style\":26,\"text\":\" \"}},\"height\":18},\"2\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":27},\"2\":{\"merge\":[0,9],\"text\":\"智能医学院处方笺\",\"style\":38},\"3\":{\"style\":12,\"text\":\" \"},\"4\":{\"style\":12,\"text\":\" \"},\"5\":{\"style\":12,\"text\":\" \"},\"6\":{\"style\":12,\"text\":\" \"},\"7\":{\"style\":12,\"text\":\" \"},\"8\":{\"style\":12,\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"style\":12,\"text\":\" \"},\"11\":{\"style\":12,\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"},\"13\":{\"style\":80,\"text\":\" \"}},\"height\":124},\"3\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":46},\"2\":{\"merge\":[0,1],\"text\":\"姓名：\",\"style\":4},\"3\":{\"style\":4,\"text\":\" \"},\"4\":{\"text\":\"${yonghu.yphone}\"},\"5\":{\"text\":\"性别：\",\"style\":42},\"6\":{\"text\":\"${yonghu.ysex}\",\"style\":42},\"7\":{\"text\":\"年龄：\",\"style\":47},\"8\":{\"text\":\"${yonghu.yage}\"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \",\"style\":42},\"11\":{\"style\":69,\"text\":\" \",\"merge\":[0,1]},\"12\":{\"style\":43,\"text\":\" \"},\"13\":{\"style\":80,\"text\":\" \"}},\"isDrag\":true},\"4\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":74},\"2\":{\"style\":4,\"merge\":[0,1],\"text\":\"单位：\"},\"3\":{\"style\":4,\"text\":\" \"},\"4\":{\"text\":\"${yonghu.danwei}\"},\"5\":{\"text\":\"电话：\"},\"6\":{\"text\":\"${yonghu.yphone}\",\"merge\":[0,5]},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"},\"15\":{\"text\":\"\"}},\"isDrag\":true,\"height\":29},\"5\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"merge\":[0,1],\"text\":\"初步诊断：\",\"style\":4},\"3\":{\"text\":\" \",\"style\":4},\"4\":{\"text\":\"${yonghu.yjieguo}\",\"merge\":[0,7]},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"isDrag\":true,\"height\":34},\"6\":{\"cells\":{\"1\":{\"text\":\" RP：\",\"merge\":[0,2],\"style\":79},\"2\":{\"style\":11,\"text\":\" \"},\"3\":{\"style\":11,\"text\":\" \"},\"4\":{\"style\":39,\"text\":\" \"},\"5\":{\"style\":0,\"text\":\" \"},\"6\":{\"style\":0,\"text\":\" \"},\"7\":{\"style\":0,\"text\":\" \"},\"8\":{\"style\":0,\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"style\":0,\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"},\"14\":{},\"16\":{}},\"height\":79},\"7\":{\"cells\":{\"1\":{\"text\":\".\",\"style\":48},\"2\":{\"text\":\"\",\"style\":1},\"3\":{\"text\":\"#{yaopin.name}\",\"merge\":[0,1]},\"5\":{},\"6\":{},\"7\":{\"text\":\"#{yaopin.percent}\",\"merge\":[0,1]},\"9\":{},\"10\":{},\"11\":{\"text\":\"\"},\"12\":{\"style\":28,\"text\":\" \"},\"14\":{}},\"isDrag\":true,\"height\":37},\"8\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\" \"},\"3\":{\"text\":\" \"},\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"height\":27},\"9\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"医嘱：\",\"style\":76},\"3\":{\"text\":\"${yonghu.yizhu}\",\"style\":6,\"merge\":[0,8]},\"12\":{\"style\":28,\"text\":\" \"}},\"isDrag\":true},\"10\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"药品费\",\"style\":6,\"merge\":[0,1]},\"3\":{\"text\":\" \"},\"4\":{\"text\":\"${yonghu.yprice}\",\"style\":6},\"5\":{\"text\":\"中成药费\",\"style\":6,\"rendered\":\"\",\"merge\":[0,1]},\"7\":{\"style\":6,\"text\":\" \"},\"8\":{\"text\":\"治疗费\",\"merge\":[0,2],\"style\":6},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"style\":6,\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"isDrag\":true},\"11\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"检查费\",\"style\":6,\"merge\":[0,1]},\"3\":{\"text\":\" \"},\"4\":{\"style\":6,\"text\":\" \"},\"5\":{\"text\":\"换药费\",\"style\":6,\"merge\":[0,1]},\"7\":{\"style\":6,\"text\":\" \"},\"8\":{\"merge\":[0,2],\"text\":\"诊疗费\",\"style\":6},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\"${yonghu.yzhenliao}\",\"style\":6},\"12\":{\"style\":28,\"text\":\" \"}},\"isDrag\":true},\"12\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"注射费\",\"style\":6,\"merge\":[0,1]},\"3\":{\"text\":\" \"},\"4\":{\"style\":6,\"merge\":[0,3],\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"merge\":[0,2],\"text\":\"其他\",\"style\":6},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"style\":6,\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}}},\"13\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"合计\",\"style\":6,\"merge\":[0,1]},\"3\":{\"text\":\" \"},\"4\":{\"text\":\"${yonghu.ytotal}\",\"style\":6,\"merge\":[0,7]},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"isDrag\":true},\"14\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\" \"},\"3\":{\"text\":\" \"},\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"},\"13\":{\"style\":80,\"text\":\" \"}},\"height\":9},\"15\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"医师：\",\"style\":4,\"rendered\":\"\",\"merge\":[0,1]},\"4\":{\"text\":\"${yonghu.yishe}\",\"style\":80},\"5\":{\"style\":80,\"text\":\" \"},\"6\":{\"style\":80,\"text\":\" \"},\"7\":{\"style\":80,\"text\":\" \"},\"8\":{\"text\":\"日期：\",\"style\":4},\"9\":{\"text\":\"${yonghu.kdata}\",\"style\":80,\"merge\":[0,2]},\"12\":{\"style\":71,\"text\":\" \"},\"13\":{\"style\":80,\"text\":\" \"}},\"isDrag\":true,\"height\":43},\"16\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"style\":80,\"text\":\" \"},\"3\":{\"style\":80,\"text\":\" \"},\"4\":{\"style\":80,\"text\":\" \"},\"5\":{\"style\":80,\"text\":\" \"},\"6\":{\"style\":80,\"text\":\" \"},\"7\":{\"style\":80,\"text\":\" \"},\"8\":{\"style\":80,\"text\":\" \"},\"9\":{\"style\":80,\"text\":\" \"},\"10\":{\"style\":80,\"text\":\" \"},\"11\":{\"style\":80,\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"height\":17},\"17\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":32},\"2\":{\"text\":\" \",\"style\":33},\"3\":{\"style\":33,\"text\":\" \"},\"4\":{\"text\":\" \",\"style\":33},\"5\":{\"text\":\" \",\"style\":33},\"6\":{\"text\":\" \",\"style\":33},\"7\":{\"text\":\" \",\"style\":33},\"8\":{\"text\":\" \",\"style\":33},\"9\":{\"text\":\" \",\"style\":33},\"10\":{\"text\":\" \",\"style\":33},\"11\":{\"text\":\" \",\"style\":33},\"12\":{\"text\":\" \",\"style\":34}}},\"18\":{\"cells\":{\"11\":{\"text\":\"\"}},\"isDrag\":true},\"len\":94,\"-1\":{\"cells\":{\"-1\":{\"text\":\"#{yaopin.key1}\"}},\"isDrag\":true},\"\":{\"cells\":{\"NaN\":{\"text\":\"\",\"rendered\":\"\"}}}},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":709,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"font\":{\"size\":12}},{\"font\":{\"size\":10}},{\"font\":{\"size\":12},\"align\":\"right\"},{\"font\":{\"size\":14}},{\"align\":\"right\"},{\"font\":{\"size\":10},\"align\":\"right\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\"},{\"font\":{\"size\":12},\"align\":\"center\"},{\"font\":{\"size\":12,\"bold\":true},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true}},{\"font\":{\"size\":14,\"bold\":true},\"align\":\"center\"},{\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":14,\"bold\":true},\"align\":\"center\",\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14,\"bold\":true},\"align\":\"center\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":15},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":15}},{\"align\":\"left\"},{\"font\":{\"size\":14,\"bold\":true},\"align\":\"center\",\"border\":{\"bottom\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":true}},{\"font\":{\"size\":12,\"bold\":true},\"align\":\"center\",\"border\":{\"bottom\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"valign\":\"bottom\"},{\"font\":{\"size\":10},\"valign\":\"bottom\"},{\"valign\":\"bottom\"},{\"align\":\"right\",\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"valign\":\"bottom\",\"align\":\"right\"},{\"font\":{\"size\":10},\"valign\":\"bottom\",\"align\":\"right\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"right\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"textwrap\":true},{\"font\":{\"size\":10},\"textwrap\":true},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"textwrap\":false},{\"font\":{\"size\":10},\"textwrap\":false},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"textwrap\":false,\"align\":\"right\"},{\"font\":{\"size\":10},\"textwrap\":false,\"align\":\"right\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"textwrap\":false,\"align\":\"left\"},{\"font\":{\"size\":10},\"textwrap\":false,\"align\":\"left\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"textwrap\":false,\"align\":\"center\"},{\"font\":{\"size\":10},\"textwrap\":false,\"align\":\"center\"},{\"font\":{\"size\":15},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"right\"},{\"font\":{\"size\":15},\"align\":\"right\"},{\"font\":{\"size\":15},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thin\",\"#000\"]},\"valign\":\"bottom\",\"align\":\"right\"},{\"font\":{\"size\":10},\"valign\":\"bottom\",\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thin\",\"#000\"]},\"align\":\"right\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thin\",\"#000\"]},\"textwrap\":false,\"align\":\"left\"},{\"font\":{\"size\":10},\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":15},\"border\":{\"left\":[\"thin\",\"#000\"]},\"align\":\"center\"},{\"align\":\"left\",\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":10},\"valign\":\"bottom\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":10},\"align\":\"left\"},{\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"right\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"right\"},{\"font\":{\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":10},\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":15,\"bold\":true},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{},{\"font\":{\"size\":15,\"bold\":true},\"align\":\"center\"},{\"align\":\"right\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":14,\"bold\":true},\"align\":\"center\",\"border\":{\"bottom\":[\"thick\",\"#000\"],\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}}],\"validations\":[],\"cols\":{\"0\":{\"width\":23},\"1\":{\"width\":14},\"2\":{\"width\":56},\"3\":{\"width\":40},\"4\":{\"width\":156},\"5\":{\"width\":41},\"6\":{\"width\":18},\"7\":{\"width\":92},\"8\":{\"width\":58},\"9\":{\"width\":20},\"10\":{\"width\":20},\"11\":{\"width\":148},\"12\":{\"width\":12},\"13\":{\"width\":11},\"len\":50},\"merges\":[\"C3:E3\",\"C7:E7\",\"H3:I3\",\"H7:I7\",\"C7:E7\",\"H7:I7\",\"I11:K11\",\"I12:K12\",\"I13:K13\",\"E13:H13\",\"C11:D11\",\"C12:D12\",\"C13:D13\",\"C14:D14\",\"L4:M4\",\"C3:L3\",\"B7:D7\",\"C4:D4\",\"C5:D5\",\"E14:L14\",\"G5:L5\",\"C6:D6\",\"E6:L6\",\"D8:E8\",\"H8:I8\",\"C16:D16\",\"J16:L16\",\"F11:G11\",\"F12:G12\",\"D10:L10\"]}', '', 'https://static.jeecg.com/designreport/images/处方_1607071731580.png', 'jeecg', '2020-07-10 17:12:16', 'admin', '2021-02-03 14:03:05', 0, NULL, NULL, 1, 846, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('6d6bdcb5e820c301ea32789e3ae43c44', '1223', '供电公司抢修单', '', NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":{\"sri\":14,\"sci\":8,\"eri\":14,\"eci\":8,\"width\":100,\"height\":67},\"printElWidth\":718,\"excel_config_id\":\"6d6bdcb5e820c301ea32789e3ae43c44\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{},\"height\":11},\"1\":{\"cells\":{\"1\":{\"text\":\"供电公司抢修竣工单\",\"merge\":[0,5],\"style\":39},\"2\":{\"style\":39},\"3\":{\"style\":39},\"4\":{\"style\":39},\"5\":{\"style\":39},\"6\":{\"style\":39}},\"height\":56},\"2\":{\"cells\":{\"1\":{\"text\":\"填报单位：\",\"style\":26},\"2\":{\"text\":\"#{qiangxiu.danwei}\",\"style\":27},\"3\":{\"style\":27},\"4\":{\"text\":\"\",\"style\":27},\"5\":{\"text\":\"填报日期：\",\"style\":26},\"6\":{\"text\":\"#{qiangxiu.time}\",\"style\":27}}},\"3\":{\"cells\":{\"1\":{\"text\":\"填报名称：\",\"style\":26},\"2\":{\"text\":\"#{qiangxiu.ktime}\",\"style\":27},\"3\":{\"style\":27},\"4\":{\"style\":27},\"5\":{\"text\":\"项目编号：\",\"style\":26},\"6\":{\"text\":\"#{qiangxiu.wtime}\",\"style\":27}}},\"4\":{\"cells\":{\"1\":{\"style\":28},\"2\":{\"style\":28},\"3\":{\"style\":28},\"4\":{\"style\":28},\"5\":{\"style\":28},\"6\":{\"style\":28}},\"height\":10},\"5\":{\"cells\":{\"1\":{\"text\":\"项目批准核算\",\"style\":29},\"2\":{\"text\":\"#{qiangxiu.yusuan}\",\"style\":30,\"merge\":[0,4]}},\"height\":89},\"6\":{\"cells\":{\"1\":{\"text\":\"开工日期\",\"style\":32},\"2\":{\"style\":33,\"text\":\"#{qiangxiu.ktime}\",\"merge\":[0,1]},\"3\":{\"style\":28},\"4\":{\"style\":34,\"text\":\"完工日期\"},\"5\":{\"style\":33,\"merge\":[0,1],\"text\":\"#{qiangxiu.wtime}\"},\"6\":{\"style\":28}},\"height\":31},\"7\":{\"cells\":{\"1\":{\"text\":\"完工主要内容\",\"style\":32},\"2\":{\"style\":33,\"text\":\"#{qiangxiu.neirong}\",\"merge\":[0,4]}},\"height\":71},\"8\":{\"cells\":{\"1\":{\"text\":\"形成能力\",\"style\":32},\"2\":{\"style\":33,\"merge\":[0,4],\"text\":\"#{qiangxiu.nengli}\"},\"3\":{\"style\":28},\"4\":{\"style\":28},\"5\":{\"style\":28},\"6\":{\"style\":28}},\"height\":49},\"9\":{\"cells\":{\"1\":{\"text\":\"目标效益验收意见\",\"style\":32},\"2\":{\"style\":35,\"text\":\"#{qiangxiu.yijian}\",\"rendered\":\"\",\"merge\":[0,4]}},\"height\":100},\"10\":{\"cells\":{\"1\":{\"style\":37,\"text\":\"                                                                                                                     \",\"merge\":[0,3]},\"2\":{\"style\":28},\"3\":{\"style\":28},\"4\":{\"style\":28},\"5\":{\"style\":37,\"text\":\"#{qiangxiu.time1}\",\"merge\":[0,1]},\"6\":{\"style\":28}}},\"11\":{\"cells\":{\"1\":{\"text\":\"实施质量验收评价\",\"style\":32},\"2\":{\"style\":35,\"text\":\"#{qiangxiu.pingjia}\",\"merge\":[0,4]}},\"height\":99},\"12\":{\"cells\":{\"1\":{\"style\":33,\"merge\":[0,3]},\"2\":{\"style\":28},\"3\":{\"style\":28},\"4\":{\"style\":28},\"5\":{\"style\":33,\"merge\":[0,1],\"text\":\"#{qiangxiu.time1}\"},\"6\":{\"style\":28}}},\"13\":{\"cells\":{\"1\":{\"text\":\"验收总结\",\"style\":32},\"2\":{\"style\":35,\"text\":\"#{qiangxiu.zongjie}\",\"merge\":[0,4],\"rendered\":\"\"}},\"height\":80},\"14\":{\"cells\":{\"1\":{\"text\":\"责任单位意见\",\"style\":32},\"2\":{\"style\":33,\"merge\":[0,4],\"text\":\"#{qiangxiu.zongjie}\"}},\"height\":67},\"15\":{\"cells\":{\"1\":{\"text\":\"责任单位审核人\",\"style\":32},\"2\":{\"style\":33,\"merge\":[0,1],\"text\":\"#{qiangxiu.dshenhe}\"},\"3\":{\"style\":28},\"4\":{\"style\":34,\"text\":\"日期\"},\"5\":{\"style\":33,\"text\":\"#{qiangxiu.time3}\",\"merge\":[0,1]},\"6\":{\"style\":28}},\"height\":42},\"16\":{\"cells\":{\"1\":{\"text\":\"生技部审批意见\",\"style\":32},\"2\":{\"style\":33,\"text\":\"#{qiangxiu.dshenhe}\",\"merge\":[0,4]}},\"height\":107},\"17\":{\"cells\":{\"1\":{\"text\":\"生技部主任\",\"style\":32},\"2\":{\"style\":33,\"merge\":[0,1],\"text\":\"#{qiangxiu.zhuren}\"},\"3\":{\"style\":28},\"4\":{\"style\":34,\"text\":\"日期\"},\"5\":{\"style\":33,\"text\":\"#{qiangxiu.time4}\",\"merge\":[0,1]},\"6\":{\"style\":28}},\"height\":41},\"18\":{\"cells\":{\"1\":{\"style\":28},\"2\":{\"style\":28},\"3\":{\"style\":28},\"4\":{\"style\":28},\"5\":{\"style\":28},\"6\":{\"style\":28}}},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":699,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#9cc2e6\"},{\"bgcolor\":\"#9cc2e6\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#ffffff\"},{\"bgcolor\":\"#ffffff\"},{\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":14}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"right\"},{\"align\":\"right\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"left\"},{\"align\":\"left\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true},{\"textwrap\":true},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":false},{\"textwrap\":false},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"align\":\"right\",\"color\":\"#7f7f7f\"},{\"color\":\"#7f7f7f\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#ffffff\",\"font\":{\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#ffffff\",\"font\":{\"bold\":false}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":false}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"right\",\"font\":{\"bold\":true}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true,\"name\":\"宋体\"}},{\"align\":\"right\",\"color\":\"#7f7f7f\",\"font\":{\"name\":\"宋体\"}},{\"color\":\"#7f7f7f\",\"font\":{\"name\":\"宋体\"}},{\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#ffffff\",\"font\":{\"bold\":true,\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#ffffff\",\"font\":{\"name\":\"宋体\"}},{\"bgcolor\":\"#ffffff\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"bold\":true,\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"right\",\"font\":{\"bold\":true,\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"font\":{\"name\":\"宋体\"}},{\"textwrap\":true,\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"left\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":false,\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true,\"name\":\"宋体\"}}],\"validations\":[],\"cols\":{\"0\":{\"width\":23},\"1\":{\"width\":117},\"3\":{\"width\":108},\"4\":{\"width\":127},\"5\":{\"width\":76},\"6\":{\"width\":148},\"7\":{\"width\":13},\"len\":50},\"merges\":[\"C7:D7\",\"F7:G7\",\"B2:G2\",\"C9:G9\",\"B11:E11\",\"F11:G11\",\"B13:E13\",\"F13:G13\",\"C16:D16\",\"C18:D18\",\"F16:G16\",\"F18:G18\",\"C10:G10\",\"C8:G8\",\"C6:G6\",\"C12:G12\",\"C14:G14\",\"C15:G15\",\"C17:G17\"]}', '', 'https://static.jeecg.com/designreport/images/222_1607311944321.png', 'jeecg', '2020-07-20 19:37:54', 'admin', '2021-02-03 14:00:39', 0, NULL, NULL, 1, 177, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('6df599d933df24de007764d0e98eb105', '5667774539', '处方笺副本4539', '', NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":false,\"printElWidth\":718,\"excel_config_id\":\"6df599d933df24de007764d0e98eb105\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{\"3\":{\"style\":80,\"text\":\" \"}},\"height\":96},\"1\":{\"cells\":{\"1\":{\"style\":24,\"text\":\" \"},\"2\":{\"style\":25,\"text\":\" \"},\"3\":{\"style\":25,\"text\":\" \"},\"4\":{\"style\":25,\"text\":\" \"},\"5\":{\"style\":25,\"text\":\" \"},\"6\":{\"style\":25,\"text\":\" \"},\"7\":{\"style\":25,\"text\":\" \"},\"8\":{\"style\":25,\"text\":\" \"},\"9\":{\"style\":25,\"text\":\" \"},\"10\":{\"style\":25,\"text\":\" \"},\"11\":{\"style\":25,\"text\":\" \"},\"12\":{\"style\":26,\"text\":\" \"}},\"height\":18},\"2\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":27},\"2\":{\"merge\":[0,9],\"text\":\"智能医学院处方笺\",\"style\":38},\"3\":{\"style\":12,\"text\":\" \"},\"4\":{\"style\":12,\"text\":\" \"},\"5\":{\"style\":12,\"text\":\" \"},\"6\":{\"style\":12,\"text\":\" \"},\"7\":{\"style\":12,\"text\":\" \"},\"8\":{\"style\":12,\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"style\":12,\"text\":\" \"},\"11\":{\"style\":12,\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"},\"13\":{\"style\":80,\"text\":\" \"}},\"height\":124},\"3\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":46},\"2\":{\"merge\":[0,1],\"text\":\"姓名：\",\"style\":4},\"3\":{\"style\":4,\"text\":\" \"},\"4\":{\"text\":\"${yonghu.yphone}\"},\"5\":{\"text\":\"性别：\",\"style\":42},\"6\":{\"text\":\"${yonghu.ysex}\",\"style\":42},\"7\":{\"text\":\"年龄：\",\"style\":47},\"8\":{\"text\":\"${yonghu.yage}\"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \",\"style\":42},\"11\":{\"style\":69,\"text\":\" \",\"merge\":[0,1]},\"12\":{\"style\":43,\"text\":\" \"},\"13\":{\"style\":80,\"text\":\" \"}},\"isDrag\":true},\"4\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":74},\"2\":{\"style\":4,\"merge\":[0,1],\"text\":\"单位：\"},\"3\":{\"style\":4,\"text\":\" \"},\"4\":{\"text\":\"${yonghu.danwei}\"},\"5\":{\"text\":\"电话：\"},\"6\":{\"text\":\"${yonghu.yphone}\",\"merge\":[0,5]},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"},\"15\":{\"text\":\"\"}},\"isDrag\":true,\"height\":29},\"5\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"merge\":[0,1],\"text\":\"初步诊断：\",\"style\":4},\"3\":{\"text\":\" \",\"style\":4},\"4\":{\"text\":\"${yonghu.yjieguo}\",\"merge\":[0,7]},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"isDrag\":true,\"height\":34},\"6\":{\"cells\":{\"1\":{\"text\":\" RP：\",\"merge\":[0,2],\"style\":79},\"2\":{\"style\":11,\"text\":\" \"},\"3\":{\"style\":11,\"text\":\" \"},\"4\":{\"style\":39,\"text\":\" \"},\"5\":{\"style\":0,\"text\":\" \"},\"6\":{\"style\":0,\"text\":\" \"},\"7\":{\"style\":0,\"text\":\" \"},\"8\":{\"style\":0,\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"style\":0,\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"},\"14\":{},\"16\":{}},\"height\":79},\"7\":{\"cells\":{\"1\":{\"text\":\".\",\"style\":48},\"2\":{\"text\":\"\",\"style\":1},\"3\":{\"text\":\"#{yaopin.name}\",\"merge\":[0,1]},\"5\":{},\"6\":{},\"7\":{\"text\":\"#{yaopin.percent}\",\"merge\":[0,1]},\"9\":{},\"10\":{},\"11\":{\"text\":\"\"},\"12\":{\"style\":28,\"text\":\" \"},\"14\":{}},\"isDrag\":true,\"height\":37},\"8\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\" \"},\"3\":{\"text\":\" \"},\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"height\":27},\"9\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"医嘱：\",\"style\":76},\"3\":{\"text\":\"${yonghu.yizhu}\",\"style\":6,\"merge\":[0,8]},\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"isDrag\":true},\"10\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"药品费\",\"style\":6,\"merge\":[0,1]},\"3\":{\"text\":\" \"},\"4\":{\"text\":\"${yonghu.yprice}\",\"style\":6},\"5\":{\"merge\":[0,1],\"text\":\"中成药费\",\"style\":6},\"6\":{\"text\":\" \"},\"7\":{\"style\":6,\"text\":\" \"},\"8\":{\"text\":\"治疗费\",\"merge\":[0,2],\"style\":6},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"style\":6,\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"isDrag\":true},\"11\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"检查费\",\"style\":6,\"merge\":[0,1]},\"3\":{\"text\":\" \"},\"4\":{\"style\":6,\"text\":\" \"},\"5\":{\"merge\":[0,1],\"text\":\"换药费\",\"style\":6},\"6\":{\"text\":\" \"},\"7\":{\"style\":6,\"text\":\" \"},\"8\":{\"merge\":[0,2],\"text\":\"诊疗费\",\"style\":6},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\"${yonghu.yzhenliao}\",\"style\":6},\"12\":{\"style\":28,\"text\":\" \"}},\"isDrag\":true},\"12\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"注射费\",\"style\":6,\"merge\":[0,1]},\"3\":{\"text\":\" \"},\"4\":{\"style\":6,\"merge\":[0,3],\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"merge\":[0,2],\"text\":\"其他\",\"style\":6},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"style\":6,\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}}},\"13\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"合计\",\"style\":6,\"merge\":[0,1]},\"3\":{\"text\":\" \"},\"4\":{\"text\":\"${yonghu.ytotal}\",\"style\":6,\"merge\":[0,7]},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"isDrag\":true},\"14\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\" \"},\"3\":{\"text\":\" \"},\"4\":{\"text\":\" \"},\"5\":{\"text\":\" \"},\"6\":{\"text\":\" \"},\"7\":{\"text\":\" \"},\"8\":{\"text\":\" \"},\"9\":{\"text\":\" \"},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"},\"13\":{\"style\":80,\"text\":\" \"}},\"height\":9},\"15\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"text\":\"医师：\",\"style\":4,\"merge\":[0,1]},\"3\":{\"text\":\" \"},\"4\":{\"text\":\"${yonghu.yishe}\",\"style\":80},\"5\":{\"style\":80,\"text\":\" \"},\"6\":{\"style\":80,\"text\":\" \"},\"7\":{\"style\":80,\"text\":\" \"},\"8\":{\"text\":\"日期：\",\"style\":4},\"9\":{\"text\":\"${yonghu.kdata}\",\"style\":80,\"merge\":[0,2]},\"10\":{\"text\":\" \"},\"11\":{\"text\":\" \"},\"12\":{\"style\":71,\"text\":\" \"},\"13\":{\"style\":80,\"text\":\" \"}},\"isDrag\":true,\"height\":43},\"16\":{\"cells\":{\"1\":{\"style\":31,\"text\":\" \"},\"2\":{\"style\":80,\"text\":\" \"},\"3\":{\"style\":80,\"text\":\" \"},\"4\":{\"style\":80,\"text\":\" \"},\"5\":{\"style\":80,\"text\":\" \"},\"6\":{\"style\":80,\"text\":\" \"},\"7\":{\"style\":80,\"text\":\" \"},\"8\":{\"style\":80,\"text\":\" \"},\"9\":{\"style\":80,\"text\":\" \"},\"10\":{\"style\":80,\"text\":\" \"},\"11\":{\"style\":80,\"text\":\" \"},\"12\":{\"style\":28,\"text\":\" \"}},\"height\":17},\"17\":{\"cells\":{\"1\":{\"text\":\" \",\"style\":32},\"2\":{\"text\":\" \",\"style\":33},\"3\":{\"style\":33,\"text\":\" \"},\"4\":{\"text\":\" \",\"style\":33},\"5\":{\"text\":\" \",\"style\":33},\"6\":{\"text\":\" \",\"style\":33},\"7\":{\"text\":\" \",\"style\":33},\"8\":{\"text\":\" \",\"style\":33},\"9\":{\"text\":\" \",\"style\":33},\"10\":{\"text\":\" \",\"style\":33},\"11\":{\"text\":\" \",\"style\":33},\"12\":{\"text\":\" \",\"style\":34}}},\"18\":{\"cells\":{\"11\":{\"text\":\"\"}},\"isDrag\":true},\"len\":94,\"-1\":{\"cells\":{\"-1\":{\"text\":\"#{yaopin.key1}\"}},\"isDrag\":true},\"\":{\"cells\":{\"NaN\":{\"text\":\"\",\"rendered\":\"\"}}}},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":798,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"font\":{\"size\":12}},{\"font\":{\"size\":10}},{\"font\":{\"size\":12},\"align\":\"right\"},{\"font\":{\"size\":14}},{\"align\":\"right\"},{\"font\":{\"size\":10},\"align\":\"right\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\"},{\"font\":{\"size\":12},\"align\":\"center\"},{\"font\":{\"size\":12,\"bold\":true},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true}},{\"font\":{\"size\":14,\"bold\":true},\"align\":\"center\"},{\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":14,\"bold\":true},\"align\":\"center\",\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14,\"bold\":true},\"align\":\"center\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":15},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":15}},{\"align\":\"left\"},{\"font\":{\"size\":14,\"bold\":true},\"align\":\"center\",\"border\":{\"bottom\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":true}},{\"font\":{\"size\":12,\"bold\":true},\"align\":\"center\",\"border\":{\"bottom\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"valign\":\"bottom\"},{\"font\":{\"size\":10},\"valign\":\"bottom\"},{\"valign\":\"bottom\"},{\"align\":\"right\",\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"valign\":\"bottom\",\"align\":\"right\"},{\"font\":{\"size\":10},\"valign\":\"bottom\",\"align\":\"right\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"right\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"textwrap\":true},{\"font\":{\"size\":10},\"textwrap\":true},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"textwrap\":false},{\"font\":{\"size\":10},\"textwrap\":false},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"textwrap\":false,\"align\":\"right\"},{\"font\":{\"size\":10},\"textwrap\":false,\"align\":\"right\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"textwrap\":false,\"align\":\"left\"},{\"font\":{\"size\":10},\"textwrap\":false,\"align\":\"left\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thick\",\"#000\"]},\"textwrap\":false,\"align\":\"center\"},{\"font\":{\"size\":10},\"textwrap\":false,\"align\":\"center\"},{\"font\":{\"size\":15},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"right\"},{\"font\":{\"size\":15},\"align\":\"right\"},{\"font\":{\"size\":15},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thin\",\"#000\"]},\"valign\":\"bottom\",\"align\":\"right\"},{\"font\":{\"size\":10},\"valign\":\"bottom\",\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thin\",\"#000\"]},\"align\":\"right\"},{\"font\":{\"size\":10},\"border\":{\"left\":[\"thin\",\"#000\"]},\"textwrap\":false,\"align\":\"left\"},{\"font\":{\"size\":10},\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":15},\"border\":{\"left\":[\"thin\",\"#000\"]},\"align\":\"center\"},{\"align\":\"left\",\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":10},\"valign\":\"bottom\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":10},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":10},\"align\":\"left\"},{\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"right\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"right\"},{\"font\":{\"size\":10},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":10},\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":15,\"bold\":true},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{},{\"font\":{\"size\":15,\"bold\":true},\"align\":\"center\"},{\"align\":\"right\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":14,\"bold\":true},\"align\":\"center\",\"border\":{\"bottom\":[\"thick\",\"#000\"],\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}}],\"validations\":[],\"cols\":{\"0\":{\"width\":23},\"1\":{\"width\":14},\"2\":{\"width\":56},\"3\":{\"width\":40},\"4\":{\"width\":156},\"5\":{\"width\":41},\"6\":{\"width\":18},\"7\":{\"width\":92},\"8\":{\"width\":58},\"9\":{\"width\":20},\"10\":{\"width\":20},\"11\":{\"width\":148},\"12\":{\"width\":12},\"len\":50},\"merges\":[\"C3:E3\",\"C7:E7\",\"H3:I3\",\"H7:I7\",\"C7:E7\",\"H7:I7\",\"F11:G11\",\"I11:K11\",\"F12:G12\",\"I12:K12\",\"I13:K13\",\"E13:H13\",\"C11:D11\",\"C12:D12\",\"C13:D13\",\"C14:D14\",\"C16:D16\",\"L4:M4\",\"C3:L3\",\"B7:D7\",\"C4:D4\",\"C5:D5\",\"E14:L14\",\"J16:L16\",\"D10:L10\",\"G5:L5\",\"C6:D6\",\"E6:L6\",\"D8:E8\",\"H8:I8\"]}', '', 'https://static.jeecg.com/designreport/images/处方_1607071731580.png', 'admin', '2021-02-02 20:13:47', 'admin', '2021-02-03 14:01:33', 0, NULL, NULL, 0, 834, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('7905022412733a0c68dc7b4ef8947489', '8996445', '介绍信', '', NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":false,\"excel_config_id\":\"7905022412733a0c68dc7b4ef8947489\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"0\":{\"cells\":{\"1\":{},\"12\":{}},\"height\":11},\"1\":{\"cells\":{},\"height\":24},\"2\":{\"cells\":{},\"isDrag\":true,\"height\":43},\"3\":{\"cells\":{\"0\":{\"text\":\"\",\"style\":46},\"1\":{\"merge\":[0,10],\"text\":\"介绍信\",\"style\":337}},\"height\":216},\"4\":{\"cells\":{\"1\":{\"text\":\"${jieshaoxin.name}\",\"style\":338,\"merge\":[0,3]},\"5\":{\"text\":\"：\",\"style\":339}},\"isDrag\":true,\"height\":80},\"5\":{\"cells\":{\"1\":{\"text\":\"兹介绍我局\",\"style\":340,\"merge\":[0,5]},\"7\":{\"text\":\"${jieshaoxin.value}\",\"style\":341},\"8\":{\"text\":\"同志\",\"style\":339},\"9\":{\"text\":\"#{jieshaoxin.percent}\",\"style\":339},\"10\":{\"text\":\"人，前往你处\",\"style\":339,\"merge\":[0,1]}},\"isDrag\":true,\"height\":42},\"6\":{\"cells\":{\"1\":{\"text\":\"${jieshaoxin.shiqing}\",\"style\":342,\"merge\":[0,5]},\"15\":{\"text\":\"\"}},\"isDrag\":true,\"height\":48},\"7\":{\"cells\":{\"1\":{\"style\":343,\"text\":\"\"},\"2\":{\"style\":344,\"merge\":[0,5],\"text\":\"请予接洽并给予帮助。\"}},\"height\":56},\"8\":{\"cells\":{},\"height\":15},\"9\":{\"cells\":{},\"height\":11},\"10\":{\"cells\":{\"8\":{\"text\":\"\",\"style\":316,\"merge\":[0,3]}},\"height\":39},\"11\":{\"cells\":{\"8\":{\"merge\":[0,2],\"text\":\"单位盖章\",\"style\":347},\"11\":{\"merge\":[0,1],\"style\":316}},\"height\":84},\"12\":{\"cells\":{\"1\":{\"merge\":[0,2],\"text\":\"\",\"style\":317},\"4\":{\"merge\":[0,2],\"text\":\"\",\"style\":346},\"7\":{\"text\":\"（有效时间：至\",\"style\":317},\"8\":{\"text\":\"${jieshaoxin.gdata}\",\"style\":316,\"merge\":[0,2]},\"11\":{\"style\":348,\"text\":\"止）\"}},\"isDrag\":true,\"height\":30},\"13\":{\"cells\":{\"1\":{\"merge\":[12,11]}}},\"17\":{\"cells\":{},\"isDrag\":true},\"len\":89},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":688,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"left\"},{\"align\":\"left\",\"underline\":true},{\"underline\":true},{\"align\":\"center\",\"underline\":true},{\"align\":\"center\"},{\"align\":\"center\",\"underline\":false},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":16}},{\"font\":{\"size\":16}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16}},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":16}},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16}},{\"align\":\"left\",\"font\":{\"size\":16,\"bold\":true}},{\"font\":{\"size\":16,\"bold\":true}},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":16,\"bold\":true}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":true}},{\"font\":{\"bold\":true}},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":true}},{\"align\":\"left\",\"font\":{\"size\":16,\"bold\":false}},{\"font\":{\"size\":16,\"bold\":false}},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":16,\"bold\":false}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":false}},{\"font\":{\"bold\":false}},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":false}},{\"align\":\"left\",\"font\":{\"size\":16,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":16,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":16,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"align\":\"center\"},{\"font\":{\"size\":12},\"align\":\"center\"},{\"font\":{\"size\":8}},{\"font\":{\"size\":10}},{\"font\":{\"size\":10,\"bold\":true}},{\"font\":{\"size\":10,\"bold\":true},\"align\":\"center\"},{\"font\":{\"size\":18,\"bold\":true},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":18}},{\"font\":{\"size\":16,\"bold\":true},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":16}},{\"font\":{\"size\":12},\"valign\":\"bottom\"},{\"font\":{\"size\":12},\"valign\":\"middle\"},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"valign\":\"middle\",\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"right\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"right\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"right\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"left\":[\"dashed\",\"#000\"]}},{\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"font\":{\"size\":12,\"bold\":true},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true}},{\"font\":{\"size\":14,\"bold\":true},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"name\":\"Arial\"}},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Arial\"}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Arial\"}},{\"font\":{\"name\":\"Arial\"}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Source Sans Pro\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Source Sans Pro\"}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"}},{\"font\":{\"name\":\"Source Sans Pro\"}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Comic Sans MS\"}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Comic Sans MS\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Comic Sans MS\"}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"}},{\"font\":{\"name\":\"Comic Sans MS\"}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Comic Sans MS\"}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"name\":\"Courier New\"}},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Courier New\"}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Courier New\"}},{\"font\":{\"name\":\"Courier New\"}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"top\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Helvetica\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"top\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":10,\"name\":\"Lato\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"center\"},{\"font\":{\"size\":10,\"name\":\"Lato\"},\"valign\":\"middle\",\"color\":\"#000100\"},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{},{\"font\":{\"size\":12,\"name\":\"Lato\",\"bold\":true},\"color\":\"#000100\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"bold\":true},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"right\"},{\"align\":\"right\"},{\"align\":\"right\",\"font\":{\"size\":12}},{\"align\":\"left\",\"font\":{\"size\":12}},{\"font\":{\"size\":12},\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"align\":\"center\"},{\"valign\":\"top\"},{\"valign\":\"top\",\"align\":\"center\"},{\"valign\":\"top\",\"align\":\"center\",\"font\":{\"size\":12}},{\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"right\"},{\"font\":{\"size\":14}},{\"align\":\"right\",\"font\":{\"size\":14}},{\"font\":{\"size\":14},\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":14,\"bold\":true}},{\"align\":\"right\",\"font\":{\"size\":9}},{\"font\":{\"size\":9}},{\"font\":{\"size\":9},\"align\":\"center\"},{\"font\":{\"size\":9},\"align\":\"left\"},{\"align\":\"left\",\"font\":{\"bold\":true,\"size\":14}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14},\"valign\":\"top\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16},\"valign\":\"top\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":18},\"valign\":\"top\"},{\"align\":\"right\",\"font\":{\"size\":10}},{\"font\":{\"size\":10},\"align\":\"center\"},{\"align\":\"left\",\"font\":{\"size\":10}},{\"align\":\"right\",\"font\":{\"size\":12},\"valign\":\"bottom\"},{\"valign\":\"bottom\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"right\",\"valign\":\"bottom\"},{\"font\":{\"size\":12},\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"align\":\"center\",\"valign\":\"bottom\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"valign\":\"bottom\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"valign\":\"bottom\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":22},\"valign\":\"top\"},{\"align\":\"right\",\"font\":{\"size\":14},\"valign\":\"bottom\"},{\"font\":{\"size\":14},\"valign\":\"bottom\"},{\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"right\",\"valign\":\"bottom\"},{\"font\":{\"size\":14},\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"align\":\"center\",\"valign\":\"bottom\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"valign\":\"bottom\"},{\"align\":\"left\",\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"valign\":\"bottom\"},{\"font\":{\"size\":14,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":14},\"align\":\"center\"},{\"valign\":\"top\",\"align\":\"center\",\"font\":{\"size\":14}},{\"align\":\"left\",\"font\":{\"size\":14}}],\"validations\":[],\"cols\":{\"0\":{\"width\":23},\"1\":{\"width\":46},\"2\":{\"width\":24},\"3\":{\"width\":15},\"4\":{\"width\":37},\"5\":{\"width\":13},\"6\":{\"width\":83},\"7\":{\"width\":256},\"8\":{\"width\":42},\"9\":{\"width\":18},\"10\":{\"width\":77},\"11\":{\"width\":54},\"12\":{\"width\":28},\"13\":{\"width\":62},\"16\":{\"width\":55},\"len\":50},\"merges\":[\"C0:D0\",\"G11:H11\",\"G12:H12\",\"B5:E5\",\"B6:G6\",\"C8:H8\",\"I12:K12\",\"B4:L4\",\"K6:L6\",\"B13:D13\",\"E13:G13\",\"I11:L11\",\"L12:M12\",\"B14:M26\",\"I13:K13\",\"B7:G7\"]}', '', 'https://static.jeecg.com/designreport/images/介绍xin_1607072641405.png', 'jeecg', '2020-07-10 13:38:40', 'admin', '2021-04-01 03:15:11', 0, NULL, NULL, 1, 831, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('7acddbc92bc73d06c7f62ff55dfdca19', '566233333333867', '销售单副本3867', '', NULL, 'printinfo', '{\"area\":{\"sri\":6,\"sci\":7,\"eri\":6,\"eci\":7,\"width\":88,\"height\":25},\"printElWidth\":794,\"excel_config_id\":\"519c1c6f4d1f584ae8fa5b43b45acdc7\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{\"1\":{\"text\":\"销售单\",\"style\":40,\"merge\":[0,6]},\"2\":{\"style\":41},\"3\":{\"style\":41},\"4\":{\"style\":41},\"5\":{\"style\":41},\"6\":{\"style\":41},\"7\":{\"style\":41}},\"height\":99},\"1\":{\"cells\":{\"1\":{\"text\":\"商品编码\",\"style\":62},\"2\":{\"text\":\"商品名称\",\"style\":62},\"3\":{\"text\":\"销售时间\",\"style\":62},\"4\":{\"text\":\"销售数量\",\"style\":62},\"5\":{\"text\":\"定价\",\"style\":62},\"6\":{\"text\":\"优惠价\",\"style\":62},\"7\":{\"text\":\"付款金额\",\"style\":62}},\"height\":39},\"2\":{\"cells\":{\"1\":{\"text\":\"#{xiaoshou.bianma}\",\"style\":61},\"2\":{\"text\":\"#{xiaoshou.cname}\",\"style\":61},\"3\":{\"text\":\"#{xiaoshou.ctime}\",\"style\":61},\"4\":{\"text\":\"#{xiaoshou.cnum}\",\"style\":61},\"5\":{\"text\":\"#{xiaoshou.cprice}\",\"style\":61},\"6\":{\"text\":\"#{xiaoshou.yprice}\",\"style\":61},\"7\":{\"text\":\"#{xiaoshou.ctotal}\",\"style\":61}},\"isDrag\":true,\"height\":35},\"3\":{\"cells\":{\"1\":{\"style\":44,\"text\":\"\"},\"2\":{\"style\":44},\"3\":{\"style\":44},\"4\":{\"style\":44},\"5\":{\"style\":44,\"text\":\"\"},\"6\":{\"text\":\"\",\"style\":45},\"7\":{\"style\":46,\"text\":\"=SUM(H3)\"}},\"isDrag\":true,\"height\":73},\"5\":{\"cells\":{},\"isDrag\":true},\"6\":{\"cells\":{},\"isDrag\":true},\"7\":{\"cells\":{\"2\":{\"text\":\"\"}},\"isDrag\":true},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":754,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#01b0f1\"],\"top\":[\"thin\",\"#01b0f1\"],\"left\":[\"thin\",\"#01b0f1\"],\"right\":[\"thin\",\"#01b0f1\"]}},{\"border\":{\"bottom\":[\"thin\",\"#01b0f1\"],\"top\":[\"thin\",\"#01b0f1\"],\"left\":[\"thin\",\"#01b0f1\"],\"right\":[\"thin\",\"#01b0f1\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#01b0f1\"],\"top\":[\"thin\",\"#01b0f1\"],\"left\":[\"thin\",\"#01b0f1\"],\"right\":[\"thin\",\"#01b0f1\"]},\"bgcolor\":\"#01b0f1\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#01b0f1\"},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"size\":18}},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"align\":\"center\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#fed964\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#fdc101\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#fdc101\"},{\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"align\":\"center\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#ffe59a\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#ffc001\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#fed964\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#ed7d31\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#fdc101\"],\"top\":[\"thin\",\"#fdc101\"],\"left\":[\"thin\",\"#fdc101\"],\"right\":[\"thin\",\"#fdc101\"]},\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"align\":\"center\"},{\"font\":{\"size\":8}},{\"font\":{\"size\":8},\"color\":\"#7f7f7f\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#9cc2e6\"},{\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]}},{\"font\":{\"bold\":true}},{\"font\":{\"bold\":true,\"size\":12}},{\"font\":{\"bold\":true,\"size\":16}},{\"font\":{\"bold\":true,\"size\":18}},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"align\":\"right\"},{\"align\":\"right\"},{\"align\":\"left\"},{\"align\":\"right\",\"font\":{\"size\":16}},{\"align\":\"left\",\"font\":{\"size\":16}},{\"align\":\"right\",\"font\":{\"size\":14}},{\"align\":\"left\",\"font\":{\"size\":14}},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true,\"name\":\"宋体\"}},{\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"right\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"right\",\"font\":{\"size\":14,\"name\":\"宋体\"}},{\"align\":\"left\",\"font\":{\"size\":14,\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#2e75b5\"],\"top\":[\"thin\",\"#2e75b5\"],\"left\":[\"thin\",\"#2e75b5\"],\"right\":[\"thin\",\"#2e75b5\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#000100\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#ffff01\"],\"top\":[\"thin\",\"#ffff01\"],\"left\":[\"thin\",\"#ffff01\"],\"right\":[\"thin\",\"#ffff01\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"right\",\"font\":{\"size\":14,\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"color\":\"#ffffff\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#2e75b5\"],\"top\":[\"thin\",\"#2e75b5\"],\"left\":[\"thin\",\"#2e75b5\"],\"right\":[\"thin\",\"#2e75b5\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#4371c6\"],\"top\":[\"thin\",\"#4371c6\"],\"left\":[\"thin\",\"#4371c6\"],\"right\":[\"thin\",\"#4371c6\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#ffffff\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]}},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"],\"top\":[\"thin\",\"#d8d8d8\"],\"left\":[\"thin\",\"#d8d8d8\"],\"right\":[\"thin\",\"#d8d8d8\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#ffffff\",\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#ffffff\",\"bgcolor\":\"#5b9cd6\",\"font\":{\"name\":\"宋体\"},\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]}}],\"validations\":[],\"cols\":{\"0\":{\"width\":31},\"1\":{\"width\":102},\"2\":{\"width\":170},\"3\":{\"width\":147},\"4\":{\"width\":66},\"5\":{\"width\":66},\"6\":{\"width\":84},\"7\":{\"width\":88},\"8\":{\"width\":121},\"len\":26},\"merges\":[\"B1:H1\"]}', '', 'https://static.jeecg.com/designreport/images/xiaoshou_1607310086160.png', 'admin', '2021-01-19 10:46:18', 'admin', '2021-02-02 19:01:02', 1, NULL, NULL, 0, 2096, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('7c02c224a2db56d0350069650033f702', '895666', '核查评估表', '', NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":{\"sri\":5,\"sci\":18,\"eri\":5,\"eci\":18,\"width\":53,\"height\":46},\"printElWidth\":1399,\"excel_config_id\":\"7c02c224a2db56d0350069650033f702\",\"printElHeight\":790,\"rows\":{\"0\":{\"cells\":{\"1\":{\"text\":\"XX县（市、区）YY低保第三方核查评估汇总表\",\"merge\":[0,21],\"style\":386},\"2\":{\"style\":386},\"3\":{\"style\":386},\"4\":{\"style\":386},\"5\":{\"style\":386},\"6\":{\"style\":386},\"7\":{\"style\":386},\"8\":{\"style\":386},\"9\":{\"style\":386},\"10\":{\"style\":386},\"11\":{\"style\":386},\"12\":{\"style\":386},\"13\":{\"style\":386},\"14\":{\"style\":386},\"15\":{\"style\":386},\"16\":{\"style\":386},\"17\":{\"style\":386},\"18\":{\"style\":386},\"19\":{\"style\":386},\"20\":{\"style\":386},\"21\":{\"style\":386},\"22\":{\"style\":386}},\"height\":70},\"1\":{\"cells\":{\"1\":{\"merge\":[0,2],\"style\":403,\"text\":\"     北京市林翠社区\"},\"2\":{\"style\":398,\"text\":\" \"},\"3\":{\"style\":398,\"text\":\" \"},\"4\":{\"merge\":[0,2],\"text\":\"镇（乡、街道办事处）\",\"style\":399},\"5\":{\"style\":399},\"6\":{\"style\":399},\"7\":{\"style\":399,\"merge\":[0,7]},\"8\":{\"style\":400},\"9\":{\"style\":400},\"10\":{\"style\":400},\"11\":{\"style\":400},\"12\":{\"style\":400},\"13\":{\"style\":400},\"14\":{\"style\":400},\"15\":{\"merge\":[0,7],\"text\":\"单位：人、元、套、平方米\",\"style\":398},\"16\":{\"style\":401},\"17\":{\"style\":401},\"18\":{\"style\":401},\"19\":{\"style\":401},\"20\":{\"style\":401},\"21\":{\"style\":401},\"22\":{\"style\":401}}},\"2\":{\"cells\":{\"1\":{\"style\":114},\"2\":{\"style\":114},\"3\":{\"style\":114},\"4\":{\"style\":114},\"5\":{\"style\":114},\"6\":{\"style\":114},\"7\":{\"style\":114},\"8\":{\"style\":114},\"9\":{\"style\":114},\"10\":{\"style\":114},\"11\":{\"style\":114},\"12\":{\"style\":114},\"13\":{\"style\":114},\"14\":{\"style\":114},\"15\":{\"style\":114},\"16\":{\"style\":114},\"17\":{\"style\":114},\"18\":{\"style\":114},\"19\":{\"style\":114},\"20\":{\"style\":114},\"21\":{\"style\":114},\"22\":{\"style\":114}},\"height\":14},\"3\":{\"cells\":{\"1\":{\"style\":406,\"text\":\"村（社区）名称\",\"merge\":[1,0]},\"2\":{\"style\":407,\"text\":\"户主名称\",\"merge\":[1,0]},\"3\":{\"style\":407,\"text\":\"保障编号\",\"merge\":[1,0]},\"4\":{\"style\":408,\"text\":\"家庭人口\",\"merge\":[1,0]},\"5\":{\"style\":409,\"text\":\"家庭住址\",\"merge\":[1,0]},\"6\":{\"style\":409,\"text\":\"联系电话\",\"merge\":[1,0]},\"7\":{\"style\":408,\"text\":\"身份证号码\",\"merge\":[1,0]},\"8\":{\"style\":409,\"text\":\"原保障\",\"merge\":[0,2]},\"9\":{\"style\":377,\"text\":\" \"},\"10\":{\"style\":377,\"text\":\" \"},\"11\":{\"text\":\"核减后月人均收入\",\"style\":408,\"merge\":[1,0]},\"12\":{\"merge\":[0,5],\"text\":\"保障建议\",\"style\":410},\"13\":{\"style\":379,\"text\":\" \"},\"14\":{\"style\":379,\"text\":\" \"},\"15\":{\"style\":379,\"text\":\" \"},\"16\":{\"style\":379,\"text\":\" \"},\"17\":{\"style\":379,\"text\":\" \"},\"18\":{\"text\":\"是否新增对象\",\"style\":411,\"merge\":[1,0]},\"19\":{\"text\":\"建议取消原因\",\"style\":409,\"merge\":[0,3]},\"20\":{\"style\":377,\"text\":\" \"},\"21\":{\"style\":377,\"text\":\" \"},\"22\":{\"style\":377,\"text\":\" \"}}},\"4\":{\"cells\":{\"1\":{\"style\":381,\"text\":\" \"},\"2\":{\"style\":407,\"text\":\" \"},\"3\":{\"style\":382,\"text\":\" \"},\"4\":{\"style\":408,\"text\":\" \"},\"5\":{\"style\":377,\"text\":\" \"},\"6\":{\"style\":409,\"text\":\" \"},\"7\":{\"style\":383,\"text\":\" \"},\"8\":{\"text\":\"户数\",\"style\":412},\"9\":{\"style\":411,\"text\":\"人口\"},\"10\":{\"style\":413,\"text\":\"金额\"},\"11\":{\"style\":383,\"text\":\" \"},\"12\":{\"text\":\"保障类型\",\"style\":408},\"13\":{\"style\":413,\"text\":\"人口\"},\"14\":{\"style\":408,\"text\":\"差额补助\"},\"15\":{\"style\":408,\"text\":\"全额补助\"},\"16\":{\"style\":408,\"text\":\"增发补助\"},\"17\":{\"style\":408,\"text\":\"合计补助\"},\"18\":{\"style\":411,\"text\":\" \"},\"19\":{\"style\":408,\"text\":\"收入超标\"},\"20\":{\"style\":406,\"text\":\"机动车超标\"},\"21\":{\"style\":410,\"text\":\"死亡\"},\"22\":{\"style\":410,\"text\":\"其他\"}},\"height\":50},\"5\":{\"cells\":{\"1\":{\"text\":\"#{hecha.name}\",\"style\":414,\"rendered\":\"\"},\"2\":{\"text\":\"#{hecha.hname}\",\"style\":414},\"3\":{\"text\":\"#{hecha.num}\",\"style\":414},\"4\":{\"text\":\"#{hecha.knum}\",\"style\":414},\"5\":{\"text\":\"#{hecha.zhuzhi}\",\"style\":414},\"6\":{\"text\":\"#{hecha.phone}\",\"style\":414},\"7\":{\"text\":\"#{hecha.scard}\",\"style\":414},\"8\":{\"text\":\"#{hecha.yhnum}\",\"style\":414},\"9\":{\"text\":\"#{hecha.yren}\",\"style\":414},\"10\":{\"text\":\"#{hecha.yjine}\",\"style\":414},\"11\":{\"text\":\"#{hecha.yjine}\",\"style\":414},\"12\":{\"text\":\"#{hecha.type}\",\"style\":414},\"13\":{\"text\":\"#{hecha.rk}\",\"style\":414},\"14\":{\"text\":\"#{hecha.cbz}\",\"style\":414},\"15\":{\"text\":\"#{hecha.cbz}\",\"style\":414},\"16\":{\"text\":\"#{hecha.cbz}\",\"style\":414},\"17\":{\"text\":\"#{hecha.cbz}\",\"style\":414},\"18\":{\"text\":\"#{hecha.sf1}\",\"style\":414},\"19\":{\"text\":\"#{hecha.sf2}\",\"style\":414},\"20\":{\"text\":\"#{hecha.sf3}\",\"style\":414},\"21\":{\"text\":\"#{hecha.sf4}\",\"style\":414},\"22\":{\"text\":\"#{hecha.bz}\",\"style\":414}},\"isDrag\":true,\"height\":46},\"6\":{\"cells\":{\"1\":{\"style\":114},\"2\":{\"style\":114},\"3\":{\"style\":114},\"4\":{\"style\":114},\"5\":{\"style\":114},\"6\":{\"style\":114},\"7\":{\"style\":114},\"8\":{\"style\":114},\"9\":{\"style\":114},\"10\":{\"style\":114},\"11\":{\"style\":114},\"12\":{\"style\":114},\"13\":{\"style\":114},\"14\":{\"style\":114},\"15\":{\"style\":114},\"16\":{\"style\":114},\"17\":{\"style\":114},\"18\":{\"style\":114},\"19\":{\"style\":114},\"20\":{\"style\":114},\"21\":{\"style\":114},\"22\":{\"style\":114}},\"height\":46},\"7\":{\"cells\":{\"1\":{\"style\":114},\"2\":{\"style\":114},\"3\":{\"style\":114},\"4\":{\"style\":114},\"5\":{\"style\":114},\"6\":{\"style\":114},\"7\":{\"style\":114},\"8\":{\"style\":114},\"9\":{\"style\":114},\"10\":{\"style\":114},\"11\":{\"style\":114},\"12\":{\"style\":114},\"13\":{\"style\":114},\"14\":{\"style\":114},\"15\":{\"style\":114},\"16\":{\"style\":114},\"17\":{\"style\":114},\"18\":{\"style\":114},\"19\":{\"style\":114},\"20\":{\"style\":114},\"21\":{\"style\":114},\"22\":{\"style\":114}},\"height\":46},\"8\":{\"cells\":{\"1\":{\"text\":\"\"},\"2\":{\"style\":114},\"3\":{\"style\":114},\"4\":{\"style\":114},\"5\":{\"style\":114},\"6\":{\"style\":114},\"7\":{\"style\":114},\"8\":{\"style\":114},\"9\":{\"style\":114},\"10\":{\"style\":114},\"11\":{\"style\":114},\"12\":{\"style\":114},\"13\":{\"style\":114},\"14\":{\"style\":114},\"15\":{\"style\":114},\"16\":{\"style\":114},\"17\":{\"style\":114},\"18\":{\"style\":114},\"19\":{\"style\":114},\"20\":{\"style\":114},\"21\":{\"style\":114},\"22\":{\"style\":114}},\"isDrag\":true},\"len\":102},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":1378,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true},{\"textwrap\":true},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":false},{\"textwrap\":false},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\"},{\"textwrap\":true,\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"valign\":\"middle\"},{\"textwrap\":true,\"valign\":\"middle\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":false,\"valign\":\"middle\"},{\"textwrap\":false,\"valign\":\"middle\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"valign\":\"bottom\"},{\"textwrap\":true,\"valign\":\"bottom\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"valign\":\"top\"},{\"border\":{\"bottom\":[\"medium\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"size\":18}},{\"align\":\"center\",\"font\":{\"size\":16}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true,\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"}},{\"font\":{\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"font\":{\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"font\":{\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Helvetica\"}},{\"align\":\"center\",\"font\":{\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Helvetica\"}},{\"textwrap\":true,\"font\":{\"name\":\"Helvetica\"}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Helvetica\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Helvetica\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Helvetica\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Helvetica\"}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true,\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"align\":\"center\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"textwrap\":true,\"font\":{\"name\":\"Source Sans Pro\"}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true,\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Comic Sans MS\"}},{\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"align\":\"center\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"textwrap\":true,\"font\":{\"name\":\"Comic Sans MS\"}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true,\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Courier New\"}},{\"align\":\"center\",\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Courier New\"}},{\"textwrap\":true,\"font\":{\"name\":\"Courier New\"}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Courier New\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Courier New\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Courier New\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Courier New\"}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true,\"name\":\"Verdana\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Verdana\"}},{\"font\":{\"name\":\"Verdana\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"font\":{\"name\":\"Verdana\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Verdana\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"font\":{\"name\":\"Verdana\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Verdana\"}},{\"align\":\"center\",\"font\":{\"name\":\"Verdana\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Verdana\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Verdana\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Verdana\"}},{\"textwrap\":true,\"font\":{\"name\":\"Verdana\"}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Verdana\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Verdana\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Verdana\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Verdana\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Verdana\"}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true,\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"}},{\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\"}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\"}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"textwrap\":true,\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"align\":\"center\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"textwrap\":true,\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"align\":\"center\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"align\":\"center\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"}},{\"align\":\"center\",\"valign\":\"middle\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"valign\":\"middle\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":false,\"font\":{\"name\":\"Lato\"}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"font\":{\"name\":\"Lato\"},\"valign\":\"middle\"},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true,\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"textwrap\":true,\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\"},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"top\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]},\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"valign\":\"middle\"},{\"align\":\"center\",\"border\":{\"right\":[\"thin\",\"#ffffff\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]}},{\"align\":\"center\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]}},{\"border\":{\"bottom\":[\"thin\",\"#ffffff\"],\"top\":[\"thin\",\"#ffffff\"],\"left\":[\"thin\",\"#ffffff\"],\"right\":[\"thin\",\"#ffffff\"]}},{\"align\":\"center\",\"valign\":\"middle\",\"border\":{\"right\":[\"thin\",\"#ffffff\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"border\":{\"right\":[\"thin\",\"#ffffff\"]}},{\"border\":{\"right\":[\"thin\",\"#ffffff\"]}},{\"align\":\"center\",\"valign\":\"middle\",\"border\":{\"right\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"border\":{\"right\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"border\":{\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"right\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"valign\":\"middle\",\"border\":{\"left\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"]}},{\"font\":{\"name\":\"Lato\"},\"border\":{\"top\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"font\":{\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"]}},{\"font\":{\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"]}},{\"font\":{\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#000100\"]},\"align\":\"right\"},{\"font\":{\"name\":\"Lato\"},\"align\":\"right\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"valign\":\"middle\"},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#5b9cd6\",\"color\":\"#ffffff\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"align\":\"center\"},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\"},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#ffffff\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\"},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#000100\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\"},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#f4b184\",\"color\":\"#262626\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\"},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#9cc2e6\",\"color\":\"#262626\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\"},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#262626\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\"},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#00b04e\",\"color\":\"#ffffff\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]},\"align\":\"center\"},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\"},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#a7d08c\",\"color\":\"#ffffff\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\"},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":8},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]},\"align\":\"center\",\"font\":{\"size\":8}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\"},{\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#71ae47\",\"color\":\"#ffffff\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\"},{\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\"},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#00b04e\"],\"top\":[\"thin\",\"#00b04e\"],\"left\":[\"thin\",\"#00b04e\"],\"right\":[\"thin\",\"#00b04e\"]}},{\"align\":\"center\",\"font\":{\"size\":15,\"bold\":true,\"name\":\"Lato\"}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#000100\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":9}},{\"font\":{\"name\":\"Lato\",\"size\":9}},{\"font\":{\"size\":9}},{\"align\":\"center\",\"font\":{\"size\":9}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#000100\"]},\"color\":\"#a5a5a5\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":9},\"color\":\"#a5a5a5\"},{\"font\":{\"name\":\"Lato\",\"size\":9},\"color\":\"#a5a5a5\"},{\"font\":{\"size\":9},\"color\":\"#a5a5a5\"},{\"align\":\"center\",\"font\":{\"size\":9},\"color\":\"#a5a5a5\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#000100\"]},\"color\":\"#7f7f7f\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":9},\"color\":\"#7f7f7f\"},{\"font\":{\"name\":\"Lato\",\"size\":9},\"color\":\"#7f7f7f\"},{\"font\":{\"size\":9},\"color\":\"#7f7f7f\"},{\"align\":\"center\",\"font\":{\"size\":9},\"color\":\"#7f7f7f\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]},\"color\":\"#7f7f7f\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":9},\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"]},\"color\":\"#7f7f7f\"},{\"border\":{\"bottom\":[\"thin\",\"#d8d8d8\"]},\"align\":\"center\",\"font\":{\"size\":8}},{\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"]},\"align\":\"center\",\"font\":{\"size\":8}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"textwrap\":true,\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"align\":\"center\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"textwrap\":true,\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"textwrap\":true,\"valign\":\"bottom\",\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"textwrap\":true,\"font\":{\"name\":\"Lato\",\"size\":10},\"bgcolor\":\"#02a274\",\"color\":\"#ffffff\",\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]}},{\"border\":{\"bottom\":[\"thin\",\"#a5a5a5\"],\"top\":[\"thin\",\"#a5a5a5\"],\"left\":[\"thin\",\"#a5a5a5\"],\"right\":[\"thin\",\"#a5a5a5\"]},\"align\":\"center\",\"font\":{\"size\":8}}],\"validations\":[],\"cols\":{\"0\":{\"width\":30},\"1\":{\"width\":68},\"2\":{\"width\":86},\"3\":{\"width\":93},\"4\":{\"width\":91},\"5\":{\"width\":156},\"6\":{\"width\":95},\"7\":{\"width\":85},\"8\":{\"width\":37},\"9\":{\"width\":30},\"10\":{\"width\":43},\"11\":{\"width\":66},\"12\":{\"width\":38},\"13\":{\"width\":41},\"14\":{\"width\":54},\"15\":{\"width\":49},\"16\":{\"width\":45},\"17\":{\"width\":49},\"18\":{\"width\":53},\"19\":{\"width\":40},\"20\":{\"width\":50},\"21\":{\"width\":40},\"22\":{\"width\":39},\"len\":50},\"merges\":[\"M4:R4\",\"B4:B5\",\"C4:C5\",\"D4:D5\",\"E4:E5\",\"F4:F5\",\"G4:G5\",\"H4:H5\",\"I4:K4\",\"L4:L5\",\"S4:S5\",\"T4:W4\",\"E2:G2\",\"B2:D2\",\"B1:W1\",\"P2:W2\",\"H2:O2\"]}', '', 'https://static.jeecg.com/designreport/images/QQ截图20201207113312_1607312171402.png', 'jeecg', '2020-07-14 16:41:42', 'admin', '2021-02-03 14:01:17', 0, NULL, NULL, 1, 260, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('94b04a1ed7c17f8e96baa6d89fb90758', '3698522', '员工请假单', '', NULL, 'printinfo', '{\"area\":false,\"printElWidth\":794,\"excel_config_id\":\"94b04a1ed7c17f8e96baa6d89fb90758\",\"printElHeight\":1047,\"rows\":{\"1\":{\"cells\":{\"0\":{\"text\":\"员工请假单\",\"style\":100,\"merge\":[0,7]},\"1\":{\"style\":100},\"2\":{\"style\":100},\"3\":{\"style\":100},\"4\":{\"style\":100},\"5\":{\"style\":100},\"6\":{\"style\":100},\"7\":{\"style\":100}},\"height\":65},\"2\":{\"cells\":{\"0\":{\"text\":\"单位：北极星\",\"style\":101,\"merge\":[0,2]},\"1\":{\"style\":101},\"2\":{\"style\":101},\"3\":{\"style\":102},\"4\":{\"style\":102},\"5\":{\"style\":102},\"6\":{\"style\":102},\"7\":{\"style\":102}},\"height\":38},\"3\":{\"cells\":{\"0\":{\"text\":\"姓名\",\"style\":119},\"1\":{\"style\":119,\"text\":\" \"},\"2\":{\"text\":\"工作岗位\",\"style\":120},\"3\":{\"style\":119,\"text\":\" \"},\"4\":{\"text\":\"工作时间\",\"style\":119},\"5\":{\"style\":119,\"text\":\" \"},\"6\":{\"text\":\"出生日期\",\"style\":119},\"7\":{\"style\":119,\"text\":\" \"}}},\"4\":{\"cells\":{\"0\":{\"text\":\"请选择假类型\",\"style\":121,\"merge\":[4,0]},\"1\":{\"text\":\"年休假\",\"style\":120},\"2\":{\"style\":120,\"text\":\"病、事假\"},\"3\":{\"style\":120,\"text\":\"探亲假\"},\"4\":{\"style\":119,\"merge\":[0,1],\"text\":\"婚、丧假\"},\"5\":{\"style\":107,\"text\":\" \"},\"6\":{\"style\":119,\"merge\":[0,1],\"text\":\"生育假\"},\"7\":{\"style\":107,\"text\":\" \"}},\"height\":29},\"5\":{\"cells\":{\"0\":{\"style\":0},\"1\":{\"text\":\"1、公岭满1~9年（5天）\",\"style\":122},\"2\":{\"style\":119,\"text\":\"1、病假\"},\"3\":{\"style\":119,\"text\":\"1、未婚探父母（20天）\"},\"4\":{\"style\":119,\"merge\":[0,1],\"text\":\"1、婚假（3天）\"},\"5\":{\"style\":107,\"text\":\" \"},\"6\":{\"style\":119,\"merge\":[0,1],\"text\":\"1、流产\"},\"7\":{\"style\":107,\"text\":\" \"}},\"height\":25},\"6\":{\"cells\":{\"0\":{\"style\":0},\"1\":{\"style\":123,\"text\":\"2、公岭满10~19年（10天）\"},\"2\":{\"style\":119,\"text\":\"2、事假\"},\"3\":{\"style\":119,\"text\":\"2、已婚探父母（20天）\"},\"4\":{\"style\":119,\"merge\":[0,1],\"text\":\"2、晚婚假（13天）\"},\"5\":{\"style\":107,\"text\":\" \"},\"6\":{\"style\":119,\"merge\":[0,1],\"text\":\"2、产假\"},\"7\":{\"style\":107,\"text\":\" \"}}},\"7\":{\"cells\":{\"0\":{\"style\":0},\"1\":{\"style\":123,\"text\":\"3、公岭满20年（15天）\"},\"2\":{\"style\":119,\"text\":\" \"},\"3\":{\"style\":119,\"text\":\"3、探配偶（30天）\"},\"4\":{\"style\":119,\"merge\":[0,1],\"text\":\"3、丧假（3天）\"},\"5\":{\"style\":107,\"text\":\" \"},\"6\":{\"style\":119,\"merge\":[0,1],\"text\":\"3、哺乳假\"},\"7\":{\"style\":107,\"text\":\" \"}}},\"8\":{\"cells\":{\"0\":{\"style\":0},\"1\":{\"style\":119,\"text\":\" \"},\"2\":{\"style\":119,\"text\":\" \"},\"3\":{\"style\":119,\"text\":\"探亲地点：\",\"merge\":[0,2]},\"4\":{\"style\":107,\"text\":\" \"},\"5\":{\"style\":107,\"text\":\" \"},\"6\":{\"style\":119,\"merge\":[0,1],\"text\":\"4、陪护假\"},\"7\":{\"style\":107,\"text\":\" \"},\"8\":{\"style\":15},\"9\":{\"style\":15},\"10\":{\"style\":15},\"11\":{\"style\":15},\"12\":{\"style\":15},\"13\":{\"style\":15},\"14\":{\"style\":15},\"15\":{\"style\":15},\"16\":{\"style\":15},\"17\":{\"style\":15},\"18\":{\"style\":15},\"19\":{\"style\":15},\"20\":{\"style\":15},\"21\":{\"style\":15},\"22\":{\"style\":15},\"23\":{\"style\":5},\"24\":{\"style\":5},\"25\":{\"style\":5}}},\"9\":{\"cells\":{\"0\":{\"style\":124,\"text\":\"请假时间\"},\"1\":{\"style\":125,\"merge\":[0,6],\"text\":\"2020年02-30 至2020年02-03-30\"},\"2\":{\"style\":115,\"text\":\" \"},\"3\":{\"style\":115,\"text\":\" \"},\"4\":{\"style\":115,\"text\":\" \"},\"5\":{\"style\":115,\"text\":\" \"},\"6\":{\"style\":115,\"text\":\" \"},\"7\":{\"style\":115,\"text\":\" \"}},\"height\":46},\"10\":{\"cells\":{\"0\":{\"style\":126,\"text\":\"审批人员及意见\"},\"1\":{\"merge\":[0,6],\"style\":127,\"text\":\"同意\"},\"2\":{\"style\":118,\"text\":\" \"},\"3\":{\"style\":118,\"text\":\" \"},\"4\":{\"style\":118,\"text\":\" \"},\"5\":{\"style\":118,\"text\":\" \"},\"6\":{\"style\":118,\"text\":\" \"},\"7\":{\"style\":118,\"text\":\" \"}},\"height\":89},\"11\":{\"cells\":{\"0\":{\"text\":\"备注\",\"style\":119},\"1\":{\"style\":119,\"text\":\" \"},\"2\":{\"text\":\"请假人签名\",\"style\":119},\"3\":{\"merge\":[0,4],\"style\":119,\"text\":\" \"},\"4\":{\"style\":107,\"text\":\" \"},\"5\":{\"style\":107,\"text\":\" \"},\"6\":{\"style\":107,\"text\":\" \"},\"7\":{\"style\":107,\"text\":\" \"}},\"height\":90},\"12\":{\"cells\":{\"0\":{\"merge\":[0,7],\"style\":120,\"text\":\"请假审批表一式两份，考勤员与人力资源部门各存一份\"},\"1\":{\"style\":106,\"text\":\" \"},\"2\":{\"style\":106,\"text\":\" \"},\"3\":{\"style\":106,\"text\":\" \"},\"4\":{\"style\":106,\"text\":\" \"},\"5\":{\"style\":106,\"text\":\" \"},\"6\":{\"style\":106,\"text\":\" \"},\"7\":{\"style\":106,\"text\":\" \"}},\"height\":25},\"len\":101},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":789,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"textwrap\":true},{\"textwrap\":false},{\"textwrap\":true,\"valign\":\"middle\"},{\"textwrap\":false,\"valign\":\"middle\"},{\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"textwrap\":false,\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"textwrap\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"textwrap\":false,\"valign\":\"middle\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"textwrap\":false,\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"textwrap\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"left\"},{},{\"font\":{\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"}},{\"align\":\"center\",\"font\":{\"name\":\"Helvetica\"}},{\"textwrap\":false,\"valign\":\"middle\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"}},{\"textwrap\":false,\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"}},{\"font\":{\"name\":\"Arial\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"align\":\"center\",\"font\":{\"name\":\"Arial\"}},{\"textwrap\":false,\"valign\":\"middle\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"textwrap\":false,\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"align\":\"center\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"textwrap\":false,\"valign\":\"middle\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"textwrap\":false,\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"align\":\"center\",\"font\":{\"name\":\"Courier New\"}},{\"textwrap\":false,\"valign\":\"middle\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"textwrap\":false,\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"font\":{\"name\":\"Courier New\"},\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"name\":\"Courier New\"},\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"textwrap\":true,\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"textwrap\":true,\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"align\":\"center\"},{\"font\":{\"name\":\"Courier New\"},\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"name\":\"Courier New\",\"size\":14}},{\"align\":\"center\",\"font\":{\"size\":14}},{\"align\":\"center\",\"font\":{\"name\":\"Courier New\",\"size\":14,\"bold\":true}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true}},{\"font\":{\"name\":\"Courier New\"},\"color\":\"#7f7f7f\"},{\"color\":\"#7f7f7f\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"textwrap\":true,\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Courier New\"},\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"textwrap\":false,\"valign\":\"middle\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"textwrap\":false,\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"align\":\"center\",\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\"},{\"align\":\"center\",\"color\":\"#000100\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\"},{\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"textwrap\":true,\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Lato\"},\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"textwrap\":false,\"valign\":\"middle\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"textwrap\":false,\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"align\":\"center\",\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\",\"font\":{\"name\":\"Lato\"}},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\",\"font\":{\"name\":\"Lato\"},\"valign\":\"middle\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\",\"font\":{\"name\":\"Lato\"},\"valign\":\"bottom\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\",\"font\":{\"name\":\"Lato\"},\"valign\":\"top\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"valign\":\"top\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"valign\":\"top\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"valign\":\"middle\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"valign\":\"middle\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"valign\":\"bottom\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"valign\":\"bottom\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"textwrap\":true},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"textwrap\":true},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"textwrap\":false},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"textwrap\":false},{\"textwrap\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\",\"font\":{\"name\":\"Lato\"}},{\"align\":\"center\",\"font\":{\"name\":\"宋体\",\"size\":14,\"bold\":true}},{\"font\":{\"name\":\"宋体\"},\"color\":\"#7f7f7f\"},{\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"textwrap\":true,\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"宋体\"},\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"textwrap\":false,\"valign\":\"middle\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"textwrap\":false,\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"align\":\"center\",\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\",\"font\":{\"name\":\"宋体\"},\"valign\":\"top\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\",\"valign\":\"top\"},{\"align\":\"center\",\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\",\"valign\":\"top\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\",\"font\":{\"name\":\"宋体\"},\"valign\":\"bottom\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\",\"textwrap\":false},{\"align\":\"center\",\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\",\"textwrap\":false},{\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"name\":\"宋体\"},\"align\":\"center\",\"color\":\"#000100\"},{\"textwrap\":false,\"valign\":\"middle\",\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"textwrap\":false,\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"color\":\"#000100\",\"font\":{\"name\":\"宋体\"},\"valign\":\"top\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\",\"valign\":\"top\"},{\"textwrap\":true,\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"color\":\"#000100\",\"font\":{\"name\":\"宋体\"},\"valign\":\"bottom\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#262626\"],\"top\":[\"thin\",\"#262626\"],\"left\":[\"thin\",\"#262626\"],\"right\":[\"thin\",\"#262626\"]},\"font\":{\"name\":\"宋体\"},\"color\":\"#000100\",\"textwrap\":false}],\"validations\":[],\"cols\":{\"0\":{\"width\":35},\"1\":{\"width\":195},\"2\":{\"width\":77},\"3\":{\"width\":168},\"4\":{\"width\":62},\"6\":{\"width\":70},\"7\":{\"width\":82},\"len\":26},\"merges\":[\"D9:F9\",\"E5:F5\",\"E6:F6\",\"E7:F7\",\"E8:F8\",\"G5:H5\",\"G6:H6\",\"G7:H7\",\"G8:H8\",\"G9:H9\",\"B10:H10\",\"B11:H11\",\"D12:H12\",\"A13:H13\",\"A3:C3\",\"A2:H2\",\"A5:A9\"]}', '', 'https://static.jeecg.com/designreport/images/QQ截图20201207135257_1607320433681.png', 'jeecg', '2020-07-10 18:29:39', 'admin', '2021-02-03 14:01:12', 0, NULL, NULL, 1, 142, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('961455b47c0b86dc961e90b5893bff05', '56780774', '阜阳检票数查询副本0774', '', NULL, 'printinfo', '{\"area\":{\"sri\":8,\"sci\":6,\"eri\":8,\"eci\":6,\"width\":75,\"height\":25},\"printElWidth\":794,\"excel_config_id\":\"53c82a76f837d5661dceec7d93afafec\",\"printElHeight\":1047,\"rows\":{\"0\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"text\":\"\",\"style\":66},\"2\":{\"style\":66},\"3\":{\"style\":67,\"merge\":[0,3],\"text\":\"阜阳火车站检票数\"},\"4\":{\"style\":67},\"5\":{\"style\":67},\"6\":{\"style\":67},\"7\":{\"style\":66},\"8\":{\"style\":66},\"9\":{\"style\":58}},\"height\":63},\"1\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"style\":66},\"2\":{\"style\":66},\"3\":{\"style\":66},\"4\":{\"style\":66},\"5\":{\"style\":66},\"6\":{\"style\":66},\"7\":{\"style\":66},\"8\":{\"style\":66},\"9\":{\"style\":58}},\"height\":20},\"2\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"text\":\"日期：\",\"style\":68},\"2\":{\"text\":\"${gongsi.tdata}\",\"style\":69},\"3\":{\"style\":66},\"4\":{\"style\":66,\"text\":\"制表人：\"},\"5\":{\"text\":\"${gongsi.gname}\",\"style\":66},\"6\":{\"style\":66},\"7\":{\"text\":\"\",\"merge\":[0,1],\"style\":70},\"8\":{\"style\":70},\"9\":{\"style\":58}},\"isDrag\":true},\"3\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"text\":\"班次\",\"merge\":[1,0],\"style\":71},\"2\":{\"text\":\"发车时间\",\"merge\":[1,0],\"style\":71},\"3\":{\"text\":\"是否放空\",\"merge\":[1,0],\"style\":71},\"4\":{\"text\":\"路线\",\"merge\":[0,1],\"style\":71},\"5\":{\"style\":72},\"6\":{\"text\":\"核载座位数\",\"merge\":[1,0],\"style\":71},\"7\":{\"merge\":[1,0],\"style\":71,\"text\":\"检票数\"},\"8\":{\"merge\":[1,0],\"style\":71,\"text\":\"实载率（%）\"},\"9\":{\"style\":58}}},\"4\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"style\":72},\"2\":{\"style\":71},\"3\":{\"style\":72},\"4\":{\"text\":\"从\",\"style\":71},\"5\":{\"text\":\"到\",\"style\":71},\"6\":{\"style\":72},\"7\":{\"style\":71},\"8\":{\"style\":72},\"9\":{\"style\":58}},\"height\":25},\"5\":{\"cells\":{\"0\":{\"style\":58},\"1\":{\"style\":73,\"text\":\"#{jianpiao.bnum}\"},\"2\":{\"style\":73,\"text\":\"#{jianpiao.ftime}\"},\"3\":{\"style\":73,\"text\":\"#{jianpiao.sfkong}\"},\"4\":{\"style\":73,\"text\":\"#{jianpiao.kaishi}\"},\"5\":{\"style\":73,\"text\":\"#{jianpiao.jieshu}\"},\"6\":{\"style\":73,\"text\":\"#{jianpiao.hezairen}\"},\"7\":{\"style\":73,\"text\":\"#{jianpiao.jpnum}\"},\"8\":{\"style\":73,\"text\":\"#{jianpiao.shihelv}\"},\"9\":{\"style\":58}},\"height\":33},\"6\":{\"cells\":{\"1\":{\"text\":\"\",\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}},\"isDrag\":true},\"7\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11,\"text\":\"\"},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"8\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"9\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"10\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"11\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"12\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"13\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"14\":{\"cells\":{\"1\":{\"style\":11},\"2\":{\"style\":11},\"3\":{\"style\":11},\"4\":{\"style\":11},\"5\":{\"style\":11},\"6\":{\"style\":11},\"7\":{\"style\":11},\"8\":{\"style\":11}}},\"len\":96,\"-1\":{\"cells\":{\"-1\":{\"text\":\"${gongsi.id}\"}},\"isDrag\":true}},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":737,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"],\"top\":[\"thin\",\"#7f7f7f\"],\"left\":[\"thin\",\"#7f7f7f\"],\"right\":[\"thin\",\"#7f7f7f\"]}},{\"border\":{\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"]}},{\"border\":{\"top\":[\"thin\",\"#000100\"]}},{\"border\":{\"top\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"left\":[\"thin\",\"#000100\"]}},{\"border\":{\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"top\":[\"thin\",\"#7f7f7f\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]}},{\"border\":{\"right\":[\"thin\",\"#7f7f7f\"],\"bottom\":[\"thin\",\"#7f7f7f\"]}},{\"border\":{\"bottom\":[\"thin\",\"#7f7f7f\"]}},{\"border\":{\"right\":[\"thin\",\"#7f7f7f\"]}},{\"align\":\"center\",\"font\":{\"size\":16}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"font\":{\"bold\":true}},{\"font\":{\"bold\":false}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":true}},{\"align\":\"center\",\"font\":{\"bold\":true}},{\"align\":\"right\"},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":true},\"bgcolor\":\"#4371c6\"},{\"align\":\"center\",\"font\":{\"bold\":true},\"bgcolor\":\"#4371c6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#4371c6\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#4371c6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#2e75b5\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#2e75b5\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#0170c1\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#0170c1\"},{\"font\":{\"bold\":false},\"color\":\"#7f7f7f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000100\"],\"top\":[\"thin\",\"#000100\"],\"left\":[\"thin\",\"#000100\"],\"right\":[\"thin\",\"#000100\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#01b0f1\"},{\"align\":\"center\",\"font\":{\"bold\":false},\"bgcolor\":\"#01b0f1\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#5b9cd6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"bold\":false},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true},\"valign\":\"bottom\"},{\"align\":\"center\",\"font\":{\"size\":22,\"bold\":true},\"valign\":\"bottom\"},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true},\"valign\":\"bottom\"},{\"font\":{\"bold\":false},\"color\":\"#7f7f7f\",\"align\":\"right\"},{\"color\":\"#7f7f7f\"},{\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true,\"name\":\"宋体\"},\"valign\":\"bottom\"},{\"font\":{\"bold\":false,\"name\":\"宋体\"},\"color\":\"#7f7f7f\",\"align\":\"right\"},{\"color\":\"#7f7f7f\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"right\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"bold\":false,\"name\":\"宋体\"},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"font\":{\"bold\":false,\"name\":\"宋体\"},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"name\":\"宋体\"}},{\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true,\"name\":\"Microsoft YaHei\"},\"valign\":\"bottom\"},{\"font\":{\"bold\":false,\"name\":\"Microsoft YaHei\"},\"color\":\"#7f7f7f\",\"align\":\"right\"},{\"color\":\"#7f7f7f\",\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"right\",\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"bold\":false,\"name\":\"Microsoft YaHei\"},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"font\":{\"bold\":false,\"name\":\"Microsoft YaHei\"},\"bgcolor\":\"#9cc2e6\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"font\":{\"name\":\"Microsoft YaHei\"}}],\"validations\":[],\"cols\":{\"0\":{\"width\":53},\"1\":{\"width\":118},\"2\":{\"width\":75},\"3\":{\"width\":54},\"4\":{\"width\":95},\"5\":{\"width\":109},\"6\":{\"width\":75},\"7\":{\"width\":75},\"8\":{\"width\":83},\"9\":{\"width\":30},\"len\":27},\"merges\":[\"E4:F4\",\"B4:B5\",\"C4:C5\",\"D4:D5\",\"G4:G5\",\"H4:H5\",\"I4:I5\",\"D1:G1\",\"H3:I3\"]}', '', 'https://static.jeecg.com/designreport/images/25_1597233573577.png', 'admin', '2021-01-19 10:46:45', 'admin', '2021-02-03 13:58:22', 0, NULL, NULL, 0, 687, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('9dbadaee8720767efe3164a7d018c870', '45566', '发票打印', '', NULL, 'printinfo', '{\"area\":{\"sri\":8,\"sci\":4,\"eri\":8,\"eci\":4,\"width\":100,\"height\":25},\"printElWidth\":794,\"excel_config_id\":\"9dbadaee8720767efe3164a7d018c870\",\"printElHeight\":500,\"rows\":{\"0\":{\"cells\":{\"0\":{\"text\":\"\",\"virtual\":\"RTA6TUIKs1pmgVOM\"},\"1\":{\"text\":\" \",\"virtual\":\"RTA6TUIKs1pmgVOM\"},\"2\":{\"text\":\" \",\"virtual\":\"RTA6TUIKs1pmgVOM\"},\"3\":{\"text\":\" \",\"virtual\":\"RTA6TUIKs1pmgVOM\"},\"4\":{\"text\":\" \",\"virtual\":\"RTA6TUIKs1pmgVOM\"},\"5\":{\"text\":\" \",\"virtual\":\"RTA6TUIKs1pmgVOM\"},\"6\":{\"text\":\" \",\"virtual\":\"RTA6TUIKs1pmgVOM\"},\"7\":{\"text\":\" \",\"virtual\":\"RTA6TUIKs1pmgVOM\"},\"8\":{\"text\":\" \",\"virtual\":\"RTA6TUIKs1pmgVOM\"}}},\"2\":{\"cells\":{},\"height\":11},\"3\":{\"cells\":{\"2\":{\"text\":\"\"},\"5\":{\"text\":\"\"}},\"height\":18},\"4\":{\"cells\":{\"2\":{\"text\":\"182123434\",\"style\":0},\"5\":{\"text\":\"12345678\"}},\"height\":15},\"5\":{\"cells\":{\"2\":{\"text\":\"\"}}},\"7\":{\"cells\":{}},\"8\":{\"cells\":{\"1\":{\"text\":\"餐饮\"},\"2\":{\"text\":\"        A11\"},\"3\":{\"text\":\"    333      3\"},\"4\":{\"text\":\"  3                   4\"},\"5\":{\"text\":\"          1\"},\"6\":{\"text\":\"3333\"}}},\"9\":{\"cells\":{\"1\":{\"text\":\"测试\"},\"2\":{\"text\":\"      mmm\"},\"3\":{\"text\":\"    33          5\"}}},\"10\":{\"cells\":{},\"height\":22},\"11\":{\"cells\":{\"2\":{\"text\":\"                          \"},\"3\":{\"text\":\"343434\"},\"6\":{\"text\":\"3434\"}},\"height\":45},\"12\":{\"cells\":{\"4\":{\"text\":\"           刮开中奖\"}},\"height\":12},\"13\":{\"cells\":{\"2\":{\"text\":\"\"},\"4\":{\"text\":\"      \"},\"5\":{\"text\":\"备注\"}},\"height\":31},\"14\":{\"cells\":{\"1\":{\"text\":\" 张三\"},\"3\":{\"text\":\"完成\"},\"4\":{\"text\":\"           李思\"}},\"height\":41},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":847,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"font\":{\"size\":8}}],\"validations\":[],\"cols\":{\"0\":{\"width\":93},\"1\":{\"width\":74},\"2\":{\"width\":80},\"len\":26},\"merges\":[],\"imgList\":[{\"row\":0,\"col\":0,\"width\":\"832\",\"height\":\"480\",\"src\":\"https://static.jeecg.com/designreport/images/套打_1609313052910.png\",\"isBackend\":true,\"commonBackend\":true,\"layer_id\":\"RTA6TUIKs1pmgVOM\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[0,0],[0,1],[0,2],[0,3],[0,4],[0,5],[0,6],[0,7],[0,8]]}]}', '', 'https://static.jeecg.com/designreport/images/QQ截图20201207113651_1607312223499.png', 'jeecg', '2020-07-20 18:55:59', 'admin', '2021-02-03 13:38:49', 0, NULL, NULL, 0, 1124, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('a250846887abe01217aab173d3006489', '56663', '不动产打印', '', NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":false,\"excel_config_id\":\"a250846887abe01217aab173d3006489\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":true,\"marginX\":10,\"marginY\":10},\"rows\":{\"0\":{\"cells\":{\"0\":{\"text\":\" \",\"virtual\":\"BJ9o6oelCr85EpT2\"},\"1\":{\"text\":\" \",\"virtual\":\"BJ9o6oelCr85EpT2\"},\"2\":{\"text\":\" \",\"virtual\":\"BJ9o6oelCr85EpT2\"},\"3\":{\"text\":\" \",\"virtual\":\"BJ9o6oelCr85EpT2\"},\"4\":{\"text\":\" \",\"virtual\":\"BJ9o6oelCr85EpT2\"},\"5\":{\"text\":\" \",\"virtual\":\"BJ9o6oelCr85EpT2\"},\"6\":{\"text\":\" \",\"virtual\":\"BJ9o6oelCr85EpT2\"},\"7\":{\"text\":\" \",\"virtual\":\"BJ9o6oelCr85EpT2\"},\"8\":{\"text\":\" \",\"virtual\":\"BJ9o6oelCr85EpT2\"},\"9\":{\"text\":\" \",\"virtual\":\"BJ9o6oelCr85EpT2\"}},\"isDrag\":true,\"height\":45},\"1\":{\"cells\":{},\"height\":23},\"2\":{\"cells\":{\"0\":{\"text\":\"\",\"style\":0},\"1\":{\"text\":\"           ${budong.yname}\",\"style\":21,\"merge\":[0,2]}},\"isDrag\":true,\"height\":34},\"3\":{\"cells\":{\"1\":{\"text\":\"            ${budong.chanquan}\",\"style\":0,\"merge\":[0,2]},\"5\":{\"text\":\"${budong.beizhu}\",\"merge\":[5,3]}},\"isDrag\":true,\"height\":39},\"4\":{\"cells\":{\"1\":{\"text\":\"           ${budong.zhuzhi}\",\"style\":39,\"merge\":[0,2]}},\"isDrag\":true,\"height\":33},\"5\":{\"cells\":{\"1\":{\"text\":\"           ${budong.danyuan}\",\"style\":0,\"merge\":[0,2]}},\"isDrag\":true,\"height\":53},\"6\":{\"cells\":{\"1\":{\"text\":\"            ${budong.type}\",\"style\":0,\"merge\":[0,2]}},\"isDrag\":true,\"height\":47},\"7\":{\"cells\":{\"1\":{\"text\":\"            ${budong.xtype}\",\"style\":0,\"merge\":[0,2]}},\"isDrag\":true,\"height\":38},\"8\":{\"cells\":{\"1\":{\"text\":\"             ${budong.suoyou}\",\"style\":0,\"merge\":[0,2]}},\"isDrag\":true,\"height\":31},\"9\":{\"cells\":{\"1\":{\"text\":\"              ${budong.mianji}\",\"style\":0,\"merge\":[0,2]}},\"isDrag\":true,\"height\":45},\"10\":{\"cells\":{\"1\":{\"text\":\"               ${budong.riqi}\",\"style\":0,\"merge\":[0,2]}},\"isDrag\":true,\"height\":26},\"11\":{\"cells\":{\"1\":{\"text\":\"\",\"style\":0,\"merge\":[0,2]}},\"height\":35},\"12\":{\"cells\":{\"1\":{\"text\":\"\",\"style\":0},\"2\":{\"text\":\"${budong.chanquan}\",\"style\":0,\"merge\":[4,1]}},\"isDrag\":true},\"13\":{\"cells\":{}},\"14\":{\"cells\":{}},\"15\":{\"cells\":{}},\"16\":{\"cells\":{},\"height\":5},\"17\":{\"cells\":{\"2\":{\"text\":\"\",\"style\":0}},\"isDrag\":true,\"height\":33},\"18\":{\"cells\":{\"2\":{\"style\":0,\"text\":\"\"}}},\"len\":100,\"-1\":{\"cells\":{\"0\":{\"text\":\"#{budong.zhuzhi}\"},\"-1\":{\"text\":\"#{budong.suoyou}\"}},\"isDrag\":true}},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":1024,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"font\":{\"bold\":true}},{\"font\":{\"italic\":true}},{\"font\":{\"italic\":true,\"bold\":true}},{\"font\":{\"italic\":true,\"bold\":false}},{\"font\":{\"italic\":false,\"bold\":false}},{\"font\":{\"italic\":false,\"bold\":true}},{\"align\":\"left\"},{\"align\":\"center\"},{\"align\":\"right\"},{\"align\":\"left\",\"valign\":\"top\"},{\"align\":\"left\",\"valign\":\"top\",\"font\":{\"bold\":true}},{\"font\":{\"bold\":false}},{\"align\":\"left\",\"valign\":\"bottom\"},{\"valign\":\"bottom\"},{\"align\":\"center\",\"valign\":\"bottom\"},{\"textwrap\":true},{\"font\":{\"bold\":true},\"valign\":\"bottom\"},{\"font\":{\"italic\":false,\"bold\":true},\"valign\":\"top\"},{\"valign\":\"top\"},{\"textwrap\":true,\"font\":{\"bold\":true}},{\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"bold\":true}},{\"align\":\"left\",\"valign\":\"bottom\",\"font\":{\"bold\":true}},{\"align\":\"left\",\"valign\":\"bottom\",\"font\":{\"bold\":true,\"size\":8}},{\"font\":{\"bold\":true,\"size\":8},\"valign\":\"bottom\"},{\"align\":\"center\",\"valign\":\"bottom\",\"font\":{\"bold\":true,\"size\":8}},{\"align\":\"left\",\"valign\":\"middle\",\"font\":{\"bold\":true}},{\"align\":\"left\",\"valign\":\"middle\"},{\"font\":{\"italic\":false,\"bold\":true},\"valign\":\"bottom\"},{\"font\":{\"italic\":false,\"bold\":true},\"valign\":\"middle\"},{\"valign\":\"middle\"},{\"font\":{\"italic\":true,\"bold\":true},\"valign\":\"middle\"},{\"valign\":\"middle\",\"font\":{\"italic\":true}},{\"valign\":\"middle\",\"font\":{\"italic\":false}},{\"font\":{\"italic\":false,\"bold\":false},\"valign\":\"middle\"},{\"align\":\"center\",\"valign\":\"middle\",\"font\":{\"bold\":true,\"size\":8}},{\"font\":{\"bold\":true,\"size\":8},\"valign\":\"middle\"},{\"align\":\"left\",\"valign\":\"middle\",\"font\":{\"bold\":true,\"size\":8}},{\"align\":\"right\",\"valign\":\"middle\",\"font\":{\"bold\":true,\"size\":8}},{\"font\":{\"italic\":false,\"bold\":true},\"valign\":\"middle\",\"align\":\"center\"},{\"font\":{\"italic\":false,\"bold\":true},\"valign\":\"middle\",\"align\":\"left\"},{\"align\":\"right\",\"valign\":\"bottom\"},{\"align\":\"right\",\"valign\":\"bottom\",\"font\":{\"bold\":true,\"size\":8}},{\"align\":\"center\",\"valign\":\"middle\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":107},\"1\":{\"width\":54},\"2\":{\"width\":135},\"3\":{\"width\":180},\"6\":{\"width\":123},\"8\":{\"width\":25},\"len\":50},\"merges\":[\"B1:B2\",\"B12:D12\",\"B9:D9\",\"B7:D7\",\"B6:D6\",\"B5:D5\",\"B3:D3\",\"B11:D11\",\"B8:D8\",\"B10:D10\",\"C13:D17\",\"C1:C2\",\"B4:D4\",\"F4:I9\",\"D1:D2\"],\"imgList\":[{\"row\":0,\"col\":0,\"width\":\"950\",\"height\":\"683\",\"src\":\"https://jimureport.oss-cn-beijing.aliyuncs.com/designreport/images/38_1610456500965_1617247643815.jpg\",\"isBackend\":true,\"commonBackend\":true,\"layer_id\":\"BJ9o6oelCr85EpT2\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[0,0],[0,1],[0,2],[0,3],[0,4],[0,5],[0,6],[0,7],[0,8],[0,9]]}]}', '', 'https://static.jeecg.com/designreport/images/24_1597233568822.png', 'jeecg', '2020-07-09 10:48:22', 'admin', '2021-04-01 03:27:28', 0, NULL, NULL, 1, 1413, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('a9f068972508920cd4aab831814f0c04', '23445', '逮捕证', '', NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":false,\"excel_config_id\":\"a9f068972508920cd4aab831814f0c04\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"0\":{\"cells\":{\"2\":{\"text\":\"\",\"merge\":[0,9],\"style\":324},\"12\":{}},\"isDrag\":true,\"height\":55},\"1\":{\"cells\":{\"1\":{\"style\":410,\"merge\":[0,13],\"text\":\"兰州市经济侦查大队\"},\"15\":{\"style\":324,\"text\":\" \"}},\"height\":128},\"2\":{\"cells\":{\"1\":{\"style\":411,\"merge\":[0,13],\"text\":\"逮捕令\"},\"15\":{\"style\":324,\"text\":\" \"}},\"height\":41},\"3\":{\"cells\":{\"1\":{\"style\":412,\"merge\":[0,12],\"text\":\"第123459663号\"},\"14\":{\"style\":413,\"text\":\" \"}},\"height\":60},\"4\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"2\":{\"text\":\"                                 根据《中华人民共和国刑事诉讼法》第七十八条之规定，\",\"style\":341,\"merge\":[0,11]},\"14\":{\"style\":413,\"text\":\" \"}},\"height\":43},\"5\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"2\":{\"style\":341,\"text\":\"经\",\"merge\":[0,1]},\"4\":{\"text\":\"${pdaibu.pname}\",\"style\":342,\"merge\":[0,9]},\"14\":{\"style\":413,\"text\":\" \"}},\"isDrag\":true,\"height\":47},\"6\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"2\":{\"style\":344,\"text\":\" \",\"merge\":[0,2]},\"5\":{\"merge\":[0,3],\"text\":\"批准，兹由我局对涉嫌\",\"style\":338},\"9\":{\"text\":\"${pdaibu.shiqing}\",\"style\":347,\"merge\":[0,4]},\"14\":{\"style\":413,\"text\":\" \"}},\"isDrag\":true,\"height\":49},\"7\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"2\":{\"style\":341,\"text\":\"的\"},\"3\":{\"text\":\"${pdaibu.fname}\",\"style\":345,\"merge\":[0,1]},\"5\":{\"text\":\"(性别\",\"style\":343},\"6\":{\"text\":\"${pdaibu.fsex}\",\"style\":347,\"merge\":[0,1]},\"8\":{\"style\":346,\"text\":\"出生日期\"},\"9\":{\"text\":\"${pdaibu.cdata}\",\"style\":345,\"merge\":[0,4]},\"14\":{\"style\":413,\"text\":\" \"}},\"isDrag\":true,\"height\":51},\"8\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"2\":{\"text\":\"${pdaibu.zhuzhi}\",\"style\":345,\"merge\":[0,7]},\"10\":{\"style\":341,\"text\":\"执行逮捕，送兰州\",\"merge\":[0,3]},\"14\":{\"style\":413,\"text\":\" \"}},\"isDrag\":true,\"height\":51},\"9\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"2\":{\"style\":341,\"merge\":[0,6],\"text\":\"市经济侦查大队羁押。\"},\"9\":{\"style\":341,\"text\":\" \"},\"10\":{\"style\":341,\"merge\":[5,1],\"text\":\" \"},\"14\":{\"style\":413,\"text\":\" \"}},\"height\":57},\"10\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"4\":{\"style\":338,\"virtual\":\"DId4FGTLnP3vfp4y\",\"text\":\" \"},\"5\":{\"style\":338,\"virtual\":\"DId4FGTLnP3vfp4y\",\"text\":\" \"},\"6\":{\"style\":338,\"virtual\":\"DId4FGTLnP3vfp4y\",\"text\":\" \"},\"14\":{\"style\":413,\"text\":\" \"}},\"height\":61},\"11\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"6\":{\"style\":376,\"merge\":[0,2],\"text\":\" \"},\"14\":{\"style\":413,\"text\":\" \"}},\"height\":83},\"12\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"2\":{\"merge\":[0,6],\"style\":338,\"text\":\" \"},\"14\":{\"style\":413,\"text\":\" \"}},\"height\":14},\"13\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"2\":{\"style\":351,\"merge\":[0,5],\"text\":\" \"},\"8\":{\"style\":380,\"text\":\"公安局印\"},\"9\":{\"text\":\" \",\"virtual\":\"XefZfpEcdS3wI6Ae\"},\"10\":{\"text\":\" \",\"virtual\":\"XefZfpEcdS3wI6Ae\"},\"11\":{\"text\":\" \",\"virtual\":\"XefZfpEcdS3wI6Ae\"},\"14\":{\"style\":413,\"text\":\" \"}},\"height\":89},\"14\":{\"cells\":{\"1\":{\"style\":414,\"text\":\" \"},\"14\":{\"style\":413,\"text\":\" \"}},\"height\":21},\"15\":{\"cells\":{\"1\":{\"style\":415,\"text\":\" \"},\"2\":{\"style\":416,\"text\":\" \"},\"3\":{\"style\":417,\"text\":\" \"},\"4\":{\"style\":417,\"text\":\" \"},\"5\":{\"style\":417,\"text\":\" \"},\"6\":{\"text\":\"${pdaibu.gdata}\",\"style\":421,\"merge\":[0,6]},\"13\":{\"style\":417,\"text\":\" \"},\"14\":{\"style\":419,\"text\":\" \"}},\"isDrag\":true,\"height\":168},\"len\":88,\"-1\":{\"cells\":{\"1\":{\"text\":\"#{daibu.fdata}\"},\"-1\":{\"text\":\"#{pdaibu.shiqing}\"}},\"isDrag\":true}},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":709,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"left\"},{\"align\":\"left\",\"underline\":true},{\"underline\":true},{\"align\":\"center\",\"underline\":true},{\"align\":\"center\"},{\"align\":\"center\",\"underline\":false},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":16}},{\"font\":{\"size\":16}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16}},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":16}},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16}},{\"align\":\"left\",\"font\":{\"size\":16,\"bold\":true}},{\"font\":{\"size\":16,\"bold\":true}},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":16,\"bold\":true}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":true}},{\"font\":{\"bold\":true}},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":true}},{\"align\":\"left\",\"font\":{\"size\":16,\"bold\":false}},{\"font\":{\"size\":16,\"bold\":false}},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":16,\"bold\":false}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":false}},{\"font\":{\"bold\":false}},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":false}},{\"align\":\"left\",\"font\":{\"size\":16,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":16,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":16,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":16,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"align\":\"center\"},{\"font\":{\"size\":12},\"align\":\"center\"},{\"font\":{\"size\":8}},{\"font\":{\"size\":10}},{\"font\":{\"size\":10,\"bold\":true}},{\"font\":{\"size\":10,\"bold\":true},\"align\":\"center\"},{\"font\":{\"size\":18,\"bold\":true},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":18}},{\"font\":{\"size\":16,\"bold\":true},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":16}},{\"font\":{\"size\":12},\"valign\":\"bottom\"},{\"font\":{\"size\":12},\"valign\":\"middle\"},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"valign\":\"middle\",\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"right\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"right\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"right\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"left\":[\"dashed\",\"#000\"]}},{\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"font\":{\"size\":12,\"bold\":true},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true}},{\"font\":{\"size\":14,\"bold\":true},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"name\":\"Arial\"}},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Arial\"}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Arial\"}},{\"font\":{\"name\":\"Arial\"}},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"name\":\"Source Sans Pro\"}},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Source Sans Pro\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Source Sans Pro\"}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"}},{\"font\":{\"name\":\"Source Sans Pro\"}},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Source Sans Pro\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"name\":\"Source Sans Pro\"},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Source Sans Pro\"}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Comic Sans MS\"}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"name\":\"Comic Sans MS\"}},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Comic Sans MS\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Comic Sans MS\"}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"}},{\"font\":{\"name\":\"Comic Sans MS\"}},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Comic Sans MS\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"name\":\"Comic Sans MS\"},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Comic Sans MS\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Comic Sans MS\"}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"name\":\"Courier New\"}},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Courier New\"}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Courier New\"}},{\"font\":{\"name\":\"Courier New\"}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"}},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Courier New\"},\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Courier New\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Arial\"},\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Arial\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"top\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Helvetica\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Helvetica\"},\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Helvetica\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"top\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]},\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":10,\"name\":\"Lato\"},\"valign\":\"middle\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"center\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"color\":\"#000100\",\"align\":\"right\"},{\"align\":\"right\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"left\",\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"left\",\"color\":\"#000100\",\"valign\":\"top\"},{\"align\":\"left\",\"valign\":\"top\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"left\",\"color\":\"#000100\",\"valign\":\"middle\"},{\"align\":\"left\",\"valign\":\"middle\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"left\",\"color\":\"#000100\",\"valign\":\"bottom\"},{\"align\":\"left\",\"valign\":\"bottom\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\",\"valign\":\"bottom\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"left\":[\"thick\",\"#000\"]},\"align\":\"right\",\"color\":\"#000100\",\"valign\":\"bottom\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":true,\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"right\",\"color\":\"#000100\",\"valign\":\"bottom\"},{\"align\":\"left\",\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"underline\":false,\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\",\"align\":\"right\"},{\"font\":{\"size\":12,\"name\":\"Lato\",\"bold\":true},\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"color\":\"#000100\"},{\"border\":{\"right\":[\"thin\",\"#000\"]}},{},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"color\":\"#000100\",\"align\":\"right\"},{\"font\":{\"size\":12,\"name\":\"Lato\",\"bold\":true},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"align\":\"right\",\"color\":\"#000100\",\"valign\":\"bottom\"},{\"align\":\"center\",\"underline\":false,\"font\":{\"size\":12,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"right\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":12}},{\"align\":\"center\",\"font\":{\"bold\":false}},{\"align\":\"center\",\"font\":{\"bold\":false,\"size\":12}},{\"align\":\"center\",\"font\":{\"bold\":false,\"size\":12},\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"valign\":\"top\"},{\"font\":{\"size\":14,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"center\"},{\"font\":{\"size\":14}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"name\":\"Lato\"},\"align\":\"right\",\"color\":\"#000100\",\"valign\":\"bottom\"},{\"align\":\"left\",\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"center\",\"font\":{\"bold\":false,\"size\":14},\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"font\":{\"name\":\"Lato\",\"size\":14},\"color\":\"#000100\"},{\"align\":\"left\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"center\"},{\"font\":{\"size\":14},\"align\":\"center\",\"border\":{\"bottom\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"]},\"font\":{\"size\":14}},{\"align\":\"left\",\"font\":{\"size\":14}},{\"align\":\"left\",\"font\":{\"name\":\"Lato\",\"size\":14},\"color\":\"#000100\"},{\"font\":{\"size\":14,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"right\"},{\"align\":\"left\",\"valign\":\"top\",\"font\":{\"size\":14}},{\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":16,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14,\"name\":\"Lato\"},\"align\":\"right\",\"color\":\"#000100\",\"valign\":\"bottom\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"bold\":false,\"size\":14},\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\"},{\"border\":{\"right\":[\"thick\",\"#000\"]},\"font\":{\"size\":14}},{\"align\":\"left\",\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"name\":\"Lato\",\"size\":14},\"color\":\"#000100\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"right\",\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"right\",\"border\":{\"bottom\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14},\"border\":{\"bottom\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"bold\":false,\"size\":14}},{\"font\":{\"size\":14},\"align\":\"center\"},{\"font\":{\"size\":14,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"center\",\"border\":{\"top\":[\"thick\",\"#000\"]}},{\"border\":{\"top\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"right\",\"border\":{\"bottom\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14},\"align\":\"right\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"size\":12}},{\"font\":{\"size\":14},\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thick\",\"#000\"]},\"font\":{\"size\":12},\"align\":\"center\"},{\"align\":\"left\",\"valign\":\"middle\",\"font\":{\"size\":14}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"size\":24}},{\"font\":{\"size\":24}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"size\":22}},{\"font\":{\"size\":22}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"size\":18}},{\"font\":{\"size\":18}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"size\":18,\"bold\":true}},{\"font\":{\"size\":18,\"bold\":true}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"size\":18,\"bold\":true},\"align\":\"center\"},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"size\":18,\"bold\":false},\"align\":\"center\"},{\"font\":{\"size\":18,\"bold\":false},\"align\":\"center\"},{\"font\":{\"size\":14,\"bold\":true}},{\"border\":{\"top\":[\"thick\",\"#000\"]},\"font\":{\"size\":18,\"bold\":false},\"align\":\"center\",\"valign\":\"bottom\"},{\"font\":{\"size\":18,\"bold\":false},\"align\":\"center\",\"valign\":\"bottom\"},{\"valign\":\"bottom\"},{\"valign\":\"bottom\",\"align\":\"right\"},{\"valign\":\"bottom\",\"align\":\"right\",\"font\":{\"size\":14}},{\"font\":{\"size\":18,\"bold\":false},\"align\":\"center\",\"valign\":\"bottom\",\"border\":{\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14},\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"valign\":\"bottom\",\"align\":\"right\",\"font\":{\"size\":14},\"border\":{\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"left\",\"font\":{\"size\":14,\"bold\":false,\"name\":\"Lato\"},\"color\":\"#000100\",\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"bold\":false,\"size\":14},\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":14},\"align\":\"center\",\"border\":{\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":18,\"bold\":false},\"align\":\"center\",\"valign\":\"bottom\",\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14},\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"valign\":\"bottom\",\"align\":\"right\",\"font\":{\"size\":14},\"border\":{\"left\":[\"thick\",\"#000\"],\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":14},\"align\":\"center\",\"border\":{\"right\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":18,\"bold\":false},\"align\":\"center\",\"valign\":\"bottom\",\"border\":{\"top\":[\"thick\",\"#000\"],\"left\":[\"thick\",\"#000\"]}},{\"valign\":\"bottom\",\"align\":\"right\",\"font\":{\"size\":14},\"border\":{\"left\":[\"thick\",\"#000\"]}},{\"font\":{\"size\":18,\"bold\":false},\"align\":\"center\",\"valign\":\"bottom\",\"border\":{\"top\":[\"medium\",\"#000\"],\"left\":[\"medium\",\"#000\"],\"right\":[\"medium\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"bold\":true,\"size\":14},\"border\":{\"left\":[\"medium\",\"#000\"],\"right\":[\"medium\",\"#000\"]}},{\"valign\":\"bottom\",\"align\":\"right\",\"font\":{\"size\":14},\"border\":{\"left\":[\"medium\",\"#000\"]}},{\"border\":{\"right\":[\"medium\",\"#000\"]}},{\"border\":{\"left\":[\"medium\",\"#000\"]}},{\"border\":{\"bottom\":[\"medium\",\"#000\"],\"left\":[\"medium\",\"#000\"]}},{\"font\":{\"size\":12,\"name\":\"Lato\"},\"color\":\"#000100\",\"align\":\"right\",\"border\":{\"bottom\":[\"medium\",\"#000\"]}},{\"border\":{\"bottom\":[\"medium\",\"#000\"]}},{\"font\":{\"size\":12},\"align\":\"center\",\"border\":{\"bottom\":[\"medium\",\"#000\"]}},{\"border\":{\"bottom\":[\"medium\",\"#000\"],\"right\":[\"medium\",\"#000\"]}},{\"align\":\"center\",\"font\":{\"bold\":false,\"size\":14},\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"font\":{\"size\":12},\"align\":\"right\",\"border\":{\"bottom\":[\"medium\",\"#000\"]}},{\"font\":{\"size\":12},\"align\":\"right\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":18},\"1\":{\"width\":21},\"2\":{\"width\":27},\"3\":{\"width\":6},\"4\":{\"width\":87},\"5\":{\"width\":51},\"6\":{\"width\":51},\"7\":{\"width\":1},\"8\":{\"width\":86},\"9\":{\"width\":163},\"10\":{\"width\":1},\"11\":{\"width\":60},\"12\":{\"width\":45},\"13\":{\"width\":49},\"14\":{\"width\":23},\"15\":{\"width\":20},\"len\":50},\"merges\":[\"D8:E8\",\"C6:D6\",\"C10:I10\",\"G8:H8\",\"C9:J9\",\"C1:L1\",\"K10:L15\",\"C13:I13\",\"C14:H14\",\"F7:I7\",\"G12:I12\",\"G16:M16\",\"B4:N4\",\"C5:N5\",\"E6:N6\",\"J7:N7\",\"C7:E7\",\"K9:N9\",\"B2:O2\",\"B3:O3\",\"J8:N8\"],\"imgList\":[{\"row\":13,\"col\":9,\"width\":\"168\",\"height\":\"158\",\"src\":\"https://static.jeecg.com/designreport/images/QQ截图20210105214919_1610075317075.png\",\"layer_id\":\"XefZfpEcdS3wI6Ae\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[13,9],[13,10],[13,11]]}]}', '', 'https://static.jeecg.com/designreport/images/逮捕令_1607070625878.png', 'jeecg', '2020-07-10 13:38:40', 'admin', '2021-04-05 18:47:36', 0, NULL, NULL, 1, 2506, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('dd482bfd6ca470a0f49d9bb4e61ec694', '202101081046034402', '实习证明副本4402', NULL, NULL, 'printinfo', '{\"area\":false,\"printElWidth\":570,\"excel_config_id\":\"1347373863746539520\",\"printElHeight\":1047,\"rows\":{\"6\":{\"cells\":{\"2\":{\"merge\":[0,1],\"text\":\"实习证明\",\"style\":2},\"3\":{\"style\":2}},\"height\":50},\"8\":{\"cells\":{\"1\":{\"text\":\"#{tt.name}\",\"style\":3},\"2\":{\"merge\":[0,2],\"text\":\"同学在我公司与 2020年4月1日 至 2020年5月1日 实习。\"}}},\"9\":{\"cells\":{\"1\":{\"text\":\"\"}},\"isDrag\":true},\"12\":{\"cells\":{\"1\":{\"merge\":[4,3],\"text\":\"#{tt.pingjia}\",\"style\":6},\"2\":{\"style\":6},\"3\":{\"style\":6},\"4\":{\"style\":6}}},\"13\":{\"cells\":{\"1\":{\"style\":6},\"2\":{\"style\":6},\"3\":{\"style\":6},\"4\":{\"style\":6}}},\"14\":{\"cells\":{\"1\":{\"style\":6},\"2\":{\"style\":6},\"3\":{\"style\":6},\"4\":{\"style\":6}}},\"15\":{\"cells\":{\"1\":{\"style\":6},\"2\":{\"style\":6},\"3\":{\"style\":6},\"4\":{\"style\":6}}},\"16\":{\"cells\":{\"1\":{\"style\":6},\"2\":{\"style\":6},\"3\":{\"style\":6},\"4\":{\"style\":6}}},\"17\":{\"cells\":{\"1\":{\"text\":\"特此证明！\"}}},\"20\":{\"cells\":{\"2\":{\"text\":\"\"},\"3\":{\"text\":\"\",\"style\":3},\"4\":{\"text\":\"\"}}},\"21\":{\"cells\":{\"4\":{\"text\":\"\"}}},\"22\":{\"cells\":{\"3\":{\"text\":\"证明人：\",\"style\":3},\"4\":{\"text\":\"#{tt.lingdao}\"}}},\"23\":{\"cells\":{\"4\":{\"text\":\"#{tt.shijian}\"}}},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":487,\"background\":{\"path\":\"https://static.jeecg.com/designreport/images/report_1595906079684_1610075686629.png\",\"repeat\":\"no-repeat\",\"width\":\"\",\"height\":\"\"},\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"font\":{\"size\":14}},{\"align\":\"center\",\"font\":{\"size\":16}},{\"align\":\"right\"},{\"align\":\"left\"},{\"align\":\"left\",\"valign\":\"top\"},{\"align\":\"left\",\"valign\":\"top\",\"textwrap\":true}],\"validations\":[],\"cols\":{\"0\":{\"width\":82},\"1\":{\"width\":86},\"4\":{\"width\":119},\"len\":26},\"merges\":[\"C7:D7\",\"C9:E9\",\"B13:E17\"]}', NULL, 'https://static.jeecg.com/designreport/images/未标题-1_1610074948259.png', 'admin', '2021-01-18 13:21:18', 'admin', '2021-02-02 19:01:05', 1, NULL, NULL, 0, 94, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('f5f275b5e28b45256ef24587ec792f0c', '202101081641215447', '实例:来源收入统计副本5447', NULL, NULL, 'datainfo', '{\"loopBlockList\":[],\"chartList\":[{\"row\":1,\"col\":1,\"width\":\"624\",\"height\":\"281\",\"config\":\"{\\\"legend\\\":{\\\"padding\\\":[25,20,25,10],\\\"data\\\":[\\\"中国石油全资（集团所属）\\\",\\\"中国石油全资（股份所属）\\\",\\\"中石油控股或有控股权\\\",\\\"中石油参股\\\",\\\"非中石油\\\"],\\\"top\\\":\\\"top\\\",\\\"orient\\\":\\\"vertical\\\",\\\"left\\\":\\\"right\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#333\\\",\\\"fontSize\\\":12}},\\\"series\\\":[{\\\"isRose\\\":false,\\\"data\\\":[{\\\"name\\\":\\\"中国石油全资（集团所属）\\\",\\\"value\\\":38460270.57,\\\"itemStyle\\\":{\\\"color\\\":\\\"#E46C8A\\\"}},{\\\"name\\\":\\\"中国石油全资（股份所属）\\\",\\\"value\\\":227595.77,\\\"itemStyle\\\":{\\\"color\\\":\\\"#FCDE43\\\"}},{\\\"name\\\":\\\"中石油控股或有控股权\\\",\\\"value\\\":679926.75,\\\"itemStyle\\\":{\\\"color\\\":\\\"#01A8E1\\\"}},{\\\"name\\\":\\\"中石油参股\\\",\\\"value\\\":72062.75,\\\"itemStyle\\\":{\\\"color\\\":\\\"#99CC00\\\"}},{\\\"name\\\":\\\"非中石油\\\",\\\"value\\\":1698597.62,\\\"itemStyle\\\":{\\\"color\\\":\\\"#800080\\\"}}],\\\"isRadius\\\":false,\\\"roseType\\\":\\\"\\\",\\\"notCount\\\":false,\\\"center\\\":[320,180],\\\"name\\\":\\\"访问来源\\\",\\\"minAngle\\\":0,\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"outside\\\",\\\"textStyle\\\":{\\\"fontSize\\\":16,\\\"fontWeight\\\":\\\"bolder\\\"}},\\\"type\\\":\\\"pie\\\",\\\"radius\\\":\\\"55%\\\",\\\"autoSort\\\":false}],\\\"tooltip\\\":{\\\"formatter\\\":\\\"{b} : {c}\\\",\\\"show\\\":true,\\\"textStyle\\\":{\\\"color\\\":\\\"#fff\\\",\\\"fontSize\\\":18}},\\\"title\\\":{\\\"show\\\":true,\\\"top\\\":5,\\\"text\\\":\\\"来源收入统计\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#c23531\\\",\\\"fontWeight\\\":\\\"bolder\\\",\\\"fontSize\\\":18},\\\"left\\\":\\\"center\\\",\\\"padding\\\":[5,20,5,10]},\\\"backgroundColor\\\":\\\"#fff\\\"}\",\"url\":\"\",\"extData\":{\"dataType\":\"sql\",\"apiStatus\":\"\",\"apiUrl\":\"\",\"dataId\":\"4af57d343f1d6521b71b85097b580786\",\"axisX\":\"biz_income\",\"axisY\":\"total\",\"series\":\"\",\"yText\":\"total\",\"xText\":\"biz_income\",\"dbCode\":\"tmp_report_data_income\",\"dataId1\":\"\",\"source\":\"\",\"target\":\"\",\"isTiming\":true,\"intervalTime\":\"5\",\"chartType\":\"pie.simple\",\"id\":\"\"},\"layer_id\":\"nVUy533exgQ70OPb\",\"offsetX\":0,\"offsetY\":0,\"virtualCellRange\":[[1,1],[1,2],[1,3],[1,4],[1,5],[1,6],[1,7],[1,8]]}],\"area\":{\"sri\":2,\"sci\":11,\"eri\":2,\"eci\":11,\"width\":100,\"height\":25},\"excel_config_id\":\"f5f275b5e28b45256ef24587ec792f0c\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"1\":{\"cells\":{\"1\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"2\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"3\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"4\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"5\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"6\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"7\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"},\"8\":{\"text\":\" \",\"virtual\":\"nVUy533exgQ70OPb\"}}},\"3\":{\"cells\":{}},\"16\":{\"cells\":{\"1\":{\"text\":\"业务来源\",\"style\":1},\"2\":{\"text\":\"保险经纪佣金费\",\"style\":1},\"3\":{\"text\":\"风险咨询费\",\"style\":1},\"4\":{\"text\":\"承保公证评估费\",\"style\":1},\"5\":{\"text\":\"保险公证费\",\"style\":1},\"6\":{\"text\":\"投标咨询费\",\"style\":1},\"7\":{\"text\":\"内控咨询费\",\"style\":1},\"8\":{\"text\":\"总计\",\"style\":1}}},\"17\":{\"cells\":{\"1\":{\"text\":\"#{tmp_report_data_income.biz_income}\",\"style\":0},\"2\":{\"text\":\"#{tmp_report_data_income.bx_jj_yongjin}\",\"style\":0},\"3\":{\"text\":\"#{tmp_report_data_income.bx_zx_money}\",\"style\":0},\"4\":{\"text\":\"#{tmp_report_data_income.chengbao_gz_money}\",\"style\":0},\"5\":{\"text\":\"#{tmp_report_data_income.bx_gg_moeny}\",\"style\":0},\"6\":{\"text\":\"#{tmp_report_data_income.tb_zx_money}\",\"style\":0},\"7\":{\"text\":\"#{tmp_report_data_income.neikong_zx_money}\",\"style\":0},\"8\":{\"text\":\"#{tmp_report_data_income.total}\",\"style\":0}},\"isDrag\":true,\"height\":24},\"len\":58},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":701,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#33CCCC\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":15},\"1\":{\"width\":105},\"2\":{\"width\":119},\"3\":{\"width\":87},\"4\":{\"width\":61},\"5\":{\"width\":63},\"6\":{\"width\":60},\"7\":{\"width\":91},\"len\":50},\"merges\":[]}', NULL, NULL, 'admin', '2021-01-18 13:21:14', 'admin', '2021-06-01 19:21:25', 0, NULL, NULL, 0, 59, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('f6ee801e8bdc28ba9d63f95dc65ccd79', '4556633', '采购单', '', NULL, 'printinfo', '{\"loopBlockList\":[],\"area\":false,\"excel_config_id\":\"f6ee801e8bdc28ba9d63f95dc65ccd79\",\"printConfig\":{\"paper\":\"A4\",\"width\":210,\"height\":297,\"definition\":1,\"isBackend\":false,\"marginX\":10,\"marginY\":10},\"rows\":{\"0\":{\"cells\":{\"1\":{\"text\":\"采购单\",\"style\":21,\"merge\":[0,6]}},\"height\":89},\"1\":{\"cells\":{\"1\":{\"text\":\"产品名称\",\"style\":23},\"2\":{\"text\":\"产品数量\",\"style\":23},\"3\":{\"text\":\"单价\",\"style\":23},\"4\":{\"text\":\"库存量\",\"style\":23},\"5\":{\"text\":\"库存总值\",\"style\":23},\"6\":{\"text\":\"订购量\",\"style\":23},\"7\":{\"text\":\"二次订购量\",\"style\":23}},\"height\":45},\"2\":{\"cells\":{\"1\":{\"style\":24,\"text\":\"#{caigou.cname}\"},\"2\":{\"style\":24,\"text\":\"#{caigou.cnum}\"},\"3\":{\"style\":24,\"text\":\"#{caigou.cprice}\"},\"4\":{\"style\":24,\"text\":\"#{caigou.ctotal}\"},\"5\":{\"style\":24,\"text\":\"#{caigou.tp}\"},\"6\":{\"style\":24,\"text\":\"#{caigou.dtotal}\"},\"7\":{\"style\":24,\"text\":\"#{caigou.ztotal}\"}},\"height\":26},\"5\":{\"cells\":{\"1\":{\"text\":\"\"}},\"isDrag\":true},\"6\":{\"cells\":{\"1\":{\"text\":\"\"}},\"isDrag\":true},\"7\":{\"cells\":{\"1\":{\"text\":\"\"},\"2\":{\"text\":\"\"}},\"isDrag\":true},\"len\":100},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":718,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":682,\"displayConfig\":{},\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"align\":\"center\"},{\"align\":\"center\",\"color\":\"#000100\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#01b0f1\"],\"top\":[\"thin\",\"#01b0f1\"],\"left\":[\"thin\",\"#01b0f1\"],\"right\":[\"thin\",\"#01b0f1\"]}},{\"border\":{\"bottom\":[\"thin\",\"#01b0f1\"],\"top\":[\"thin\",\"#01b0f1\"],\"left\":[\"thin\",\"#01b0f1\"],\"right\":[\"thin\",\"#01b0f1\"]}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#01b0f1\"],\"top\":[\"thin\",\"#01b0f1\"],\"left\":[\"thin\",\"#01b0f1\"],\"right\":[\"thin\",\"#01b0f1\"]},\"bgcolor\":\"#01b0f1\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#01b0f1\"},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]}},{\"align\":\"center\",\"font\":{\"size\":18}},{\"align\":\"center\",\"font\":{\"size\":18,\"bold\":true}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true}},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"align\":\"center\"},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#9cc2e6\"},{\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true,\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#5b9cd6\"],\"top\":[\"thin\",\"#5b9cd6\"],\"left\":[\"thin\",\"#5b9cd6\"],\"right\":[\"thin\",\"#5b9cd6\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#9cc2e6\",\"font\":{\"name\":\"宋体\"}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#000100\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#5b9cd6\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#5b9cd6\",\"font\":{\"name\":\"宋体\"}},{\"align\":\"center\",\"font\":{\"size\":16,\"bold\":true,\"name\":\"Microsoft YaHei\"}},{\"font\":{\"name\":\"Microsoft YaHei\"}},{\"align\":\"center\",\"color\":\"#ffffff\",\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"bgcolor\":\"#5b9cd6\",\"font\":{\"name\":\"Microsoft YaHei\"}},{\"border\":{\"bottom\":[\"thin\",\"#bfbfbf\"],\"top\":[\"thin\",\"#bfbfbf\"],\"left\":[\"thin\",\"#bfbfbf\"],\"right\":[\"thin\",\"#bfbfbf\"]},\"align\":\"center\",\"font\":{\"name\":\"Microsoft YaHei\"}}],\"validations\":[],\"cols\":{\"0\":{\"width\":43},\"1\":{\"width\":114},\"2\":{\"width\":109},\"3\":{\"width\":78},\"4\":{\"width\":77},\"5\":{\"width\":84},\"6\":{\"width\":82},\"7\":{\"width\":95},\"len\":50},\"merges\":[\"B1:H1\"]}', '', 'https://static.jeecg.com/designreport/images/caigou_1607310279439.png', 'jeecg', '2020-07-28 16:54:44', 'admin', '2021-04-01 03:09:41', 0, NULL, NULL, 1, 1248, NULL, NULL);
INSERT INTO `jimu_report` VALUES ('ff9bd143582a6dfed897ba8b6f93b175', '56696', '销售公司出库单', '', NULL, 'printinfo', '{\"area\":{\"sri\":4,\"sci\":0,\"eri\":4,\"eci\":0,\"width\":32,\"height\":25},\"printElWidth\":794,\"excel_config_id\":\"ff9bd143582a6dfed897ba8b6f93b175\",\"printElHeight\":800,\"rows\":{\"0\":{\"cells\":{\"0\":{\"style\":11,\"text\":\"医疗器械销售公司出货单\",\"merge\":[0,9]}},\"height\":83},\"1\":{\"cells\":{\"0\":{\"text\":\"供货单位：\",\"style\":20,\"merge\":[0,1]},\"1\":{\"style\":30},\"2\":{\"text\":\"${gongsi.gname}\",\"style\":19},\"3\":{\"style\":19},\"4\":{\"text\":\"供货日期：\",\"style\":19},\"5\":{\"text\":\"${gongsi.gdata}\",\"style\":19,\"merge\":[0,1]},\"6\":{\"style\":19},\"7\":{\"text\":\"编号：\",\"style\":20},\"8\":{\"text\":\"${gongsi.num}\",\"style\":19,\"merge\":[0,1]},\"9\":{\"style\":19}},\"isDrag\":true},\"2\":{\"cells\":{\"0\":{\"text\":\"行号\",\"style\":39},\"1\":{\"text\":\"产品代码\",\"style\":39},\"2\":{\"text\":\"产品名称\",\"style\":39},\"3\":{\"text\":\"规格型号\",\"style\":39},\"4\":{\"text\":\"单位\",\"style\":39},\"5\":{\"text\":\"实发数量\",\"style\":39},\"6\":{\"text\":\"销售单价(元)\",\"style\":39},\"7\":{\"text\":\"折扣率（%）\",\"style\":39},\"8\":{\"text\":\"销售金额(元)\",\"style\":39},\"9\":{\"text\":\"备注\",\"style\":39}}},\"3\":{\"cells\":{\"0\":{\"style\":35,\"text\":\"#{xiaoshou.id}\"},\"1\":{\"style\":35,\"text\":\"#{xiaoshou.hnum}\"},\"2\":{\"style\":35,\"text\":\"#{xiaoshou.hname}\"},\"3\":{\"style\":35,\"text\":\"#{xiaoshou.xinghao}\"},\"4\":{\"style\":35,\"text\":\"#{xiaoshou.danwei}\"},\"5\":{\"style\":35,\"text\":\"#{xiaoshou.num}\"},\"6\":{\"style\":35,\"text\":\"#{xiaoshou.danjia}\"},\"7\":{\"style\":35,\"text\":\"#{xiaoshou.zhekoulv}\"},\"8\":{\"style\":35,\"text\":\"#{xiaoshou.xiaoshoujine}\"},\"9\":{\"style\":35,\"text\":\"#{xiaoshou.xiaoshoujine}\"}}},\"4\":{\"cells\":{\"0\":{\"style\":4},\"1\":{}},\"isDrag\":true},\"len\":84,\"-1\":{\"cells\":{\"0\":{\"text\":\"#{gongsi.gdata}\"},\"-1\":{\"text\":\"#{gongsi.didian}\"}},\"isDrag\":true}},\"dbexps\":[],\"toolPrintSizeObj\":{\"printType\":\"A4\",\"widthPx\":794,\"heightPx\":1047},\"dicts\":[],\"freeze\":\"A1\",\"dataRectWidth\":794,\"background\":false,\"name\":\"sheet1\",\"autofilter\":{},\"styles\":[{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\"},{\"font\":{\"size\":16}},{\"font\":{\"size\":16},\"align\":\"center\"},{\"align\":\"center\"},{\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"]}},{\"border\":{\"top\":[\"thin\",\"#000\"],\"bottom\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]}},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"right\"},{\"align\":\"right\"},{\"align\":\"center\",\"font\":{\"size\":14}},{\"align\":\"center\",\"font\":{\"size\":14,\"bold\":true}},{\"align\":\"center\",\"font\":{\"size\":9}},{\"font\":{\"size\":9}},{\"align\":\"right\",\"font\":{\"size\":9}},{\"align\":\"center\",\"font\":{\"size\":8}},{\"font\":{\"size\":8}},{\"align\":\"right\",\"font\":{\"size\":8}},{\"align\":\"center\",\"font\":{\"size\":8},\"color\":\"#7f7f7f\"},{\"font\":{\"size\":8},\"color\":\"#7f7f7f\"},{\"align\":\"right\",\"font\":{\"size\":8},\"color\":\"#7f7f7f\"},{\"align\":\"center\",\"font\":{\"size\":8},\"color\":\"#3f3f3f\"},{\"font\":{\"size\":8},\"color\":\"#3f3f3f\"},{\"align\":\"right\",\"font\":{\"size\":8},\"color\":\"#3f3f3f\"},{\"align\":\"center\",\"font\":{\"size\":8},\"color\":\"#262626\"},{\"font\":{\"size\":8},\"color\":\"#262626\"},{\"align\":\"right\",\"font\":{\"size\":8},\"color\":\"#262626\"},{\"align\":\"center\",\"font\":{\"size\":8},\"color\":\"#0c0c0c\"},{\"font\":{\"size\":8},\"color\":\"#0c0c0c\"},{\"align\":\"right\",\"font\":{\"size\":8},\"color\":\"#0c0c0c\"},{\"align\":\"right\",\"color\":\"#7f7f7f\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"align\":\"center\",\"bgcolor\":\"#71ae47\"},{\"border\":{\"bottom\":[\"thin\",\"#000\"],\"top\":[\"thin\",\"#000\"],\"left\":[\"thin\",\"#000\"],\"right\":[\"thin\",\"#000\"]},\"bgcolor\":\"#71ae47\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"align\":\"center\",\"bgcolor\":\"#71ae47\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"bgcolor\":\"#71ae47\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"align\":\"center\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]}},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"align\":\"center\",\"bgcolor\":\"#c5e0b3\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"bgcolor\":\"#c5e0b3\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"align\":\"center\",\"bgcolor\":\"#a7d08c\"},{\"border\":{\"bottom\":[\"thin\",\"#538136\"],\"top\":[\"thin\",\"#538136\"],\"left\":[\"thin\",\"#538136\"],\"right\":[\"thin\",\"#538136\"]},\"bgcolor\":\"#a7d08c\"}],\"validations\":[],\"cols\":{\"0\":{\"width\":32},\"1\":{\"width\":65},\"2\":{\"width\":115},\"3\":{\"width\":70},\"4\":{\"width\":52},\"5\":{\"width\":70},\"6\":{\"width\":93},\"7\":{\"width\":86},\"8\":{\"width\":75},\"9\":{\"width\":136},\"10\":{\"width\":81},\"len\":24},\"merges\":[\"F2:G2\",\"F2:G2\",\"I2:J2\",\"A2:B2\",\"C2:D2\",\"A2:B2\",\"A1:J1\"]}', '', 'https://static.jeecg.com/designreport/images/医疗器械_1607070355110.png', 'jeecg', '2020-06-16 11:54:02', 'admin', '2021-02-02 19:34:39', 0, NULL, NULL, 0, 764, NULL, NULL);

-- ----------------------------
-- Table structure for jimu_report_data_source
-- ----------------------------
DROP TABLE IF EXISTS `jimu_report_data_source`;
CREATE TABLE `jimu_report_data_source`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源名称',
  `report_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '报表_id',
  `code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码',
  `remark` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `db_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据库类型',
  `db_driver` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '驱动类',
  `db_url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源地址',
  `db_username` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户名',
  `db_password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密码',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `connect_times` int(1) UNSIGNED NULL DEFAULT 0 COMMENT '连接失败次数',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_jmdatasource_report_id`(`report_id`) USING BTREE,
  INDEX `idx_jmdatasource_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jimu_report_data_source
-- ----------------------------
INSERT INTO `jimu_report_data_source` VALUES ('1324261983692902402', 'jeewx', '1324261770294071296', '', NULL, 'MYSQL', 'com.mysql.jdbc.Driver', 'jdbc:mysql://127.0.0.1:3306/jeewx-boot?useUnicode=true&characterEncoding=UTF-8&serverTimezone=GMT%2B8', 'root', 'root', 'jeecg', '2020-11-05 16:07:15', NULL, '2020-11-05 16:07:15', 0);
INSERT INTO `jimu_report_data_source` VALUES ('26d21fe4f27920d2f56abc8d90a8e527', 'oracle', '1308645288868712448', '', NULL, 'ORACLE', 'oracle.jdbc.OracleDriver', 'jdbc:oracle:thin:@192.168.1.199:1521:helowin', 'jeecgbootbpm', 'jeecg196283', 'admin', '2021-01-05 19:26:24', NULL, '2021-01-05 19:26:24', 0);
INSERT INTO `jimu_report_data_source` VALUES ('8f90daf47d15d35ca6cf420748b8b9ba', 'localhost', '1316944968992034816', '', NULL, 'MYSQL5.7', 'com.mysql.cj.jdbc.Driver', 'jdbc:mysql://127.0.0.1:3306/jeecg-boot?useUnicode=true&characterEncoding=UTF-8&serverTimezone=GMT%2B8', 'root', 'root', 'admin', '2021-01-13 14:34:00', NULL, '2021-01-13 14:34:00', 0);

-- ----------------------------
-- Table structure for jimu_report_db
-- ----------------------------
DROP TABLE IF EXISTS `jimu_report_db`;
CREATE TABLE `jimu_report_db`  (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
  `jimu_report_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '主键字段',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `db_code` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据集编码',
  `db_ch_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据集名字',
  `db_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据源类型',
  `db_table_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据库表名',
  `db_dyn_sql` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '动态查询SQL',
  `db_key` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据源KEY',
  `tb_db_key` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '填报数据源',
  `tb_db_table_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '填报数据表',
  `java_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'java类数据集  类型（spring:springkey,class:java类名）',
  `java_value` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'java类数据源  数值（bean key/java类名）',
  `api_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求地址',
  `api_method` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求方法0-get,1-post',
  `is_list` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '是否是列表0否1是 默认0',
  `is_page` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否作为分页,0:不分页，1:分页',
  `db_source` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据源',
  `db_source_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据库类型 MYSQL ORACLE SQLSERVER',
  `json_data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'json数据，直接解析json内容',
  `api_convert` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'api转换器',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_jmreportdb_db_key`(`db_key`) USING BTREE,
  INDEX `idx_jimu_report_id`(`jimu_report_id`) USING BTREE,
  INDEX `idx_db_source_id`(`db_source`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jimu_report_db
-- ----------------------------
INSERT INTO `jimu_report_db` VALUES ('1272834687525482497', '53c82a76f837d5661dceec7d93afafec', 'admin', NULL, '2021-01-04 20:42:17', '2021-01-04 20:42:17', 'jianpiao', 'jianpiao', '0', NULL, 'select * from rep_demo_jianpiao where s_id=\'${id}\'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '1', NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1272858455908073473', 'ff9bd143582a6dfed897ba8b6f93b175', 'admin', NULL, '2020-12-14 16:21:09', '2020-12-14 16:21:09', 'xiaoshou', 'xiaoshou', '0', NULL, 'select * from rep_demo_xiaoshou where s_id=\'${id}\'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '1', NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1273495682564534273', 'ff9bd143582a6dfed897ba8b6f93b175', 'admin', NULL, '2020-09-28 10:18:07', '2020-12-14 16:21:09', 'gongsi', 'gongsi', '0', NULL, 'select * from rep_demo_gongsi where id=\'${id}\'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0', NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1283730831482937345', '6059e405dd9c66a6d38e00841d2e40cc', 'admin', NULL, '2020-12-04 16:53:38', '2020-12-04 16:53:38', 'yaopin', 'yaopin', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/chufangjian', '0', '0', '0', NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1283957016150249473', '6059e405dd9c66a6d38e00841d2e40cc', NULL, NULL, '2020-07-17 10:49:42', NULL, 'yonghu', 'yonghu', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/yonghu', '0', '0', NULL, NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1284070508744257537', 'a250846887abe01217aab173d3006489', NULL, NULL, '2020-07-17 15:33:53', '2020-07-20 17:50:49', 'budong', 'budong', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/budongchan', '0', '0', NULL, NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1285157606524002305', 'a9f068972508920cd4aab831814f0c04', 'admin', 'admin', '2021-04-01 02:44:48', '2021-04-01 02:44:48', 'pdaibu', 'pdaibu', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/daibu', '0', '0', '0', '', 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1285164420728692737', '7905022412733a0c68dc7b4ef8947489', NULL, NULL, '2020-07-20 18:47:30', NULL, 'jieshaoxin', 'jieshaoxin', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/jieshaoxin', '0', '0', NULL, NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1285178919099637762', '6d6bdcb5e820c301ea32789e3ae43c44', NULL, NULL, '2020-07-20 19:45:06', NULL, 'qiangxiu', 'qiangxiu', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/qiangxiu', '0', '0', NULL, NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1288038655293661186', 'f6ee801e8bdc28ba9d63f95dc65ccd79', 'admin', 'admin', '2021-04-01 03:09:40', '2021-04-01 03:09:40', 'caigou', 'caigou', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/caigou?pageNo=\'${pageNo}\'&pageSize=\'${pageSize}\'', '0', '1', '1', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1289140698221678593', '519c1c6f4d1f584ae8fa5b43b45acdc7', 'admin', 'admin', '2021-04-01 03:09:23', '2021-04-01 03:09:23', 'xiaoshou', 'xiaoshou', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/xiaoshou?pageNo=\'${pageNo}\'&pageSize=\'${pageSize}\'', '0', '1', '1', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1290104038414721025', '53c82a76f837d5661dceec7d93afafec', 'admin', NULL, '2021-01-04 20:47:07', '2021-01-04 20:47:07', 'gongsi', 'gongsi', '0', NULL, 'select * from rep_demo_gongsi where id=\'${id}\'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0', '', 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1316987047604514817', '1314846205892759552', 'admin', NULL, '2021-01-08 10:36:58', '2021-01-08 10:36:58', 'yuangongjiben', 'yuangongjiben', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/yuangongjiben', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1316997232402231298', '1316944968992034816', 'admin', NULL, '2021-01-13 14:34:06', '2021-01-13 14:34:06', 'employee', 'employee', '0', NULL, 'select * from rep_demo_employee  where id=\'${id}\'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '0', '', '', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1317006713165049858', '1314846205892759552', 'admin', NULL, '2021-01-11 14:38:14', '2021-01-11 14:38:14', 'xueli', 'xueli', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/xueli', '0', '1', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1317007979484147714', '1314846205892759552', 'admin', NULL, '2021-01-08 10:40:31', '2021-01-08 10:40:31', 'uu', 'uu', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/gongzuojingli', '0', '1', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1317009166140829698', '1314846205892759552', 'admin', NULL, '2020-10-16 15:47:09', '2021-01-05 15:33:58', 'zhengshu', 'zhengshu', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/zhengshu', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1317013474634756097', '1314846205892759552', 'admin', NULL, '2020-10-16 16:04:16', '2021-01-05 15:33:58', 'jtcy', 'jtcy', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/jtcy', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1317015169494282241', '1314846205892759552', 'admin', NULL, '2020-10-16 16:11:00', '2021-01-05 15:33:58', 'jiangli', 'jiangli', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/jiangli', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1331511745851731969', '1331503965770223616', 'admin', NULL, '2020-11-25 16:15:13', '2020-11-25 16:15:13', 'chengjiao', 'chengjiao', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/chengjiao', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1331514838211407873', '1331503965770223616', 'admin', NULL, '2020-11-25 16:27:30', '2020-11-25 16:27:30', 'cjpaihang', 'cjpaihang', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/cjpaihang', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1331514935028527106', '1331503965770223616', 'admin', NULL, '2020-11-25 16:27:54', '2020-11-25 16:27:54', 'cjjine', 'cjjine', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/cjjine', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1331872643531526146', '1331503965770223616', 'admin', NULL, '2020-11-26 16:09:18', '2020-11-26 16:09:18', 'chengjiao1', 'chengjiao1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/chengjiao1', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1331878107552010242', '1331503965770223616', 'admin', NULL, '2020-11-26 16:31:01', '2020-11-26 16:31:01', 'zhuangxiu', 'zhuangxiu', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/zhuangxiu', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1331916030221602818', '1331503965770223616', 'admin', NULL, '2020-11-26 19:01:42', '2020-11-26 19:01:42', 'btchanquan', 'btchanquan', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/btchanquan', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1331919172472524801', '1331503965770223616', 'admin', NULL, '2020-11-26 19:14:11', '2020-11-26 19:14:11', 'huxingxiaoshou', 'huxingxiaoshou', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/huxingxiaoshou', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1331922734933987329', '1331503965770223616', 'admin', NULL, '2020-11-26 19:28:21', '2020-11-26 19:28:21', 'fangyuan', 'fangyuan', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/fangyuan', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1331926127597441025', '1331503965770223616', 'admin', NULL, '2020-11-26 19:41:49', '2020-11-26 19:41:49', 'qingkuang', 'qingkuang', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/qingkuang', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1334390762455965697', '1334378897302753280', 'admin', NULL, '2021-01-06 11:43:35', '2021-01-06 11:43:35', 'quyuxiaoshou', 'quyuxiaoshou', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/quyuxiaoshou', '0', '1', '1', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1334440263732436994', '1334420681185566722', 'admin', NULL, '2021-01-04 21:28:19', '2021-01-04 21:28:19', 'laiyuan', 'laiyuan', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/laiyuan', '0', '1', '1', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1334465135435063298', '1334457419857793024', 'admin', NULL, '2021-01-04 21:29:28', '2021-01-04 21:29:28', 'xiaoshou', 'xiaoshou', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/xiaoshou', '0', '1', '1', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1334708015269490689', '1334696790477377536', 'admin', NULL, '2021-01-04 21:30:29', '2021-01-04 21:30:29', 'shouru', 'shouru', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/shouru', '0', '1', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1334763434197200897', '1334757703079301120', 'admin', NULL, '2020-12-04 15:40:31', '2020-12-04 15:40:31', 'chejian', 'chejian', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/chejian', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('1338756341933543425', '1338744112815411200', 'admin', NULL, '2021-02-02 19:20:56', '2021-02-02 19:20:56', 'jdcx', 'jdcx', '0', NULL, 'select * from rep_demo_dxtj', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '0', '', 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('22f025b781ee9fe4746438621e82674f', '01a1e07ed4b12348b29d5a47ac7f0228', 'admin', NULL, '2020-12-14 16:21:09', '2020-12-14 16:21:09', 'xiaoshou', 'xiaoshou', '0', NULL, 'select * from rep_demo_xiaoshou where s_id=\'${id}\'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '1', NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('2324fac242b35938678a05bbbba345e2', '7acddbc92bc73d06c7f62ff55dfdca19', 'admin', NULL, '2021-01-11 14:25:45', '2021-01-11 14:25:45', 'xiaoshou', 'xiaoshou', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/xiaoshou?pageNo=\'${pageNo}\'&pageSize=\'${pageSize}\'', '0', '1', '1', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('28e0b01cc3e2b0d361107661527bfdff', '6df599d933df24de007764d0e98eb105', 'admin', NULL, '2020-12-04 16:53:38', '2020-12-04 16:53:38', 'yaopin', 'yaopin', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/chufangjian', '0', '0', '0', NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('4af57d343f1d6521b71b85097b580786', '1347459370216198144', 'admin', NULL, '2021-01-08 17:26:57', '2021-01-08 17:26:57', 'tmp_report_data_income', '来源收入统计', '0', NULL, 'select * from tmp_report_data_income', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '1', '', 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('4dc208eb92fd1a84ef7b4723251e3e51', '5485950d88c9918d03dece2ad24b4d72', 'admin', NULL, '2021-01-08 16:24:16', '2021-01-08 16:24:16', 'tmp_report_data_1', '年度佣金收入', '0', NULL, 'select monty,main_income,total,his_lowest,his_average,his_highest from tmp_report_data_1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '0', '', 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('537477711022567424', '537446834339098624', 'admin', 'admin', '2021-04-01 05:54:42', '2021-04-01 05:54:42', 'yy', 'yy', '0', NULL, 'select * from rep_demo_dxtj', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '1', '', 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('537478337278291968', '537446834339098624', 'admin', 'admin', '2021-04-01 05:54:37', '2021-04-01 05:54:37', 'tt', 'tt', '0', NULL, 'select *  from SYS_DATA_LOG', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '0', '26d21fe4f27920d2f56abc8d90a8e527', 'ORACLE', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('537478706314129408', '537446834339098624', 'admin', 'admin', '2021-04-01 05:56:44', '2021-04-01 05:56:44', 'pp', 'pp', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/caigou', '0', '1', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('6011955e58d89040fca52e7f962d0bf4', '961455b47c0b86dc961e90b5893bff05', 'admin', NULL, '2021-01-04 20:47:07', '2021-01-04 20:47:07', 'gongsi', 'gongsi', '0', NULL, 'select * from rep_demo_gongsi where id=\'${id}\'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0', '', 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('60b3feffadc55eb49baa5a48fdf1ff0e', '1352160857479581696', 'admin', 'admin', '2021-05-19 19:20:44', '2021-05-19 19:20:44', 'infoForReport', '信息', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '{{ domainURL }}/sys/actuator/redis/infoForReport', '0', '1', '1', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('629609c4d540cb4675e9064af8955296', '7c02c224a2db56d0350069650033f702', 'admin', NULL, '2021-02-02 19:33:09', '2021-02-02 19:33:09', 'hecha', 'hecha', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/hecha', '0', '1', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('654609e4247a0469e0b2befbc69b00f9', '1cd9d574d0c42f3915046dc61d9f33bd', 'admin', NULL, '2020-12-17 16:42:21', '2020-12-17 19:50:14', 'xiaoshoue', '销售额', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/xiaoshoue', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('6a1d22ca4c95e8fab655d3ceed43a84d', '1352160857479581696', 'admin', 'admin', '2021-05-19 19:20:50', '2021-05-19 19:20:50', 'memoryForReport', '内存', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '{{ domainURL }}/sys/actuator/redis/memoryForReport', '0', '1', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('7911bd189c2d53e182693bd599a315a2', '1cd9d574d0c42f3915046dc61d9f33bd', 'admin', NULL, '2020-12-17 16:59:12', '2020-12-17 19:50:14', 'chengshi', '城市', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/chengshi', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('7b20679054449c554cde856ef24126ab', '1347454742040809472', 'admin', NULL, '2021-01-08 16:24:16', '2021-01-08 16:24:16', 'tmp_report_data_1', '年度佣金收入', '0', NULL, 'select monty,main_income,total,his_lowest,his_average,his_highest from tmp_report_data_1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '0', '', 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('94bcd8202bc6bc467efd0d679dadd7bb', '1338370016550195200', 'admin', NULL, '2021-02-02 19:27:31', '2021-02-02 19:27:31', 'tm', 'tm', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/tiaoma1', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('9b75c161322e0b7e29b3ffc84239a72c', '1cd9d574d0c42f3915046dc61d9f33bd', 'admin', NULL, '2020-12-17 17:13:21', '2020-12-17 19:50:14', 'xsjd', '销售进度', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/xsjd', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('9b7d28336b01f9a6b1a613957c3d7cda', '1338769064067076098', 'admin', NULL, '2021-02-02 19:12:55', '2021-02-02 19:12:55', 'pop', 'pop', '0', NULL, 'select * from rep_demo_dxtj', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '0', '', 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('a543d8dd40f4d26839b78bd604be659e', 'f5f275b5e28b45256ef24587ec792f0c', 'admin', NULL, '2021-01-08 17:26:57', '2021-01-08 17:26:57', 'tmp_report_data_income', '来源收入统计', '0', NULL, 'select * from tmp_report_data_income', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '1', '', 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('bbc5d5ab143d59f0beab484682361aa5', 'dd482bfd6ca470a0f49d9bb4e61ec694', 'admin', NULL, '2021-01-08 10:47:52', '2021-01-08 10:47:52', 'tt', 'tt', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/shixi', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('c9bdb6b7ac68accfecb366718bf78f79', '01a1e07ed4b12348b29d5a47ac7f0228', 'admin', NULL, '2020-09-28 10:18:07', '2020-12-14 16:21:09', 'gongsi', 'gongsi', '0', NULL, 'select * from rep_demo_gongsi where id=\'${id}\'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0', NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('d4a29dfda94357308faf62be2b94db08', '1352160857479581696', 'admin', 'admin', '2021-05-19 19:21:03', '2021-05-19 19:21:03', 'keysSizeForReport', '数量', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '{{ domainURL }}/sys/actuator/redis/keysSizeForReport', '0', '1', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('e0fe1d693625c906c1171d7de706a47c', '6df599d933df24de007764d0e98eb105', NULL, NULL, '2020-07-17 10:49:42', NULL, 'yonghu', 'yonghu', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/yonghu', '0', '0', NULL, NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('e4cec9ff15bc0ea42f536a442a6d1335', '961455b47c0b86dc961e90b5893bff05', 'admin', NULL, '2021-01-04 20:42:17', '2021-01-04 20:42:17', 'jianpiao', 'jianpiao', '0', NULL, 'select * from rep_demo_jianpiao where s_id=\'${id}\'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '1', NULL, 'MYSQL', NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('f7649b77cfc9e0a9dacdac370cd4036b', '1347373863746539520', 'admin', NULL, '2021-01-08 10:47:52', '2021-01-08 10:47:52', 'tt', 'tt', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/baobiao/shixi', '0', '0', '0', '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db` VALUES ('fb70a91730f087f8023afd88d24f9697', '1cd9d574d0c42f3915046dc61d9f33bd', 'admin', NULL, '2020-12-17 19:50:14', '2020-12-17 19:50:14', 'zhexian', 'zhexian', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://api.jeecg.com/mock/26/zhexian', '0', '1', '1', '', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for jimu_report_db_field
-- ----------------------------
DROP TABLE IF EXISTS `jimu_report_db_field`;
CREATE TABLE `jimu_report_db_field`  (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `jimu_report_db_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据源ID',
  `field_name` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段名',
  `field_text` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段文本',
  `widget_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '控件类型',
  `widget_width` int(10) NULL DEFAULT NULL COMMENT '控件宽度',
  `order_num` int(3) NULL DEFAULT NULL COMMENT '排序',
  `search_flag` int(3) NULL DEFAULT 0 COMMENT '查询标识0否1是 默认0',
  `search_mode` int(3) NULL DEFAULT NULL COMMENT '查询模式1简单2范围',
  `dict_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字典编码支持从表中取数据',
  `search_value` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询默认值',
  `search_format` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询时间格式化表达式',
  `ext_json` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '参数配置',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_jrdf_jimu_report_db_id`(`jimu_report_db_id`) USING BTREE,
  INDEX `idx_dbfield_order_num`(`order_num`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jimu_report_db_field
-- ----------------------------
INSERT INTO `jimu_report_db_field` VALUES ('00a67b539ac15446c1bd658104e1020a', NULL, '2020-07-21 15:17:10', NULL, NULL, 'c9bdb6b7ac68accfecb366718bf78f79', 'gdata', 'gdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('014179e260e0adf1706c616a3ad6e552', NULL, '2021-01-08 16:10:28', NULL, NULL, '7b20679054449c554cde856ef24126ab', 'main_income', 'main_income', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('01cb1f61f836aae43bca333dbaf293be', NULL, '2021-01-11 14:38:14', NULL, NULL, '1317006713165049858', 'zhuanye', 'zhuanye', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('0470c07d386940053253fe8a8c200225', NULL, '2021-01-08 16:29:02', NULL, NULL, '4af57d343f1d6521b71b85097b580786', 'chengbao_gz_money', 'chengbao_gz_money', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('0680555456f0e579a0065c4ca5dd8d06', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'id', 'id', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('06b24135f3670ea4f4c7f554d2521a39', NULL, '2021-01-08 16:29:02', NULL, NULL, 'a543d8dd40f4d26839b78bd604be659e', 'biz_income', 'biz_income', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('08a3043298245b914eec1444906f6acd', NULL, '2021-02-02 19:13:46', NULL, NULL, '1338756341933543425', 'name', '姓名', 'string', NULL, 2, 1, NULL, '', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('08e22bbf63e81198c0d2585dce8ee8f9', NULL, '2021-02-02 19:10:15', NULL, NULL, '9b7d28336b01f9a6b1a613957c3d7cda', 'jperson', 'jperson', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('0c82931edb766ad89ead9e98a998d43f', NULL, '2021-01-11 14:38:14', NULL, NULL, '1317006713165049858', 'kdate', 'kdate', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('0c9f65f5f754f1251070f51a2a19905d', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'hname', 'hname', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('0e47a8aa98116f10c53c3a366b9c2324', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'dizhi', 'dizhi', 'String', NULL, 21, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('0fb03c8e2330e051564f3dd1de54512f', NULL, '2021-01-11 14:38:14', NULL, NULL, '1317006713165049858', 'jstudent', 'jstudent', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('10e61155dcf655d7843ebc01cc90c8b1', NULL, '2021-01-08 16:10:28', NULL, NULL, '7b20679054449c554cde856ef24126ab', 'total', 'total', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('115c1ac01462ca1fbecb3c0a55218395', NULL, '2021-01-08 16:10:28', NULL, NULL, '7b20679054449c554cde856ef24126ab', 'his_highest', 'his_highest', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('11713370900fa3c1455cac7e8db61fe1', NULL, '2021-01-08 10:47:52', NULL, NULL, 'bbc5d5ab143d59f0beab484682361aa5', 'pingjia', 'pingjia', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('11d3a082d297adeffecd86690e28cf39', NULL, '2021-01-05 15:09:15', NULL, NULL, '2324fac242b35938678a05bbbba345e2', 'ctotal', 'ctotal', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('123772e3abf28b00bd43bf81a824b525', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'slyy', 'slyy', 'String', NULL, 11, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1260eb03ab66bd12766b2102e343d280', NULL, '2021-01-21 17:07:16', NULL, NULL, '6a1d22ca4c95e8fab655d3ceed43a84d', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1272834907562864641', NULL, '2020-06-16 18:14:25', NULL, NULL, '1272834687525482497', 'id', 'id', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1272834907567058946', NULL, '2020-06-16 18:14:25', NULL, NULL, '1272834687525482497', 'bnum', 'bnum', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1272834907571253250', NULL, '2020-06-16 18:14:25', NULL, NULL, '1272834687525482497', 'ftime', 'ftime', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1272834907571253251', NULL, '2020-06-16 18:14:25', NULL, NULL, '1272834687525482497', 'sfkong', 'sfkong', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1272834907571253252', NULL, '2020-06-16 18:14:25', NULL, NULL, '1272834687525482497', 'kaishi', 'kaishi', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1272834907571253253', NULL, '2020-06-16 18:14:25', NULL, NULL, '1272834687525482497', 'jieshu', 'jieshu', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1272834907571253254', NULL, '2020-06-16 18:14:25', NULL, NULL, '1272834687525482497', 'hezairen', 'hezairen', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1272834907571253255', NULL, '2020-06-16 18:14:25', NULL, NULL, '1272834687525482497', 'jpnum', 'jpnum', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1272834907575447554', NULL, '2020-06-16 18:14:25', NULL, NULL, '1272834687525482497', 'shihelv', 'shihelv', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016175415297', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'yphone', 'yphone', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016183803906', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'yzhenliao', 'yzhenliao', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016187998209', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'ysex', 'ysex', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016192192513', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'danwei', 'danwei', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016196386818', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'kdata', 'kdata', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016204775425', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'yname', 'yname', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016208969729', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'yprice', 'yprice', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016213164033', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'ytotal', 'ytotal', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016217358337', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'yishe', 'yishe', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016221552641', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'yizhu', 'yizhu', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016225746946', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'yage', 'yage', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1283957016229941249', NULL, '2020-07-17 10:49:42', NULL, NULL, '1283957016150249473', 'yjieguo', 'yjieguo', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155649130497', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'xtype', 'xtype', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155686879234', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'danyuan', 'danyuan', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155691073538', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'chanquan', 'chanquan', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155695267841', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'zhuzhi', 'zhuzhi', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155699462145', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'fujian', 'fujian', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155707850754', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'didian', 'didian', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155707850755', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'type', 'type', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155712045058', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'suoyou', 'suoyou', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155716239361', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'name', 'name', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155716239362', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'bianhao', 'bianhao', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155720433666', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'yname', 'yname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155720433667', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'riqi', 'riqi', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155724627969', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'beizhu', 'beizhu', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155728822274', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'time', 'time', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285150155728822275', NULL, '2020-07-20 17:50:49', NULL, NULL, '1284070508744257537', 'mianji', 'mianji', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285159608326889474', 'admin', '2021-04-01 02:44:48', NULL, NULL, '1285157606524002305', 'fsex', 'fsex', 'string', NULL, NULL, 0, NULL, 'sex', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285159608335278082', 'admin', '2021-04-01 02:44:48', NULL, NULL, '1285157606524002305', 'fname', 'fname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285159608339472385', 'admin', '2021-04-01 02:44:48', NULL, NULL, '1285157606524002305', 'shiqing', 'shiqing', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285159608339472386', 'admin', '2021-04-01 02:44:48', NULL, NULL, '1285157606524002305', 'pname', 'pname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285159608339472387', 'admin', '2021-04-01 02:44:48', NULL, NULL, '1285157606524002305', 'zhuzhi', 'zhuzhi', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285159608339472388', 'admin', '2021-04-01 02:44:48', NULL, NULL, '1285157606524002305', 'gdata', 'gdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285159608343666690', 'admin', '2021-04-01 02:44:48', NULL, NULL, '1285157606524002305', 'cdata', 'cdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285164420749664258', NULL, '2020-07-20 18:47:30', NULL, NULL, '1285164420728692737', 'shiqing', 'shiqing', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285164420753858561', NULL, '2020-07-20 18:47:30', NULL, NULL, '1285164420728692737', 'name', 'name', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285164420758052866', NULL, '2020-07-20 18:47:30', NULL, NULL, '1285164420728692737', 'gdata', 'gdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285164420758052867', NULL, '2020-07-20 18:47:30', NULL, NULL, '1285164420728692737', 'value', 'value', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285164420758052868', NULL, '2020-07-20 18:47:30', NULL, NULL, '1285164420728692737', 'percent', 'percent', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285164420762247169', NULL, '2020-07-20 18:47:30', NULL, NULL, '1285164420728692737', 'tdata', 'tdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919124803585', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'ktime', 'ktime', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919133192193', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'danwei', 'danwei', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919133192194', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'wtime', 'wtime', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919133192195', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'yusuan', 'yusuan', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919133192196', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'dshenhe', 'dshenhe', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919133192197', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'zhuren', 'zhuren', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919137386498', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'neirong', 'neirong', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919137386499', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'yijian', 'yijian', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919137386500', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'time1', 'time1', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919137386501', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'time2', 'time2', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919137386502', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'time3', 'time3', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919141580801', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'time4', 'time4', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919141580802', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'pingjia', 'pingjia', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919141580803', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'name', 'name', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919141580804', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'bianhao', 'bianhao', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919141580805', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'zongjie', 'zongjie', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919145775105', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'nengli', 'nengli', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285178919145775106', NULL, '2020-07-20 19:45:06', NULL, NULL, '1285178919099637762', 'time', 'time', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285473875810967553', NULL, '2020-07-21 15:17:10', NULL, NULL, '1273495682564534273', 'id', 'id', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285473875823550466', NULL, '2020-07-21 15:17:10', NULL, NULL, '1273495682564534273', 'gname', 'gname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285473875823550467', NULL, '2020-07-21 15:17:10', NULL, NULL, '1273495682564534273', 'gdata', 'gdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285473875823550468', NULL, '2020-07-21 15:17:10', NULL, NULL, '1273495682564534273', 'tdata', 'tdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285473875827744769', NULL, '2020-07-21 15:17:10', NULL, NULL, '1273495682564534273', 'didian', 'didian', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285473875827744770', NULL, '2020-07-21 15:17:10', NULL, NULL, '1273495682564534273', 'zhaiyao', 'zhaiyao', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1285473875827744771', NULL, '2020-07-21 15:17:10', NULL, NULL, '1273495682564534273', 'num', 'num', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288038655394324482', 'admin', '2021-04-01 03:09:40', NULL, NULL, '1288038655293661186', 'ctotal', '库存量', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288038655402713090', 'admin', '2021-04-01 03:09:40', NULL, NULL, '1288038655293661186', 'cname', '产品名称', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288038655406907393', 'admin', '2021-04-01 03:09:40', NULL, NULL, '1288038655293661186', 'cprice', '单价', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288038655411101697', 'admin', '2021-04-01 03:09:40', NULL, NULL, '1288038655293661186', 'dtotal', '订购量', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288038655411101698', 'admin', '2021-04-01 03:09:40', NULL, NULL, '1288038655293661186', 'tp', '库存总值', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288038655415296002', 'admin', '2021-04-01 03:09:40', NULL, NULL, '1288038655293661186', 'ztotal', '二次订购量', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288038655415296003', 'admin', '2021-04-01 03:09:40', NULL, NULL, '1288038655293661186', 'cnum', '产品数量', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290843074561', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'id', 'id', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290847268865', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'hnum', 'hnum', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290851463170', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'hname', 'hname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290851463171', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'xinghao', 'xinghao', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290851463172', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'fahuocangku', 'fahuocangku', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290851463173', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'danwei', 'danwei', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290851463174', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'num', 'num', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290851463175', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'danjia', 'danjia', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290851463176', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'zhekoulv', 'zhekoulv', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290855657473', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'xiaoshoujine', 'xiaoshoujine', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290859851778', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 'beizhu', 'beizhu', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1288048290859851779', NULL, '2020-07-28 17:46:58', NULL, NULL, '1272858455908073473', 's_id', 's_id', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1290104038439886849', NULL, '2020-08-03 09:55:46', NULL, NULL, '1290104038414721025', 'id', 'id', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1290104038448275458', NULL, '2020-08-03 09:55:46', NULL, NULL, '1290104038414721025', 'gname', 'gname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1290104038448275459', NULL, '2020-08-03 09:55:46', NULL, NULL, '1290104038414721025', 'gdata', 'gdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1290104038448275460', NULL, '2020-08-03 09:55:46', NULL, NULL, '1290104038414721025', 'tdata', 'tdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1290104038452469761', NULL, '2020-08-03 09:55:46', NULL, NULL, '1290104038414721025', 'didian', 'didian', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1290104038452469762', NULL, '2020-08-03 09:55:46', NULL, NULL, '1290104038414721025', 'zhaiyao', 'zhaiyao', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1290104038452469763', NULL, '2020-08-03 09:55:46', NULL, NULL, '1290104038414721025', 'num', 'num', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317007979534479361', NULL, '2020-10-16 15:42:26', NULL, NULL, '1317007979484147714', 'zmphone', 'zmphone', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317007979534479362', NULL, '2020-10-16 15:42:26', NULL, NULL, '1317007979484147714', 'jstudent', 'jstudent', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317007979534479363', NULL, '2020-10-16 15:42:26', NULL, NULL, '1317007979484147714', 'kdate', 'kdate', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317007979534479364', NULL, '2020-10-16 15:42:26', NULL, NULL, '1317007979484147714', 'jdate', 'jdate', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317007979534479365', NULL, '2020-10-16 15:42:26', NULL, NULL, '1317007979484147714', 'zmname', 'zmname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317009166149218305', NULL, '2020-10-16 15:47:09', NULL, NULL, '1317009166140829698', 'zcname', 'zcname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317009166149218306', NULL, '2020-10-16 15:47:09', NULL, NULL, '1317009166140829698', 'danwei', 'danwei', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317009166149218307', NULL, '2020-10-16 15:47:09', NULL, NULL, '1317009166140829698', 'fdate', 'fdate', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317009166149218308', NULL, '2020-10-16 15:47:09', NULL, NULL, '1317009166140829698', 'jibie', 'jibie', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317009166149218309', NULL, '2020-10-16 15:47:09', NULL, NULL, '1317009166140829698', 'beizhu', 'beizhu', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317013474643144706', NULL, '2020-10-16 16:04:16', NULL, NULL, '1317013474634756097', 'danwei', 'danwei', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317013474643144707', NULL, '2020-10-16 16:04:16', NULL, NULL, '1317013474634756097', 'phone', 'phone', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317013474643144708', NULL, '2020-10-16 16:04:16', NULL, NULL, '1317013474634756097', 'name', 'name', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317013474643144709', NULL, '2020-10-16 16:04:16', NULL, NULL, '1317013474634756097', 'zzmm', 'zzmm', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317013474643144710', NULL, '2020-10-16 16:04:16', NULL, NULL, '1317013474634756097', 'guanxi', 'guanxi', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317013474643144711', NULL, '2020-10-16 16:04:16', NULL, NULL, '1317013474634756097', 'age', 'age', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317015169502670849', NULL, '2020-10-16 16:11:00', NULL, NULL, '1317015169494282241', 'date', 'date', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317015169502670850', NULL, '2020-10-16 16:11:00', NULL, NULL, '1317015169494282241', 'mingcheng', 'mingcheng', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1317015169502670851', NULL, '2020-10-16 16:11:00', NULL, NULL, '1317015169494282241', 'didian', 'didian', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331511745855926274', NULL, '2020-11-25 16:15:13', NULL, NULL, '1331511745851731969', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331511745855926275', NULL, '2020-11-25 16:15:13', NULL, NULL, '1331511745851731969', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331511745855926276', NULL, '2020-11-25 16:15:13', NULL, NULL, '1331511745851731969', 'type', 'type', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331514838215602178', NULL, '2020-11-25 16:27:30', NULL, NULL, '1331514838211407873', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331514838215602179', NULL, '2020-11-25 16:27:30', NULL, NULL, '1331514838211407873', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331514838215602180', NULL, '2020-11-25 16:27:30', NULL, NULL, '1331514838211407873', 'type', 'type', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331514935032721409', NULL, '2020-11-25 16:27:54', NULL, NULL, '1331514935028527106', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331514935032721410', NULL, '2020-11-25 16:27:54', NULL, NULL, '1331514935028527106', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331514935032721411', NULL, '2020-11-25 16:27:54', NULL, NULL, '1331514935028527106', 'type', 'type', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331872643539914754', NULL, '2020-11-26 16:09:18', NULL, NULL, '1331872643531526146', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331872643539914755', NULL, '2020-11-26 16:09:18', NULL, NULL, '1331872643531526146', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331872643539914756', NULL, '2020-11-26 16:09:18', NULL, NULL, '1331872643531526146', 'type', 'type', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331878107560398849', NULL, '2020-11-26 16:31:01', NULL, NULL, '1331878107552010242', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331878107560398850', NULL, '2020-11-26 16:31:01', NULL, NULL, '1331878107552010242', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331916030229991425', NULL, '2020-11-26 19:01:42', NULL, NULL, '1331916030221602818', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331916030229991426', NULL, '2020-11-26 19:01:42', NULL, NULL, '1331916030221602818', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331916030229991427', NULL, '2020-11-26 19:01:42', NULL, NULL, '1331916030221602818', 'type', 'type', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331919172480913409', NULL, '2020-11-26 19:14:11', NULL, NULL, '1331919172472524801', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331919172480913410', NULL, '2020-11-26 19:14:11', NULL, NULL, '1331919172472524801', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331922734942375938', NULL, '2020-11-26 19:28:21', NULL, NULL, '1331922734933987329', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331922734942375939', NULL, '2020-11-26 19:28:21', NULL, NULL, '1331922734933987329', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331926127605829634', NULL, '2020-11-26 19:41:49', NULL, NULL, '1331926127597441025', 'cjl', 'cjl', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331926127605829635', NULL, '2020-11-26 19:41:49', NULL, NULL, '1331926127597441025', 'cjje', 'cjje', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331926127605829636', NULL, '2020-11-26 19:41:49', NULL, NULL, '1331926127597441025', 'xsmj', 'xsmj', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331926127605829637', NULL, '2020-11-26 19:41:49', NULL, NULL, '1331926127597441025', 'cjjj', 'cjjj', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331926127605829638', NULL, '2020-11-26 19:41:49', NULL, NULL, '1331926127597441025', 'sfyj', 'sfyj', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1331926127605829639', NULL, '2020-11-26 19:41:49', NULL, NULL, '1331926127597441025', 'ydkh', 'ydkh', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825602', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'class', 'class', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825603', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'school', 'school', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825604', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'lv', 'lv', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825605', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'renyuan_jy', 'renyuan_jy', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825606', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'richang_jy', 'richang_jy', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825607', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'biaozhun_jy', 'biaozhun_jy', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825608', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'xinxi_jy', 'xinxi_jy', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825609', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'jichubokuan_jy', 'jichubokuan_jy', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825610', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'renyuan_ct', 'renyuan_ct', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825611', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'richang_ct', 'richang_ct', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825612', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'xiangmu_ct', 'xiangmu_ct', 'String', NULL, 11, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825613', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'jichubokuan_ct', 'jichubokuan_ct', 'String', NULL, 12, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825614', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'xiangmu_sh', 'xiangmu_sh', 'String', NULL, 13, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825615', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'jichubokuan_sh', 'jichubokuan_sh', 'String', NULL, 14, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825616', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'diannao', 'diannao', 'String', NULL, 15, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334440263740825617', NULL, '2020-12-03 18:12:06', NULL, NULL, '1334440263732436994', 'xiaoyuanwang', 'xiaoyuanwang', 'String', NULL, 16, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135443451905', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'diqu', 'diqu', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135443451906', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'class', 'class', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135443451907', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_11', 'sales_11', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135443451908', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_12', 'sales_12', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135443451909', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_13', 'sales_13', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135443451910', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_14', 'sales_14', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135443451911', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_15', 'sales_15', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135443451912', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_16', 'sales_16', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135443451913', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_17', 'sales_17', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646210', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_18', 'sales_18', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646211', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_19', 'sales_19', 'String', NULL, 11, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646212', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_20', 'sales_20', 'String', NULL, 12, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646213', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_21', 'sales_21', 'String', NULL, 13, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646214', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_22', 'sales_22', 'String', NULL, 14, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646215', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_31', 'sales_31', 'String', NULL, 15, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646216', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_32', 'sales_32', 'String', NULL, 16, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646217', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_33', 'sales_33', 'String', NULL, 17, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646218', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_34', 'sales_34', 'String', NULL, 18, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646219', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_35', 'sales_35', 'String', NULL, 19, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646220', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_36', 'sales_36', 'String', NULL, 20, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646221', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_37', 'sales_37', 'String', NULL, 21, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646222', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_38', 'sales_38', 'String', NULL, 22, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646223', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_39', 'sales_39', 'String', NULL, 23, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646224', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_40', 'sales_40', 'String', NULL, 24, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646225', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_41', 'sales_41', 'String', NULL, 25, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334465135447646226', NULL, '2020-12-03 19:50:56', NULL, NULL, '1334465135435063298', 'sales_42', 'sales_42', 'String', NULL, 26, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015277879297', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'city', 'city', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073601', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'school', 'school', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073602', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'ncnum', 'ncnum', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073603', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'num', 'num', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073604', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'name', 'name', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073605', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'class', 'class', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073606', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'pay', 'pay', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073607', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'paytime', 'paytime', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073608', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'payclass', 'payclass', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073609', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'pay1', 'pay1', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073610', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'paymoth', 'paymoth', 'String', NULL, 11, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073611', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'pay2', 'pay2', 'String', NULL, 12, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073612', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'tuition_09', 'tuition_09', 'String', NULL, 13, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073613', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'meals_09', 'meals_09', 'String', NULL, 14, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073614', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'busfee_09', 'busfee_09', 'String', NULL, 15, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073615', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'tuition_10', 'tuition_10', 'String', NULL, 16, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073616', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'meals_10', 'meals_10', 'String', NULL, 17, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334708015282073617', NULL, '2020-12-04 11:56:03', NULL, NULL, '1334708015269490689', 'busfee_10', 'busfee_10', 'String', NULL, 18, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504126402561', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'city', 'city', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596866', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'finish', 'finish', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596867', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'semifinish', 'semifinish', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596868', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'time', 'time', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596869', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'state', 'state', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596870', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'attribute', 'attribute', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596871', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'num', 'num', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596872', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'gnum', 'gnum', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596873', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'jnum', 'jnum', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596874', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'wnum', 'wnum', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596875', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'uph', 'uph', 'String', NULL, 11, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596876', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'hc', 'hc', 'String', NULL, 12, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596877', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'jtime', 'jtime', 'String', NULL, 13, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596878', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'yield', 'yield', 'String', NULL, 14, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334764504130596879', NULL, '2020-12-04 15:40:31', NULL, NULL, '1334763434197200897', 'beizhu', 'beizhu', 'String', NULL, 15, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334782903430754305', NULL, '2020-12-04 16:53:38', NULL, NULL, '1283730831482937345', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334782903430754306', NULL, '2020-12-04 16:53:38', NULL, NULL, '1283730831482937345', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334782903430754307', NULL, '2020-12-04 16:53:38', NULL, NULL, '1283730831482937345', 'key1', 'key1', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334782903430754308', NULL, '2020-12-04 16:53:38', NULL, NULL, '1283730831482937345', 'key2', 'key2', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334782903430754309', NULL, '2020-12-04 16:53:38', NULL, NULL, '1283730831482937345', 'key3', 'key3', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334782903430754310', NULL, '2020-12-04 16:53:38', NULL, NULL, '1283730831482937345', 'key4', 'key4', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334782903430754311', NULL, '2020-12-04 16:53:38', NULL, NULL, '1283730831482937345', 'key5', 'key5', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334782903430754312', NULL, '2020-12-04 16:53:38', NULL, NULL, '1283730831482937345', 'key6', 'key6', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334782903430754313', NULL, '2020-12-04 16:53:38', NULL, NULL, '1283730831482937345', 'key7', 'key7', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1334782903430754314', NULL, '2020-12-04 16:53:38', NULL, NULL, '1283730831482937345', 'percent', 'percent', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('141dc952421a55e66fcddb94adddc48b', NULL, '2021-02-02 19:10:15', NULL, NULL, '9b7d28336b01f9a6b1a613957c3d7cda', 'sex', '性别', 'String', NULL, 10, 1, 1, 'sex', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('15eb0c90635e9b9427a6e0a2d87f31b6', NULL, '2021-01-08 16:29:02', NULL, NULL, 'a543d8dd40f4d26839b78bd604be659e', 'chengbao_gz_money', 'chengbao_gz_money', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('16cca55134a7951fe6724e5d98787498', NULL, '2021-01-05 15:09:15', NULL, NULL, '2324fac242b35938678a05bbbba345e2', 'yprice', 'yprice', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('175e76d9da7c88d8c2c0d7708b308e6c', NULL, '2020-12-04 16:53:38', NULL, NULL, '28e0b01cc3e2b0d361107661527bfdff', 'key7', 'key7', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('17a278c53299d1342c56a8eb1614a44e', 'admin', '2021-04-01 03:09:23', NULL, NULL, '1289140698221678593', 'ctime', 'ctime', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('19e6fe3dc95b352d97f460648dc93e15', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'proportion_z', 'proportion_z', 'String', NULL, 23, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1a1487eb23cc0008b933537c69d51bd9', NULL, '2021-01-05 15:09:15', NULL, NULL, '2324fac242b35938678a05bbbba345e2', 'cname', 'cname', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1aee61147ee0eb946574db960bc77aec', NULL, '2021-01-08 10:47:52', NULL, NULL, 'bbc5d5ab143d59f0beab484682361aa5', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1b09540b3d8deddc06ebdbec26f6ae87', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'political', 'political', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1b53581fa4096f4a05c7e8d73c7a7af9', NULL, '2021-02-02 19:13:46', NULL, NULL, '1338756341933543425', 'jphone', 'jphone', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1b6fbe11728a1c4633eeea8ffb12bc25', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'update_by', 'update_by', 'String', NULL, 30, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1c649cbddf0506464e08ae84c20ea20d', NULL, '2021-01-21 18:00:57', NULL, NULL, '60b3feffadc55eb49baa5a48fdf1ff0e', 'key', 'key', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1d21c72184f2e06ca1be3dc95fbcc259', NULL, '2021-01-11 14:38:14', NULL, NULL, '1317006713165049858', 'zhiwu', 'zhiwu', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1d4cc138f277f5d78e1fe3f5241db7f2', NULL, '2021-01-08 16:29:02', NULL, NULL, 'a543d8dd40f4d26839b78bd604be659e', 'tb_zx_money', 'tb_zx_money', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1ee3018b4d0c305e2c06f77e1e5f3c4c', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'sales_3', 'sales_3', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('1fac3f8219222b8963dc6b85870ffd86', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'telphone', 'telphone', NULL, NULL, 16, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('218fb9e81e6255a6589c52ddd8279c40', NULL, '2021-02-02 19:13:46', NULL, NULL, '1338756341933543425', 'laddress', 'laddress', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('21f7de0326129dbbbc03d64aceb4d3f7', 'admin', '2021-04-01 03:09:23', NULL, NULL, '1289140698221678593', 'yprice', 'yprice', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('2309090975648b8765ef36ff16c09270', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'danwei', 'danwei', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('2330620c6a26ff9e2840fcdcb2fd22af', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'yphone', 'yphone', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('240f3415fa8e7b3876c0b422d468c90d', NULL, '2020-08-03 09:55:46', NULL, NULL, '6011955e58d89040fca52e7f962d0bf4', 'gname', 'gname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('26ee0ad4aea9dcd4604f98ea168aa1be', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'xiaoshoujine', 'xiaoshoujine', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('27bd70e2e4a08009edf64fac0fba5119', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'yizhu', 'yizhu', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('284f03aead3848cf0994f71a64ce1eba', NULL, '2020-12-04 16:53:38', NULL, NULL, '28e0b01cc3e2b0d361107661527bfdff', 'key1', 'key1', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('298cfe65d8b484624f8a28199dc800e7', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'sr', 'sr', 'String', NULL, 16, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('29fcb4292d4782888e9fd0496bd8ddc8', 'admin', '2021-04-01 03:09:23', NULL, NULL, '1289140698221678593', 'id', 'id', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('2a20af47c214fc8ad9570c9c6ba585c2', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'yzhenliao', 'yzhenliao', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('2a3b35b4830f1b1eff84a5a9bceed0b6', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'gift_z', 'gift_z', 'String', NULL, 22, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('2a613408420925ed9cf9618eb77a05cf', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'yage', 'yage', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('2baefff331206f29a9c3bf895982473a', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'kdata', 'kdata', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('2be25d6c7e3ac28abec99854618d0e3d', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'birthday', 'birthday', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('2f94a4be25426f3f4013c50103559969', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'sales_4', 'sales_4', 'String', NULL, 12, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('30034c384d47b0193e04b19b3068b89b', NULL, '2020-12-04 16:53:38', NULL, NULL, '28e0b01cc3e2b0d361107661527bfdff', 'key4', 'key4', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('30f8183ff4ec5a6b30724a1da7fbbed0', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'pworktime', 'pworktime', NULL, NULL, 18, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('30fc020c8d14776e96350edb479f40ac', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'zhuzhi', 'zhuzhi', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('31649efb1fbc69009bdbb41f388c7d7f', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'ysex', 'ysex', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('31bd06f8bc201628d8c9c56b29f0621e', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'yjieguo', 'yjieguo', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('32545e398eea7bf89791cc78dd16ab12', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'yhnum', 'yhnum', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('3331f86002c128555443d8e7b79c70d2', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('334ffa2aec9300ff712a1f3f3143a4cd', NULL, '2021-01-08 16:29:02', NULL, NULL, '4af57d343f1d6521b71b85097b580786', 'bx_gg_moeny', 'bx_gg_moeny', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('34c933903ddf6ba5bad588d913c487c5', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'gift_4', 'gift_4', 'String', NULL, 13, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('350be7312c299482acfe44fb086f91c1', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'sales_5', 'sales_5', 'String', NULL, 15, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('35c224f8acfb063af6828b31e31f3967', NULL, '2020-12-04 16:53:38', NULL, NULL, '28e0b01cc3e2b0d361107661527bfdff', 'percent', 'percent', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('35d9204189dd1d1f142a7587f89ab46c', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'email', 'email', 'String', NULL, 18, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('37868bf0bad09f6d2084340e0b05333d', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'sf4', 'sf4', 'String', NULL, 18, 0, NULL, 'ttype', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('38b2955e0ef75d384d0d9ff8417e4945', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'sf3', 'sf3', 'String', NULL, 17, 0, NULL, 'ttype', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('39878a3df0fe2cafc481469b8eb71ea5', NULL, '2021-02-02 19:13:46', NULL, NULL, '1338756341933543425', 'sex', 'sex', 'String', NULL, 10, 0, NULL, 'sex', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('3c2a8313af79dbecba4c5687b65a66ab', 'admin', '2021-04-01 03:09:23', NULL, NULL, '1289140698221678593', 'cnum', 'cnum', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('3c71c10a0d27796808cb201e30024fe8', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'school', 'school', 'String', NULL, 14, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('3c7597c1efa73ca9400cdc36a9a48e23', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'gift_1', 'gift_1', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('3cd9d09176d10d3225e4fe86b4538739', NULL, '2020-12-17 16:59:12', NULL, NULL, '7911bd189c2d53e182693bd599a315a2', 'type', 'type', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('3d0f4b223f7ada50a7363235ae39e675', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'hnum', 'hnum', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('3ec76a981ff5353d4a65052963166477', NULL, '2020-12-17 17:13:21', NULL, NULL, '9b75c161322e0b7e29b3ffc84239a72c', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('3f5a04060285392287f4e7f6d59988c6', NULL, '2020-08-03 09:55:46', NULL, NULL, '6011955e58d89040fca52e7f962d0bf4', 'tdata', 'tdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('3f7ce1ee2ad20770e64016384f2c1cd5', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'homephone', 'homephone', NULL, NULL, 17, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('42225abb0677e51111a8e9e7b001332c', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'yjine', 'yjine', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('445c1d5a76a45fb0137425d1a51be6d7', NULL, '2021-01-08 16:10:28', NULL, NULL, '4dc208eb92fd1a84ef7b4723251e3e51', 'main_income', 'main_income', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('450316da5f9b7d8505944e16f1284a38', NULL, '2021-01-08 16:10:28', NULL, NULL, '7b20679054449c554cde856ef24126ab', 'monty', 'monty', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('467edbfc6ca934a7a4d600391ed0fb75', NULL, '2021-01-08 16:29:02', NULL, NULL, '4af57d343f1d6521b71b85097b580786', 'bx_jj_yongjin', 'bx_jj_yongjin', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('468acf3a75a559a283e8f424db3ac4a8', NULL, '2020-12-04 16:53:38', NULL, NULL, '28e0b01cc3e2b0d361107661527bfdff', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('46a4074647a27aaee0e5263d5f6bcf5a', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'tp', 'tp', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('46f68d27013cff9b09c5d059c79fbf28', NULL, '2021-02-02 19:10:15', NULL, NULL, '9b7d28336b01f9a6b1a613957c3d7cda', 'gtime', '雇佣时间', 'date', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('472e430a024d9648a7ab8a125419b161', NULL, '2021-01-05 15:09:15', NULL, NULL, '2324fac242b35938678a05bbbba345e2', 'cprice', 'cprice', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('48b03a60cab1f280d4b304da6b27dae2', NULL, '2021-01-05 15:09:15', NULL, NULL, '2324fac242b35938678a05bbbba345e2', 'ctime', 'ctime', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('4942cc4d04ac7330799ecc3fec48ac8b', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'id_card', 'id_card', 'String', NULL, 12, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('49def4afc641cb52775ff03fdba3007a', NULL, '2021-01-08 16:10:28', NULL, NULL, '7b20679054449c554cde856ef24126ab', 'his_lowest', 'his_lowest', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('49fa04e98f2ed62966d7f6141611dd7e', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'children', 'children', NULL, NULL, 24, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('49febadfe1eb3a59bfbe802d506aa590', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'data', 'data', NULL, NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('4b9e347c71a67de7a7a466b07109a101', NULL, '2020-07-21 15:17:10', NULL, NULL, 'c9bdb6b7ac68accfecb366718bf78f79', 'zhaiyao', 'zhaiyao', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('4d782de2bf10be3a79f04e8841053f00', NULL, '2021-01-08 10:47:52', NULL, NULL, 'f7649b77cfc9e0a9dacdac370cd4036b', 'pingjia', 'pingjia', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('4d7dd94ecf26b5fa69f9a1f811583340', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'address', 'address', 'String', NULL, 16, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('502a0a66b4dbf8689ed36e56ab272c2f', NULL, '2021-02-02 19:10:15', NULL, NULL, '9b7d28336b01f9a6b1a613957c3d7cda', 'birth', '出生日期', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('52444b20f2fcdfe43461a5a49079e4dc', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'health', 'health', 'String', NULL, 11, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537477711047733248', 'admin', '2021-04-01 05:54:42', NULL, NULL, '537477711022567424', 'id', 'id', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537477711056121856', 'admin', '2021-04-01 05:54:42', NULL, NULL, '537477711022567424', 'name', 'name', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537477711064510464', 'admin', '2021-04-01 05:54:42', NULL, NULL, '537477711022567424', 'gtime', 'gtime', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537477711072899072', 'admin', '2021-04-01 05:54:42', NULL, NULL, '537477711022567424', 'update_by', 'update_by', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537477711077093376', 'admin', '2021-04-01 05:54:42', NULL, NULL, '537477711022567424', 'jphone', 'jphone', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537477711085481984', 'admin', '2021-04-01 05:54:42', NULL, NULL, '537477711022567424', 'birth', 'birth', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537477711093870592', 'admin', '2021-04-01 05:54:42', NULL, NULL, '537477711022567424', 'hukou', 'hukou', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537477711102259200', 'admin', '2021-04-01 05:54:42', NULL, NULL, '537477711022567424', 'laddress', 'laddress', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537477711106453504', 'admin', '2021-04-01 05:54:42', NULL, NULL, '537477711022567424', 'jperson', 'jperson', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537477711110647808', 'admin', '2021-04-01 05:54:42', NULL, NULL, '537477711022567424', 'sex', 'sex', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478337303457792', 'admin', '2021-04-01 05:54:37', NULL, NULL, '537478337278291968', 'id', 'id', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478337320235008', 'admin', '2021-04-01 05:54:37', NULL, NULL, '537478337278291968', 'create_by', 'create_by', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478337328623616', 'admin', '2021-04-01 05:54:37', NULL, NULL, '537478337278291968', 'create_time', 'create_time', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478337332817920', 'admin', '2021-04-01 05:54:37', NULL, NULL, '537478337278291968', 'update_by', 'update_by', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478337341206528', 'admin', '2021-04-01 05:54:37', NULL, NULL, '537478337278291968', 'update_time', 'update_time', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478337349595136', 'admin', '2021-04-01 05:54:37', NULL, NULL, '537478337278291968', 'data_table', 'data_table', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478337353789440', 'admin', '2021-04-01 05:54:37', NULL, NULL, '537478337278291968', 'data_id', 'data_id', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478337362178048', 'admin', '2021-04-01 05:54:37', NULL, NULL, '537478337278291968', 'data_content', 'data_content', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478337370566656', 'admin', '2021-04-01 05:54:37', NULL, NULL, '537478337278291968', 'data_version', 'data_version', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478337378955264', 'admin', '2021-04-01 05:54:37', NULL, NULL, '537478337278291968', 'rownum_', 'rownum_', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478706330906624', 'admin', '2021-04-01 05:56:44', NULL, NULL, '537478706314129408', 'id', 'id', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478706343489536', 'admin', '2021-04-01 05:56:44', NULL, NULL, '537478706314129408', 'cname', 'cname', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478706351878144', 'admin', '2021-04-01 05:56:44', NULL, NULL, '537478706314129408', 'cnum', 'cnum', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478706356072448', 'admin', '2021-04-01 05:56:44', NULL, NULL, '537478706314129408', 'cprice', 'cprice', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478706360266752', 'admin', '2021-04-01 05:56:44', NULL, NULL, '537478706314129408', 'ctotal', 'ctotal', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478706368655360', 'admin', '2021-04-01 05:56:44', NULL, NULL, '537478706314129408', 'tp', 'tp', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478706377043968', 'admin', '2021-04-01 05:56:44', NULL, NULL, '537478706314129408', 'dtotal', 'dtotal', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478706381238272', 'admin', '2021-04-01 05:56:44', NULL, NULL, '537478706314129408', 'ztotal', 'ztotal', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('537478706389626880', 'admin', '2021-04-01 05:56:44', NULL, NULL, '537478706314129408', 'd_id', 'd_id', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('538563757aa1a49935824ce14568f27c', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'archivesdi', 'archivesdi', NULL, NULL, 34, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('53bb8b7ef4c8d8dc9b151f07929fb587', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'xinghao', 'xinghao', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('5406c33ff49384c2bcad5b85a9701355', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'province', 'province', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('558e3bb304d51582f225ec1d911cb4b8', NULL, '2021-01-05 15:09:15', NULL, NULL, '2324fac242b35938678a05bbbba345e2', 'id', 'id', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('5648f5a00640e3adf57fb9bbf27269f4', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'tm', 'tm', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('56749103eb4a60e7046dea34453b439e', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'shao', 'shao', 'String', NULL, 13, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('57ee0e6ffe7135a943dde2408d424c97', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'proportion_1', 'proportion_1', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('589a5a4fe61fc71aa1bf45d3bd73974b', NULL, '2020-12-17 19:50:14', NULL, NULL, 'fb70a91730f087f8023afd88d24f9697', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('5a88459afcf01cc20ac5a50322b35fd6', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'hukounum', 'hukounum', NULL, NULL, 26, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('5b7f7bebf0c3951b891026e7c2ac90cb', NULL, '2020-08-03 09:55:46', NULL, NULL, '6011955e58d89040fca52e7f962d0bf4', 'didian', 'didian', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('5bc99af9cfddd240794167a6765a1517', NULL, '2021-01-08 16:29:02', NULL, NULL, '4af57d343f1d6521b71b85097b580786', 'neikong_zx_money', 'neikong_zx_money', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('5bf6aee0bd8f676a218e0210e9e6fa0e', NULL, '2020-12-17 16:59:12', NULL, NULL, '7911bd189c2d53e182693bd599a315a2', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('5cf4a1ca15691d6340e522e1831dc3ac', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'sales_6', 'sales_6', 'String', NULL, 18, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('5e4e8b7531a88f4db1a0d133de159494', NULL, '2020-08-03 09:55:46', NULL, NULL, '6011955e58d89040fca52e7f962d0bf4', 'num', 'num', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('6020e457162b86b75a2d335999ab06ec', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'nation', 'nation', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('631632bc2243018788d11d4f8348bfd2', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'socialsecurity', 'socialsecurity', NULL, NULL, 30, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('6394ea45a090ca79cfbfdbbfe2016d95', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'yprice', 'yprice', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('64ff8b4e61a58a0ca3e34108c9bd97c0', NULL, '2021-01-08 16:29:02', NULL, NULL, 'a543d8dd40f4d26839b78bd604be659e', 'bx_gg_moeny', 'bx_gg_moeny', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('665f13c7fcebac6c35c894d885c4b344', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'proportion_6', 'proportion_6', 'String', NULL, 20, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('677bf4d6400fc465067b0d5bd6ad2a58', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'gift_2', 'gift_2', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('6a3544cc8c028e94692bb1b448620ec2', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'yname', 'yname', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('6b2db5f824af08166e5074feea82ab52', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'sex', 'sex', 'String', NULL, 2, 0, NULL, 'sex', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('6c2b1c9e4cfd3f6b79d0fb26fea72cec', NULL, '2020-08-03 09:55:46', NULL, NULL, '6011955e58d89040fca52e7f962d0bf4', 'zhaiyao', 'zhaiyao', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('6c8250304aa25753f64c6f4723e6d2d8', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'fahuocangku', 'fahuocangku', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('6d4b24ab2f685556d6161a86658329c8', NULL, '2021-01-21 16:25:09', NULL, NULL, 'd4a29dfda94357308faf62be2b94db08', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('6dae70a5323b3d517c8f13278f0e1d5f', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'proportion_5', 'proportion_5', 'String', NULL, 17, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('6ec41a06e2dee9ec8f07a894ddcaaae5', NULL, '2021-02-02 19:10:15', NULL, NULL, '9b7d28336b01f9a6b1a613957c3d7cda', 'jphone', 'jphone', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('70abaf24c413f38ff6a3c315ad8824b2', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'height', 'height', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('710104c3e0541602a151d5e00fc2ee29', NULL, '2020-12-17 16:42:21', NULL, NULL, '654609e4247a0469e0b2befbc69b00f9', 'type', 'type', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('718a062a1e42276c1913c7d7836b1bee', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'hobby', 'hobby', NULL, NULL, 32, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('71cb567cd27fda05d55d80324c7b59e1', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'del_flag', 'del_flag', 'String', NULL, 32, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('729c2d2c70da0f3bc092f4aab4432244', NULL, '2020-12-17 16:42:21', NULL, NULL, '654609e4247a0469e0b2befbc69b00f9', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('732c8b168ade2e34974c9db6396df61f', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'type', 'type', 'String', NULL, 12, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('742954cf518d8026db68cc87c017ad2a', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'bz', 'bz', 'String', NULL, 19, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('765d95a760a36d0c853bec639af85302', NULL, '2021-01-05 15:09:15', NULL, NULL, '2324fac242b35938678a05bbbba345e2', 'bianma', 'bianma', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('768fb670937ab4aadde39842df36bfd3', 'admin', '2021-04-01 03:09:23', NULL, NULL, '1289140698221678593', 'cprice', 'cprice', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('796408f2959fc40edd9b460a1a5bdfb8', NULL, '2021-02-02 19:13:46', NULL, NULL, '1338756341933543425', 'gtime', '雇佣日期', 'date', NULL, 3, 1, 2, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('79f29ea3b1c7ec966077941fdd004e4d', NULL, '2021-01-08 16:29:02', NULL, NULL, 'a543d8dd40f4d26839b78bd604be659e', 'bx_zx_money', 'bx_zx_money', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('7b794ecee6f61f64839eb1094a7c20bb', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'region', 'region', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('7c2c06cc52978c4e5665deac1784535d', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'yren', 'yren', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('7df83cf21e083451a47f2f731a225a7e', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'num', 'num', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('7e564f212697079394030ac0563df496', NULL, '2020-06-16 18:14:25', NULL, NULL, 'e4cec9ff15bc0ea42f536a442a6d1335', 'id', 'id', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('7f5570e3056d82210d7d4e79b861560c', NULL, '2021-02-02 19:10:15', NULL, NULL, '9b7d28336b01f9a6b1a613957c3d7cda', 'laddress', 'laddress', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('80017f23232ea91ae32e4718eb10e8c3', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'proportion_4', 'proportion_4', 'String', NULL, 14, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('80b5e3fd550d9be1a8c8ea69a2a593f8', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'birth', 'birth', NULL, NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('81dea8f0ccba2b3530038ebcf92b36b1', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'name', 'name', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('81f2de244fa1e6b5f28419f60c4db169', NULL, '2020-06-16 18:14:25', NULL, NULL, 'e4cec9ff15bc0ea42f536a442a6d1335', 'bnum', 'bnum', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('824a22cf80849d110e04fd5c573f40de', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'jphone', 'jphone', 'String', NULL, 17, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('83da395758d9bca23b2c5b9f54e79eed', NULL, '2021-01-21 16:25:09', NULL, NULL, 'd4a29dfda94357308faf62be2b94db08', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('84391d55c9bd4185c4abbc0d9a8a3f9b', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'native_place', 'native_place', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('85263a305fba4c7e7a991ed3b416e006', NULL, '2020-12-17 16:42:21', NULL, NULL, '654609e4247a0469e0b2befbc69b00f9', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('865ca077977b78934e5e82e733ef4e47', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'major', 'major', 'String', NULL, 15, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('8749d00c6c3cf873841a227a5206478a', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'sales_1', 'sales_1', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('87f43f4f5220c34a95d55ff3fa9de0c1', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'health', 'health', NULL, NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('8875e4280c1a62759ec4b3719b5f9566', NULL, '2021-01-08 10:47:52', NULL, NULL, 'bbc5d5ab143d59f0beab484682361aa5', 'lingdao', 'lingdao', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('88b19703dac5a5ae8c01c68101cd8b5b', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'cbz', 'cbz', 'String', NULL, 14, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('89bd5c1f5b37b82ab2d56d8c9e50a674', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'sex', 'sex', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('8a122291db744a6109a93af5d289787f', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'computer_level', 'computer_level', 'String', NULL, 22, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('8ab8d51dfb792cdc767e68d7e9370f3d', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'num', 'num', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('8bfc84f6d610581d736fcccc5f04a863', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'scard', 'scard', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('8d186f249df9e1c1c549fbdc6a0a4d77', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'currentdi', 'currentdi', NULL, NULL, 28, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('8db810062e3a19eb83fca651691b848e', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'sales_2', 'sales_2', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('8e39d42a7fad183fe75ce1a56f148db1', 'admin', '2021-04-01 03:09:23', NULL, NULL, '1289140698221678593', 'bianma', 'bianma', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('8fb12c3929ea745f94cc4a90df9d5181', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'idcard', 'idcard', NULL, NULL, 21, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9168272dc8fa019a861f11b81bea1dc2', NULL, '2021-01-08 16:29:02', NULL, NULL, 'a543d8dd40f4d26839b78bd604be659e', 'bx_jj_yongjin', 'bx_jj_yongjin', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9238ae757fb73c0ef546d7e0e91aa662', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 's_id', 's_id', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9282683fd000d19b205ad6841f0f7b6e', NULL, '2021-01-08 16:29:02', NULL, NULL, '4af57d343f1d6521b71b85097b580786', 'total', 'total', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('92da818568d6c8e1e499abf51e439870', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'lzr', 'lzr', 'String', NULL, 18, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('94fc5c2791e2e218383864b80095c89c', NULL, '2021-02-02 19:10:15', NULL, NULL, '9b7d28336b01f9a6b1a613957c3d7cda', 'id', 'id', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('95486ef4c7e0f3f3ac4ce249b1c761a1', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'id', 'id', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('95650b0335c6981bf0d657e11b1b2082', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'hysr', 'hysr', 'String', NULL, 11, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9a5f78c12595cb66d3b630962f7cd7bf', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'sf1', 'sf1', 'String', NULL, 15, 0, NULL, 'ttype', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9b77e74bed080cbd798d223bb0177c5d', NULL, '2020-07-21 15:17:10', NULL, NULL, 'c9bdb6b7ac68accfecb366718bf78f79', 'didian', 'didian', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9bb9b5329f79564ec030694a639ffd7f', NULL, '2021-01-08 16:29:02', NULL, NULL, '4af57d343f1d6521b71b85097b580786', 'bx_zx_money', 'bx_zx_money', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9bf1e9bc4e887eb0816365262d0e9c8e', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'zhekoulv', 'zhekoulv', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9d3986d3a32e9b4672dc2b29174749f3', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'rk', 'rk', 'String', NULL, 13, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9d6a3a8b9cf5c659e7d752028b70da8b', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'sf2', 'sf2', 'String', NULL, 16, 0, NULL, 'ttype', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9d9b437037bb304f5def5b97d4c2b4c4', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'zhuzhi', 'zhuzhi', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9ddf87596d6701eda383c3d8d7853b2b', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'education', 'education', 'String', NULL, 13, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9e28f1951ea83b6e6dae4e3892baea90', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'positional_titles', 'positional_titles', 'String', NULL, 25, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('9f15fef9efd35f5a5c1418ce5a6eceb0', NULL, '2021-02-02 19:13:46', NULL, NULL, '1338756341933543425', 'birth', '出生日期', 'datetime', NULL, 6, 1, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a15e649faa93fbae15a66f5266bd9336', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'phone', 'phone', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a17a61990a30e0cfbe4c7169dafcd85d', NULL, '2020-07-21 15:17:10', NULL, NULL, 'c9bdb6b7ac68accfecb366718bf78f79', 'id', 'id', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a1b7ffeb00d30e7c0a1a1f466dd1fe06', NULL, '2020-12-04 16:53:38', NULL, NULL, '28e0b01cc3e2b0d361107661527bfdff', 'key2', 'key2', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a200ec7a67ded4302744ee7e4e156d13', NULL, '2021-01-08 16:10:28', NULL, NULL, '4dc208eb92fd1a84ef7b4723251e3e51', 'monty', 'monty', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a2e680c356e712b43343d589539da011', NULL, '2021-01-08 10:47:52', NULL, NULL, 'f7649b77cfc9e0a9dacdac370cd4036b', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a379ebc1ac4dd2d567eee55c403ab2a3', NULL, '2020-07-21 15:17:10', NULL, NULL, 'c9bdb6b7ac68accfecb366718bf78f79', 'gname', 'gname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a42eed89da67da0653650edcc1576f8c', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'currentnum', 'currentnum', NULL, NULL, 29, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a93ce07361b9d6ec02a58cf7f6b94664', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'political', 'political', NULL, NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a949c4beac3fec79e96309a6d2d8f5bb', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'entrytime', 'entrytime', NULL, NULL, 19, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a97ee04d3e745b3be9ee48cb16fdb419', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'birth', 'birth', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a9c7c96a412537b4da3df68ff8e93cc8', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'post', 'post', NULL, NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('a9e4bf3b458d821307e0749f6e119f8d', NULL, '2021-01-08 16:10:28', NULL, NULL, '4dc208eb92fd1a84ef7b4723251e3e51', 'total', 'total', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('aa26aca6685baef7b24189214866f370', NULL, '2021-01-21 18:00:57', NULL, NULL, '60b3feffadc55eb49baa5a48fdf1ff0e', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ab0aabf8cc08327a4510420bd553e6c0', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'providentfund', 'providentfund', NULL, NULL, 31, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ab4ee4418e54c4a4fef3c14ad8e98fa5', NULL, '2021-01-08 16:29:02', NULL, NULL, 'a543d8dd40f4d26839b78bd604be659e', 'neikong_zx_money', 'neikong_zx_money', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ad0b3d410c53378134428afb1b063758', NULL, '2021-01-08 16:10:28', NULL, NULL, '4dc208eb92fd1a84ef7b4723251e3e51', 'his_average', 'his_average', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ad146af051ba273a480223d49f59358b', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'hukoustreet', 'hukoustreet', NULL, NULL, 25, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ad1d1fe2ee182c2d3a263a127fea041e', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'proportion_2', 'proportion_2', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ad2cc52cc14e9aabc04ac79d9a10b530', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'ldate', 'ldate', 'String', NULL, 19, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ae5ec6e56478a098b36587e93b1d8908', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'arrival_time', 'arrival_time', 'String', NULL, 24, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('aee0188ab2bf9849607f6ef34b36713e', NULL, '2020-12-17 17:13:21', NULL, NULL, '9b75c161322e0b7e29b3ffc84239a72c', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('aee106a24b11b0f8ca10bc88b62189d7', NULL, '2020-08-03 09:55:46', NULL, NULL, '6011955e58d89040fca52e7f962d0bf4', 'gdata', 'gdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('aee31ce5eb6271601bc4e6f8affaceb0', NULL, '2020-06-16 18:14:25', NULL, NULL, 'e4cec9ff15bc0ea42f536a442a6d1335', 'hezairen', 'hezairen', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b14588abed341d314a08d316dfde553f', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'work_experience', 'work_experience', 'String', NULL, 27, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b1de05c2d02cdde59c1e2a93e45964f9', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'create_time', 'create_time', 'String', NULL, 29, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b2176d9680c08a7aa040aec9f71ff236', NULL, '2021-02-02 19:13:46', NULL, NULL, '1338756341933543425', 'id', 'id', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b279ab8f7d20ebbeec67f5bf2109ba22', NULL, '2021-01-08 16:10:28', NULL, NULL, '7b20679054449c554cde856ef24126ab', 'his_average', 'his_average', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b2c01550c60da7b1babf36d8535fcaed', NULL, '2021-01-08 10:47:52', NULL, NULL, 'bbc5d5ab143d59f0beab484682361aa5', 'shijian', 'shijian', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b3c98ed9cb9e4a234273aa4921efd545', NULL, '2020-06-16 18:14:25', NULL, NULL, 'e4cec9ff15bc0ea42f536a442a6d1335', 'jpnum', 'jpnum', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b450669f376fa9f075ac403c7d7f2ee9', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'proportion_3', 'proportion_3', 'String', NULL, 11, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b46d80bfe53372b6ff92a6f8e8bf38df', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'hukoudi', 'hukoudi', NULL, NULL, 27, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b5afa6c7c63f649460d4d45b7d697098', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'zip_code', 'zip_code', 'String', NULL, 17, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b5df568754994e67a15a8f5b8d4bc297', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'phone', 'phone', 'String', NULL, 19, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b60fbeff0c77080cb73aa6aaf6dd8715', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'danjia', 'danjia', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b6884ea117811c5161ff1eb11502cf19', NULL, '2020-07-21 15:17:10', NULL, NULL, 'c9bdb6b7ac68accfecb366718bf78f79', 'num', 'num', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b81d3a495af538759aa6dbaf752c48db', NULL, '2020-12-04 16:53:38', NULL, NULL, '28e0b01cc3e2b0d361107661527bfdff', 'key6', 'key6', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b863f83ac64327d86f36c8796a00f777', NULL, '2020-06-16 18:14:25', NULL, NULL, 'e4cec9ff15bc0ea42f536a442a6d1335', 'jieshu', 'jieshu', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('b8aafd56ddcf6902909722c7d2529797', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'department', 'department', NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ba83ad8a89105b198aa49798f2940c29', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'foreign_language', 'foreign_language', 'String', NULL, 20, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('bb8db85fed8034645c5517b6283addc7', NULL, '2020-12-04 16:53:38', NULL, NULL, '28e0b01cc3e2b0d361107661527bfdff', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('bd09800edb1343880b05b65974875597', NULL, '2020-07-21 15:17:10', NULL, NULL, 'c9bdb6b7ac68accfecb366718bf78f79', 'tdata', 'tdata', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('bef01b3169ec05f63c9f92245b61bedf', NULL, '2021-02-02 19:13:46', NULL, NULL, '1338756341933543425', 'jperson', 'jperson', NULL, NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c17be48ad3705f848acdb28cbe3bc1b7', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'hname', 'hname', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c1913cffe0a0a65b8f76ef280af93038', NULL, '2021-01-08 16:29:02', NULL, NULL, '4af57d343f1d6521b71b85097b580786', 'tb_zx_money', 'tb_zx_money', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c2b7ed56f87bc4cb95c8e1e0300e51ff', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'ytotal', 'ytotal', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c357b23ae68c0ee6c9dab322507dce0b', NULL, '2021-01-11 14:38:14', NULL, NULL, '1317006713165049858', 'jdate', 'jdate', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c3b0443ebecc7152343c5ea3ef32a38f', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'graduation_time', 'graduation_time', 'String', NULL, 23, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c3d8cd6e68c605fd6d6ac217fed5c8d4', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'weight', 'weight', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c3fe8f62ea0c6ce9990bfa22dc0265b6', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'major', 'major', NULL, NULL, 13, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c40fe2cf7a74a6e96575f73ef5e7d205', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'nation', 'nation', NULL, NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c4d6132699dcdff382c93ab10d64551a', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'education_experience', 'education_experience', 'String', NULL, 26, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c578969584d9b639d249bcd981bc5a08', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'ydate', 'ydate', 'String', NULL, 9, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c57bd36c25b13a8149268496e54052ae', NULL, '2020-12-17 19:50:14', NULL, NULL, 'fb70a91730f087f8023afd88d24f9697', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c5a801ff78f2ca6b1b7a03b3222fdd61', NULL, '2021-01-08 16:29:02', NULL, NULL, '4af57d343f1d6521b71b85097b580786', 'biz_income', 'biz_income', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c6144f2ca7422a71e951abea1bce6aaf', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'education', 'education', NULL, NULL, 12, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c6820a1e3308badb60582998805a0645', NULL, '2020-06-16 18:14:25', NULL, NULL, 'e4cec9ff15bc0ea42f536a442a6d1335', 'shihelv', 'shihelv', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c74ee42894f54c0ebc1a64a79395aa06', NULL, '2020-12-04 16:53:38', NULL, NULL, '28e0b01cc3e2b0d361107661527bfdff', 'key3', 'key3', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c8d1276d19bdd946e9fc18b83aacda15', 'admin', '2021-04-01 03:09:23', NULL, NULL, '1289140698221678593', 'cname', 'cname', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c904e40b35f065cbefd0b22fd5937b38', NULL, '2021-01-21 18:00:57', NULL, NULL, '60b3feffadc55eb49baa5a48fdf1ff0e', 'description', 'description', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('c98a41c7d5edcba47273e192b9d66b9b', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'beizhu', 'beizhu', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('cb99a516d392d1efb87141ec42168aa9', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'card', 'card', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('cc91f43bf975f056944b5ec19266ec9c', NULL, '2020-12-17 16:59:12', NULL, NULL, '7911bd189c2d53e182693bd599a315a2', 'value', 'value', 'String', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ce81562be14047bcbc29c0a66782fc42', NULL, '2021-01-21 17:07:16', NULL, NULL, '6a1d22ca4c95e8fab655d3ceed43a84d', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('cec893b2241134ba9b03ed6d4edf2919', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'marital', 'marital', NULL, NULL, 23, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('cf9d32fea2f67e4b11cd2823dbbefbad', NULL, '2020-08-03 09:55:46', NULL, NULL, '6011955e58d89040fca52e7f962d0bf4', 'id', 'id', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('d076942aecee8f5197b66eb382ba1995', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'sbtype', 'sbtype', NULL, NULL, 33, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('d1d67bf8aea628bba4d28dfede489d55', NULL, '2021-01-08 16:10:28', NULL, NULL, '4dc208eb92fd1a84ef7b4723251e3e51', 'his_highest', 'his_highest', 'String', NULL, 6, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('d3ef9876d3c56889157747be606f70fc', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'gift_6', 'gift_6', 'String', NULL, 19, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('d5b7b92023a2fb09fed9d36a4ac7b3e3', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'sales_z', 'sales_z', 'String', NULL, 21, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('d6accb7bb835271d1284d8a3dc394c1f', NULL, '2020-07-28 17:46:58', NULL, NULL, '22f025b781ee9fe4746438621e82674f', 'danwei', 'danwei', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('da9d0a2565cea7578415076a4d8e6c4c', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'sdate', 'sdate', 'String', NULL, 12, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('db503c31de99f35cbcb1f66a69f9964c', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'mailbox', 'mailbox', NULL, NULL, 15, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('dbc452a77ba1449096852d21c2959f34', NULL, '2021-02-02 19:13:46', NULL, NULL, '1338756341933543425', 'hukou', 'hukou', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('dd5697ec6eddcca16cca47080e9b801d', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'sld', 'sld', 'String', NULL, 15, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('dd56fbd98db5c1cda9dd77637ba1c7e6', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'create_by', 'create_by', 'String', NULL, 28, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ddcf7ade58e0a8a520b44fc94e0602bb', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'sk', 'sk', 'String', NULL, 20, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('dfbc8bba6261dcd4ceb3da5f517a0d58', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'school', 'school', NULL, NULL, 20, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('e1c77285c7ca39ebee455895ed081245', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'nation', 'nation', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('e1fffff7030dd37d70d7b5a138046fac', NULL, '2020-12-04 16:53:38', NULL, NULL, '28e0b01cc3e2b0d361107661527bfdff', 'key5', 'key5', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('e28cc14c4e1bc2c889f04a6cf30f9196', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'cbr', 'cbr', 'String', NULL, 14, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('e52e7896193ad09d700599d2ef6fa8ae', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'knum', 'knum', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('e757987004087de43f1ccab14092361f', NULL, '2020-07-17 10:49:42', NULL, NULL, 'e0fe1d693625c906c1171d7de706a47c', 'yishe', 'yishe', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('e7f6104183a7b2408f72b91f4638e9e2', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'gift_3', 'gift_3', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('e8c0f052d6bca9045fdb6197b197a92d', NULL, '2021-02-02 19:13:46', NULL, NULL, '1338756341933543425', 'update_by', 'update_by', 'String', NULL, 4, 0, NULL, 'zhiwu', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ea6018bdbd9fb192b1d3f9e832b5d382', NULL, '2021-02-02 19:10:15', NULL, NULL, '9b7d28336b01f9a6b1a613957c3d7cda', 'name', '姓名', 'string', NULL, 2, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ec6c6f56c64de5f4de16166000f31d19', NULL, '2020-06-16 18:14:25', NULL, NULL, 'e4cec9ff15bc0ea42f536a442a6d1335', 'ftime', 'ftime', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ef685270770a69bddb4f24e37eed9dc0', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'office', 'office', NULL, NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('efe17d82b5daaa3f95364e9afaeffd1c', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'register', 'register', NULL, NULL, 11, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('efe4e0110a61d9791e18308aed422aa7', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'name', 'name', NULL, NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f0a83c77c0448a9f7c8c0bc3c7f42f13', NULL, '2021-02-02 19:23:18', NULL, NULL, '94bcd8202bc6bc467efd0d679dadd7bb', 'qfjg', 'qfjg', 'String', NULL, 10, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f110f1f947e0f895b552f7edd133a60a', 'admin', '2021-04-01 03:09:23', NULL, NULL, '1289140698221678593', 'ctotal', 'ctotal', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f11af753ccbf495818e9c23c1b083ae2', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'foreign_language_level', 'foreign_language_level', 'String', NULL, 21, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f1905f7a175f8e56afd8f6c2969582e6', NULL, '2021-01-06 11:43:35', NULL, NULL, '1334390762455965697', 'gift_5', 'gift_5', 'String', NULL, 16, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f192c538d9cb0dc88e537b11a37551c8', NULL, '2021-01-08 16:10:28', NULL, NULL, '4dc208eb92fd1a84ef7b4723251e3e51', 'his_lowest', 'his_lowest', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f31715d024bad06ea8862ba383e87f5b', NULL, '2021-01-05 15:09:15', NULL, NULL, '2324fac242b35938678a05bbbba345e2', 'cnum', 'cnum', 'String', NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f3b4e31c7ff6a365c4130cbc695e2621', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'num', 'num', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f430837a3f4c08f425bcd1de46d3a2d3', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'sex', 'sex', NULL, NULL, 5, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f53143608c570f9886861442be87b5ff', NULL, '2021-02-02 19:10:15', NULL, NULL, '9b7d28336b01f9a6b1a613957c3d7cda', 'update_by', '职务', 'String', NULL, 4, 1, 3, 'zhiwu', NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f82904af04e557b12dcfe3562900597c', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'gdata', 'gdata', NULL, NULL, 14, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f9154d882408b868253ed8fb87879220', NULL, '2021-02-02 19:30:23', NULL, NULL, '629609c4d540cb4675e9064af8955296', 'name', 'name', 'String', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f95dd09a118b93cc7884b12118448ed4', NULL, '2021-02-02 19:10:15', NULL, NULL, '9b7d28336b01f9a6b1a613957c3d7cda', 'hukou', 'hukou', 'String', NULL, 7, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f978117e8eda0daee2c00223f9df4b48', NULL, '2021-01-13 11:59:53', NULL, NULL, '1316997232402231298', 'update_time', 'update_time', 'String', NULL, 31, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('f984ef26fe0a505b279a0e4a3b27201f', NULL, '2021-01-08 10:47:52', NULL, NULL, 'f7649b77cfc9e0a9dacdac370cd4036b', 'shijian', 'shijian', 'String', NULL, 4, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('fa6fce04eaee2480faa8a14393ffe15a', NULL, '2021-01-08 16:29:02', NULL, NULL, 'a543d8dd40f4d26839b78bd604be659e', 'total', 'total', 'String', NULL, 8, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('fac871f69237c6c25abe8c4332eabcbf', NULL, '2021-01-08 10:47:52', NULL, NULL, 'f7649b77cfc9e0a9dacdac370cd4036b', 'lingdao', 'lingdao', 'String', NULL, 3, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('fc07c053ed0ecbfcc45041640acf6cb1', NULL, '2021-01-05 15:33:07', NULL, NULL, '1316987047604514817', 'party', 'party', NULL, NULL, 22, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('fe3b1449ce346836f47234ca65949aea', NULL, '2020-06-16 18:14:25', NULL, NULL, 'e4cec9ff15bc0ea42f536a442a6d1335', 'sfkong', 'sfkong', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_field` VALUES ('ffb5fbe81d2cf48ca45a815c676fd9eb', NULL, '2020-06-16 18:14:25', NULL, NULL, 'e4cec9ff15bc0ea42f536a442a6d1335', 'kaishi', 'kaishi', 'string', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for jimu_report_db_param
-- ----------------------------
DROP TABLE IF EXISTS `jimu_report_db_param`;
CREATE TABLE `jimu_report_db_param`  (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `jimu_report_head_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '动态报表ID',
  `param_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '参数字段',
  `param_txt` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '参数文本',
  `param_value` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '参数默认值',
  `order_num` int(11) NULL DEFAULT NULL COMMENT '排序',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `search_flag` int(1) NULL DEFAULT NULL COMMENT '查询标识0否1是 默认0',
  `widget_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询控件类型',
  `search_mode` int(1) NULL DEFAULT NULL COMMENT '查询模式1简单2范围',
  `dict_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字典',
  `search_format` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询时间格式化表达式',
  `ext_json` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '参数配置',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_jrdp_jimu_report_head_id`(`jimu_report_head_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jimu_report_db_param
-- ----------------------------
INSERT INTO `jimu_report_db_param` VALUES ('078d99565feef91904c84b42b43f5174', '1273495682564534273', 'id', 'id', '1', 1, NULL, '2020-08-03 09:55:26', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('0d91170e4546cdbebbc3e9cc7879ce79', '22f025b781ee9fe4746438621e82674f', 'id', 'id', '1', 1, NULL, '2020-07-21 15:31:51', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('1324279360203526146', '1324279359998005250', 'pageSize', 'pageSize', '10', 2, NULL, '2020-08-03 15:19:54', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('1324279360220303361', '1324279359998005250', 'pageNo', 'pageNo', '1', 1, NULL, '2020-08-03 15:19:54', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('143f8c164072ddbdeafec5c5b1466827', '1272858455908073473', 'id', 'id', '1', 1, NULL, '2020-07-21 15:31:51', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('173c869cc45b683a9cfe25826110cead', '1272834687525482497', 'id', 'id', '1', 1, NULL, '2020-08-03 09:57:08', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('1805eb351a966dc3c039b5239b6faa49', '1291310198925840385', 'sex', 'sex', '男', 2, NULL, '2020-06-08 15:21:09', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('256eb2f8582ce4d74559b1fc1e2917ca', '1291310198925840385', 'id', 'id', '111', 1, NULL, '2020-06-08 15:21:09', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('3957799c20fcc696d680cca9649897bb', 'e4cec9ff15bc0ea42f536a442a6d1335', 'id', 'id', '1', 1, NULL, '2020-08-03 09:57:08', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('3a9efc51a6b6723d5a0ddf109aacb2b5', '1288038655293661186', 'pageNo', 'pageNo', '1', 1, 'admin', '2021-04-01 03:09:40', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('3ced36c7a2cce40c667cc485bf59cd11', '1291217511962902530', 'pageSize', 'pageSize', '10', 2, NULL, '2020-08-03 15:19:54', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('49bd3f212cd6c406c8584e6bb0d9cf93', '1291549569390243841', 'pageSize', 'pageSize', '10', 2, NULL, '2020-07-30 17:26:29', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('52db6da75ea733ae741c62cc54c85d92', '6011955e58d89040fca52e7f962d0bf4', 'id', 'id', '1', 1, NULL, '2020-08-03 09:55:46', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('57165a6fe5f2b700d4ef19518de4defd', '1290104038414721025', 'id', 'id', '1', 1, NULL, '2020-08-03 09:55:46', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('7569e95c1fa73d5438aceb19c1b85ef0', '1288038655293661186', 'pageSize', 'pageSize', '20', 2, 'admin', '2021-04-01 03:09:40', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('7d7765754aadaddab91bf1257447ae73', '1291549569390243841', 'pageNo', 'pageNo', '1', 1, NULL, '2020-07-30 17:26:29', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('8bff26e0c3fe48ddd41cf8d939ad4f2c', '2324fac242b35938678a05bbbba345e2', 'pageSize', 'pageSize', '10', 2, NULL, '2020-08-03 15:19:54', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('90b22a058cc331146b548bc93f09b5cd', '1289140698221678593', 'pageSize', 'pageSize', '20', 2, 'admin', '2021-04-01 03:09:23', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('944eaee4cb7639a435aadbf2ad7469a0', '2324fac242b35938678a05bbbba345e2', 'pageNo', 'pageNo', '1', 1, NULL, '2020-08-03 15:19:54', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('a29c10ed01c6608e899e1368f2d5d7e3', '1316997232402231298', 'id', 'id', '1', 1, NULL, '2021-01-13 14:31:13', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('a803707f3383dd9f4685fadc7efa07f4', '1224643501392728065', 'sex', 'sex', '男', 2, NULL, '2020-06-08 15:21:09', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('b7c34e8a3c2804715825af4bdbcf857a', '1224643501392728065', 'id', 'id', '111', 1, NULL, '2020-06-08 15:21:09', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('d8010a4ffbe567e6117e7f59641aeb7c', '1289140698221678593', 'pageNo', 'pageNo', '1', 1, 'admin', '2021-04-01 03:09:23', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('d9d94d6b09dd074f39af96d7a4696f9a', '1291217511962902530', 'pageNo', 'pageNo', '1', 1, NULL, '2020-08-03 15:19:54', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `jimu_report_db_param` VALUES ('ec09a8b27e7e9ec9dbc683fc5a38faec', 'c9bdb6b7ac68accfecb366718bf78f79', 'id', 'id', '1', 1, NULL, '2020-08-03 09:55:26', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for jimu_report_link
-- ----------------------------
DROP TABLE IF EXISTS `jimu_report_link`;
CREATE TABLE `jimu_report_link`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键id',
  `report_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '积木设计器id',
  `parameter` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '参数',
  `eject_type` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '弹出方式（0 当前页面 1 新窗口）',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '链接名称',
  `api_method` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求方法0-get,1-post',
  `link_type` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '链接方式(0 网络报表 1 网络连接 2 图表联动)',
  `api_url` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外网api',
  `link_chart_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联动图表的ID',
  `requirement` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条件',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `uniq_link_reportid`(`report_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '超链接配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for jimu_report_map
-- ----------------------------
DROP TABLE IF EXISTS `jimu_report_map`;
CREATE TABLE `jimu_report_map`  (
  `id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `label` varchar(125) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地图名称',
  `name` varchar(125) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地图编码',
  `data` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '地图数据',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `del_flag` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '0表示未删除,1表示删除',
  `sys_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uniq_jmreport_map_name`(`name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '地图配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for jimu_report_share
-- ----------------------------
DROP TABLE IF EXISTS `jimu_report_share`;
CREATE TABLE `jimu_report_share`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `report_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '在线excel设计器id',
  `preview_url` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预览地址',
  `preview_lock` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密码锁',
  `last_update_time` datetime NULL DEFAULT NULL COMMENT '最后更新时间',
  `term_of_validity` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '有效期(0:永久有效，1:1天，2:7天)',
  `status` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否过期(0未过期，1已过期)',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '积木报表预览权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for joa_demo
-- ----------------------------
DROP TABLE IF EXISTS `joa_demo`;
CREATE TABLE `joa_demo`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ID',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请假人',
  `days` int(11) NULL DEFAULT NULL COMMENT '请假天数',
  `begin_date` datetime NULL DEFAULT NULL COMMENT '开始时间',
  `end_date` datetime NULL DEFAULT NULL COMMENT '请假结束时间',
  `reason` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请假原因',
  `bpm_status` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1' COMMENT '流程状态',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人id',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人id'
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '流程测试' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for onl_auth_data
-- ----------------------------
DROP TABLE IF EXISTS `onl_auth_data`;
CREATE TABLE `onl_auth_data`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `cgform_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'online表ID',
  `rule_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则名',
  `rule_column` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则列',
  `rule_operator` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则条件 大于小于like',
  `rule_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则值',
  `status` int(1) NULL DEFAULT NULL COMMENT '1有效 0无效',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for onl_auth_page
-- ----------------------------
DROP TABLE IF EXISTS `onl_auth_page`;
CREATE TABLE `onl_auth_page`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT ' 主键',
  `cgform_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'online表id',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字段名/按钮编码',
  `type` int(1) NULL DEFAULT NULL COMMENT '1字段 2按钮',
  `control` int(1) NULL DEFAULT NULL COMMENT '3可编辑 5可见(仅支持两种状态值3,5)',
  `page` int(1) NULL DEFAULT NULL COMMENT '3列表 5表单(仅支持两种状态值3,5)',
  `status` int(1) NULL DEFAULT NULL COMMENT '1有效 0无效',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for onl_auth_relation
-- ----------------------------
DROP TABLE IF EXISTS `onl_auth_relation`;
CREATE TABLE `onl_auth_relation`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `role_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '角色id',
  `auth_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限id',
  `type` int(1) NULL DEFAULT NULL COMMENT '1字段 2按钮 3数据权限',
  `cgform_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'online表单ID',
  `auth_mode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '授权方式role角色，depart部门，user人',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for onl_cgform_button
-- ----------------------------
DROP TABLE IF EXISTS `onl_cgform_button`;
CREATE TABLE `onl_cgform_button`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `BUTTON_CODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '按钮编码',
  `BUTTON_ICON` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '按钮图标',
  `BUTTON_NAME` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '按钮名称',
  `BUTTON_STATUS` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '按钮状态',
  `BUTTON_STYLE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '按钮样式',
  `EXP` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '表达式',
  `CGFORM_HEAD_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '表单ID',
  `OPT_TYPE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '按钮类型',
  `ORDER_NUM` int(11) NULL DEFAULT NULL COMMENT '排序',
  `OPT_POSITION` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '按钮位置1侧面 2底部',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `idx_ocb_CGFORM_HEAD_ID`(`CGFORM_HEAD_ID`) USING BTREE,
  INDEX `idx_ocb_BUTTON_CODE`(`BUTTON_CODE`) USING BTREE,
  INDEX `idx_ocb_BUTTON_STATUS`(`BUTTON_STATUS`) USING BTREE,
  INDEX `idx_ocb_ORDER_NUM`(`ORDER_NUM`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'Online表单自定义按钮' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of onl_cgform_button
-- ----------------------------
INSERT INTO `onl_cgform_button` VALUES ('108a564643763de3f4c81bc2deb463df', 'bt1', NULL, '激活', '1', 'button', NULL, '05a3a30dada7411c9109306aa4117068', 'js', NULL, '2');
INSERT INTO `onl_cgform_button` VALUES ('7c140322fb6b1da7a5daed8b6edc0fb7', 'tjbpm', NULL, '提交流程', '1', 'link', NULL, '05a3a30dada7411c9109306aa4117068', 'js', NULL, '2');
INSERT INTO `onl_cgform_button` VALUES ('a45bc1c6fba96be6b0c91ffcdd6b54aa', 'genereate_person_config', 'icon-edit', '生成配置', '1', 'link', NULL, 'e2faf977fdaf4b25a524f58c2441a51c', 'js', NULL, '2');
INSERT INTO `onl_cgform_button` VALUES ('cc1d12de57a1a41d3986ed6d13e3ac11', '链接按钮测试', 'icon-edit', '自定义link', '1', 'link', NULL, 'd35109c3632c4952a19ecc094943dd71', 'js', NULL, '2');
INSERT INTO `onl_cgform_button` VALUES ('e2a339b9fdb4091bee98408c233ab36d', 'zuofei', NULL, '作废', '1', 'form', NULL, '05a3a30dada7411c9109306aa4117068', 'js', NULL, '2');
INSERT INTO `onl_cgform_button` VALUES ('ebcc48ef0bde4433a6faf940a5e170c1', 'button按钮测试', 'icon-edit', '自定义button', '1', 'button', NULL, 'd35109c3632c4952a19ecc094943dd71', 'js', NULL, '2');

-- ----------------------------
-- Table structure for onl_cgform_enhance_java
-- ----------------------------
DROP TABLE IF EXISTS `onl_cgform_enhance_java`;
CREATE TABLE `onl_cgform_enhance_java`  (
  `ID` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `BUTTON_CODE` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '按钮编码',
  `CG_JAVA_TYPE` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '类型',
  `CG_JAVA_VALUE` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '数值',
  `CGFORM_HEAD_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表单ID',
  `ACTIVE_STATUS` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1' COMMENT '生效状态',
  `EVENT` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'end' COMMENT '事件状态(end:结束，start:开始)',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `idx_ejava_cgform_head_id`(`CGFORM_HEAD_ID`) USING BTREE,
  INDEX `idx_ocej_BUTTON_CODE`(`BUTTON_CODE`) USING BTREE,
  INDEX `idx_ocej_ACTIVE_STATUS`(`ACTIVE_STATUS`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for onl_cgform_enhance_js
-- ----------------------------
DROP TABLE IF EXISTS `onl_cgform_enhance_js`;
CREATE TABLE `onl_cgform_enhance_js`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `CG_JS` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'JS增强内容',
  `CG_JS_TYPE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型',
  `CONTENT` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `CGFORM_HEAD_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '表单ID',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `idx_ejs_cgform_head_id`(`CGFORM_HEAD_ID`) USING BTREE,
  INDEX `idx_ejs_cg_js_type`(`CG_JS_TYPE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of onl_cgform_enhance_js
-- ----------------------------
INSERT INTO `onl_cgform_enhance_js` VALUES ('0b326acbbc8e52c9c9ecdb19342fc3cf', 'show(){\n   console.log(\'form\',that)\n   //this.form.setFieldsValue({\"name\":\"name值\"})  \n  that.$nextTick(() => {\n           //age是对应表的字段名\n            that.form.setFieldsValue({\"age\":\"999\"})\n          });\n}\n\nonlChange(){\n   return {\n     \n     sex(){\n        let value = event.value\n        //alert(\'触发控件\',value)\n        \n         //性别改动，年龄归零\n        if(value!=null && value!=\"\"){   \n          let values = {\'age\':0}\n          that.triggleChangeValues(values)\n        }\n      }\n     \n    }\n }\n', 'form', NULL, '05a3a30dada7411c9109306aa4117068');
INSERT INTO `onl_cgform_enhance_js` VALUES ('274b5d741a0262d3411958f0c465c5f0', 'genereate_person_config(row){\nconsole.log(\'选择\',row)\nalert(row.name + \'，个人积分配置生成成功！\');\n}', 'list', NULL, 'e2faf977fdaf4b25a524f58c2441a51c');
INSERT INTO `onl_cgform_enhance_js` VALUES ('2cbaf25f1edb620bea2d8de07f8233a1', 'air_china_post_materiel_item_onlChange(){\n    return {\n        wl_name(){\n           \n            let id = event.row.id\n            let cnum = event.row.num\n            let value = event.value\n            let targrt = event.target\n            let columnKey = event.column.key\n           let nval = 200*cnum\n           console.log(\'row\',event.row);\n           console.log(\'cnum\',cnum);\n           let otherValues = {\'jifen\': nval}\n              \n                that.triggleChangeValues(targrt,id,otherValues)\n\n        }\n    }\n}', 'form', NULL, 'e67d26b610dd414c884c4dbb24e71ce3');
INSERT INTO `onl_cgform_enhance_js` VALUES ('32e7b7373abe0fb9c4dd608b4517f814', '', 'form', NULL, '53a3e82b54b946c2b904f605875a275c');
INSERT INTO `onl_cgform_enhance_js` VALUES ('35d4ef464e5e8c87c9aa82ea89215fc1', '', 'list', NULL, 'e67d26b610dd414c884c4dbb24e71ce3');
INSERT INTO `onl_cgform_enhance_js` VALUES ('44cad4eec436328ed3cc134855f8d1d5', ' onlChange(){\n   return {\n    name(that, event) {\n      that.executeMainFillRule()\n    }\n  }\n }', 'form', NULL, '4adec929a6594108bef5b35ee9966e9f');
INSERT INTO `onl_cgform_enhance_js` VALUES ('4569bc0e6126d2b8a0e0c69b9a47e8db', '', 'list', NULL, '56efb74326e74064b60933f6f8af30ea');
INSERT INTO `onl_cgform_enhance_js` VALUES ('6dd82d8eac166627302230a809233481', 'ces_order_goods_onlChange(){\n    return {\n        num(){\n           \n            let id = event.row.id\n            let num = event.row.num\n            let price = event.row.price\n\n            let targrt = event.target\n            \n            let nval = price*num\n            console.log(\'row\',event.row);\n            console.log(\'num\',num);\n            console.log(\'that\',that);\n            let otherValues = {\'zong_price\': nval}\n              \n            that.triggleChangeValues(otherValues,id,targrt)\n   \n\n        }\n    }\n}', 'form', NULL, '56efb74326e74064b60933f6f8af30ea');
INSERT INTO `onl_cgform_enhance_js` VALUES ('85e7acd772c8ec322b97a1fd548007e0', '', 'form', NULL, '09fd28e4b7184c1a9668496a5c496450');
INSERT INTO `onl_cgform_enhance_js` VALUES ('8b76f282ddc81ce99a129e90fdd977ce', '', 'form', NULL, '86bf17839a904636b7ed96201b2fa6ea');
INSERT INTO `onl_cgform_enhance_js` VALUES ('90394fbc3d48978cc0937bc56f2d5370', '', 'list', NULL, 'deea5a8ec619460c9245ba85dbc59e80');
INSERT INTO `onl_cgform_enhance_js` VALUES ('ae9cf52fbe13cc718de2de6e1b3d6792', '', 'list', NULL, '18f064d1ef424c93ba7a16148851664f');
INSERT INTO `onl_cgform_enhance_js` VALUES ('beec235f0b2d633ff3a6c395affdf59d', '', 'list', NULL, '4adec929a6594108bef5b35ee9966e9f');
INSERT INTO `onl_cgform_enhance_js` VALUES ('c5ac9a2b2fd92ef68274f630b8aec78a', 'tjbpm(row){\n  alert(\'提交流程\')\n  console.log(\'row\',row)\n}\n\nbt1(){\n   console.log(\'that.table.selectionRows\',that.table.selectionRows)\n   console.log(\'that.table.selectedRowKeys\',that.table.selectedRowKeys)\n   console.log(\'that.table.dataSource\',that.table.dataSource)\n   alert(\'激活全部数据\')\n}', 'list', NULL, '05a3a30dada7411c9109306aa4117068');
INSERT INTO `onl_cgform_enhance_js` VALUES ('d7ddb7aa407f6deed75aac11f0a25f0e', '222', 'list', NULL, '09fd28e4b7184c1a9668496a5c496450');
INSERT INTO `onl_cgform_enhance_js` VALUES ('f6f8f230566d09d4b66338955ffb5691', '', 'form', NULL, '18f064d1ef424c93ba7a16148851664f');
INSERT INTO `onl_cgform_enhance_js` VALUES ('fd711738f58d5481ca0ce9bc3a415223', '', 'list', NULL, '86bf17839a904636b7ed96201b2fa6ea');

-- ----------------------------
-- Table structure for onl_cgform_enhance_sql
-- ----------------------------
DROP TABLE IF EXISTS `onl_cgform_enhance_sql`;
CREATE TABLE `onl_cgform_enhance_sql`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `BUTTON_CODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '按钮编码',
  `CGB_SQL` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'SQL内容',
  `CGB_SQL_NAME` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'Sql名称',
  `CONTENT` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `CGFORM_HEAD_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '表单ID',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `idx_oces_CGFORM_HEAD_ID`(`CGFORM_HEAD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of onl_cgform_enhance_sql
-- ----------------------------
INSERT INTO `onl_cgform_enhance_sql` VALUES ('0ebf418bd02f486342123eaf84cd39ad', 'add', '', NULL, '', '18f064d1ef424c93ba7a16148851664f');
INSERT INTO `onl_cgform_enhance_sql` VALUES ('5ab418a13fd0bbf30ee9dd04203f3c28', 'add', '', NULL, '', '4adec929a6594108bef5b35ee9966e9f');
INSERT INTO `onl_cgform_enhance_sql` VALUES ('8750b93ba5332460c76c492359d7a06b', 'edit', '', NULL, '', '18f064d1ef424c93ba7a16148851664f');
INSERT INTO `onl_cgform_enhance_sql` VALUES ('c1ba45b6ee70e4662b5ec95f8fdcb31f', 'add', '', NULL, '', '05a3a30dada7411c9109306aa4117068');
INSERT INTO `onl_cgform_enhance_sql` VALUES ('edfab059050b19328ac81e6833b5ebc2', 'delete', '', NULL, '', '18f064d1ef424c93ba7a16148851664f');

-- ----------------------------
-- Table structure for onl_cgform_field
-- ----------------------------
DROP TABLE IF EXISTS `onl_cgform_field`;
CREATE TABLE `onl_cgform_field`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `cgform_head_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表ID',
  `db_field_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字段名字',
  `db_field_txt` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段备注',
  `db_field_name_old` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '原字段名',
  `db_is_key` tinyint(1) NULL DEFAULT NULL COMMENT '是否主键 0否 1是',
  `db_is_null` tinyint(1) NULL DEFAULT NULL COMMENT '是否允许为空0否 1是',
  `db_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '数据库字段类型',
  `db_length` int(11) NOT NULL COMMENT '数据库字段长度',
  `db_point_length` int(11) NULL DEFAULT NULL COMMENT '小数点',
  `db_default_val` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '表字段默认值',
  `dict_field` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字典code',
  `dict_table` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字典表',
  `dict_text` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字典Text',
  `field_show_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '表单控件类型',
  `field_href` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '跳转URL',
  `field_length` int(11) NULL DEFAULT NULL COMMENT '表单控件长度',
  `field_valid_type` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '表单字段校验规则',
  `field_must_input` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段是否必填',
  `field_extend_json` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展参数JSON',
  `field_default_value` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '控件默认值，不同的表达式展示不同的结果。\r\n1. 纯字符串直接赋给默认值；\r\n2. #{普通变量}；\r\n3. {{ 动态JS表达式 }}；\r\n4. ${填值规则编码}；\r\n填值规则表达式只允许存在一个，且不能和其他规则混用。',
  `is_query` tinyint(1) NULL DEFAULT NULL COMMENT '是否查询条件0否 1是',
  `is_show_form` tinyint(1) NULL DEFAULT NULL COMMENT '表单是否显示0否 1是',
  `is_show_list` tinyint(1) NULL DEFAULT NULL COMMENT '列表是否显示0否 1是',
  `is_read_only` tinyint(1) NULL DEFAULT 0 COMMENT '是否是只读（1是 0否）',
  `query_mode` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询模式',
  `main_table` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '外键主表名',
  `main_field` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '外键主键字段',
  `order_num` int(11) NULL DEFAULT NULL COMMENT '排序',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `converter` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '自定义值转换器',
  `query_def_val` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询默认值',
  `query_dict_text` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询配置字典text',
  `query_dict_field` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询配置字典code',
  `query_dict_table` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询配置字典table',
  `query_show_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询显示控件',
  `query_config_flag` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否启用查询配置1是0否',
  `query_valid_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询字段校验类型',
  `query_must_input` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询字段是否必填1是0否',
  `sort_flag` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否支持排序1是0否',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_ocf_cgform_head_id`(`cgform_head_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of onl_cgform_field
-- ----------------------------
INSERT INTO `onl_cgform_field` VALUES ('0021c969dc23a9150d6f70a13b52e73e', '402860816aa5921f016aa5921f480000', 'begin_date', '开始时间', 'begin_date', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 4, 'admin', '2019-05-11 15:31:54', '2019-05-11 14:26:19', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('020c1622c3df0aef30185f57874f6959', '79091e8277c744158530321513119c68', 'bpm_status', '流程状态', NULL, 0, 1, 'string', 32, 0, '1', 'bpm_status', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 1, 0, 'single', '', '', 8, 'admin', '2019-05-11 15:29:47', '2019-05-11 15:29:26', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('02b20e692456403e2fed1a89a06833b4', '402860816bff91c0016bff91d2810005', 'phone', '联系方式', 'phone', 0, 1, 'string', 20, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 8, 'admin', '2019-07-19 18:05:55', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('02b4ee2612d569cd187877eea6559e87', '402881e6760269a20176026a22e70001', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 5, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('03668009f0ad92b20abb1a377197ee47', 'deea5a8ec619460c9245ba85dbc59e80', 'order_fk_id', '订单外键ID', NULL, 0, 0, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', 'test_order_main', 'id', 10, 'admin', '2020-05-03 01:01:18', '2019-04-20 11:42:53', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('03709092184fdf4a66b0cdb4dd10a159', '402860816bff91c0016bffa220a9000b', 'bpm_status', '流程状态', NULL, 0, 1, 'string', 32, 0, '1', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 46, 'admin', '2019-07-22 16:15:32', '2019-07-19 15:34:44', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('03988419d751a330c2b0f0519a531880', '997ee931515a4620bc30a9c1246429a9', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2020-05-03 00:57:44', '2020-05-03 00:56:56', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('03c105d2706c8286416833684de67406', '79091e8277c744158530321513119c68', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2019-05-11 15:29:47', '2019-05-11 15:27:17', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('03fd5ab69f331ff760c3f7d86b4a93f8', '4028318169e81b970169e81b97650000', 'log_content', '日志内容', 'log_content', 0, 1, 'string', 1000, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 3, NULL, NULL, '2019-04-04 19:28:36', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('045eb432c418b2b103b1e1b8e8a8a75d', 'fb7125a344a649b990c12949945cb6c1', 'age', '年龄', NULL, 0, 1, 'int', 32, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', NULL, NULL, NULL, '2019-03-26 19:24:11', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('04e4185a503e6aaaa31c243829ff4ac7', 'd35109c3632c4952a19ecc094943dd71', 'birthday', '生日', NULL, 0, 1, 'Date', 32, 0, '', '', '', '', 'date', '', 120, '', '0', '', '', 1, 1, 1, 0, 'single', '', '', 10, 'admin', '2021-08-18 15:53:31', '2019-03-15 14:24:35', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('04ff134cb4aae845059e10b3b85f1451', '7ea60a25fa27470e9080d6a921aabbd1', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, NULL, NULL, '2019-04-17 00:22:21', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('051dd70c504c97a028daab2af261ea35', '1acb6f81a1d9439da6cc4e868617b565', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2019-06-10 14:47:14', '2019-04-23 22:58:19', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('052dcc6f34976b66754fd99415bd22ce', '79091e8277c744158530321513119c68', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2019-05-11 15:29:47', '2019-05-11 15:27:17', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('054db05394e83b318f097a60bc044134', '402860816bff91c0016bffa220a9000b', 'residence_address', '户籍地址', 'residence_address', 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 28, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('05dbdd8d9f0f84c8504faa6f24c7d4ac', '402880eb71d61d3d0171d61d3de30000', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 9, 'admin', '2020-05-03 00:54:16', '2020-05-02 23:59:33', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('05ed6a78a2e9d0c82bfa2c55898570b8', '997ee931515a4620bc30a9c1246429a9', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 1, 'single', '', '', 1, 'admin', '2020-05-03 00:57:44', '2020-05-03 00:56:56', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0604945c206e867644e9a44b4c9b20c6', 'fb19fb067cd841f9ae93d4eb3b883dc0', '2', '4', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 5, NULL, NULL, '2019-03-23 11:39:48', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0617de6d735b37a3f80f2f35ad5d1511', '4028839a6de2ebd3016de2ebd3870000', 'size_type', '尺码类型', 'size_type', 0, 1, 'string', 2, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 13, NULL, NULL, '2019-10-19 15:29:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0619dfc3fbf9e193534bb3460a1a9d92', 'cb2d8534a2f544bc9c618dd49da66336', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 1, 'single', '', '', 1, 'admin', '2020-02-24 17:22:42', '2020-02-24 15:15:13', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('06a1badae6119abf4ec48858a3e94e1c', '402860816bff91c0016bffa220a9000b', 'sys_org_code', '组织机构编码', 'sys_org_code', 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 43, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('06be12d850f7cb3261111e35c2622f5c', 'b493c5fd4fa64a3a84e74ee171763e37', 'dd', 'dd', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, NULL, NULL, '2021-06-07 18:13:37', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('06f1cfff58395ff62526b894f6182641', 'e67d26b610dd414c884c4dbb24e71ce3', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2019-04-24 11:03:32', '2019-04-24 11:02:57', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('07a307972076a392ffc61b11437f89dd', '402860816bff91c0016bff91c0cb0000', 'create_time', '创建时间', 'create_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 13, 'admin', '2019-07-19 18:09:01', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('07f4776fd641389a8c98a85713990dce', '402860816bff91c0016bff91c0cb0000', 'update_by', '更新人', 'update_by', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 14, 'admin', '2019-07-19 18:09:01', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('08a3353c11efd5f062c3076d0554b5c5', '402881e6760269a20176026d25650002', 'salary_money', '工资', 'salary_money', 0, 1, 'BigDecimal', 10, 3, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'single', NULL, NULL, 5, NULL, NULL, '2020-11-26 10:41:17', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('08f002095da7c1886c86648fcec38ca9', '56efb74326e74064b60933f6f8af30ea', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2020-07-10 16:53:27', '2020-05-08 23:45:32', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('09450359eb90b40d224ec43588a62f9e', '402860816bff91c0016bff91c0cb0000', 'user_id', '用户ID', 'user_id', 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 3, 'admin', '2019-07-19 18:09:01', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0a1208184216d9f5defa41d08040a8fd', 'a2ca0c7297a8491ca849fc1a06c9efbf', 'sex', 'sex', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'list', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, 'admin', '2021-01-24 14:39:35', '2021-01-24 14:38:58', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0a453a63e33654aa1b9ee2affa854a6d', '4fb8e12a697f4d5bbe9b9fb1e9009486', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2020-11-26 17:28:14', '2020-04-10 19:47:01', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0a4cdcb7e54f614ab952024f6c72bb6d', 'beee191324fd40c1afec4fda18bd9d47', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2019-04-13 13:41:13', '2019-04-13 13:40:56', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0aad6fa0bf0965a6be1df8aa6005afb4', 'feea98637c2144caae7c5d56a815a245', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, NULL, NULL, '2021-10-27 10:24:24', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0acfc27e493c204f72d42b6dc00a2ded', '53a3e82b54b946c2b904f605875a275c', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2020-05-08 23:42:51', '2020-05-07 22:49:47', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0adc06d9b497684bcbb5a781e044517c', '1acb6f81a1d9439da6cc4e868617b565', 'supplier', '供应商', NULL, 0, 1, 'string', 32, 0, '', 'air_china_ supplier', '', '', 'list', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 15, 'admin', '2019-06-10 14:47:14', '2019-04-24 16:52:00', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0ae4bc5d4921aa240d814e018ddb7779', '56efb74326e74064b60933f6f8af30ea', 'money', '订单总额', NULL, 0, 1, 'double', 10, 3, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 9, 'admin', '2020-07-10 16:53:27', '2020-05-08 23:45:32', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0b3e833ac4aae3a13ec2f8ae460708f8', '4028839a6de2ebd3016de2ebd3870000', 'no', '预算表序号', 'no', 0, 1, 'string', 50, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 8, NULL, NULL, '2019-10-19 15:29:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0b63bd30b8646901310d8d0374df5587', '18f064d1ef424c93ba7a16148851664f', 'fuwenb', '富文本', NULL, 0, 1, 'Text', 0, 0, '', '', '', '', 'umeditor', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 17, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0ba1bf74e2a6a94a7a63010ec7230706', '402860816bff91c0016bffa220a9000b', 'update_time', '更新时间', 'update_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 42, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0bd10d416252bdc6b169056d2a1a4a68', '402880e5721355dd01721355dd390000', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 3, NULL, NULL, '2020-05-14 21:18:14', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0bf9c178173bd86eec4144b819cfac0b', '18f064d1ef424c93ba7a16148851664f', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0c34ebfe2e2a619d42db13f93d2a2d40', 'b81de38db24047b497d476516f8a0865', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, NULL, NULL, '2020-02-24 14:56:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0cba94f0497d4d3d829fc573f58eff9f', '402860816bff91c0016bffa220a9000b', 'graduation_time', '毕业时间', 'graduation_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 16, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0cbc49f419e3545613d0b2eb9c025eae', '402881e6760269a20176026a22e70001', 'fuwenb', '富文本', NULL, 0, 1, 'Text', 0, 0, '', '', '', '', 'umeditor', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 17, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0d00c51a4ddad2598a587fadc968a8b2', '402860816bff91c0016bff91cfea0004', 'sys_org_code', '组织机构编码', 'sys_org_code', 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 13, 'admin', '2019-07-19 18:05:13', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0ddd0c0afc967a9ab6050401ca62a4be', 'e67d26b610dd414c884c4dbb24e71ce3', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2019-04-24 11:03:32', '2019-04-24 11:02:57', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('0e157503e648653836a602f5bbad4e83', '402881e6760269a201760269a2af0000', 'files', '文件', NULL, 0, 1, 'string', 1000, 0, '', '', '', '', 'file', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 15, NULL, NULL, '2020-11-26 10:37:26', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0e5fb96c3f5a37c758eb7f5d1322694f', '402880e5721355dd01721355dd390000', 'good_name', '商品名字', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 7, NULL, NULL, '2020-05-14 21:18:14', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0e6952db23d5a578ab74344a299c2322', '18f064d1ef424c93ba7a16148851664f', 'birthday', '时间', NULL, 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 13, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0f4c07621dcd465f7954b4297962db9b', '18f064d1ef424c93ba7a16148851664f', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('0fb6fa76c5c78a1e957dbb411e110738', '402860816bff91c0016bff91d8830007', 'politically_status', '政治面貌', 'politically_status', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 7, 'admin', '2019-07-19 18:04:41', '2019-07-17 18:54:37', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('101a73df0aa5199ac05c4ce92a4f0e3e', '4adec929a6594108bef5b35ee9966e9f', 'name', '姓名', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '#{sysUserCode}', 0, 1, 1, 0, 'single', '', '', 3, 'admin', '2020-04-10 19:43:38', '2020-04-10 19:35:58', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('105be0f7d827a0324216cf8af268fb9e', '09fd28e4b7184c1a9668496a5c496450', 'birthday', '客户生日', NULL, 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 9, 'admin', '2020-05-14 21:19:21', '2020-05-08 23:51:49', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('105c8e44ad13026b641f0363601f30f3', 'e5464aa8fa7b47c580e91593cf9b46dc', 'num', '循环数量', NULL, 0, 1, 'int', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 9, 'admin', '2019-04-24 17:09:49', '2019-04-24 11:05:10', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('105e112bddec9cc23e853b9c68af1b05', '18f064d1ef424c93ba7a16148851664f', 'radio', 'radio', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'radio', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 9, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('10b78ee7954f230117689a226c44c0db', '402880e570a5d7000170a5d700f50000', 'descc', '描述', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 11, NULL, NULL, '2020-03-04 21:58:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('1130f1e252533529bb1167b896dffe32', 'deea5a8ec619460c9245ba85dbc59e80', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2020-05-03 01:01:18', '2019-04-20 11:41:19', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('117fc4ba649d6690a3ac482ad5e4ad38', '56870166aba54ebfacb20ba6c770bd73', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2021-08-18 20:22:58', '2019-04-20 11:38:39', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('12aa08f8e948e2b60b40a7b6429c866b', '56efb74326e74064b60933f6f8af30ea', 'order_code', '订单编码', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '${shop_order_num}', 0, 1, 1, 1, 'single', '', '', 7, 'admin', '2020-07-10 16:53:27', '2020-05-08 23:45:32', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('13246645b7650491b70205d99703ca06', '402860816aa5921f016aa5dedcb90009', 'bpm_status', '流程状态', 'bpm_status', 0, 1, 'string', 32, 0, '1', 'bpm_status', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 1, 0, 'group', '', '', 8, 'admin', '2019-05-11 15:56:47', '2019-05-11 15:50:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('135dd0ee50712722db65b8762bd487ea', '8994f2817b5a45d9890aa04497a317c5', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 4, NULL, NULL, '2019-03-23 11:39:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('13d9c22ba0a4f09111d115022a148d23', '09fd28e4b7184c1a9668496a5c496450', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2020-05-14 21:19:21', '2020-05-08 23:51:49', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('14b7e6161d1f908e13026439af302a66', '3b5e18da618247539481816995b6bf9f', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2020-07-11 11:27:29', '2020-07-11 11:27:17', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('14ec4c83c29966ab42b6b718c5a3e774', '7ea60a25fa27470e9080d6a921aabbd1', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, NULL, NULL, '2019-04-17 00:22:21', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('154ba4ca5328866010e042086ffc2b81', '56efb74326e74064b60933f6f8af30ea', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 1, 'single', '', '', 1, 'admin', '2020-07-10 16:53:27', '2020-05-08 23:45:32', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('16363d0bc125125e395772278d0cf22e', '4b556f0168f64976a3d20bfb932bc798', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, NULL, NULL, '2019-04-12 23:38:28', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('168426cf1016cf0b99705ae1c4c8591e', '402880e5721355dd01721355dd390000', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 1, 'single', NULL, NULL, 1, NULL, NULL, '2020-05-14 21:18:14', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('16918ac159cb6313fec1dea7ac4bd0a0', '402880eb71d52dc30171d52dc3a10000', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 10, NULL, NULL, '2020-05-02 19:37:58', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('169318fa19cf5acf77c58a98c2d5a6bf', '18f064d1ef424c93ba7a16148851664f', 'remakr', 'markdown', NULL, 0, 1, 'Text', 0, 0, '', '', '', '', 'markdown', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 16, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('179c290e383009810fb738f07bd5af8d', '402860816bff91c0016bff91d2810005', 'id', 'id', 'id', 1, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'group', '', '', 1, 'admin', '2019-07-19 18:05:55', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('17cbda69da9dd3632625a0647c259070', '73162c3b8161413e8ecdca7eb288d0c9', 'wl_name', '物料名字', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '1', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2019-07-01 14:23:32', '2019-06-10 15:18:34', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('182d038554a6ee7ddfd07763aaa10686', '53a3e82b54b946c2b904f605875a275c', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2020-05-08 23:42:51', '2020-05-07 22:49:47', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('18fefb2257901f05508f8ec13ada78a3', 'e5464aa8fa7b47c580e91593cf9b46dc', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 1, 'admin', '2019-04-24 17:09:48', '2019-04-24 11:05:10', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('191705159cea35e8cbacb326f172be94', 'd35109c3632c4952a19ecc094943dd71', 'search_sel', '搜索下拉', NULL, 0, 1, 'string', 100, 0, '', 'role_code', 'sys_role', 'role_name', 'sel_search', '', 120, NULL, '0', '', '', 1, 1, 1, 0, 'single', '', '', 18, 'admin', '2021-08-18 15:53:31', '2020-11-26 18:02:20', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('1973ef1d3728fbff2db6a352e001f5f7', 'fb7125a344a649b990c12949945cb6c1', 'name', '用户名', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 5, 'admin', '2019-03-26 19:24:11', '2019-03-26 19:01:52', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('19a9bf071cf3aa3b2ef94344d2300616', '402881e6760269a20176026d25650002', 'create_by', '创建人', 'create_by', 0, 1, 'string', 32, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'single', NULL, NULL, 12, NULL, NULL, '2020-11-26 10:41:17', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('1ab5be1f937f393b3e5cc214ef1b855c', '7ea60a25fa27470e9080d6a921aabbd1', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, NULL, NULL, '2019-04-17 00:22:21', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('1b071c02de2830f9fe82a542b31cce7f', '3b5e18da618247539481816995b6bf9f', 'age', '年龄', NULL, 0, 1, 'int', 10, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, 'admin', '2020-07-11 11:27:29', '2020-07-11 11:27:17', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('1b6c7b95028bed9ff656d65557dd2bdf', '402860816bff91c0016bffa220a9000b', 'user_id', '用户id', 'user_id', 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 3, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('1c2f307e315bac77a6d3f02e88387a43', 'deea5a8ec619460c9245ba85dbc59e80', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 1, 'admin', '2020-05-03 01:01:18', '2019-04-20 11:41:19', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('1c3b2ad0a52ecb47fa7fd53f25875beb', 'deea5a8ec619460c9245ba85dbc59e80', 'price', '价格', NULL, 0, 1, 'double', 32, 0, '', '', '', '', 'text', '', 120, 'n', '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2020-05-03 01:01:18', '2019-04-20 11:41:19', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('1c4d25a12388c80d397bb4f4664fe4e6', '4b556f0168f64976a3d20bfb932bc798', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, NULL, NULL, '2019-04-12 23:38:28', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('1cfe967bb457cbaa6e041e45d019b583', '402860816bff91c0016bff91c7010001', 'update_time', '更新时间', 'update_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 10, 'admin', '2019-07-19 18:07:47', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('1d0037eba10efd76be45150479399a7e', '8d66ea41c7cc4ef9ab3aab9055657fc9', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, NULL, NULL, '2020-05-07 22:46:32', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('1d712db19506ee40b2c1ef5a611baf88', '53a3e82b54b946c2b904f605875a275c', 'name', '商品名字', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2020-05-08 23:42:51', '2020-05-07 22:49:47', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('1d95bdf1120c5a1776df022d0a571f21', '4fb8e12a697f4d5bbe9b9fb1e9009486', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 7, 'admin', '2020-11-26 17:28:14', '2020-04-10 19:47:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('1e37ae77c0d406d4ff3c5442ec63cd1f', '8d66ea41c7cc4ef9ab3aab9055657fc9', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, NULL, NULL, '2020-05-07 22:46:32', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('1e3d8cfbf12155559666a23ee2c6c5ca', 'e5464aa8fa7b47c580e91593cf9b46dc', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2019-04-24 17:09:49', '2019-04-24 11:05:10', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('1ed46fdeb289bd7805c9b83332ccd3b4', '402860816bff91c0016bff91d2810005', 'relation', '关系', 'relation', 0, 1, 'string', 20, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 4, 'admin', '2019-07-19 18:05:55', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('1eda61dece35abd76b8d8d49e1b139b8', '8d66ea41c7cc4ef9ab3aab9055657fc9', 'content', '描述', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, NULL, NULL, '2020-05-07 22:46:32', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('1f0c6d33b79713fe79fb30373c81f6f7', '758334cb1e7445e2822b60e807aec4a3', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, NULL, NULL, '2019-10-18 18:02:09', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('1fa5f07b3e70d4925b69b2bf51309421', '56870166aba54ebfacb20ba6c770bd73', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2021-08-18 20:22:58', '2019-04-20 11:38:39', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('209ddb923d8dab9f454d56d82c0cc725', '3d447fa919b64f6883a834036c14aa67', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2020-02-21 17:58:46', '2020-02-20 16:19:00', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('20ff34fb0466089cb633d73d5a6f08d6', 'd35109c3632c4952a19ecc094943dd71', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2021-08-18 15:53:31', '2019-03-15 14:24:35', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('2113a4ec7b88b4820dcbbdf96e46bbb7', 'fbc35f067da94a70adb622ddba259352', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, NULL, NULL, '2019-07-03 19:44:23', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2150e48b2cb6072d2d8ecd79a7daf7cc', '402860816bff91c0016bff91ca7e0002', 'create_time', '创建时间', 'create_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 10, 'admin', '2019-07-19 18:07:13', '2019-07-17 18:54:33', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2323239efb5a40b73034411868dfc41d', 'fb19fb067cd841f9ae93d4eb3b883dc0', 'update_by', '更新人登录名称', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 3, NULL, NULL, '2019-03-23 11:39:48', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('239448a05801af1b07232d30d8e610b1', '402881e6760269a20176026a22e70001', 'dep_sel', '选择部门', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'sel_depart', '', 120, NULL, '0', '', '#{sysOrgCode}', 0, 1, 1, 0, 'single', NULL, NULL, 19, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('23f42061ed218bdbc1262913c071e1cd', 'e5464aa8fa7b47c580e91593cf9b46dc', 'iz_valid', '启动状态', NULL, 0, 1, 'int', 2, 0, '', 'air_china_valid', '', '', 'list', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 12, 'admin', '2019-04-24 17:09:49', '2019-04-24 14:09:06', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('242cc59b23965a92161eca69ffdbf018', 'd35109c3632c4952a19ecc094943dd71', 'age', '年龄', NULL, 0, 1, 'int', 32, 0, '', '', '', '', 'text', 'http://www.baidu.com', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, 'admin', '2021-08-18 15:53:31', '2019-03-15 14:24:35', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('24588340313096179b9ec0b49f40bed3', '18f064d1ef424c93ba7a16148851664f', 'sel_mut', '下拉多选', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'list_multi', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 11, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('25d91ca4cdc3919c7557d23caf7ed6de', 'f9fb8bee1a64472889d077c757b9acc7', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2021-08-17 13:58:15', '2021-08-17 13:57:48', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('2640235b9638547f1776b930bd8c12b4', '997ee931515a4620bc30a9c1246429a9', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2020-05-03 00:57:44', '2020-05-03 00:56:56', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('265702edb8872e322fe72d3640e34ac5', '402860816bff91c0016bff91cfea0004', 'from_time', '开始日期', 'from_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 3, 'admin', '2019-07-19 18:05:13', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('26645f6f6eb2646033bad11e0402d7e4', '18f064d1ef424c93ba7a16148851664f', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('2739ab1ece4d6053ba931bb6572f4ed8', '4028839a6de2ebd3016de2ebd3870000', 'iz_valid', '启用状态', 'iz_valid', 0, 1, 'string', 2, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 9, NULL, NULL, '2019-10-19 15:29:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('273b0fd37640a9ef1614e987e2bc44a0', '8d66ea41c7cc4ef9ab3aab9055657fc9', 'pics', '图片', NULL, 0, 1, 'string', 500, 0, '', '', '', '', 'image', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 9, NULL, NULL, '2020-05-07 22:46:32', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('281ce0b5343cd42b28825d7df16422f1', 'b81de38db24047b497d476516f8a0865', 'vv', 'vv', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, NULL, NULL, '2020-02-24 14:56:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('283f42283b9d0bf3b95ba3384ab2d255', '758334cb1e7445e2822b60e807aec4a3', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, NULL, NULL, '2019-10-18 18:02:09', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('284864d99fddfdcb00e188e3a512cb28', '1acb6f81a1d9439da6cc4e868617b565', 'no', '预算表序号', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2019-06-10 14:47:14', '2019-04-23 22:58:19', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2889d3cef706f91e092d76a56b8055be', '402860816bff91c0016bff91cda80003', 'order_no', '序号', 'order_no', 0, 1, 'int', 10, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 8, 'admin', '2019-07-19 18:06:36', '2019-07-17 18:54:34', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('28900c8e76dd0e77193cbd85b5bc6af8', '402881e6760269a201760269a2af0000', 'remakr', 'markdown', NULL, 0, 1, 'Text', 0, 0, '', '', '', '', 'markdown', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 16, NULL, NULL, '2020-11-26 10:37:26', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('293f6bc9a0f557a32bbdf45669404f35', 'feea98637c2144caae7c5d56a815a245', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 1, 'single', '', '', 1, NULL, NULL, '2021-10-27 10:24:24', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('29e4abea55d9fa7dbbd0c8dbbb2b3756', '402860816bff91c0016bff91cda80003', 'update_time', '更新时间', 'update_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 12, 'admin', '2019-07-19 18:06:36', '2019-07-17 18:54:34', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2aef31179964d0a5a945df7bddff00ae', '53a3e82b54b946c2b904f605875a275c', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2020-05-08 23:42:51', '2020-05-07 22:49:47', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('2c70edc7d5a9861239c6537ae0eb39c7', '18f064d1ef424c93ba7a16148851664f', 'dep_sel', '选择部门', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'sel_depart', '', 120, NULL, '0', '', '#{sysOrgCode}', 0, 1, 1, 0, 'single', '', '', 19, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('2c9be627e7cab7f5a2ae9c7ca7ce94a2', 'cb2d8534a2f544bc9c618dd49da66336', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2020-02-24 17:22:42', '2020-02-24 15:15:14', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2d53a66f0b72d820b86ff445e2181d76', 'beee191324fd40c1afec4fda18bd9d47', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 1, 'admin', '2019-04-13 13:41:13', '2019-04-13 13:40:56', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2d8366d934e3c3a060496c115c7a438e', '402881e6760269a20176026a22e70001', 'sex', '下拉框', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'list', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 8, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '1');
INSERT INTO `onl_cgform_field` VALUES ('2dfc4c81926f678c5f8d5ffd27858201', 'e2faf977fdaf4b25a524f58c2441a51c', 'account', '用户编码', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2019-06-10 17:27:00', '2019-04-24 17:12:11', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2e0374878fb3d5be3b0b3f868a97fb59', '09fd28e4b7184c1a9668496a5c496450', 'sex', '客户性别', NULL, 0, 1, 'string', 1, 0, '', 'sex', '', '', 'list', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, 'admin', '2020-05-14 21:19:21', '2020-05-08 23:51:49', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('2e5275b6407e1b4265af8519077fa4a5', 'd3ae1c692b9640e0a091f8c46e17bb01', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, NULL, NULL, '2019-07-24 14:47:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2e66b9db37648389e0846e2204111732', '73162c3b8161413e8ecdca7eb288d0c9', 'has_child', '是否有子节点', NULL, 0, 1, 'string', 3, 0, '', 'valid_status', '', '', 'list', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 10, 'admin', '2019-07-01 14:23:32', '2019-06-10 15:18:34', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2e6740e79d51ac935d673b7d207611d2', '18f064d1ef424c93ba7a16148851664f', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 1, 'single', '', '', 1, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('2e6f741fa96a49a0adccc7b4682c1cef', '4fb8e12a697f4d5bbe9b9fb1e9009486', 'name', '名称', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '#{sysUserName}', 0, 1, 1, 0, 'single', '', '', 3, 'admin', '2020-11-26 17:28:14', '2020-04-10 19:47:01', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('2ee58d8e4844dfe1fa6b1b841ae0b312', '402860816bff91c0016bff91d2810005', 'politically_status', '政治面貌', 'politically_status', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 7, 'admin', '2019-07-19 18:05:55', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2f111722eb3a994450e67e3211fd69a8', '402860816bff91c0016bff91ca7e0002', 'id', 'id', 'id', 1, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'group', '', '', 1, 'admin', '2019-07-19 18:07:13', '2019-07-17 18:54:33', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('2f13bd36aadfe10fb79c57d727279981', 'feea98637c2144caae7c5d56a815a245', 'aaa', 'aa', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, NULL, NULL, '2021-10-27 10:24:24', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('30143cc3de69c413828f9fba20662026', '402860816bff91c0016bffa220a9000b', 'healthy', '健康状况', 'healthy', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 12, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('306e3fb9c87ca6442cefbd61f498f1f7', '402881e6760269a201760269a2af0000', 'dep_sel', '选择部门', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'sel_depart', '', 120, NULL, '0', '', '#{sysOrgCode}', 0, 1, 1, 0, 'single', NULL, NULL, 19, NULL, NULL, '2020-11-26 10:37:26', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('3087aa8f38c787e066a886d950a9edfa', '05a3a30dada7411c9109306aa4117068', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2021-08-18 15:54:51', '2020-05-06 11:34:31', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('310c86bfd1e67500774c208d601acdc3', '56870166aba54ebfacb20ba6c770bd73', 'xiala', '下拉多选', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'list_multi', '', 120, NULL, '0', '', '', 1, 1, 1, 0, 'single', '', '', 9, 'admin', '2021-08-18 20:22:58', '2020-11-30 21:08:26', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('31193dc8ceacf979e4042e784ea8278a', '402880e570a5d7000170a5d700f50000', 'order_fk_id', '订单外键ID', NULL, 0, 0, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 10, NULL, NULL, '2020-03-04 21:58:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('315eab14c7d9de37434b3cb7fa7b054d', '18f064d1ef424c93ba7a16148851664f', 'files', '文件', NULL, 0, 1, 'string', 1000, 0, '', '', '', '', 'file', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 15, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('31fd90306c3942f09cb79deabbf2f541', '402860816bff91c0016bff91d2810005', 'employee_id', '员工ID', 'employee_id', 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', 'oa_employee_info', 'id', 2, 'admin', '2019-07-19 18:05:55', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('336495117e3a31351fed6963b950dddb', '402860816bff91c0016bffa220a9000b', 'inside_transfer', '内部工作调动情况', 'inside_transfer', 0, 1, 'string', 255, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 37, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('34138092d743d4232341a920efd2699e', '402880eb71d52dc30171d52dc3a10000', 'name', '名称', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '#{sysUserName}', 0, 1, 1, 0, 'single', NULL, NULL, 3, NULL, NULL, '2020-05-02 19:37:58', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('345c8b48e1e128e77c4c6e2b36512804', '402860816aa5921f016aa5dedcb90009', 'create_by', '创建人', 'create_by', 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'group', '', '', 2, 'admin', '2019-05-11 15:56:47', '2019-05-11 15:50:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('34625a911b39e0596690c1a15f784448', '402880e570a5d7000170a5d700f50000', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 5, NULL, NULL, '2020-03-04 21:58:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3489a6451bbbcabc0f39ca04b0dd62f2', '8d66ea41c7cc4ef9ab3aab9055657fc9', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, NULL, NULL, '2020-05-07 22:46:32', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('34ecf29484ffd4b287bd34b52cf89775', 'a2ca0c7297a8491ca849fc1a06c9efbf', 'name', 'name', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2021-01-24 14:39:35', '2021-01-24 14:38:58', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('351faaeb2dd8105e9c66f678211c9d4f', 'dbf4675875e14676a3f9a8b2b8941140', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, NULL, NULL, '2019-05-27 18:02:07', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('35417ba3993afe3405e1e0b9abbd7e1b', '402880e5721355dd01721355dd390000', 'num', '数量', NULL, 0, 1, 'int', 10, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 9, NULL, NULL, '2020-05-14 21:18:14', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('354b2ce39c5e8ec3f0bbb01bf8ff0fb7', '32f75e4043ef4070919dbd4337186a3d', 'content', '描述', NULL, 0, 1, 'string', 300, 0, '', '', '', '', 'textarea', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 9, 'admin', '2019-04-11 10:15:31', '2019-03-28 15:24:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('35ca1c8aa1501bc8a79c880928841f18', '402860816aa5921f016aa5921f480000', 'update_by', '修改人id', 'update_by', 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'group', '', '', 11, 'admin', '2019-05-11 15:31:55', '2019-05-11 14:26:19', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3635793767371c6db9f76b4b79f9d321', '402860816bff91c0016bff91d8830007', 'create_time', '创建时间', 'create_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 11, 'admin', '2019-07-19 18:04:41', '2019-07-17 18:54:37', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('370a6eebc2d732eaf121fe0830d853a6', 'e5464aa8fa7b47c580e91593cf9b46dc', 'wl_code', '物料编码', NULL, 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 7, 'admin', '2019-04-24 17:09:49', '2019-04-24 11:05:10', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('37462a4d78968d0e432d746423603b81', '3d447fa919b64f6883a834036c14aa67', 'province', '省份', NULL, 0, 1, 'string', 100, 0, '', '', '{table:\'sys_category\',txt:\'name\',key:\'id\',linkField:\'city,area\',idField:\'id\',pidField:\'pid\', condition:\" pid = \'1230769196661510146\' \"         }', '', 'link_down', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 2, 'admin', '2020-02-21 17:58:46', '2020-02-20 16:19:00', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('37e2548874f09ef7d08642a30bc918fa', 'fbc35f067da94a70adb622ddba259352', 'group_name', '小组名', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, NULL, NULL, '2019-07-03 19:44:23', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3816bb487c6665a5f2ae7a4dbcbc9095', 'd35109c3632c4952a19ecc094943dd71', 'sel_table', '下拉字典表', NULL, 0, 1, 'string', 32, 0, '', 'username', 'sys_user where username like \'a%\'', 'realname', 'sel_search', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 19, 'admin', '2021-08-18 15:53:31', '2021-07-01 12:29:11', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('391e7cbd9f29743b11bb555c50547b1f', '32f75e4043ef4070919dbd4337186a3d', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2019-04-11 10:15:32', '2019-03-27 15:54:49', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('396c36fa5320975851d06772d10ea7b1', 'cb2d8534a2f544bc9c618dd49da66336', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2020-02-24 17:22:42', '2020-02-24 15:15:14', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3acd1b022fd8cb6b99534161fa3d6a24', 'd35109c3632c4952a19ecc094943dd71', 'ceck', 'checkbox', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'checkbox', '', 120, NULL, '0', '', '', 1, 1, 1, 0, 'single', '', '', 16, 'admin', '2021-08-18 15:53:31', '2020-11-26 18:02:20', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('3b439859f98e30e34d25e983eb22e408', '402860816bff91c0016bff91c7010001', 'award_time', '获奖时间', 'award_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 3, 'admin', '2019-07-19 18:07:47', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3b67be0187044a0d023fc2c4c7eceabc', '402881e6760269a20176026d25650002', 'bonus_money', '奖金', 'bonus_money', 0, 1, 'double', 10, 2, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'single', NULL, NULL, 6, NULL, NULL, '2020-11-26 10:41:17', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3bf44e68de518f3ddf72b87671d0ff90', '8994f2817b5a45d9890aa04497a317c5', 'update_by', '更新人登录名称', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 3, NULL, NULL, '2019-03-23 11:39:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3c74df163f36d1ac61af6811d2569d6c', 'f9fb8bee1a64472889d077c757b9acc7', 'ds', 'ds', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2021-08-17 13:58:15', '2021-08-17 13:57:48', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('3cd2061ea15ce9eeb4b7cf2e544ccb6b', 'd35109c3632c4952a19ecc094943dd71', 'file_kk', '附件', NULL, 0, 1, 'string', 500, 0, '', '', '', '', 'file', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 13, 'admin', '2021-08-18 15:53:31', '2019-06-10 20:06:57', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('3cfd4d60c7d8409ae716a579bcb0910d', '402860816bff91c0016bff91c0cb0000', 'sys_org_code', '组织机构编码', 'sys_org_code', 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 16, 'admin', '2019-07-19 18:09:01', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3e32f6c30c9028872388f70743c5d6a5', '402860816bff91c0016bff91c0cb0000', 'reason', '申请理由', 'reason', 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 9, 'admin', '2019-07-19 18:09:01', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3e70d1c516c3533c6698300665c669e1', '402860816bff91c0016bff91c0cb0000', 'id', 'id', 'id', 1, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'group', '', '', 1, 'admin', '2019-07-19 18:09:01', '2019-07-17 18:54:31', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3ef0a9ed04605267f7fa304a8c353576', '05a3a30dada7411c9109306aa4117068', 'name', '用户名', NULL, 0, 1, 'string', 32, 0, '', 'username', 'tj_user_report', 'name', 'popup', '', 120, NULL, '0', '', '', 1, 1, 1, 0, 'single', '', '', 7, 'admin', '2021-08-18 15:54:51', '2020-05-06 11:34:31', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '1');
INSERT INTO `onl_cgform_field` VALUES ('3eff1d21b946e23d7f83de977962d9cf', '402880eb71d61d3d0171d61d3de30000', 'main_id', '主表ID', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2020-11-26 17:28:14', '2020-05-02 23:59:33', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('3f2ace8f968a0e5b91d1340ee2957cda', '402860816bff91c0016bff91d8830007', 'real_name', '姓名', 'real_name', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 3, 'admin', '2019-07-19 18:04:41', '2019-07-17 18:54:37', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('3f7f7720ee65648cb2850fccedf7be9d', '53a3e82b54b946c2b904f605875a275c', 'contents', '商品简介', NULL, 0, 1, 'Text', 0, 0, '', '', '', '', 'umeditor', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2020-05-08 23:42:51', '2020-05-07 22:49:47', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('3f9deca6c193f0b2609113713956ad19', '86bf17839a904636b7ed96201b2fa6ea', 'order_main_id', '订单ID', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', 'ces_order_main', 'id', 11, 'admin', '2020-05-14 21:18:49', '2020-05-08 23:48:31', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('40471eb4560bf0bbd2ffef17d48a269d', 'dbf4675875e14676a3f9a8b2b8941140', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, NULL, NULL, '2019-05-27 18:02:07', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('404b516d4f2229f292783db595b02ba1', '402860816bff91c0016bff91d8830007', 'update_time', '更新时间', 'update_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 13, 'admin', '2019-07-19 18:04:41', '2019-07-17 18:54:37', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('405de5ea82e54138a0613dd41b006dfb', '56870166aba54ebfacb20ba6c770bd73', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2021-08-18 20:22:58', '2019-04-20 11:38:39', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('40675bb9f053aabf8823ddf4b5389141', 'b81de38db24047b497d476516f8a0865', 'aa', 'aa', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, NULL, NULL, '2020-02-24 14:56:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4164314d6a51d100169a29872b7504d8', '402860816bff91c0016bff91ca7e0002', 'cert_time', '发证时间', 'cert_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 3, 'admin', '2019-07-19 18:07:13', '2019-07-17 18:54:33', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('41d4215c01b0d26871f2cb83d3e532ae', '402860816bff91c0016bff91c0cb0000', 'bpm_status', '流程状态', NULL, 0, 1, 'string', 32, 0, '1', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 17, 'admin', '2019-07-19 18:09:01', '2019-07-19 15:35:23', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('422a44a15fa39fd57c3c23eb601f7c03', '56870166aba54ebfacb20ba6c770bd73', 'descc', '描述', NULL, 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, 'admin', '2021-08-18 20:22:58', '2019-04-20 11:38:39', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('42cccfa014c9e131a0a1b23f563d3688', '402860816bff91c0016bffa220a9000b', 'sex', '性别', 'sex', 0, 1, 'string', 20, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 6, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4312f618c83e07db82e468b81a1eaa45', '402860816bff91c0016bffa220a9000b', 'photo', '照片', 'photo', 0, 1, 'string', 255, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 20, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4355aaad8679a1adf8578b20310e93c1', 'a2ca0c7297a8491ca849fc1a06c9efbf', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2021-01-24 14:39:35', '2021-01-24 14:38:58', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('435b57180fc995e3c4ec42516963bca3', '4028839a6de2ebd3016de2ebd3870000', 'wl_code', '物料编码', 'wl_code', 0, 1, 'string', 60, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 6, NULL, NULL, '2019-10-19 15:29:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('44bdc595f1e565fc053e01134b92bb47', 'd3ae1c692b9640e0a091f8c46e17bb01', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, NULL, NULL, '2019-07-24 14:47:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('44e81e24d2384b0f187e8f69eda55390', '402860816bff91c0016bff91cda80003', 'create_time', '创建时间', 'create_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 10, 'admin', '2019-07-19 18:06:36', '2019-07-17 18:54:34', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('45c0a1a89a1e2a72533b9af894be1011', '27fc5f91274344afa7673a732b279939', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2019-07-01 16:28:20', '2019-07-01 16:26:42', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('45d59eb647257fcbcb9d143ff1ba2080', 'deea5a8ec619460c9245ba85dbc59e80', 'pro_type', '产品类型', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'radio', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 9, 'admin', '2020-05-03 01:01:18', '2019-04-23 20:54:08', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('469b250595f15dfebe69991d72e4bfb2', 'e9faf717024b4aae95cff224ae9b6d97', 'name', '员工姓名', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 6, 'admin', '2019-07-03 18:23:49', '2019-07-03 18:22:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('46be01bef342519e268902d0d36a7473', 'deea5a8ec619460c9245ba85dbc59e80', 'descc', '描述', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 11, 'admin', '2020-05-03 01:01:18', '2019-04-20 11:41:19', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('46f1a875f86a4f48d0540ad0d5e667d7', '56870166aba54ebfacb20ba6c770bd73', 'order_date', '下单时间', NULL, 0, 1, 'Date', 32, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 1, 1, 1, 0, 'single', '', '', 7, 'admin', '2021-08-18 20:22:58', '2019-04-20 11:38:39', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('47c21a6b45e59a6b70bb9c0cc4510a68', '1acb6f81a1d9439da6cc4e868617b565', 'integral_val', '积分值', NULL, 0, 1, 'int', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 13, 'admin', '2019-06-10 14:47:14', '2019-04-23 22:58:19', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('47fa05530f3537a1be8f9e7a9e98be82', 'd35109c3632c4952a19ecc094943dd71', 'sex', '性别', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'list', '', 120, '', '0', '', '', 1, 1, 1, 0, 'single', '', '', 7, 'admin', '2021-08-18 15:53:31', '2019-03-15 14:24:35', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '1');
INSERT INTO `onl_cgform_field` VALUES ('4851697fdf63709d2bc7451b7415f4af', '32f75e4043ef4070919dbd4337186a3d', 'sex', '性别', NULL, 0, 1, 'string', 32, 0, '1', 'sex', '', '', 'list', '', 120, NULL, '0', '', '', 1, 1, 1, 0, 'single', '', '', 6, 'admin', '2019-04-11 10:15:32', '2019-03-27 15:54:49', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('485a8ddce2c033f88af674ec98b68e32', '402860816bff91c0016bffa220a9000b', 'create_time', '创建时间', 'create_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 40, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4863e3b3e632a254ad3b2ec873767bcb', 'b493c5fd4fa64a3a84e74ee171763e37', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, NULL, NULL, '2021-06-07 18:13:37', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('48fad8b8ac3f9226294c1078807646ae', '402881e6760269a20176026a22e70001', 'birthday', '时间', NULL, 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 13, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('492a462b212fc34b0ee70e872684ed7e', '7ea60a25fa27470e9080d6a921aabbd1', 'name', '用户名', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 6, NULL, NULL, '2019-04-17 00:22:21', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('499a5dac033a01ce58009e4c5b786697', 'e9faf717024b4aae95cff224ae9b6d97', 'age', '员工年龄', NULL, 0, 1, 'int', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2019-07-03 18:23:49', '2019-07-03 18:22:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('49cd3dbd4f7f7cf0d19b1ee1045cfa69', 'e67d26b610dd414c884c4dbb24e71ce3', 'post_code', '岗位编码', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 6, 'admin', '2019-04-24 11:03:32', '2019-04-24 11:02:57', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4ad94222c025b56fb0833a88a1514aeb', '86bf17839a904636b7ed96201b2fa6ea', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 1, 'single', '', '', 1, 'admin', '2020-05-14 21:18:49', '2020-05-08 23:48:31', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('4b136f953675fffcc1b6d7d6d414d57e', '402880eb71d61d3d0171d61d3de30000', 'date', '日期', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '#{date}', 0, 1, 1, 0, 'single', '', '', 4, 'admin', '2020-11-26 17:28:14', '2020-05-02 23:59:33', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('4b1d4d7a1c1f7d5b99ae6c6a6d91b403', 'a2ca0c7297a8491ca849fc1a06c9efbf', 'dated', '生日', NULL, 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2021-01-24 14:39:35', '2021-01-24 14:38:58', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('4ba7c553ca4babcec75273c531cd65e1', '402860816bff91c0016bff91cfea0004', 'workplace', '工作单位', 'workplace', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 5, 'admin', '2019-07-19 18:05:13', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4c2cba9fc950333421c4193576b8384d', '32f75e4043ef4070919dbd4337186a3d', 'salary', '工资', NULL, 0, 1, 'double', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2019-04-11 10:15:32', '2019-03-28 15:24:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4c4f4067fa31737f3ff9e088130ef793', '4adec929a6594108bef5b35ee9966e9f', 'sex', '性别', NULL, 0, 1, 'string', 200, 0, '', 'sex', '', '', 'list', '', 120, NULL, '0', '', '{{ 2 }}', 0, 1, 1, 0, 'single', '', '', 4, 'admin', '2020-04-10 19:43:38', '2020-04-10 19:35:58', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('4c570c5cf05590348e12621ca62773cf', '402860816aa5921f016aa5921f480000', 'name', '请假人', 'name', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 2, 'admin', '2019-05-11 15:31:54', '2019-05-11 14:26:19', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4cacfa054e96791ab938b5c8f8e02cd1', '27fc5f91274344afa7673a732b279939', 'bpm_status', '流程状态', NULL, 0, 1, 'string', 2, 0, '', 'bpm_status', '', '', 'list', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 9, NULL, NULL, '2019-07-01 16:28:20', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4dc3f7e772564de45773a8379adc4335', '3b5e18da618247539481816995b6bf9f', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2020-07-11 11:27:29', '2020-07-11 11:27:17', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('4e3760f9068aee4318123d85fbf2ebf9', '53a3e82b54b946c2b904f605875a275c', 'good_type_id', '商品分类', NULL, 0, 1, 'string', 32, 0, '', '0', 'ces_shop_type', 'id,pid,name,has_child', 'sel_tree', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 11, 'admin', '2020-05-08 23:42:51', '2020-05-07 22:51:42', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('4f718d95ad9de33eac18fd0663e4c1f1', '32f75e4043ef4070919dbd4337186a3d', 'birthday', '生日', NULL, 0, 1, 'Date', 32, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 1, 1, 1, 0, 'single', '', '', 8, 'admin', '2019-04-11 10:15:32', '2019-03-27 15:54:49', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4f7cba71de7afe6efbd024f5f9935521', '402860816bff91c0016bff91cda80003', 'to_time', '截止时间', 'to_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 4, 'admin', '2019-07-19 18:06:36', '2019-07-17 18:54:34', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('4fa29e880104e0ed0cb9143d801b209f', '18f064d1ef424c93ba7a16148851664f', 'checkbox', 'checkbox', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'checkbox', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('4faa7848b92f05bcb3cf03de34af9ff2', 'cb2d8534a2f544bc9c618dd49da66336', 'ddd', 'dd', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 9, 'admin', '2020-02-24 17:22:42', '2020-02-24 15:15:14', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('506c9b0b2331a24e5c284274d28fe569', '27fc5f91274344afa7673a732b279939', 'kkk', '描述', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, 'admin', '2019-07-01 16:28:20', '2019-07-01 16:26:42', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('508eb28e1409a2a9501cdf6fd7eb24c7', 'dbf4675875e14676a3f9a8b2b8941140', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, NULL, NULL, '2019-05-27 18:02:07', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('509a4f63f02e784bc04499a6a9be8528', 'd35109c3632c4952a19ecc094943dd71', 'update_by', '更新人登录名称', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2021-08-18 15:53:31', '2019-03-15 14:24:35', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('519f68557b953fc2d38400182b187366', '402860816bff91c0016bffa220a9000b', 'residence_type', '户籍类别', 'residence_type', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 13, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5237e186de11017ee52d3c344f450b3b', 'f9fb8bee1a64472889d077c757b9acc7', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2021-08-17 13:58:15', '2021-08-17 13:57:48', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('52975c3f03325de8233d3459b2230b09', 'f9fb8bee1a64472889d077c757b9acc7', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 1, 'single', '', '', 1, 'admin', '2021-08-17 13:58:15', '2021-08-17 13:57:48', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('52ee861bc1b62cd8e4f10632b3d9d1b2', '79091e8277c744158530321513119c68', 'name', '顺序会签标题', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 6, 'admin', '2019-05-11 15:29:47', '2019-05-11 15:27:17', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5531fb261c77e9d12f7cca1af528f70a', '05a3a30dada7411c9109306aa4117068', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2021-08-18 15:54:51', '2020-05-06 11:34:31', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('553a250fb89de39e4ba9f8450fd72ade', '05a3a30dada7411c9109306aa4117068', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2021-08-18 15:54:51', '2020-05-06 11:34:31', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('555f9d43db20204128d76e22226ca36e', '402881e6760269a201760269a2af0000', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 2, NULL, NULL, '2020-11-26 10:37:26', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('5562a7242e4978f02e6d3a08d5828bbf', '53a3e82b54b946c2b904f605875a275c', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2020-05-08 23:42:51', '2020-05-07 22:49:47', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('5562ad3165b1399f97a48f5f06d7fa06', '3b5e18da618247539481816995b6bf9f', 'ccc', 'cc', NULL, 0, 1, 'string', 1000, 0, '', '', '', '', 'umeditor', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2020-07-11 11:27:29', '2020-07-11 11:27:17', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('55ee63fe34f0b666078e6af940bee222', 'feea98637c2144caae7c5d56a815a245', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, NULL, NULL, '2021-10-27 10:24:24', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('56a7800e4e476812c74217c2aad781aa', '32feeb502544416c9bf41329c10a88f4', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2019-08-23 20:03:40', '2019-07-02 18:23:23', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('56cd0a76f922bf76d982b24a509e4782', '4028839a6de2ebd3016de2ebd3870000', 'create_time', '创建日期', 'create_time', 0, 1, 'Date', 0, 0, NULL, NULL, NULL, NULL, 'date', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 3, NULL, NULL, '2019-10-19 15:29:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('56e247f12d62b49cd9bd537e3efecf16', '402860816bff91c0016bff91c0cb0000', 'create_by', '创建人', 'create_by', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 12, 'admin', '2019-07-19 18:09:01', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('57552a4f0b7b5c096ab8985ced57cc7d', 'cb2d8534a2f544bc9c618dd49da66336', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2020-02-24 17:22:42', '2020-02-24 15:15:14', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('581d8e8ce270b762458121b1dea0be9a', '8d66ea41c7cc4ef9ab3aab9055657fc9', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, NULL, NULL, '2020-05-07 22:46:32', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('588400f6ebcdd0bc9bb560dd36636af9', 'e2faf977fdaf4b25a524f58c2441a51c', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2019-06-10 17:27:00', '2019-04-24 17:12:11', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('58a96f945912d33b64ebf5dee98156dc', '402860816bff91c0016bffa220a9000b', 'mobile', '手机号', 'mobile', 0, 1, 'string', 20, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 19, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('58eea85add4788b83c893092434bc413', 'fb19fb067cd841f9ae93d4eb3b883dc0', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 4, NULL, NULL, '2019-03-23 11:39:48', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('59ae1e853668c676e85329aa029c68a6', '402860816bff91c0016bff91c0cb0000', 'status', '状态（1：申请中 2：通过）', 'status', 0, 1, 'string', 2, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 11, 'admin', '2019-07-19 18:09:01', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5a043c7ae042e48f50d1fb0bb3d760a8', '402880eb71d61d3d0171d61d3de30000', 'code', '编码', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '${order_num_rule_param}', 0, 1, 1, 0, 'single', '', '', 2, 'admin', '2020-11-26 17:28:14', '2020-05-02 23:59:33', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('5a1ab458d88bb766f92c3d791495cdcd', '402860816bff91c0016bff91d2810005', 'age', '年龄', 'age', 0, 1, 'int', 10, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 5, 'admin', '2019-07-19 18:05:55', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5a48150409b0960173f091558d1611d0', 'a2ca0c7297a8491ca849fc1a06c9efbf', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2021-01-24 14:39:35', '2021-01-24 14:38:58', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('5a4ef083dd572114aeb581b6828de545', '402860816bff91c0016bff91c7010001', 'award_name', '获奖名称', 'award_name', 0, 1, 'string', 255, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 5, 'admin', '2019-07-19 18:07:47', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5a621f27aa443fe9eccc73717e4fa172', '4028318169e81b970169e81b97650000', 'method', '请求java方法', 'method', 0, 1, 'string', 500, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 8, NULL, NULL, '2019-04-04 19:28:36', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5a655b208d6318ed02f236f15a319b5f', 'fbc35f067da94a70adb622ddba259352', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, NULL, NULL, '2019-07-03 19:44:23', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5a6f88710c49bbe8e2e0ca58e149abad', '402860816bff91c0016bff91cda80003', 'create_by', '创建人', 'create_by', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 9, 'admin', '2019-07-19 18:06:36', '2019-07-17 18:54:34', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5a7ce5af50f28d613d8beea7c866ae0c', '402881e6760269a20176026d25650002', 'update_by', '修改人', 'update_by', 0, 1, 'string', 32, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'single', NULL, NULL, 14, NULL, NULL, '2020-11-26 10:41:17', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5ab702dbc37d6fd8d3a1093fda7223bf', '53a3e82b54b946c2b904f605875a275c', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2020-05-08 23:42:51', '2020-05-07 22:49:47', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('5b17ba693745c258f6b66380ac851e5f', 'd35109c3632c4952a19ecc094943dd71', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 1, 'admin', '2021-08-18 15:53:31', '2019-03-15 14:24:35', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('5c76f5ecc774d7339eb0c2199c0052bc', '402860816bff91c0016bff91c0cb0000', 'biz_no', '编号', 'biz_no', 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 2, 'admin', '2019-07-19 18:09:01', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5c8c8d573e01e4f40b5a7c451515e1d2', '32feeb502544416c9bf41329c10a88f4', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2019-08-23 20:03:40', '2019-07-02 18:23:23', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5dfbea516ee2390d712eace5405c5219', '402860816bff91c0016bff91ca7e0002', 'create_by', '创建人', 'create_by', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 9, 'admin', '2019-07-19 18:07:13', '2019-07-17 18:54:33', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5e4484b7348dc3e59a0c58bdc3828cc0', '27fc5f91274344afa7673a732b279939', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2019-07-01 16:28:20', '2019-07-01 16:26:42', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5e4ac29ac2007ceabf93368330290a42', '402860816bff91c0016bff91d8830007', 'order_no', '序号', 'order_no', 0, 1, 'int', 10, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 9, 'admin', '2019-07-19 18:04:41', '2019-07-17 18:54:37', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('5e729f9823b5cc96c50b0b7c0f07eb05', '402880e5721355dd01721355dd390000', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 2, NULL, NULL, '2020-05-14 21:18:14', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('5e991844962b2f3c42237445fdf2cd19', '402881e6760269a20176026a22e70001', 'remakr', 'markdown', NULL, 0, 1, 'Text', 0, 0, '', '', '', '', 'markdown', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 16, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('5f13f7087caa0bbf47e5eba01d0d0443', '05a3a30dada7411c9109306aa4117068', 'contents', '请假原因', NULL, 0, 1, 'string', 500, 0, '', '', '', '', 'markdown', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 11, 'admin', '2021-08-18 15:54:51', '2020-05-06 11:34:31', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('5f5ac4d37fd1a3a09e2b19f0d4d99c0f', '4adec929a6594108bef5b35ee9966e9f', 'code', '编码', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '${order_num_rule_param}', 0, 1, 1, 0, 'single', '', '', 2, 'admin', '2020-04-10 19:43:38', '2020-04-10 19:35:58', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('5f718d8968d908cd2e4de6ee4c74d644', '402880eb71d61d3d0171d61d3de30000', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 7, 'admin', '2020-05-03 00:54:16', '2020-05-02 23:59:33', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('60b3b452232904f5a1130348bc1eab53', '402881e6760269a20176026d25650002', 'sys_org_code', '所属部门编码', 'sys_org_code', 0, 1, 'string', 64, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'single', NULL, NULL, 16, NULL, NULL, '2020-11-26 10:41:17', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('60eed6c429cf7796c3f0a17faaed00da', 'b493c5fd4fa64a3a84e74ee171763e37', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, NULL, NULL, '2021-06-07 18:13:37', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6130dbb6d36bab8ee9154e7ab58af34c', '402880e570a5d7000170a5d700f50000', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 1, NULL, NULL, '2020-03-04 21:58:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('617349b18dab429009ccd304fd7d459c', '4028839a6de2ebd3016de2ebd3870000', 'update_by', '更新人', 'update_by', 0, 1, 'string', 50, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 4, NULL, NULL, '2019-10-19 15:29:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('61c7a0058c264dd746eb35e6f50fc15b', '402860816aa5921f016aa5dedcb90009', 'update_time', '更新日期', 'update_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'group', '', '', 5, 'admin', '2019-05-11 15:56:47', '2019-05-11 15:50:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('6232ade7e2a0c1e97e2c0945b32e61b6', '402860816bff91c0016bffa220a9000b', 'paying_social_insurance', '是否上社保', 'paying_social_insurance', 0, 1, 'string', 20, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 32, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('631a606d35a74c2036a81f27dd16a1a6', 'feea98637c2144caae7c5d56a815a245', 'dd', 'dd', NULL, 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, NULL, NULL, '2021-10-27 10:24:24', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6352d477b6b2751780c5852e92d0daa6', '402880eb71d61d3d0171d61d3de30000', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2020-05-03 00:54:16', '2020-05-02 23:59:33', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('635e09afc01aad757faacf1321465c23', 'b81de38db24047b497d476516f8a0865', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, NULL, NULL, '2020-02-24 14:56:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('6490a98dccb6df218feaeb4ce11bc03b', '402860816aa5921f016aa5921f480000', 'update_time', '修改时间', 'update_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'group', '', '', 10, 'admin', '2019-05-11 15:31:54', '2019-05-11 14:26:19', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('654362725195829005036b3db47ec826', '402860816bff91c0016bffa220a9000b', 'post', '职务', 'post', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 4, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('6603058186832c4ff9e8c6e43baa5c3d', '86bf17839a904636b7ed96201b2fa6ea', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2020-05-14 21:18:49', '2020-05-08 23:48:31', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('66a7ef842bc34e105a90186e48167ef2', 'dbf4675875e14676a3f9a8b2b8941140', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, NULL, NULL, '2019-05-27 18:02:07', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('671e62c685bc86bde3cef0e023418fb4', '05a3a30dada7411c9109306aa4117068', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2021-08-18 15:54:51', '2020-05-06 11:34:31', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('686dea2621feadcd9b4c611df046adb4', '86bf17839a904636b7ed96201b2fa6ea', 'price', '价格', NULL, 0, 1, 'double', 10, 3, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, 'admin', '2020-05-14 21:18:49', '2020-05-08 23:48:31', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('68769fa7e4696e3a28f4cecf63076b7b', '402860816bff91c0016bff91ca7e0002', 'order_no', '序号', 'order_no', 0, 1, 'int', 10, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 8, 'admin', '2019-07-19 18:07:13', '2019-07-17 18:54:33', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('68861523516849eff46a0df045f1031b', '402881e6760269a201760269a2af0000', 'birthday', '时间', NULL, 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 13, NULL, NULL, '2020-11-26 10:37:26', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6915257f75506f72789e61bb155f49bd', '402881e6760269a20176026a22e70001', 'sel_search', '下拉搜索', NULL, 0, 1, 'string', 32, 0, '', 'username', 'sys_user', 'username', 'sel_search', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 12, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('69666f21896136af16a6303aff440156', '402860816bff91c0016bffa220a9000b', 'nation', '民族', 'nation', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 11, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('69d11490788fecfc9fb7d74bf449ba86', '32f75e4043ef4070919dbd4337186a3d', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2019-04-11 10:15:32', '2019-03-27 15:54:49', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('69e568501d10281d061311d3db15e6af', '18f064d1ef424c93ba7a16148851664f', 'user_sel', '选择用户', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'sel_user', '', 120, NULL, '0', '', '#{sysUserCode}', 0, 1, 1, 0, 'single', '', '', 18, 'admin', '2020-09-11 14:35:44', '2020-05-12 20:26:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6a0082c8ffbae092e99689520f1c83f7', '4fb8e12a697f4d5bbe9b9fb1e9009486', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 9, 'admin', '2020-11-26 17:28:14', '2020-04-10 19:47:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6a30c2e6f01ddd24349da55a37025cc0', 'd35109c3632c4952a19ecc094943dd71', 'top_pic', '头像', NULL, 0, 1, 'string', 500, 0, '', '', '', '', 'image', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 12, 'admin', '2021-08-18 15:53:31', '2019-06-10 20:06:56', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6ab2e3d9b944701b405fb1a5ed167012', '86bf17839a904636b7ed96201b2fa6ea', 'zong_price', '单品总价', NULL, 0, 1, 'double', 10, 3, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2020-05-14 21:18:49', '2020-05-08 23:48:31', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6b21f5239671023ca769b6717a51130e', '402880eb71d61d3d0171d61d3de30000', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 8, 'admin', '2020-05-03 00:54:16', '2020-05-02 23:59:33', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6b6f3aa00b8e73fb785154e795189739', '402860816aa5921f016aa5dedcb90009', 'start_time', '会签发起时间', 'start_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 7, 'admin', '2019-05-11 15:56:47', '2019-05-11 15:50:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('6beb40bdd28af22e06b26640bc0c3f4d', '3b5e18da618247539481816995b6bf9f', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 1, 'single', '', '', 1, 'admin', '2020-07-11 11:27:29', '2020-07-11 11:27:17', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6c35eb97737e9f86279939d264454a94', '86bf17839a904636b7ed96201b2fa6ea', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2020-05-14 21:18:49', '2020-05-08 23:48:31', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6cfb5acbbb69782bf0c7043b53f595b2', '402860816bff91c0016bff91cda80003', 'update_by', '更新人', 'update_by', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 11, 'admin', '2019-07-19 18:06:36', '2019-07-17 18:54:34', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('6d03a7774a50c6e6f76dbc7a8269beba', '3b5e18da618247539481816995b6bf9f', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2020-07-11 11:27:29', '2020-07-11 11:27:17', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6d4a4414b55ad5b6f31c8fb327dad834', '09fd28e4b7184c1a9668496a5c496450', 'address', '常用地址', NULL, 0, 1, 'string', 300, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 11, 'admin', '2020-05-14 21:19:21', '2020-05-08 23:51:49', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6e5c9d8e8b7eb6980ec246cb813b180b', '4fb8e12a697f4d5bbe9b9fb1e9009486', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 10, 'admin', '2020-11-26 17:28:14', '2020-04-10 19:47:01', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6ed8d9acef3cccd1b8fd659b3b538023', '53a3e82b54b946c2b904f605875a275c', 'price', '价格', NULL, 0, 1, 'BigDecimal', 10, 5, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, 'admin', '2020-05-08 23:42:51', '2020-05-07 22:49:47', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6f38a07ea2b1065315a6b89a02af5bb4', '3b5e18da618247539481816995b6bf9f', 'name', '用户名', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2020-07-11 11:27:29', '2020-07-11 11:27:17', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('6f73e96a659c200c083006b6fce1f043', '402860816bff91c0016bff91ca7e0002', 'cert_name', '证书名称', 'cert_name', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 4, 'admin', '2019-07-19 18:07:13', '2019-07-17 18:54:33', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('71197d255e05c9f6db67fd30380953c7', '402881e6760269a201760269a2af0000', 'sel_mut', '下拉多选', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'list_multi', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 11, NULL, NULL, '2020-11-26 10:37:26', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('7154c75d754a5f88bef2b68829baf576', '4028318169e81b970169e81b97650000', 'operate_type', '操作类型', 'operate_type', 0, 1, 'string', 10, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 4, NULL, NULL, '2019-04-04 19:28:36', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('71afb00a1971125ecfa13b4dfa49665e', '402860816bff91c0016bff91cfea0004', 'order_no', '序号', 'order_no', 0, 1, 'int', 10, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 8, 'admin', '2019-07-19 18:05:13', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('71d5b0675df5aba71688c9d7d75cccee', '4028318169e81b970169e81b97650000', 'log_type', '日志类型（1登录日志，2操作日志）', 'log_type', 0, 1, 'string', 10, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 2, NULL, NULL, '2019-04-04 19:28:36', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('71e9ab74dae687837365e50eed090591', '1acb6f81a1d9439da6cc4e868617b565', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 1, 'admin', '2019-06-10 14:47:14', '2019-04-23 22:58:19', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7280c56a210e6a47794fda855d0c6abb', 'fbc35f067da94a70adb622ddba259352', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, NULL, NULL, '2019-07-03 19:44:23', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('72e784af5c47bbbc0534b29bf656bd61', '4028839a6de2ebd3016de2ebd3870000', 'id', '主键', 'id', 1, 0, 'string', 36, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 0, 0, 0, 'group', NULL, NULL, 1, NULL, NULL, '2019-10-19 15:29:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7365f05f551092716223d5d449efd8c7', 'beee191324fd40c1afec4fda18bd9d47', 'name', 'ss', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 6, 'admin', '2019-04-13 13:41:13', '2019-04-13 13:40:56', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('73d3b57df0c6cf15c21970f4dd979319', '402880e5721355dd01721355dd390000', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 5, NULL, NULL, '2020-05-14 21:18:14', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('73dc6089556f3446e39d42df3dedb2db', '402880e570a5d7000170a5d700f50000', 'num', '数量', NULL, 0, 1, 'int', 32, 0, '', '', '', '', 'text', '', 120, 'n', '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 8, NULL, NULL, '2020-03-04 21:58:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('742329ccdb185cf5d3e0b5b0c05dcffa', '402860816bff91c0016bffa220a9000b', 'interest', '兴趣爱好', 'interest', 0, 1, 'string', 255, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 34, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('744444a7ada3bbb05c6b114b5ba0d477', '402860816aa5921f016aa5dedcb90009', 'id', 'id', 'id', 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'group', '', '', 1, 'admin', '2019-05-11 15:56:47', '2019-05-11 15:50:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('74af99545de724a4abd2022581a36026', 'fb7125a344a649b990c12949945cb6c1', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2019-03-26 19:24:11', '2019-03-26 19:01:52', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('756b07656386dbd91245f7ffda32ae61', '402860816bff91c0016bff91d8830007', 'id', 'id', 'id', 1, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'group', '', '', 1, 'admin', '2019-07-19 18:04:41', '2019-07-17 18:54:37', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('75841fa7c75ebdc94655bd5e44fbc9f6', '402860816bff91c0016bffa220a9000b', 'native_place', '籍贯', 'native_place', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 10, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('75ba781c67711bed71bba1c3e3c68e11', '8994f2817b5a45d9890aa04497a317c5', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 0, NULL, NULL, '2019-03-23 11:39:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('75e82f151e8cc12455f7f0d25bf4dac0', '4028839a6de2ebd3016de2ebd3870000', 'wl_name', '物料名称', 'wl_name', 0, 1, 'string', 100, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 7, NULL, NULL, '2019-10-19 15:29:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7639c1bc4327f1f674ffeab2ca261134', '32f75e4043ef4070919dbd4337186a3d', 'update_by', '更新人登录名称', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2019-04-11 10:15:32', '2019-03-27 15:54:49', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('766ca866b72d118f5d8883de46a8c043', '4028839a6de2ebd3016de2ebd3870000', 'supplier', '供应商', 'supplier', 0, 1, 'string', 32, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 15, NULL, NULL, '2019-10-19 15:29:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('76c64fdb02faecd86c817cbb58d293c2', '402881e6760269a201760269a2af0000', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 6, NULL, NULL, '2020-11-26 10:37:26', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('783a5ff64c6b0da3fd4cd540ddc662bf', '402881e6760269a20176026a22e70001', 'id', '主键', NULL, 1, 0, 'string', 36, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 1, 'single', NULL, NULL, 1, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('78a40344207c791b8d7ac7de721ce1c4', '79091e8277c744158530321513119c68', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2019-05-11 15:29:47', '2019-05-11 15:27:17', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('78eb7e3b77cd49f9acb9b024cfe834e1', '402860816aa5921f016aa5dedcb90009', 'create_time', '创建日期', 'create_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'group', '', '', 3, 'admin', '2019-05-11 15:56:47', '2019-05-11 15:50:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('78fd804d93dc716fd8c2ccc45f788565', 'fb7125a344a649b990c12949945cb6c1', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 0, 0, 0, 'single', '', '', 1, 'admin', '2019-03-26 19:24:11', '2019-03-26 19:01:52', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('790c9f3dba773ed9a6ea3ad627393f57', '402860816bff91c0016bffa220a9000b', 'archives_location', '档案所在地', 'archives_location', 0, 1, 'string', 255, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 36, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7a665ed90ef64b4d65632c941e5795b2', '4b556f0168f64976a3d20bfb932bc798', 'sex', '性别', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, NULL, NULL, '2019-04-12 23:38:29', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7a697e4053445f07ad1a56a246f593e7', '86bf17839a904636b7ed96201b2fa6ea', 'good_name', '商品名字', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2020-05-14 21:18:49', '2020-05-08 23:48:31', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('7abe873f542bb5d7ce1cd8c798a62073', '402881e6760269a20176026a22e70001', 'checkbox', 'checkbox', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'checkbox', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 10, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('7af06f4d732ff15c114ed51acc1c8891', '402881e6760269a20176026a22e70001', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 4, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('7b4c181e4ebd76022f75535ed6fd9de3', '4adec929a6594108bef5b35ee9966e9f', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 10, 'admin', '2020-04-10 19:43:38', '2020-04-10 19:35:58', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('7b642d983ac06bfef91edde2c932dbe7', '1acb6f81a1d9439da6cc4e868617b565', 'xg_shangxian', '选购上限', NULL, 0, 1, 'int', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 14, 'admin', '2019-06-10 14:47:14', '2019-04-23 22:58:19', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7b849e57debfb889caea5e0fef09062b', 'beee191324fd40c1afec4fda18bd9d47', 'sex2', 'dd', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2019-04-13 13:41:13', '2019-04-13 13:40:56', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7beb639aa9ffda07edb5ce1e49c2287f', '402860816bff91c0016bff91d2810005', 'update_time', '更新时间', 'update_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 13, 'admin', '2019-07-19 18:05:55', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7bf091da401b74d55b107fe9f930ea54', '4028839a6de2ebd3016de2ebd3870000', 'create_by', '创建人', 'create_by', 0, 1, 'string', 50, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 2, NULL, NULL, '2019-10-19 15:29:30', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7c6aecc377816c69147f1193b17dfcc5', 'e9faf717024b4aae95cff224ae9b6d97', 'sex', '员工性别', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 8, 'admin', '2019-07-03 18:23:49', '2019-07-03 18:22:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7cadf4e0be0b173bb5b8d39613e25190', '402860816bff91c0016bffa220a9000b', 'residence_postcode', '户籍邮编', 'residence_postcode', 0, 1, 'string', 10, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 29, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7cc13710a3ff2046364204b7e5158467', '402881e6760269a20176026a22e70001', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 6, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('7cce797000cec08416fb027d1a4013cb', '402881e6760269a20176026d25650002', 'sex', '性别 {男:1,女:2}', 'sex', 0, 1, 'string', 2, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'single', NULL, NULL, 7, NULL, NULL, '2020-11-26 10:41:17', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7cdbe0d563e15f3fb1fb32d996fe4ba7', '3d447fa919b64f6883a834036c14aa67', 'area', '区', NULL, 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 4, 'admin', '2020-02-21 17:58:46', '2020-02-20 16:19:00', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7d107728408c21ece332406a21f2d692', '402860816bff91c0016bff91cfea0004', 'update_by', '更新人', 'update_by', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 11, 'admin', '2019-07-19 18:05:13', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7d27d79157dff60f847d98cbc4e66e81', 'b493c5fd4fa64a3a84e74ee171763e37', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, NULL, NULL, '2021-06-07 18:13:37', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('7e066f60680158d47b328ef519d80e49', 'beee191324fd40c1afec4fda18bd9d47', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2019-04-13 13:41:13', '2019-04-13 13:40:56', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7e331396f6e544ae801690cf475e7615', '402881e6760269a201760269a2af0000', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 3, NULL, NULL, '2020-11-26 10:37:26', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('7f10901c6ade3aa9d9ff46ed7039c70f', '1acb6f81a1d9439da6cc4e868617b565', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 3, 'admin', '2019-06-10 14:47:14', '2019-04-23 22:58:19', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('7ff9dbe4ac71bb64d057a3a2063fca2c', '402881e6760269a20176026a22e70001', 'radio', 'radio', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'radio', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 9, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('809a9fafe0b79c9997de32cb6e831c6f', '05a3a30dada7411c9109306aa4117068', 'birthday', '生日', NULL, 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2021-08-18 15:54:51', '2020-05-06 11:34:31', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('8119d3de514092232935b038531828c5', '05a3a30dada7411c9109306aa4117068', 'sex', '性别', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'list', '', 120, NULL, '0', '', '', 1, 1, 1, 0, 'single', '', '', 9, 'admin', '2021-08-18 15:54:51', '2020-05-06 11:34:31', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('813a5ebf7335309c7edb3803f7e4b204', '402880e570a5d7000170a5d700f50000', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 2, NULL, NULL, '2020-03-04 21:58:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('817cc5e277e88164dffd4caee1169276', '56efb74326e74064b60933f6f8af30ea', 'remark', '备注', NULL, 0, 1, 'string', 500, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2020-07-10 16:53:27', '2020-05-08 23:45:32', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('81ed9556c9fda1bbb46d94a53a6c90c7', '402860816bff91c0016bff91c0cb0000', 'depart_name', '部门名称', 'depart', 0, 1, 'string', 100, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 7, 'admin', '2019-07-19 18:09:01', '2019-07-17 18:54:32', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('83764a3d17590f5a69047295803eaa07', 'feea98637c2144caae7c5d56a815a245', 'cc', 'cc', NULL, 0, 1, 'double', 10, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 9, NULL, NULL, '2021-10-27 10:24:24', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('838622bc247b35606e95ddcc079f70f4', 'f9fb8bee1a64472889d077c757b9acc7', 'nn', 'nn', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2021-08-17 13:58:15', '2021-08-17 13:57:48', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('840343a59a8e705821d393506c2bc1fe', '402880e570a5d7000170a5d700f50000', 'create_time', '创建日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 3, NULL, NULL, '2020-03-04 21:58:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('8419278effeb3a6531247fbfdb3b10e3', '402881e6760269a201760269a2af0000', 'user_sel', '选择用户', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'sel_user', '', 120, NULL, '0', '', '#{sysUserCode}', 0, 1, 1, 0, 'single', NULL, NULL, 18, NULL, NULL, '2020-11-26 10:37:26', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('8422485e1cbf4455f9ded7d0af59379c', '402860816bff91c0016bff91cfea0004', 'to_time', '截止时间', 'to_time', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 4, 'admin', '2019-07-19 18:05:13', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('845c70568d44a074f067d6d277950525', '402860816bff91c0016bffa220a9000b', 'entrytime', '入职时间', 'entrytime', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 23, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('8529ddaed8d5f3d9084e873203d55cac', '402860816bff91c0016bffa220a9000b', 'marital_status', '婚姻状况', 'marital_status', 0, 1, 'string', 20, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 24, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('857a0daa9cd8a058f2f15fc7c5fb3571', '402860816bff91c0016bffa220a9000b', 'email', '邮箱', 'email', 0, 1, 'string', 255, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 17, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('85e43fa87074845f86cf52606a23a57c', 'b81de38db24047b497d476516f8a0865', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, NULL, NULL, '2020-02-24 14:56:08', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('8652ca69a947fd4c961a3ac7c0fa252a', 'fb19fb067cd841f9ae93d4eb3b883dc0', 'create_by', '创建人登录名称', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 1, NULL, NULL, '2019-03-23 11:39:48', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('86bbafef5683674a736cf7241c458d44', '27fc5f91274344afa7673a732b279939', 'create_by', '创建人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 2, 'admin', '2019-07-01 16:28:20', '2019-07-01 16:26:42', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('86c598da4f5a3dd3e82e1d9f38d06747', 'a2ca0c7297a8491ca849fc1a06c9efbf', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2021-01-24 14:39:35', '2021-01-24 14:38:58', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('86e0f3a8f31c60698157f139ed993954', '402860816bff91c0016bffa220a9000b', 'having_reserve_funds', '是否有公积金', 'having_reserve_funds', 0, 1, 'string', 20, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 33, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('86f29e9919766e0d1128263608c016a0', '997ee931515a4620bc30a9c1246429a9', 'type_name', '商品分类', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 7, 'admin', '2020-05-03 00:57:44', '2020-05-03 00:56:56', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('873e2bb041b17bff77d3aca72900ea1b', '56870166aba54ebfacb20ba6c770bd73', 'order_code', '订单编码', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '${shop_order_num}', 1, 1, 1, 0, 'single', '', '', 6, 'admin', '2021-08-18 20:22:58', '2019-04-20 11:38:39', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('8756fbb5c23a0258e029e0cb3c0a045c', '402880e5721355dd01721355dd390000', 'price', '价格', NULL, 0, 1, 'double', 10, 3, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 8, NULL, NULL, '2020-05-14 21:18:14', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('877391ae770a4ce2c95181ef410982ce', '4028318169e81b970169e81b97650000', 'request_param', '请求参数', 'request_param', 0, 1, 'string', 255, 0, NULL, NULL, NULL, NULL, 'text', NULL, 120, NULL, '0', NULL, NULL, 0, 1, 1, 0, 'group', NULL, NULL, 10, NULL, NULL, '2019-04-04 19:28:36', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('87e22ceeb12312250c16741929586c4b', '402881e6760269a20176026a22e70001', 'sel_mut', '下拉多选', NULL, 0, 1, 'string', 32, 0, '', 'sex', '', '', 'list_multi', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', NULL, NULL, 11, NULL, NULL, '2020-11-26 10:37:59', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('87e82e3c723a6abb020122babdac6bd1', '8994f2817b5a45d9890aa04497a317c5', 'create_by', '创建人登录名称', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, '', '0', '', '', 0, 1, 1, 0, 'single', '', '', 1, NULL, NULL, '2019-03-23 11:39:16', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('87f7a2703c5850f0b063dd866d0e2917', '402860816bff91c0016bffa220a9000b', 'birthday', '出生日期', 'birthday', 0, 1, 'Date', 0, 0, '', '', '', '', 'date', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 7, 'admin', '2019-07-22 16:15:32', '2019-07-17 19:12:24', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('87fafe1a4a8a626e3875697574c19f15', '402860816bff91c0016bff91d2810005', 'sys_org_code', '组织机构编码', 'sys_org_code', 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 14, 'admin', '2019-07-19 18:05:55', '2019-07-17 18:54:35', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('883265736ad6db0c98a7517d1f4a2488', '402880eb71d52dc30171d52dc3a10000', 'main_id', '主表ID', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 5, NULL, NULL, '2020-05-02 19:37:59', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('88a12570e14c9f6f442e731ae5ad0eb1', 'beee191324fd40c1afec4fda18bd9d47', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2019-04-13 13:41:13', '2019-04-13 13:40:56', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('88de72456c03410c364c80095aaa96eb', 'd35109c3632c4952a19ecc094943dd71', 'pop', '弹窗', NULL, 0, 1, 'string', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 15, 'admin', '2021-08-18 15:53:31', '2020-11-26 18:02:20', 'admin', '', '', '', '', '', 'text', '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('89370ae67e241fa5d1e47d22adeaca7b', '402880eb71d52dc30171d52dc3a10000', 'date', '日期', NULL, 0, 1, 'string', 200, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '#{date}', 0, 1, 1, 0, 'single', NULL, NULL, 4, NULL, NULL, '2020-05-02 19:37:58', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('89ab9eedbac6141e7a0df6d37a3655d0', 'e67d26b610dd414c884c4dbb24e71ce3', 'update_by', '更新人', NULL, 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 4, 'admin', '2019-04-24 11:03:32', '2019-04-24 11:02:57', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('8a24fb45e2af120c253c8b61c0085f7a', '402860816bff91c0016bff91cda80003', 'sys_org_code', '组织机构编码', 'sys_org_code', 0, 1, 'string', 50, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'group', '', '', 13, 'admin', '2019-07-19 18:06:36', '2019-07-17 18:54:34', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('8a2f97fde739720e86fbcd3ce311c037', '09fd28e4b7184c1a9668496a5c496450', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2020-05-14 21:19:21', '2020-05-08 23:51:49', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('8a6440c447ca97b1ceac40fa8576044e', '3b5e18da618247539481816995b6bf9f', 'sys_org_code', '所属部门', NULL, 0, 1, 'string', 64, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 6, 'admin', '2020-07-11 11:27:29', '2020-07-11 11:27:17', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('8a9d6bbbe45fd3539a8cb3ba2cee470a', '402881e6760269a201760269a2af0000', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', NULL, NULL, 5, NULL, NULL, '2020-11-26 10:37:26', 'admin', '', '', '', '', '', NULL, '0', NULL, NULL, '0');
INSERT INTO `onl_cgform_field` VALUES ('8ac8a0c0087469a4e7579229ff17f273', 'e5464aa8fa7b47c580e91593cf9b46dc', 'jifen', '合计积分', NULL, 0, 1, 'int', 32, 0, '', '', '', '', 'text', '', 120, NULL, '0', '', '', 0, 1, 1, 0, 'single', '', '', 10, 'admin', '2019-04-24 17:09:49', '2019-04-24 11:05:10', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `onl_cgform_field` VALUES ('8bd4deadc9e96c1a6d7abd77033105f6', 'e67d26b610dd414c884c4dbb24e71ce3', 'update_time', '更新日期', NULL, 0, 1, 'Date', 20, 0, '', '', '', '', 'datetime', '', 120, NULL, '0', '', '', 0, 0, 0, 0, 'single', '', '', 5, 'admin', '2019-04-24 11:03:32', '2019-04-24 11:02:57', 'admin', NULL, N