# 多机环境部署注意事项
多机环境把session托管给redis存储，所以要部署和配置redis，另外需要注意的是开启相关配置

## 注意事项如下
1.单机环境下不需要依赖spring-session，所以需要把相关依赖的注释打开
```
<dependency>
    <groupId>org.springframework.session</groupId>
    <artifactId>spring-session</artifactId>
    <scope>compile</scope><!-- 需要分布式session的话需要改为compile -->
</dependency>
```
2.修改application.yml中guns.spring-session-open配置，改为true，打开spring-session
```
guns.spring-session-open=true
```
3.配置application.yml中，spring.redis.host,spring.redis.port,spring.redis.password
```
spring.redis.host=xxx
spring.redis.port=xxx
spring.redis.password=xxx
```
4.需要把SpringSessionConfig类中的注释打开
```
@EnableRedisHttpSession(maxInactiveIntervalInSeconds = 1800)
```
5.如需配置session失效时间，请在SpringSessionConfig类中修改maxInactiveIntervalInSeconds属性值

