layui.use(['layer', 'ax', 'form', 'laydate', 'element', 'table'], function () {
    var $ = layui.$;
    var $ax = layui.ax;
    var layer = layui.layer;
    var form = layui.form;
    var laydate = layui.laydate;
    var element = layui.element;
    var table = layui.table;

    $('#code_gen').click(function () {
        window.location.href = Feng.ctxPath + "/gen";
    });

    $('#db_config').click(function () {
        window.location.href = Feng.ctxPath + "/db";
    });

    $('#add_db').click(function () {
        window.location.href = Feng.ctxPath + "/db/add";
    });

    table.render({
        elem: '#dbTable'
        , url: Feng.ctxPath + '/db/list'
        , page: false
        , height: "full-158"
        , cols: [[
            {type: 'checkbox'}
            , {field: 'dbId', align: "center", title: 'id'}
            , {field: 'dbName', align: "center", title: '数据源名称'}
            , {field: 'jdbcDriver', align: "center", title: 'jdbc的驱动类型', minWidth: 168}
            , {field: 'userName', align: "center", title: '数据库连接的账号'}
            , {field: 'password', align: "center", title: '密码'}
            , {field: 'jdbcUrl', align: "center", title: 'jdbc的url'}
            , {field: 'createTime', align: "center", title: '创建时间', minWidth: 159}
            , {align: 'center', toolbar: '#tableBar', title: '操作'}
        ]]
    });

    // 工具条点击事件
    table.on('tool(dbTable)', function (obj) {
        var data = obj.data;
        var layEvent = obj.event;

        if (layEvent === 'delete') {
            var operation = function () {
                var ajax = new $ax(Feng.ctxPath + "/db/delete", function () {
                    Feng.success("删除成功!");
                    table.reload("dbTable");
                }, function (data) {
                    Feng.error("删除失败!");
                });
                ajax.set("dbId", data.dbId);
                ajax.start();
            };
            Feng.confirm("是否删除数据源 " + data.dbName + "?", operation);
        }
    });

});