# 云存储第三阶段开发说明文档

[TOC]

------

## 文档说明：

* **该文档为第三阶段开发计划的说明，具体任务安排、人员安排及开发周期会应实际开发需求有所变动，第三阶段开发分为三个阶段：**
    * [准备阶段](#准备阶段：)
    * [开发阶段](#开发阶段：)
    * [测试阶段](#测试阶段：)

### 准备阶段：

* 现有功能完善：
  * 文件下载接口修改（修改文件下载重定向为非重定向，不在暴露FastDFS地址）（通过java代码下载太慢，尝试通过对fastdfs地址进行加密，并修改fastdfs-nginx-module来解决地址暴露的问题）
  * 完善文件hash比对机制
* 模块设计：
  * 用户模块设计
  * 文件管理模块设计
  * 网关、鉴权模块设计
* 模块搭建：
  * 用户模块搭建
  * 文件管理模块搭建
  * 网关、鉴权模块搭建

### 开发阶段：

* 后台管理系统开发：
  * 用户文件信息查看（如：文件大小、格式等）
  * 用户文件操作：
    * 编辑、修改文件名
    * 修改文件为共有或私有
    * 删除文件
    * 恢复在七天内删除的文件
    * 修改文件过期时间
  * 用户文件统计（文件为非删除状态及未过期）
    * 文件数量统计
    * 文件大小统计
    * 文件类型统计
  * 用户信息修改：
    * 修改用户基本信息（如：密码、名称）
    * 修改用户AccessKey/SecretKey
* 存储系统开发：
  * 凭证系统
    * 上传凭证（UploadToken）
    * 下载凭证（DownloadToken）
    * 管理凭证（AccessToken）
  * 空间特性
    * 以空间概念代替原本公私有文件的属性，配合凭证系统实现指定空间的私有、公共读、公共读写的特性
  * 文件夹功能
    * 用户可通过后台管理对指定空间下的文件夹进行管理
* 网关开发：
  * 使用```Spring Cloud Gateway```替代现有```Spring Cloud Zuul```
  * 开发拦截器，用于对所有url进行调用其他模块服务进行鉴权

### 测试、对接阶段：

* 存储系统接口测试、对接
* 后台管理系统接口测试、对接

---

## 任务安排：

### 准备阶段：

#### 现有功能完善：

| 工作内容               | 计划用时（工作日） | 人员安排 | 备注                                                         |
| ---------------------- | ------------------ | -------- | ------------------------------------------------------------ |
| 文件下载接口修改       | 5                  | 兰平雄   | 修改文件下载重定向为非重定向，<br />不在暴露FastDFS地址，<br />并减少断点续传不必要的内存消耗 |
| 完善文件hash值比对机制 | 5                  | 兰平雄   |                                                              |

#### 模块设计：

| 工作内容           | 计划用时（工作日） | 人员安排 | 备注       |
| ------------------ | ------------------ | -------- | ---------- |
| 用户模块设计       | 4                  |          | 含业务逻辑 |
| 用户模块设计       | 7                  |          | 含业务逻辑 |
| 网关、鉴权模块设计 | 5                  |          | 网关鉴权   |

#### 模块搭建：

| 工作内容           | 计划用时（工作日） | 人员安排 | 备注 |
| ------------------ | ------------------ | -------- | ---- |
| 用户模块搭建       | 1                  |          |      |
| 文件管理模块搭建   | 1                  |          |      |
| 网关、鉴权模块搭建 | 1                  |          |      |



### 开发阶段：

#### 用户模块开发：

| 工作内容         | 计划用时（工作日） | 人员安排 | 备注 |
| ---------------- | ------------------ | -------- | ---- |
| 用户文件信息查看 | 3                  |          |      |
| 用户文件统计     | 3                  |          |      |
| 用户文件操作     | 2                  |          |      |
| 用户信息修改     | 2                  |          |      |
| 用户注册         | 3                  |          |      |
| 鉴权接口         | 4                  |          |      |

#### 存储模块开发：

| 工作内容   | 计划用时（工作日） | 人员安排 | 备注 |
| ---------- | ------------------ | -------- | ---- |
| 凭证系统   | 4                  |          |      |
| 空间特性   | 5                  |          |      |
| 文件夹功能 | 5                  |          |      |
| 鉴权接口   | 4                  |          |      |

#### 网关、鉴权模块开发：

| 工作内容 | 计划用时（工作日） | 人员安排 | 备注 |
| -------- | ------------------ | -------- | ---- |
| 转发规则 | 2                  |          |      |
| 日志记录 | 4                  |          |      |



### 测试阶段：

| 工作内容                   | 计划用时（工作日） | 人员安排 | 备注 |
| -------------------------- | ------------------ | -------- | ---- |
| 存储系统接口测试、对接     | 5                  |          |      |
| 后台管理系统接口测试、对接 | 5                  |          |      |

---

## 技术栈：

| 名称               | 版本                                             |
| ------------------ | ------------------------------------------------ |
| Spring Boot        | 2.0.4.RELEASE => 2.1.6（升级至官方稳定版本GA）   |
| Spring Cloud       | Finchley => Finchley.SR3（升级至官方稳定版本GA） |
| fastdfs-client     | 1.26.6                                           |
| mybayis-plus       | 3.1.0                                            |
| lombok             | 1.18.2                                           |
| commons-lang3      | 3.8.1                                            |
| jackson-databind   | 2.9.8                                            |
| commons-codec      | 1.11                                             |
| springfox-swagger2 | 2.9.2                                            |
| jave-all-deps      | 2.4.6                                            |



---

## 开发文档：

* [文件下载接口修改](https://test-storage.tlifang.com/storage/download?userFileId=1144452015156822018)

