# 云存储第三阶段模块说明文档

[TOC]

------

## 文档概要：

### 新增模块：

 * 用户模块（```tdfs_user```）
 * 网关模块（```tdfs_gateway```）
 * 授权模块（```tdfs_auth```）

### 修改模块：

* 存储模块（```tdfs_storage```）
  * 新增空间特性
  * 新增空间特性配置信息
  * 新增基于空间的文件夹特性
  * 修改数据库所有时间类型为```timestamp```（更快的索引速度，但需要注意服务器时间）
  * 修改数据库名有```tcloud_storage```为```tdfs_storage```

---

## 模块说明：

### 用户模块（```tdfs_user```）：

#### 库信息：

```mysql
CREATE DATABASE tdfs_user DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_unicode_ci;
```

#### 表信息：

* 用户信息（```user_info```）：

  | 字段名      | 字段类型     | 必填 | 默认值 | 备注                       |
  | ----------- | ------------ | ---- | ------ | -------------------------- |
  | id          | bigint       | 是   | -1 | 用户Id                     |
  | username    | varchar(128) | 是   | ‘’ | 用户名                     |
  | email       | varchar(128) | 是   | ‘’ | 邮箱，作为登录账号         |
  | phone       | varchar(128) | 是   | ‘’ | 手机号码                   |
  | country     | varchar(64)  | 是   | ‘’ | 国家代码                   |
  | province    | varchar(64)  | 是   | ‘’ | 省、州代码                 |
  | city        | varchar(64)  | 是   | ‘’ | 城市代码                   |
  | address     | varchar(256) | 是   | ‘’ | 街道地址                   |
  | website     | varchar(256) | 是   | ‘’ | 网站地址                   |
  | type        | tinyint(4)   | 是   | -1 | 用户类型：<br />个人、企业 |
  | status      | tinyint(4)   | 是   | -1 | 状态                       |
  | create_time | timestamp     | 是   | CURRENT_TIMESTAMP | 创建时间                   |
  | modify_time | timestamp     | 是   | CURRENT_TIMESTAMP | 修改时间                   |

- 用户密码（```user_password```）：

  | 字段名      | 字段类型     | 必填 | 默认值 | 备注     |
  | ----------- | ------------ | ---- | ------ | -------- |
  | id          | bigint       | 是   | -1 | 用户Id   |
  | password    | varchar(128) | 是   | ‘’ | 密码     |
  | create_time | timestamp     | 是   | CURRENT_TIMESTAMP | 创建时间 |
  | modify_time | timestamp     | 是   | CURRENT_TIMESTAMP | 修改时间 |

* 用户凭据（```user_credentials```）：

  | 字段名      | 字段类型     | 必填 | 默认值 | 备注     |
  | ----------- | ------------ | ---- | ------ | -------- |
  | id          | bigint       | 是   | -1 | 凭据Id   |
  | user_id     | bigint       | 是   | -1 | 用户Id   |
  | access_key  | varchar(128) | 是   | ‘’ | 访问key  |
  | secret_key  | varchar(128) | 是   | ‘’ | 秘钥key  |
  | status      | tinyint      | 是   | -1 | 状态     |
  | create_time | timestamp     | 是   | CURRENT_TIMESTAMP | 创建时间 |
  | modify_time | timestamp     | 是   | CURRENT_TIMESTAMP | 修改时间 |

#### 负责业务：

- 用户注册
- 用户基本信息维护
- 用户凭据管理
- 操作日志查看

### 网关模块（```tdfs_gateway```）：

#### 负责业务：

* 负载均衡
* 凭据生成
* 凭据验证
* 限流

### 存储模块（```tdfs_storage```）：

#### 变动说明：

* 移除```user_info```表
* 修改```user_file_info```表：
  * 去除```is_public```字段
  * 新增```bucket_id```字段，用于描述该文件所属空间
  * 新增```folder_path_id```字段，用于描述该文件所属文件夹
* 新增表：
  * 空间信息表```bucket_info```
  * 文件夹信息表```folder_path_info```
  * 空间生命周期配置（```bucket_life_cycle_setting```）

#### 库信息：

```mysql
CREATE DATABASE tdfs_storage DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_unicode_ci;
```

#### 表信息：

* 文件信息（```file_info```）：

  | 字段名      | 字段类型     | 必填 | 默认值     | 备注        |
  | ----------- | ------------ | ---- | ---------- | ----------- |
  | id          | bigint       | 是   | -1 |             |
  | size        | bigint       | 是   | -1         | 文件大小    |
  | hash        | varchar(64)  | 是   | ''         | 文件hash值  |
  | group       | varchar(32)  | 是   | ''         | FastDFS组别 |
  | path        | varchar(128) | 是   | ''         | FastDFS路径 |
  | status      | tinyint(4)   | 是   | -1         | 文件状态    |
  | create_time | timestamp     | 是   | CURRENT_TIMESTAMP | 创建时间    |
  | modify_time | timestamp     | 是   | CURRENT_TIMESTAMP | 修改时间    |

-  用户文件信息（```user_file_info```）：

  | 字段名       | 字段类型     | 必填 | 默认值 | 备注                  |
  | ------------ | ------------ | ---- | ------ | --------------------- |
  | id           | bigint       | 是   | -1 |                       |
  | custom_id    | varchar(128) | 是   | -1 | 用户自定义文件Id      |
  | user_id      | bigint       | 是   | -1 | 用户Id                |
  | file_id      | bigint       | 是   | -1 | 文件Id                |
  | bucket_id    | bigint       | 是   | -1 | 空间Id                |
  | folder_id    | bigint       | 是   | -1 | 文件夹Id              |
  | file_format  | varchar(256) | 是   | ‘’     | 文件类型（MIME type） |
  | is_delete    | tinyint(1)   | 是   | -1     | 是否删除              |
  | expired_time | timestamp     | 是   | CURRENT_TIMESTAMP | 过期时间              |
  | create_time  | timestamp     | 是   | CURRENT_TIMESTAMP | 创建时间              |
  | modify_time  | timestamp     | 是   | CURRENT_TIMESTAMP | 修改时间              |

- 用户媒体文件信息（```user_media_file_info```）：

  | 字段名                   | 字段类型     | 必填 | 默认值 | 备注                                                         |
  | ------------------------ | ------------ | ---- | ------ | ------------------------------------------------------------ |
  | id                       | bigint       | 是   | -1 |                                                              |
  | user_file_info_id        | bigint       | 是   | -1 | 用户文件Id                                                   |
  | source_user_file_info_id | bigint       | 是   | -1 | 原文件user_file_info主键，<br />若本条记录为原文件，<br />该字段与user_file_info_id相同 |
  | type                     | varchar(64)  | 是   | ‘’ | 多媒体文件类型：<br />video（视频文件）<br />audio（音频文件）<br />image（图片文件） |
  | custom_info              | varchar(256) | 是   | ‘’ | 自定义信息（可能为空）：<br />当type为video、audio时，<br />该字段值为CustomMediaInfo对象Json字符串<br />当type为image时，<br />该字段值为CustomImageInfo对象Json字符串 |
  | create_time              | timestamp     | 是   | CURRENT_TIMESTAMP | 创建时间                                                     |
  | modify_time              | timestamp     | 是   | CURRENT_TIMESTAMP | 修改时间                                                     |

- 空间信息（```bucket_info```）：

  | 字段名      | 字段类型     | 必填 | 默认值 | 备注     |
  | ----------- | ------------ | ---- | ------ | -------- |
  | id          | bigint       | 是   | -1 |          |
  | user_id     | bigint       | 是   | -1 | 用户Id   |
  | name        | varchar(128) | 是   | ‘’ | 空间名称 |
  | is_public   | tinyint(1)   | 是   | -1 | 访问控制 |
  | status      | tinyint(1)   | 是   | -1 | 状态     |
  | create_time | timestamp     | 是   | CURRENT_TIMESTAMP | 创建时间 |
  | modify_time | timestamp     | 是   | CURRENT_TIMESTAMP | 修改时间 |

* 空间生命周期配置（```bucket_life_cycle_setting```）：

  | 字段名      | 字段类型     | 必填 | 默认值 | 备注     |
  | ----------- | ------------ | ---- | ------ | -------- |
  | id          | bigint       | 是   | -1 |          |
  | bucket_id   | bigint       | 是   | -1 | 空间Id   |
  | name        | varchar(128) | 是   | ‘’ | 空间名称 |
  | type        | tinyint(1)   | 是   | -1 | 类型     |
  | cycle       | integer      | 是   | -1 | 周期     |
  | rule        | varchar(128) | 是   | ‘’ | 匹配规则 |
  | status      | tinyint(1)   | 是   | -1 | 状态     |
  | create_time | timestamp     | 是   | CURRENT_TIMESTAMP | 创建时间 |
  | modify_time | timestamp     | 是   | CURRENT_TIMESTAMP | 修改时间 |

* 文件夹信息（```folder_info```）：

  | 字段名      | 字段类型     | 必填 | 默认值 | 备注         |
  | ----------- | ------------ | ---- | ------ | ------------ |
  | id          | bigint       | 是   | -1 |              |
  | bucket_id   | bigint       | 是   | -1 | 空间Id       |
  | parent_id   | bigint       | 是   | -1 | 父级文件夹Id |
  | name        | varchar(128) | 是   | ‘’ | 文件夹名称   |
  | path        | text         | 是   | ‘’ | 路径信息     |
  | create_time | timestamp     | 是   | CURRENT_TIMESTAMP | 创建时间     |
  | modify_time | timestamp     | 是   | CURRENT_TIMESTAMP | 修改时间     |

---

## 客户端与服务简单交互示意图：

```mermaid
sequenceDiagram
    participant 客户端
    participant 网关、鉴权
    participant 服务
    
    客户端->>网关、鉴权: 发送请求
    网关、鉴权->>服务: 调用校验token接口
    服务->>网关、鉴权: token是否有效
    alt token无效
    网关、鉴权-->>客户端: 异常信息
    end
    alt token有效
    网关、鉴权->>服务: 放行请求
    网关、鉴权->>客户端: 返回信息
    end
```

